package com.diamondgoobird.trialspawnertimer.config;

import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7172;
import net.minecraft.class_8012;
import java.awt.*;
import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;

/**
 * Represents the config file for the TrialSpawnerTimer mod
 */
public class Config {
    private static final String CONFIG_PATH = "trialspawnertimer.properties";
    private final class_2561 seeThroughWallsDescriptor = class_2561.method_43470("Whether the timer is visible through walls\n").method_10852(class_2561.method_43470("NOTE: The rendering can be glitchy around pots and particles").method_54663(class_8012.field_46652));
    private boolean seeThroughWalls = false;
    private final class_2561 chromaTimerDescriptor = class_2561.method_43470("Whether the color of the timer changes through the rainbow as the timer decreases (from ").method_10852(class_2561.method_43470("blue").method_54663(Color.CYAN.getRGB())).method_10852(class_2561.method_43470(" to ")).method_10852(class_2561.method_43470("red").method_54663(Color.RED.getRGB())).method_10852(class_2561.method_43470(")")).method_10852(class_2561.method_43470(" or if the color is a static ")).method_10852(class_2561.method_43470("magenta").method_54663(Color.MAGENTA.getRGB()));
    private boolean chromaTimer = false;
    private final class_2561 highSensitivityDescriptor = class_2561.method_43470("More thorough detection that allows timers to be created if the client never receives a blockupdate for the trial spawner (ex: if there's lag during the window where the cooldown starts)\n").method_10852(class_2561.method_43470("NOTE: Try turning this on if timers aren't showing up consistently").method_54663(class_8012.field_46652));
    private boolean highSensitivity = true;
    private final Path filePath;
    private class_7172<?>[] options;

    public Config() throws IOException {
        this.filePath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_PATH);
        loadConfig();
        initOptions();
    }

    /**
     * Sets up the Minecraft options that contain the descriptors, the titles and the callbacks to change the variables
     */
    private void initOptions() {
        options = new class_7172[3];
        options[0] = class_7172.method_41750("Visible through walls", class_7172.method_42717(seeThroughWallsDescriptor), seeThroughWalls, aBoolean -> this.seeThroughWalls = aBoolean);
        options[1] = class_7172.method_41750("Rainbow timer text", class_7172.method_42717(chromaTimerDescriptor), chromaTimer, aBoolean -> this.chromaTimer = aBoolean);
        options[2] = class_7172.method_41750("Higher sensitivity", class_7172.method_42717(highSensitivityDescriptor), highSensitivity, aBoolean -> this.highSensitivity = aBoolean);
    }

    /**
     * Loads the config from the config/trialspawnertimer.properties file
     * @throws IOException if there is an error writing to the config
     */
    private void loadConfig() throws IOException {
        if (!Files.exists(filePath)) {
            saveConfig();
            return;
        }
        FileInputStream fis = new FileInputStream(filePath.toFile());
        Properties p = new Properties();
        p.load(fis);
        seeThroughWalls = getBooleanProperty(p, "seeThroughWalls", seeThroughWalls);
        chromaTimer = getBooleanProperty(p, "chromaTimer", chromaTimer);
        highSensitivity = getBooleanProperty(p, "highSensitivity", highSensitivity);
    }

    /**
     * Gets the property of a given name in boolean form from a specific properties list
     * @param p the properties list to search in
     * @param name the name of the property to get the boolean value of
     * @param fallback the backup return value in case the property is not present
     * @return either the boolean property value, or fallback in case it's not present
     */
    private boolean getBooleanProperty(Properties p, String name, boolean fallback) {
        String s = p.getProperty(name);
        if (s != null) {
            return s.equals("true");
        }
        return fallback;
    }

    /**
     * Saves the config to the config/trialspawnertimer.properties file
     */
    public void saveConfig() {
        Properties p = new Properties();
        p.setProperty("seeThroughWalls", String.valueOf(seeThroughWalls));
        p.setProperty("chromaTimer", String.valueOf(chromaTimer));
        p.setProperty("highSensitivity", String.valueOf(highSensitivity));
        try {
            if (!filePath.getParent().toFile().exists()) {
                filePath.getParent().toFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(filePath.toFile());
            p.store(fos, "TrialSpawnerTimer Config version " + TrialSpawnerTimer.VERSION);
        }
        catch (IOException e) {
            TrialSpawnerTimer.LOGGER.error("Failed to save config: {}", e.getMessage());
        }
    }

    /**
     * Gets the config properly whether the timer should be visible through walls
     * @return true if seeing through walls is enabled, false otherwise
     */
    public boolean getSeeThroughWalls() {
        return seeThroughWalls;
    }

    /**
     * Gets the config property whether the text color changes based on how long is left in the cooldown
     * @return true if the chroma timer is enabled, false otherwise
     */
    public boolean getChromaTimer() {
        return chromaTimer;
    }

    /**
     * Gets the config property whether timer creation is more sensitive
     * @return true if the setting is enabled, false otherwise
     */
    public boolean isHighSensitivity() {
        return highSensitivity;
    }

    /**
     * Gets the options that are used in a GameOptionsScreen to change and display our config
     * @return the array of simpleoptions that represent this config
     */
    public class_7172<?>[] getOptions() {
        return options;
    }
}
