package com.diamondgoobird.trialspawnertimer.mixins;

import com.diamondgoobird.trialspawnertimer.TimerRenderer;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1937;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_898;
import net.minecraft.class_8984;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer.*;

@Mixin(class_8984.class)
public abstract class TrialSpawnerBlockEntityRendererMixin {
    @Shadow @Final private class_898 entityRenderDispatcher;

    @Inject(method = "render(Lnet/minecraft/client/render/block/entity/state/BlockEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;Lnet/minecraft/client/render/state/CameraRenderState;)V", at = @At("RETURN"))
    public void onRender(class_11954 state, class_4587 matrices, class_11659 queue, class_12075 cameraState, CallbackInfo ci) {
        class_1937 w = class_310.method_1551().field_1687;

        // If there is no timer rendered, check for updates
        boolean rend = TimerRenderer.drawTimer(w, state.field_62673, matrices, w.method_22339(state.field_62673), queue, entityRenderDispatcher.field_4686);
        // If higher sensitivity is on then check for updates
        if (getConfig().isHighSensitivity()) {
            onSpawnerStateUpdate(w, state.field_62673, state.field_62674.method_11654(class_2741.field_47408));
        }
    }
}
