/*
 * Decompiled with CFR 0.152.
 */
package com.diamondgoobird.trialspawnertimer;

import com.diamondgoobird.trialspawnertimer.Timer;
import com.diamondgoobird.trialspawnertimer.TimerHandler;
import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import java.awt.Color;
import net.minecraft.class_11659;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_8138;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TimerRenderer {
    public static boolean drawTimer(class_1937 world1, class_2338 pos, class_4587 matrixStack, int light, class_11659 queue, class_4184 camera) {
        long current;
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        assert (world1 != null);
        Timer ti = TimerHandler.getTimer(world1, pos);
        if (ti == null) {
            return false;
        }
        long end = ti.getTimerEnd();
        long left = Math.max(end - (current = world1.method_8510()), 0L);
        if (left == 0L) {
            TimerHandler.deleteTime(world1, pos);
            return false;
        }
        double minutes = (double)left / 1200.0;
        double seconds = (minutes - Math.floor(minutes)) * 60.0;
        class_2561 t = class_2561.method_30163((String)String.format("%02d:%02d", (int)minutes, (int)seconds));
        int c = TimerRenderer.getColor((double)left / (double)ti.getCooldown());
        light = 0xF000F0;
        TimerRenderer.drawTextAboveBlock(t, c, matrixStack, light, queue, camera);
        return true;
    }

    private static int getColor(double progress) {
        if (TrialSpawnerTimer.getConfig().getChromaTimer()) {
            return Color.getHSBColor((float)progress / 2.0f, 1.0f, 1.0f).getRGB();
        }
        return Color.MAGENTA.getRGB();
    }

    public static void drawTextAboveBlock(class_2561 t, int color, class_4587 matrixStack, int light, class_11659 queue, class_4184 camera) {
        matrixStack.method_22903();
        float yaw = camera.method_19330();
        float pitch = camera.method_19329();
        Quaternionf rotation = new Quaternionf();
        rotation.rotationYXZ((float)(-Math.PI) / 180 * class_8138.method_52845((float)yaw), (float)Math.PI / 180 * class_8138.method_52847((float)pitch), 0.0f);
        matrixStack.method_22907((Quaternionfc)rotation);
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix4f.scale(-0.025f, -0.025f, -0.025f);
        int m = class_310.method_1551().field_1772.method_1727(t.getString());
        int n = 9;
        matrix4f.translateLocal(0.5f, 1.0f, 0.5f);
        matrix4f.translate(1.0f - (float)m / 2.0f, (float)(-n), 0.0f);
        queue.method_73478(matrixStack, 0.5f, 0.5f, t.method_30937(), true, TimerRenderer.getRenderType(), light, color, 0, 0);
        matrixStack.method_22909();
    }

    public static class_327.class_6415 getRenderType() {
        return TrialSpawnerTimer.getConfig().getSeeThroughWalls() ? class_327.class_6415.field_33994 : class_327.class_6415.field_33995;
    }
}

