/*
 * Decompiled with CFR 0.152.
 */
package com.diamondgoobird.trialspawnertimer;

import com.diamondgoobird.trialspawnertimer.TimerHandler;
import com.diamondgoobird.trialspawnertimer.config.Config;
import com.diamondgoobird.trialspawnertimer.config.TrialSpawnerTimerCommand;
import java.io.IOException;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_8963;
import net.minecraft.class_8967;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrialSpawnerTimer
implements ClientModInitializer {
    public static String VERSION = "1.1.1";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"trialspawnertimer");
    public static boolean showGui;
    private static Config CONFIG;
    public static final List<class_8967> ACCEPTABLE_STATES;

    public void onInitializeClient() {
        try {
            if (FabricLoaderImpl.INSTANCE.isModLoaded("fabric-command-api-v2")) {
                TrialSpawnerTimerCommand.register();
            }
            CONFIG = new Config();
            LOGGER.info("Initialized Trial Spawner Timer Version {}", (Object)VERSION);
        }
        catch (IOException e) {
            LOGGER.error("Error loading Trial Spawner Timer: {}", (Object)e.getMessage());
        }
    }

    public static Config getConfig() {
        return CONFIG;
    }

    public static void onSpawnerBlockUpdate(class_1937 world, class_2338 pos, class_2680 state) {
        class_8967 st = (class_8967)state.method_11656().get(class_2741.field_47408);
        TrialSpawnerTimer.onSpawnerStateUpdate(world, pos, st);
    }

    public static void onSpawnerStateUpdate(class_1937 world, class_2338 pos, class_8967 state) {
        if (TimerHandler.shouldCreate(state) && !TimerHandler.hasTimer(world, pos)) {
            TimerHandler.insertTime(world, pos, world.method_8510(), class_8963.class_11349.field_60375.comp_4233());
            return;
        }
        if (TimerHandler.shouldReset(state)) {
            TimerHandler.deleteTime(world, pos);
        }
    }

    static {
        ACCEPTABLE_STATES = List.of(class_8967.field_47386, class_8967.field_47387, class_8967.field_47388);
    }
}

