/*
 * Decompiled with CFR 0.152.
 */
package com.diamondgoobird.trialspawnertimer.config;

import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7172;

public class Config {
    private static final String CONFIG_PATH = "trialspawnertimer.properties";
    private final class_2561 seeThroughWallsDescriptor = class_2561.method_43470((String)"Whether the timer is visible through walls\n").method_10852((class_2561)class_2561.method_43470((String)"NOTE: The rendering can be glitchy around pots and particles").method_54663(-2142128));
    private boolean seeThroughWalls = false;
    private final class_2561 chromaTimerDescriptor = class_2561.method_43470((String)"Whether the color of the timer changes through the rainbow as the timer decreases (from ").method_10852((class_2561)class_2561.method_43470((String)"blue").method_54663(Color.CYAN.getRGB())).method_10852((class_2561)class_2561.method_43470((String)" to ")).method_10852((class_2561)class_2561.method_43470((String)"red").method_54663(Color.RED.getRGB())).method_10852((class_2561)class_2561.method_43470((String)")")).method_10852((class_2561)class_2561.method_43470((String)" or if the color is a static ")).method_10852((class_2561)class_2561.method_43470((String)"magenta").method_54663(Color.MAGENTA.getRGB()));
    private boolean chromaTimer = false;
    private final class_2561 highSensitivityDescriptor = class_2561.method_43470((String)"More thorough detection that allows timers to be created if the client never receives a blockupdate for the trial spawner (ex: if there's lag during the window where the cooldown starts)\n").method_10852((class_2561)class_2561.method_43470((String)"NOTE: Try turning this on if timers aren't showing up consistently").method_54663(-2142128));
    private boolean highSensitivity = true;
    private final Path filePath = FabricLoader.getInstance().getConfigDir().resolve("trialspawnertimer.properties");
    private class_7172<?>[] options;

    public Config() throws IOException {
        this.loadConfig();
        this.initOptions();
    }

    private void initOptions() {
        this.options = new class_7172[3];
        this.options[0] = class_7172.method_41750((String)"Visible through walls", (class_7172.class_7277)class_7172.method_42717((class_2561)this.seeThroughWallsDescriptor), (boolean)this.seeThroughWalls, aBoolean -> {
            this.seeThroughWalls = aBoolean;
        });
        this.options[1] = class_7172.method_41750((String)"Rainbow timer text", (class_7172.class_7277)class_7172.method_42717((class_2561)this.chromaTimerDescriptor), (boolean)this.chromaTimer, aBoolean -> {
            this.chromaTimer = aBoolean;
        });
        this.options[2] = class_7172.method_41750((String)"Higher sensitivity", (class_7172.class_7277)class_7172.method_42717((class_2561)this.highSensitivityDescriptor), (boolean)this.highSensitivity, aBoolean -> {
            this.highSensitivity = aBoolean;
        });
    }

    private void loadConfig() throws IOException {
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            this.saveConfig();
            return;
        }
        FileInputStream fis = new FileInputStream(this.filePath.toFile());
        Properties p = new Properties();
        p.load(fis);
        this.seeThroughWalls = this.getBooleanProperty(p, "seeThroughWalls", this.seeThroughWalls);
        this.chromaTimer = this.getBooleanProperty(p, "chromaTimer", this.chromaTimer);
        this.highSensitivity = this.getBooleanProperty(p, "highSensitivity", this.highSensitivity);
    }

    private boolean getBooleanProperty(Properties p, String name, boolean fallback) {
        String s = p.getProperty(name);
        if (s != null) {
            return s.equals("true");
        }
        return fallback;
    }

    public void saveConfig() {
        Properties p = new Properties();
        p.setProperty("seeThroughWalls", String.valueOf(this.seeThroughWalls));
        p.setProperty("chromaTimer", String.valueOf(this.chromaTimer));
        p.setProperty("highSensitivity", String.valueOf(this.highSensitivity));
        try {
            if (!this.filePath.getParent().toFile().exists()) {
                this.filePath.getParent().toFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(this.filePath.toFile());
            p.store(fos, "TrialSpawnerTimer Config version " + TrialSpawnerTimer.VERSION);
        }
        catch (IOException e) {
            TrialSpawnerTimer.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    public boolean getSeeThroughWalls() {
        return this.seeThroughWalls;
    }

    public boolean getChromaTimer() {
        return this.chromaTimer;
    }

    public boolean isHighSensitivity() {
        return this.highSensitivity;
    }

    public class_7172<?>[] getOptions() {
        return this.options;
    }
}

