/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redsmods.sound_physics_perfected.RedsAttenuationType;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class Config {
    private static Config INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_FILE;
    public int raysCast = 1000;
    public int raysBounced = 3;
    public boolean reverbEnabled = true;
    public boolean permeationEnabled = true;
    public int maxRayLength = 4;
    public float SoundMult = 1.0f;
    public int tickRate = 2;
    public RedsAttenuationType attenuationType = RedsAttenuationType.INVERSE_SQUARE;
    public double permeationStepSize = 0.01;

    public static Config getInstance() {
        if (INSTANCE == null) {
            INSTANCE = Config.loadConfig();
        }
        return INSTANCE;
    }

    private static Config loadConfig() {
        Config config;
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_FILE);
                config = (Config)GSON.fromJson(json, Config.class);
            }
            catch (Exception e) {
                System.err.println("Failed to load config, using defaults: " + e.getMessage());
                config = new Config();
            }
        } else {
            config = new Config();
            config.save();
        }
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_FILE, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void reload() {
        INSTANCE = Config.loadConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_FILE = Platform.getConfigFolder().resolve("SoundPhysicsPerfected.json");
    }
}

