/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected;

import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.RedsAttenuationType;
import com.redsmods.sound_physics_perfected.ReverbHelpers.EnhancedReverbData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.ReverbSurfaceData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.RoomVolumeData;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.storageclasses.AveragedSoundData;
import com.redsmods.sound_physics_perfected.storageclasses.BlueRayResult;
import com.redsmods.sound_physics_perfected.storageclasses.RayHitData;
import com.redsmods.sound_physics_perfected.storageclasses.RaycastResult;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.storageclasses.TickableSoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaycastingHelper {
    public static final Queue<RedTickableInstance> tickQueue = new LinkedList<RedTickableInstance>();
    public static final Queue<RedPermeatedSoundInstance> permeatedTickQueue = new LinkedList<RedPermeatedSoundInstance>();
    private static final ConcurrentHashMap<SoundData, Integer> entityRayHitCounts = new ConcurrentHashMap();
    public static final Queue<SoundData> soundQueue = new LinkedList<SoundData>();
    public static final Queue<SoundData> weatherQueue = new LinkedList<SoundData>();
    private static final double SPEED_OF_SOUND_TICKS = 17.15;
    private static final Map<Integer, ArrayList<class_1113>> soundPlayingWaiting = new ConcurrentHashMap<Integer, ArrayList<class_1113>>();
    private static int ticksSinceWorld;
    private static final AtomicReference<Double> distanceFromWallEcho;
    private static final AtomicReference<Double> distanceFromWallEchoDenom;
    private static final AtomicInteger reverbStrength;
    private static final AtomicInteger reverbDenom;
    private static final AtomicInteger outdoorLeak;
    private static final AtomicInteger outdoorLeakDenom;
    private static final ConcurrentHashMap<String, ReverbSurfaceData> surfaceMaterials;
    private static final ConcurrentHashMap<class_243, RoomVolumeData> roomVolumeCache;
    private static final AtomicInteger totalSurfaceArea;
    private static final AtomicReference<Double> averageAbsorption;
    private static final AtomicReference<Double> roomVolume;
    private static final AtomicReference<Double> surfaceToVolumeRatio;
    private static final AtomicReference<Double> earlyReflectionStrength;
    private static final AtomicReference<Double> lateReflectionStrength;
    private static final AtomicReference<Double> weightedReverbStrength;
    private static final AtomicInteger earlyReflectionCount;
    private static final AtomicInteger lateReflectionCount;
    private static final ConcurrentHashMap<SoundData, List<RayHitData>> rayHitsByEntity;
    private static final ConcurrentHashMap<SoundData, List<RayHitData>> redRaysToTarget;
    private static final ConcurrentHashMap<SoundData, AveragedSoundData> muffledAveragedResults;
    public static final ConcurrentHashMap<class_1113, class_1113> soundInstanceMap;
    public static final ConcurrentHashMap<class_1113, RedPermeatedSoundInstance> soundPermInstanceMap;
    private static final int THREAD_POOL_SIZE;
    private static final ExecutorService raycastExecutor;
    private static final ExecutorService soundProcessingExecutor;
    private static final AtomicBoolean isRaytracing;
    private static final AtomicBoolean freezeTickCounter;
    public static final Queue<RedPermeatedSoundInstance> FXQueue;

    public static void castBouncingRaysAndDetectSFX(class_1937 world, class_1657 player) {
        try {
            if (!isRaytracing.compareAndSet(false, true)) {
                return;
            }
            class_243 playerEyePos = player.method_33571();
            double maxTotalDistance = 16.0 * (double)Config.getInstance().maxRayLength * (double)Config.getInstance().raysBounced;
            entityRayHitCounts.clear();
            class_310 client = class_310.method_1551();
            if (client == null || client.method_1483() == null) {
                isRaytracing.set(false);
                return;
            }
            if (soundQueue.isEmpty() && tickQueue.isEmpty() && permeatedTickQueue.isEmpty()) {
                isRaytracing.set(false);
                return;
            }
            weatherQueue.clear();
            Iterator iterator = soundQueue.iterator();
            while (iterator.hasNext()) {
                SoundData sound = (SoundData)iterator.next();
                if (!sound.soundId.contains("rain")) continue;
                weatherQueue.add(sound);
                iterator.remove();
            }
            class_243[] rayDirections = RaycastingHelper.generateRayDirections();
            rayHitsByEntity.clear();
            redRaysToTarget.clear();
            RaycastingHelper.processAndPlayAveragedSounds(world, player, playerEyePos, new ArrayList<class_243>(Arrays.asList(rayDirections)), soundQueue, maxTotalDistance, client);
            RaycastingHelper.displayEntityRayHitCounts(world, player);
            tickQueue.clear();
            soundQueue.clear();
            permeatedTickQueue.clear();
            isRaytracing.set(false);
        }
        catch (Exception e) {
            System.err.println("Error in player bouncing ray entity detection: " + e.getMessage());
        }
    }

    public static void processAndPlayAveragedSounds(class_1937 world, class_1657 player, class_243 playerEyePos, List<class_243> rayDirections, Queue<SoundData> soundQueue, double maxTotalDistance, class_310 client) {
        CompletableFuture<Void> task;
        Map<SoundData, AveragedSoundData> averagedResults = RaycastingHelper.processRaysWithAveraging(world, player, playerEyePos, rayDirections, soundQueue, maxTotalDistance);
        if (averagedResults.isEmpty() && muffledAveragedResults.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture<Void>> soundTasks = new ArrayList<CompletableFuture<Void>>();
        freezeTickCounter.set(true);
        for (AveragedSoundData avgData : averagedResults.values()) {
            task = CompletableFuture.runAsync(() -> RaycastingHelper.playAveragedSoundWithAdjustments(client, avgData, playerEyePos, 1.0f, 1.0f), soundProcessingExecutor);
            soundTasks.add(task);
        }
        if (Config.getInstance().permeation) {
            for (AveragedSoundData avgData : muffledAveragedResults.values()) {
                task = CompletableFuture.runAsync(() -> RaycastingHelper.playMuffled(client, avgData, playerEyePos, 1.0f, 1.0f), soundProcessingExecutor);
                soundTasks.add(task);
            }
        }
        freezeTickCounter.set(false);
        CompletableFuture.allOf(soundTasks.toArray(new CompletableFuture[0])).join();
    }

    public static void playAveragedSoundWithAdjustments(class_310 client, AveragedSoundData avgData, class_243 playerPos, float volumeMultiplier, float pitchMultiplier) {
        if (client == null || client.field_1687 == null || avgData == null) {
            return;
        }
        try {
            class_243 targetPosition = playerPos.method_1019(avgData.averageDirection.method_1021(avgData.averageDistance));
            if (avgData.totalWeight == 0.0) {
                targetPosition = avgData.soundEntity.position;
            }
            class_1113 originalSound = avgData.soundEntity.sound;
            class_2960 soundId = originalSound.method_4775();
            if (avgData.totalWeight == 0.0 && originalSound instanceof RedTickableInstance) {
                ((RedTickableInstance)originalSound).setTargetVolume(0.0f);
                ((RedTickableInstance)originalSound).setTargetPosition(((RedTickableInstance)originalSound).getOriginalPosition());
                return;
            }
            float baseVolume = originalSound instanceof RedTickableInstance ? ((RedTickableInstance)originalSound).getOriginalVolume() : ((RedSoundInstance)originalSound).original.method_4781();
            float confidenceMultiplier = (float)avgData.totalWeight / (float)Config.getInstance().raysCast * (float)Config.getInstance().raysBounced;
            confidenceMultiplier = Math.min(confidenceMultiplier, 1.0f);
            float adjustedVolume = baseVolume * volumeMultiplier * confidenceMultiplier;
            float basePitch = originalSound.method_4782();
            float adjustedPitch = basePitch * pitchMultiplier;
            if (originalSound instanceof RedTickableInstance) {
                ((RedTickableInstance)originalSound).setTargetPosition(targetPosition);
                ((RedTickableInstance)originalSound).setTargetVolume(Math.max(0.01f, Math.min(1.0f, adjustedVolume)));
                return;
            }
            RedTickableInstance newSound = (RedSoundInstance)originalSound instanceof class_1117 ? new RedTickableInstance(soundId, originalSound.method_4776(), originalSound.method_4774(), targetPosition, Math.max(0.001f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new class_243(originalSound.method_4784(), originalSound.method_4779(), originalSound.method_4778()), baseVolume) : new RedTickableInstance(soundId, originalSound.method_4776(), originalSound.method_4774(), targetPosition, Math.max(0.001f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new class_243(originalSound.method_4784(), originalSound.method_4779(), originalSound.method_4778()), baseVolume);
            soundInstanceMap.put(((RedSoundInstance)originalSound).getOriginal(), (class_1113)newSound);
            RaycastingHelper.queueSound((class_1113)newSound, (int)(avgData.averageDistance / 17.15));
        }
        catch (Exception e) {
            System.err.println("Error playing adjusted averaged sound: " + e.getMessage());
        }
    }

    public static void playMuffled(class_310 client, AveragedSoundData avgData, class_243 playerPos, float volumeMultiplier, float pitchMultiplier) {
        if (client == null || client.field_1687 == null || avgData == null) {
            return;
        }
        try {
            class_243 targetPosition = playerPos.method_1019(avgData.averageDirection.method_1021(avgData.averageDistance));
            if (avgData.totalWeight == 0.0) {
                targetPosition = avgData.soundEntity.position;
            }
            class_1113 originalSound = avgData.soundEntity.sound;
            class_2960 soundId = originalSound.method_4775();
            float baseVolume = originalSound instanceof RedTickableInstance ? ((RedTickableInstance)originalSound).getOriginalVolume() : ((RedSoundInstance)originalSound).original.method_4781();
            float confidenceMultiplier = (float)avgData.totalWeight / (float)Config.getInstance().raysCast * (float)Config.getInstance().raysBounced;
            float adjustedVolume = baseVolume * volumeMultiplier * confidenceMultiplier;
            float basePitch = originalSound.method_4782();
            float adjustedPitch = basePitch * pitchMultiplier;
            if (avgData.totalWeight == 0.0 && originalSound instanceof RedPermeatedSoundInstance) {
                ((RedPermeatedSoundInstance)originalSound).setTargetVolume(0.0f);
                ((RedPermeatedSoundInstance)originalSound).setTargetPosition(((RedTickableInstance)originalSound).getOriginalPosition());
                return;
            }
            if (originalSound instanceof RedTickableInstance) {
                ((RedPermeatedSoundInstance)originalSound).setTargetPosition(targetPosition);
                ((RedPermeatedSoundInstance)originalSound).setTargetVolume(adjustedVolume);
                ((RedPermeatedSoundInstance)originalSound).setPermeationIndex(confidenceMultiplier);
                return;
            }
            RedPermeatedSoundInstance newSound = new RedPermeatedSoundInstance(soundId, originalSound.method_4776(), originalSound.method_4774(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new class_243(originalSound.method_4784(), originalSound.method_4779(), originalSound.method_4778()), baseVolume, confidenceMultiplier);
            soundPermInstanceMap.put(((RedSoundInstance)originalSound).getOriginal(), newSound);
            RaycastingHelper.queueSound((class_1113)newSound, (int)(avgData.averageDistance / 17.15));
        }
        catch (Exception e) {
            System.err.println("Error playing adjusted averaged sound: " + e.getMessage());
        }
    }

    private static void queueSound(class_1113 newSound, int distance) {
        soundPlayingWaiting.computeIfAbsent(ticksSinceWorld + 1, k -> new ArrayList()).add(newSound);
    }

    public static Map<SoundData, AveragedSoundData> processRaysWithAveraging(class_1937 world, class_1657 player, class_243 playerEyePos, List<class_243> rayDirections, Queue<SoundData> soundQueue, double maxTotalDistance) {
        AveragedSoundData averagedData;
        List<RayHitData> rayHits;
        SoundData entity;
        reverbStrength.set(0);
        distanceFromWallEcho.set(0.0);
        distanceFromWallEchoDenom.set(0.0);
        reverbDenom.set(0);
        outdoorLeak.set(0);
        outdoorLeakDenom.set(0);
        ConcurrentLinkedQueue<SoundData> threadSafeSoundQueue = new ConcurrentLinkedQueue<SoundData>(soundQueue);
        int raysPerChunk = Math.max(1, rayDirections.size() / THREAD_POOL_SIZE);
        ArrayList<List<class_243>> rayChunks = new ArrayList<List<class_243>>();
        for (int i = 0; i < rayDirections.size(); i += raysPerChunk) {
            int endIndex = Math.min(i + raysPerChunk, rayDirections.size());
            rayChunks.add(rayDirections.subList(i, endIndex));
        }
        ArrayList<CompletableFuture<Void>> rayTasks = new ArrayList<CompletableFuture<Void>>();
        for (List list : rayChunks) {
            CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                for (class_243 direction : rayChunk) {
                    RaycastingHelper.castBouncingRay(world, player, playerEyePos, direction, threadSafeSoundQueue, maxTotalDistance);
                }
            }, raycastExecutor);
            rayTasks.add(task);
        }
        CompletableFuture.allOf(rayTasks.toArray(new CompletableFuture[0])).join();
        ConcurrentHashMap<SoundData, AveragedSoundData> averagedResults = new ConcurrentHashMap<SoundData, AveragedSoundData>();
        muffledAveragedResults.clear();
        for (Map.Entry<SoundData, List<RayHitData>> entry : rayHitsByEntity.entrySet()) {
            entity = entry.getKey();
            rayHits = entry.getValue();
            averagedData = RaycastingHelper.calculateWeightedAverages(entity, rayHits);
            averagedResults.put(entity, averagedData);
        }
        for (Map.Entry<SoundData, List<RayHitData>> entry : redRaysToTarget.entrySet()) {
            entity = entry.getKey();
            rayHits = entry.getValue();
            averagedData = RaycastingHelper.calculateWeightedAverages(entity, rayHits);
            muffledAveragedResults.put(entity, averagedData);
        }
        return averagedResults;
    }

    public static RaycastResult castBouncingRay(class_1937 world, class_1657 player, class_243 startPos, class_243 direction, Queue<SoundData> soundQueue, double maxTotalDistance) {
        double segmentTraveled;
        class_243 currentPos = startPos;
        class_243 currentDirection = direction.method_1029();
        class_243 initialDirection = currentDirection.method_1029();
        double remainingDistance = maxTotalDistance;
        double totalDistanceTraveled = 0.0;
        SoundData hitEntity = null;
        if (Config.getInstance().permeation) {
            RaycastingHelper.castRedRay(world, player, startPos, soundQueue, totalDistanceTraveled, initialDirection);
        } else {
            RaycastingHelper.castGreenRay(world, player, startPos, soundQueue, totalDistanceTraveled, initialDirection);
        }
        for (int bounce = 0; bounce <= Config.getInstance().raysBounced && remainingDistance > 0.0; remainingDistance -= segmentTraveled, ++bounce) {
            double segmentDistance = Math.min(16.0 * (double)Config.getInstance().maxRayLength, remainingDistance);
            class_243 segmentEnd = currentPos.method_1019(currentDirection.method_1021(segmentDistance));
            class_3959 raycastContext = new class_3959(currentPos, segmentEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 blockHit = world.method_17742(raycastContext);
            class_243 actualEnd = segmentEnd;
            boolean hitBlock = false;
            if (blockHit.method_17783() == class_239.class_240.field_1332) {
                actualEnd = blockHit.method_17784();
                hitBlock = true;
            }
            segmentTraveled = currentPos.method_1022(actualEnd);
            totalDistanceTraveled += segmentTraveled;
            totalDistanceTraveled *= Config.getInstance().rayBounce;
            if (hitBlock) {
                if (Config.getInstance().reverb) {
                    BlueRayResult blueRayResult = RaycastingHelper.castBlueRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection, bounce);
                    if (blueRayResult.arrived) {
                        initialDirection = blueRayResult.directionFromPlayer;
                        totalDistanceTraveled = blueRayResult.distance;
                        totalDistanceTraveled *= Config.getInstance().rayBounce;
                    }
                }
                if (Config.getInstance().permeation) {
                    RaycastingHelper.castRedRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
                } else {
                    RaycastingHelper.castGreenRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
                }
            }
            if (hitBlock) {
                class_243 hitPos = blockHit.method_17784();
                class_2350 hitSide = blockHit.method_17780();
                class_243 reflectedDirection = RaycastingHelper.calculateReflection(currentDirection, hitSide);
                currentPos = hitPos.method_1019(reflectedDirection.method_1021(0.01));
                currentDirection = reflectedDirection;
            } else {
                for (SoundData soundEntity : weatherQueue) {
                    double weight = RaycastingHelper.getWeight(totalDistanceTraveled - segmentTraveled, 0.0, 0.0);
                    RaycastResult GreenRayResult = new RaycastResult(maxTotalDistance, initialDirection, soundEntity);
                    RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
                    rayHitsByEntity.computeIfAbsent(soundEntity, k -> new CopyOnWriteArrayList()).add(hitData);
                    entityRayHitCounts.merge(soundEntity, 1, Integer::sum);
                }
                class_243 toCenter = player.method_19538().method_1020(actualEnd);
                class_243 normal = toCenter.method_1029();
                class_243 reflectedDirection = RaycastingHelper.calculateReflection(currentDirection, normal);
                currentPos = segmentEnd.method_1019(reflectedDirection.method_1021(0.01));
                currentDirection = reflectedDirection;
                remainingDistance -= segmentTraveled;
                outdoorLeak.incrementAndGet();
                outdoorLeakDenom.incrementAndGet();
                return null;
            }
            outdoorLeakDenom.incrementAndGet();
        }
        return new RaycastResult(totalDistanceTraveled, initialDirection, hitEntity);
    }

    private static void castGreenRay(class_1937 world, class_1657 player, class_243 currentPos, Queue<SoundData> entities, double currentDistance, class_243 initialDirection) {
        for (SoundData soundData : entities) {
            class_3959 raycastContext;
            class_3965 blockHit;
            boolean hasLineOfSight;
            rayHitsByEntity.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList());
            class_243 entityCenter = soundData.position;
            double distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * soundData.sound.method_4781()) || !(hasLineOfSight = (blockHit = world.method_17742(raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() != class_239.class_240.field_1332 || currentPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 1.0)) continue;
            double weight = RaycastingHelper.getWeight(currentDistance, 0.0, distanceToEntity);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, soundData);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(soundData, 1, Integer::sum);
        }
        for (RedTickableInstance redTickableInstance : tickQueue) {
            class_3959 raycastContext;
            class_3965 blockHit;
            boolean hasLineOfSight;
            TickableSoundData data = new TickableSoundData((class_1113)redTickableInstance, redTickableInstance.getOriginalPosition(), redTickableInstance.method_4776().toString());
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList());
            class_243 entityCenter = redTickableInstance.getOriginalPosition();
            double distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redTickableInstance.getOriginalVolume()) || !(hasLineOfSight = (blockHit = world.method_17742(raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() != class_239.class_240.field_1332 || currentPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 1.0)) continue;
            double weight = RaycastingHelper.getWeight(currentDistance, 0.0, distanceToEntity);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, data);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(data, 1, Integer::sum);
        }
    }

    private static BlueRayResult castBlueRay(class_1937 world, class_1657 player, class_243 currentPos, Queue<SoundData> entities, double currentDistance, class_243 initialDirection, int bounceNumber) {
        double reflectionDelay;
        boolean hasLineOfSight;
        class_243 entityCenter = player.method_5829().method_1005();
        class_243 adjustedPos = currentPos.method_1019(entityCenter.method_1020(currentPos).method_1021(0.87));
        double distanceToEntity = adjustedPos.method_1022(entityCenter);
        class_3959 raycastContext = new class_3959(adjustedPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
        class_3965 blockHit = world.method_17742(raycastContext);
        boolean bl = hasLineOfSight = blockHit.method_17783() != class_239.class_240.field_1332 || adjustedPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 0.6;
        if (bounceNumber <= 2) {
            RaycastingHelper.analyzeSurfaceAtPosition(world, currentPos, currentDistance, hasLineOfSight);
        }
        if ((reflectionDelay = currentDistance / 17.15) < 0.05) {
            earlyReflectionStrength.updateAndGet(current -> current + (hasLineOfSight ? 1.0 : 0.0));
            earlyReflectionCount.incrementAndGet();
        } else {
            lateReflectionStrength.updateAndGet(current -> current + (hasLineOfSight ? 0.6 : 0.0));
            lateReflectionCount.incrementAndGet();
        }
        reverbDenom.incrementAndGet();
        if (hasLineOfSight) {
            distanceFromWallEcho.updateAndGet(current -> current + currentDistance);
            distanceFromWallEchoDenom.updateAndGet(current -> current + 1.0);
            reverbStrength.incrementAndGet();
            class_243 toPlayer = entityCenter.method_1020(currentPos).method_1029();
            class_243 playerToAdjustedPos = adjustedPos.method_1020(entityCenter);
            class_243 reflectionAngle = initialDirection.method_1020(toPlayer);
            double angleDeviation = Math.abs(reflectionAngle.method_1033());
            double reflectionQuality = Math.max(0.1, 1.0 - angleDeviation);
            weightedReverbStrength.updateAndGet(current -> current + reflectionQuality);
            return new BlueRayResult(true, playerToAdjustedPos, entityCenter.method_1022(adjustedPos));
        }
        return new BlueRayResult(false, null, -1.0);
    }

    private static void analyzeSurfaceAtPosition(class_1937 world, class_243 pos, double distance, boolean hasLineOfSight) {
        class_2338 blockPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350);
        class_2680 blockState = world.method_8320(blockPos);
        if (!blockState.method_26215()) {
            String materialName = blockState.method_26204().method_9518().getString().toLowerCase();
            ReverbSurfaceData surfaceData = surfaceMaterials.getOrDefault(materialName, surfaceMaterials.get("default"));
            double distanceWeight = 1.0 / Math.max(distance, 1.0);
            averageAbsorption.updateAndGet(current -> current + surfaceData.absorptionCoefficient * distanceWeight);
            totalSurfaceArea.updateAndGet(current -> current + 1);
            if (hasLineOfSight) {
                RaycastingHelper.analyzeRoomDimensions(world, pos, blockPos);
            }
        }
    }

    private static void analyzeRoomDimensions(class_1937 world, class_243 center, class_2338 hitPos) {
        double[] distances = new double[6];
        class_243[] directions = new class_243[]{new class_243(1.0, 0.0, 0.0), new class_243(-1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), new class_243(0.0, -1.0, 0.0), new class_243(0.0, 0.0, 1.0), new class_243(0.0, 0.0, -1.0)};
        for (int i = 0; i < 6; ++i) {
            distances[i] = RaycastingHelper.measureDistanceToWall(world, center, directions[i], 16.0);
        }
        double width = distances[0] + distances[1];
        double height = distances[2] + distances[3];
        double depth = distances[4] + distances[5];
        double estimatedVolume = width * height * depth;
        roomVolume.updateAndGet(current -> Math.max(current, estimatedVolume));
        double estimatedSurfaceArea = 2.0 * (width * height + width * depth + height * depth);
        if (estimatedVolume > 0.0) {
            surfaceToVolumeRatio.updateAndGet(current -> Math.max(current, estimatedSurfaceArea / estimatedVolume));
        }
    }

    private static double measureDistanceToWall(class_1937 world, class_243 start, class_243 direction, double maxDistance) {
        for (double d = 1.0; d < maxDistance; d += 1.0) {
            class_243 testPos = start.method_1019(direction.method_1021(d));
            class_2338 blockPos = new class_2338((int)testPos.field_1352, (int)testPos.field_1351, (int)testPos.field_1350);
            if (world.method_8320(blockPos).method_26215()) continue;
            return d;
        }
        return maxDistance;
    }

    public static EnhancedReverbData calculateEnhancedReverb() {
        double totalSurface = totalSurfaceArea.get();
        double avgAbsorption = totalSurface > 0.0 ? averageAbsorption.get() / totalSurface : 0.05;
        double volume = roomVolume.get();
        double surfaceToVolRatio = surfaceToVolumeRatio.get();
        double totalAbsorption = totalSurface * avgAbsorption;
        double rt60 = totalAbsorption > 0.0 ? 0.161 * volume / totalAbsorption : 0.0;
        rt60 = Math.min(rt60, 8.0);
        double roomRadius = Math.cbrt(volume * 3.0 / (Math.PI * 4));
        double earlyReflectionDelay = roomRadius / 17.15;
        double earlyStrength = earlyReflectionCount.get() > 0 ? earlyReflectionStrength.get() / (double)earlyReflectionCount.get() : 0.0;
        double lateStrength = lateReflectionCount.get() > 0 ? lateReflectionStrength.get() / (double)lateReflectionCount.get() : 0.0;
        String acousticProfile = RaycastingHelper.determineAcousticProfile(avgAbsorption, surfaceToVolRatio, volume);
        boolean isIndoors = surfaceToVolRatio > 0.5 && volume < 8000.0;
        return new EnhancedReverbData(rt60, earlyReflectionDelay, lateStrength, roomRadius, avgAbsorption, acousticProfile, isIndoors);
    }

    private static String determineAcousticProfile(double absorption, double surfaceToVolRatio, double volume) {
        if (volume > 10000.0) {
            return "cathedral";
        }
        if (absorption > 0.6) {
            return "padded_room";
        }
        if (absorption < 0.1 && surfaceToVolRatio < 0.3) {
            return "gymnasium";
        }
        if (surfaceToVolRatio > 1.0) {
            return "small_room";
        }
        if (absorption > 0.3) {
            return "living_room";
        }
        return "generic_room";
    }

    public static EnhancedReverbData getEnhancedReverbData() {
        return RaycastingHelper.calculateEnhancedReverb();
    }

    public static double getWeightedReverbStrength() {
        return weightedReverbStrength.get();
    }

    public static double getEarlyReflectionRatio() {
        int totalLate;
        int totalEarly = earlyReflectionCount.get();
        int total = totalEarly + (totalLate = lateReflectionCount.get());
        return total > 0 ? (double)totalEarly / (double)total : 0.0;
    }

    private static void castRedRay(class_1937 world, class_1657 player, class_243 currentPos, Queue<SoundData> entities, double currentDistance, class_243 initialDirection) {
        double distanceToEntity;
        TickableSoundData data;
        for (SoundData soundData : entities) {
            rayHitsByEntity.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList());
            redRaysToTarget.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList());
            class_243 entityCenter = soundData.position;
            double distanceToEntity2 = currentPos.method_1022(entityCenter);
            if (distanceToEntity2 + currentDistance > (double)(16.0f * soundData.sound.method_4781())) continue;
            double blockCount = RaycastingHelper.countBlocksBetween(world, currentPos, entityCenter, player);
            double weight = RaycastingHelper.getWeight(currentDistance, blockCount, distanceToEntity2);
            RaycastResult rayResult = new RaycastResult(distanceToEntity2, initialDirection, soundData);
            RayHitData hitData = new RayHitData(rayResult, initialDirection, weight);
            if (blockCount == 0.0) {
                rayHitsByEntity.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
                entityRayHitCounts.merge(soundData, 1, Integer::sum);
            }
            redRaysToTarget.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
        }
        for (RedPermeatedSoundInstance redPermeatedSoundInstance : permeatedTickQueue) {
            data = new TickableSoundData((class_1113)redPermeatedSoundInstance, redPermeatedSoundInstance.getOriginalPosition(), redPermeatedSoundInstance.method_4776().toString());
            redRaysToTarget.computeIfAbsent(data, k -> new CopyOnWriteArrayList());
            class_243 entityCenter = redPermeatedSoundInstance.getOriginalPosition();
            distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redPermeatedSoundInstance.getOriginalVolume())) continue;
            double blockCount = RaycastingHelper.countBlocksBetween(world, currentPos, entityCenter, player);
            double weight = RaycastingHelper.getWeight(currentDistance, blockCount, distanceToEntity);
            RaycastResult rayResult = new RaycastResult(distanceToEntity, initialDirection, data);
            RayHitData hitData = new RayHitData(rayResult, initialDirection, weight);
            redRaysToTarget.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
        }
        for (RedTickableInstance redTickableInstance : tickQueue) {
            class_3959 raycastContext;
            class_3965 blockHit;
            boolean hasLineOfSight;
            data = new TickableSoundData((class_1113)redTickableInstance, redTickableInstance.getOriginalPosition(), redTickableInstance.method_4776().toString());
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList());
            class_243 entityCenter = redTickableInstance.getOriginalPosition();
            distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redTickableInstance.getOriginalVolume()) || !(hasLineOfSight = (blockHit = world.method_17742(raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() != class_239.class_240.field_1332 || currentPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 1.0)) continue;
            double weight = RaycastingHelper.getWeight(currentDistance, 0.0, distanceToEntity);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, data);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(data, 1, Integer::sum);
        }
    }

    private static double getWeight(double currentDistance, double blockCount, double distanceToEntity) {
        double blockAttenuation = Math.pow(0.7, blockCount);
        double weight = Config.getInstance().attenuationType == RedsAttenuationType.INVERSE_SQUARE ? blockAttenuation / (Math.max(distanceToEntity + currentDistance, 0.1) * Math.max(distanceToEntity + currentDistance, 0.1)) : blockAttenuation / Math.max(distanceToEntity + currentDistance, 0.1);
        return weight;
    }

    private static AveragedSoundData calculateWeightedAverages(SoundData entity, List<RayHitData> rayHits) {
        double totalWeight = 0.0;
        double weightedDistanceSum = 0.0;
        class_243 weightedDirectionSum = class_243.field_1353;
        for (RayHitData rayHit : rayHits) {
            double weight = rayHit.weight;
            totalWeight += weight;
            weightedDistanceSum += rayHit.rayResult.totalDistance * weight;
            class_243 weightedDirection = rayHit.rayResult.initialDirection.method_1021(weight);
            weightedDirectionSum = weightedDirectionSum.method_1019(weightedDirection);
        }
        if (totalWeight == 0.0) {
            return new AveragedSoundData(entity, weightedDirectionSum, weightedDistanceSum, totalWeight, rayHits.size(), rayHits);
        }
        double averageDistance = weightedDistanceSum / totalWeight;
        class_243 averageDirection = weightedDirectionSum.method_1021(1.0 / totalWeight).method_1029();
        return new AveragedSoundData(entity, averageDirection, averageDistance, totalWeight, rayHits.size(), rayHits);
    }

    private static double countBlocksBetween(class_1937 world, class_243 start, class_243 end, class_1657 player) {
        class_3959 context;
        class_3965 hit;
        double totalDistanceInBlocks;
        double distanceInBlock;
        class_243 currentStart = start;
        class_2338 endBlockPos = new class_2338((int)Math.floor(end.field_1352), (int)Math.floor(end.field_1351), (int)Math.floor(end.field_1350));
        for (totalDistanceInBlocks = 0.0; totalDistanceInBlocks < 3.0 && (hit = world.method_17742(context = new class_3959(currentStart, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() == class_239.class_240.field_1332; totalDistanceInBlocks += distanceInBlock) {
            class_243 exitPoint;
            class_243 direction;
            class_2338 hitBlockPos = hit.method_17777();
            class_2680 blockState = world.method_8320(hitBlockPos);
            if (hitBlockPos.equals((Object)endBlockPos)) break;
            if (!blockState.method_26215()) {
                direction = end.method_1020(currentStart).method_1029();
                class_265 blockShape = blockState.method_26218((class_1922)world, hitBlockPos);
                class_238 blockBounds = !blockShape.method_1110() ? blockShape.method_1107().method_996(hitBlockPos) : new class_238((double)hitBlockPos.method_10263(), (double)hitBlockPos.method_10264(), (double)hitBlockPos.method_10260(), (double)(hitBlockPos.method_10263() + 1), (double)(hitBlockPos.method_10264() + 1), (double)(hitBlockPos.method_10260() + 1));
                exitPoint = hit.method_17784();
                double step = Config.getInstance().permeationStepSize;
                while (blockBounds.method_1006(exitPoint)) {
                    exitPoint = exitPoint.method_1019(direction.method_1021(step));
                }
                distanceInBlock = hit.method_17784().method_1022(exitPoint);
            } else {
                throw new RuntimeException("Why tf is the raycasting getting stuck within air... WHAT HAVE YOU DONE!!!");
            }
            currentStart = exitPoint.method_1019(direction.method_1021(0.01));
            if (!(currentStart.method_1022(start) >= end.method_1022(start))) continue;
            break;
        }
        return totalDistanceInBlocks;
    }

    public static class_243 calculateReflection(class_243 incident, class_2350 hitSide) {
        class_243 normal = class_243.method_24954((class_2382)hitSide.method_10163());
        double dotProduct = incident.method_1026(normal);
        return incident.method_1020(normal.method_1021(2.0 * dotProduct));
    }

    public static class_243 calculateReflection(class_243 incident, class_243 normal) {
        double dotProduct = incident.method_1026(normal);
        return incident.method_1020(normal.method_1021(2.0 * dotProduct));
    }

    public static void displayEntityRayHitCounts(class_1937 world, class_1657 player) {
        if (world.method_8608() && !entityRayHitCounts.isEmpty()) {
            for (Map.Entry<SoundData, Integer> entry : entityRayHitCounts.entrySet()) {
                SoundData entity = entry.getKey();
                int rayCount = entry.getValue();
                class_243 entityPos = entity.position;
                class_243 displayPos = entityPos.method_1031(0.0, entity.position.field_1351, 0.0);
                String string = entity.soundId;
            }
        }
    }

    public static class_243[] generateRayDirections() {
        int numRays = Config.getInstance().raysCast;
        class_243[] directions = new class_243[numRays];
        double goldenRatio = (1.0 + Math.sqrt(5.0)) / 2.0;
        for (int i = 0; i < numRays; ++i) {
            double theta = Math.PI * 2 * (double)i / goldenRatio;
            double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)numRays);
            double x = Math.sin(phi) * Math.cos(theta);
            double y = Math.cos(phi);
            double z = Math.sin(phi) * Math.sin(theta);
            directions[i] = new class_243(x, y, z);
        }
        return directions;
    }

    public static void playQueuedObjects(int tsw) {
        if (freezeTickCounter.get()) {
            return;
        }
        if (!soundPlayingWaiting.containsKey(++ticksSinceWorld)) {
            return;
        }
        class_310 client = class_310.method_1551();
        ArrayList<class_1113> sound = soundPlayingWaiting.get(ticksSinceWorld);
        for (class_1113 newSound : sound) {
            if (newSound == null) continue;
            client.method_1483().method_4873(newSound);
        }
        soundPlayingWaiting.remove(tsw);
    }

    public static double getDistanceFromWallEcho() {
        return distanceFromWallEcho.get();
    }

    public static double getDistanceFromWallEchoDenom() {
        return distanceFromWallEchoDenom.get();
    }

    public static int getReverbStrength() {
        return reverbStrength.get();
    }

    public static int getReverbDenom() {
        return reverbDenom.get();
    }

    public static int getOutdoorLeak() {
        return outdoorLeak.get();
    }

    public static int getOutdoorLeakDenom() {
        return outdoorLeakDenom.get();
    }

    public static void shutdown() {
        try {
            raycastExecutor.shutdown();
            soundProcessingExecutor.shutdown();
            if (!raycastExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                raycastExecutor.shutdownNow();
            }
            if (!soundProcessingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                soundProcessingExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            raycastExecutor.shutdownNow();
            soundProcessingExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        distanceFromWallEcho = new AtomicReference<Double>(0.0);
        distanceFromWallEchoDenom = new AtomicReference<Double>(0.0);
        reverbStrength = new AtomicInteger(0);
        reverbDenom = new AtomicInteger(0);
        outdoorLeak = new AtomicInteger(0);
        outdoorLeakDenom = new AtomicInteger(0);
        surfaceMaterials = new ConcurrentHashMap();
        roomVolumeCache = new ConcurrentHashMap();
        totalSurfaceArea = new AtomicInteger(0);
        averageAbsorption = new AtomicReference<Double>(0.0);
        roomVolume = new AtomicReference<Double>(0.0);
        surfaceToVolumeRatio = new AtomicReference<Double>(0.0);
        earlyReflectionStrength = new AtomicReference<Double>(0.0);
        lateReflectionStrength = new AtomicReference<Double>(0.0);
        weightedReverbStrength = new AtomicReference<Double>(0.0);
        earlyReflectionCount = new AtomicInteger(0);
        lateReflectionCount = new AtomicInteger(0);
        rayHitsByEntity = new ConcurrentHashMap();
        redRaysToTarget = new ConcurrentHashMap();
        muffledAveragedResults = new ConcurrentHashMap();
        soundInstanceMap = new ConcurrentHashMap();
        soundPermInstanceMap = new ConcurrentHashMap();
        THREAD_POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
        raycastExecutor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
        soundProcessingExecutor = Executors.newFixedThreadPool(2);
        isRaytracing = new AtomicBoolean(false);
        freezeTickCounter = new AtomicBoolean(false);
        surfaceMaterials.put("default", new ReverbSurfaceData(0.05, 0.7, "medium"));
        FXQueue = new LinkedList<RedPermeatedSoundInstance>();
    }
}

