/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.mixin.client;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEntityMixin {
    private static int TICKS_SINCE_WORLD = 0;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void onPlayerTick(CallbackInfo ci) {
        Player player = (Player)this;
        Level world = player.level();
        if (!world.isClientSide()) {
            return;
        }
        RaycastingHelper.castBouncingRaysAndDetectSFX(world, player);
        RaycastingHelper.playQueuedObjects(++TICKS_SINCE_WORLD);
    }
}

