/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import lombok.Generated;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

public class RedPermeatedSoundInstance
extends RedTickableInstance {
    float permeationIndex;
    int tickCount = 0;
    private int id;
    public static Integer muffleFilter = -1;
    private boolean sourceSet = false;
    private float targetMuffle;

    public RedPermeatedSoundInstance(ResourceLocation soundID, Sound sound, SoundSource category, Vec3 position, float volume, float pitch, SoundInstance wrapped, Vec3 originalPos, float originalVolume, float permeationIndex) {
        super(soundID, sound, category, position, volume, pitch, wrapped, originalPos, originalVolume);
        this.permeationIndex = permeationIndex;
    }

    public void setPermeationIndex(float permeationIndex) {
        if (super.isStopped()) {
            return;
        }
        this.targetMuffle = permeationIndex;
    }

    @Override
    public void tick() {
        ++this.tickCount;
        if (super.isStopped() || Config.getInstance().tickRate == 0) {
            return;
        }
        if (this.tickCount % Config.getInstance().tickRate == 0) {
            RaycastingHelper.permeatedTickQueue.add(this);
        }
        super.updatePos();
        super.updateVolume();
        this.updateMuffle();
    }

    public void updateMuffle() {
        float deltaVolume = this.targetMuffle - this.permeationIndex;
        float maxVolumeChange = Math.abs(deltaVolume / (float)Config.getInstance().tickRate);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)Config.getInstance().tickRate) {
            this.permeationIndex = this.targetMuffle;
            if (this.sourceSet && AL10.alIsSource((int)this.id)) {
                this.applyMuffleToSource(this.id, this.permeationIndex);
            }
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.permeationIndex = deltaVolume > 0.0f ? (this.permeationIndex += volumeChange) : (this.permeationIndex -= volumeChange);
        if (this.sourceSet && AL10.alIsSource((int)this.id)) {
            this.applyMuffleToSource(this.id, 1.0f - this.permeationIndex);
        }
    }

    public void setSource(int id) {
        this.sourceSet = true;
        this.id = id;
    }

    public void applyMuffleToSource(int sourceId, float muffleStrength) {
        try {
            muffleStrength = RedPermeatedSoundInstance.clamp(muffleStrength, 0.0f, 1.0f);
            float lowpassGain = org.joml.Math.lerp((float)1.0f, (float)0.2f, (float)muffleStrength);
            float lowpassGainHF = org.joml.Math.lerp((float)1.0f, (float)0.1f, (float)muffleStrength);
            if (muffleFilter != -1) {
                EXTEfx.alFilterf((int)muffleFilter, (int)1, (float)lowpassGain);
                EXTEfx.alFilterf((int)muffleFilter, (int)2, (float)lowpassGainHF);
                AL11.alSourcei((int)sourceId, (int)131077, (int)muffleFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static float clamp(float a, float b, float c) {
        return Math.min(Math.max(a, b), c);
    }

    @Generated
    public float getPermeationIndex() {
        return this.permeationIndex;
    }
}

