/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import lombok.Generated;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL10;

public class RedPermeatedSoundInstance
extends RedTickableInstance {
    float permeationIndex;
    int tickCount = 0;
    private int id;
    private boolean sourceSet = false;
    private float targetMuffle;

    public RedPermeatedSoundInstance(ResourceLocation soundID, Sound sound, SoundSource category, Vec3 position, float volume, float pitch, SoundInstance wrapped, Vec3 originalPos, float originalVolume, float permeationIndex) {
        super(soundID, sound, category, position, volume, pitch, wrapped, originalPos, originalVolume);
        this.permeationIndex = permeationIndex;
    }

    public void setPermeationIndex(float permeationIndex) {
        if (super.isStopped()) {
            return;
        }
        this.targetMuffle = permeationIndex;
    }

    @Override
    public void tick() {
        ++this.tickCount;
        if (super.isStopped() || Config.getInstance().permeatedTickRate == 0) {
            return;
        }
        if (this.tickCount % Config.getInstance().permeatedTickRate == 0 && !RaycastingHelper.permeatedTickQueue.contains(this)) {
            RaycastingHelper.permeatedTickQueue.add(this);
        }
        super.updatePos();
        super.updateVolume();
        this.updateMuffle();
    }

    public void updateMuffle() {
        float deltaVolume = this.targetMuffle - this.permeationIndex;
        float maxVolumeChange = Math.max(Math.abs(deltaVolume / (float)Config.getInstance().tickRate), 0.3f);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)Config.getInstance().tickRate) {
            this.permeationIndex = this.targetMuffle;
            if (this.sourceSet && AL10.alIsSource((int)this.id)) {
                RaycastingHelper.fxHandler.applyMuffleToSource(this.id, this.permeationIndex);
            }
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.permeationIndex = deltaVolume > 0.0f ? (this.permeationIndex += volumeChange) : (this.permeationIndex -= volumeChange);
        if (this.sourceSet && AL10.alIsSource((int)this.id)) {
            RaycastingHelper.fxHandler.applyMuffleToSource(this.id, 1.0f - this.permeationIndex);
        }
    }

    public void setSource(int id) {
        this.sourceSet = true;
        this.id = id;
    }

    private static float clamp(float a, float b, float c) {
        return Math.min(Math.max(a, b), c);
    }

    @Generated
    public float getPermeationIndex() {
        return this.permeationIndex;
    }
}

