/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class RedTickableInstance
implements class_1117 {
    private final class_2960 soundID;
    private final class_1111 sound;
    private final class_3419 category;
    private final class_243 originalPos;
    private final float originalVolume;
    private class_1113 wrapped;
    private double x;
    private double y;
    private double z;
    private boolean done;
    private float volume;
    private float pitch;
    private int tickCount;
    private class_243 targetPosition;
    private float targetVolume;

    public RedTickableInstance(class_2960 soundID, class_1111 sound, class_3419 category, class_243 position, float volume, float pitch, class_1113 wrapped, class_243 originalPos, float originalVolume) {
        this.soundID = soundID;
        this.sound = sound;
        this.category = category;
        this.x = position.field_1352;
        this.y = position.field_1351;
        this.z = position.field_1350;
        this.done = false;
        this.volume = volume;
        this.pitch = pitch;
        this.wrapped = wrapped;
        this.originalPos = originalPos;
        this.originalVolume = originalVolume;
        this.tickCount = 0;
        this.targetPosition = position;
        this.targetVolume = volume;
    }

    public boolean method_4793() {
        return this.done;
    }

    public void method_16896() {
        ++this.tickCount;
        if (this.done || RaycastingHelper.TICK_RATE == 0) {
            return;
        }
        if (this.tickCount % RaycastingHelper.TICK_RATE == 0) {
            RaycastingHelper.tickQueue.add(this);
        }
        if (this.wrapped instanceof class_1117) {
            ((class_1117)this.wrapped).method_16896();
        }
        this.updatePos();
        this.updateVolume();
    }

    public class_2960 method_4775() {
        return this.soundID;
    }

    @Nullable
    public class_1146 method_4783(class_1144 soundManager) {
        return this.wrapped.method_4783(soundManager);
    }

    public class_1111 method_4776() {
        return this.sound;
    }

    public class_3419 method_4774() {
        return this.category;
    }

    public boolean method_4786() {
        return this.wrapped.method_4786();
    }

    public class_243 getOriginalPosition() {
        return this.originalPos;
    }

    public double method_4784() {
        return this.x;
    }

    public double method_4779() {
        return this.y;
    }

    public double method_4778() {
        return this.z;
    }

    public boolean method_4785() {
        return this.wrapped.method_4785();
    }

    public boolean method_4787() {
        return this.wrapped.method_4787();
    }

    public int method_4780() {
        return this.wrapped.method_4780();
    }

    public float method_4781() {
        return this.volume;
    }

    public float method_4782() {
        return this.pitch;
    }

    public class_1113.class_1114 method_4777() {
        return class_1113.class_1114.field_5478;
    }

    public void stop() {
        this.done = true;
    }

    public void setPos(class_243 targetPosition) {
        this.targetPosition = targetPosition;
    }

    public void updatePos() {
        double deltaX = this.targetPosition.method_10216() - this.x;
        double deltaY = this.targetPosition.method_10214() - this.y;
        double deltaZ = this.targetPosition.method_10215() - this.z;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double maxSpeed = 17.15;
        if (distance <= 0.001 || distance > maxSpeed * (double)RaycastingHelper.TICK_RATE) {
            this.x = this.targetPosition.method_10216();
            this.y = this.targetPosition.method_10214();
            this.z = this.targetPosition.method_10215();
            return;
        }
        double moveDistance = Math.min(maxSpeed, distance);
        double moveX = deltaX / distance * moveDistance;
        double moveY = deltaY / distance * moveDistance;
        double moveZ = deltaZ / distance * moveDistance;
        this.x += moveX;
        this.y += moveY;
        this.z += moveZ;
    }

    public void setVolume(float targetVolume) {
        if (!this.soundID.toString().contains("rain")) {
            this.targetVolume = targetVolume;
        }
    }

    public void updateVolume() {
        float deltaVolume = this.targetVolume - this.volume;
        float maxVolumeChange = Math.abs(deltaVolume / (float)RaycastingHelper.TICK_RATE);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)RaycastingHelper.TICK_RATE) {
            this.volume = this.targetVolume;
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.volume = deltaVolume > 0.0f ? (this.volume += volumeChange) : (this.volume -= volumeChange);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public float getOriginalVolume() {
        return this.originalVolume;
    }

    protected class_1113 getOriginal() {
        return this.wrapped;
    }
}

