/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected;

import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.RedsAttenuationType;
import com.redsmods.sound_physics_perfected.ReverbHelpers.EnhancedReverbData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.ReverbSurfaceData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.RoomVolumeData;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.storageclasses.AveragedSoundData;
import com.redsmods.sound_physics_perfected.storageclasses.BlueRayResult;
import com.redsmods.sound_physics_perfected.storageclasses.RayHitData;
import com.redsmods.sound_physics_perfected.storageclasses.RaycastResult;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.storageclasses.TickableSoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RaycastingHelper {
    public static final Queue<RedTickableInstance> tickQueue = new LinkedList<RedTickableInstance>();
    public static final Queue<RedPermeatedSoundInstance> permeatedTickQueue = new LinkedList<RedPermeatedSoundInstance>();
    private static final ConcurrentHashMap<SoundData, Integer> entityRayHitCounts = new ConcurrentHashMap();
    public static final Queue<SoundData> soundQueue = new LinkedList<SoundData>();
    public static final Queue<SoundData> weatherQueue = new LinkedList<SoundData>();
    private static final double SPEED_OF_SOUND_TICKS = 17.15;
    private static final Map<Integer, ArrayList<SoundInstance>> soundPlayingWaiting = new ConcurrentHashMap<Integer, ArrayList<SoundInstance>>();
    private static int ticksSinceWorld;
    private static final AtomicReference<Double> distanceFromWallEcho;
    private static final AtomicReference<Double> distanceFromWallEchoDenom;
    private static final AtomicInteger reverbStrength;
    private static final AtomicInteger reverbDenom;
    private static final AtomicInteger outdoorLeak;
    private static final AtomicInteger outdoorLeakDenom;
    private static final ConcurrentHashMap<String, ReverbSurfaceData> surfaceMaterials;
    private static final ConcurrentHashMap<Vec3, RoomVolumeData> roomVolumeCache;
    private static final AtomicInteger totalSurfaceArea;
    private static final AtomicReference<Double> averageAbsorption;
    private static final AtomicReference<Double> roomVolume;
    private static final AtomicReference<Double> surfaceToVolumeRatio;
    private static final AtomicReference<Double> earlyReflectionStrength;
    private static final AtomicReference<Double> lateReflectionStrength;
    private static final AtomicReference<Double> weightedReverbStrength;
    private static final AtomicInteger earlyReflectionCount;
    private static final AtomicInteger lateReflectionCount;
    private static final ConcurrentHashMap<SoundData, List<RayHitData>> rayHitsByEntity;
    private static final ConcurrentHashMap<SoundData, List<RayHitData>> redRaysToTarget;
    private static final ConcurrentHashMap<SoundData, AveragedSoundData> muffledAveragedResults;
    public static final ConcurrentHashMap<SoundInstance, SoundInstance> soundInstanceMap;
    public static final ConcurrentHashMap<SoundInstance, RedPermeatedSoundInstance> soundPermInstanceMap;
    private static final int THREAD_POOL_SIZE;
    private static final ExecutorService raycastExecutor;
    private static final ExecutorService soundProcessingExecutor;
    private static final AtomicBoolean isRaytracing;
    private static final AtomicBoolean freezeTickCounter;
    public static final Queue<RedPermeatedSoundInstance> FXQueue;

    public static void castBouncingRaysAndDetectSFX(Level world, Player player) {
        try {
            if (!isRaytracing.compareAndSet(false, true)) {
                return;
            }
            Vec3 playerEyePos = player.getEyePosition();
            double maxTotalDistance = 16.0 * (double)Config.getInstance().maxRayLength * (double)Config.getInstance().raysBounced;
            entityRayHitCounts.clear();
            Minecraft client = Minecraft.getInstance();
            if (client == null || client.getSoundManager() == null) {
                isRaytracing.set(false);
                return;
            }
            if (soundQueue.isEmpty() && tickQueue.isEmpty() && permeatedTickQueue.isEmpty()) {
                isRaytracing.set(false);
                return;
            }
            weatherQueue.clear();
            Iterator iterator = soundQueue.iterator();
            while (iterator.hasNext()) {
                SoundData sound = (SoundData)iterator.next();
                if (!sound.soundId.contains("rain")) continue;
                weatherQueue.add(sound);
                iterator.remove();
            }
            Vec3[] rayDirections = RaycastingHelper.generateRayDirections();
            rayHitsByEntity.clear();
            redRaysToTarget.clear();
            RaycastingHelper.processAndPlayAveragedSounds(world, player, playerEyePos, new ArrayList<Vec3>(Arrays.asList(rayDirections)), soundQueue, maxTotalDistance, client);
            RaycastingHelper.displayEntityRayHitCounts(world, player);
            tickQueue.clear();
            soundQueue.clear();
            permeatedTickQueue.clear();
            isRaytracing.set(false);
        }
        catch (Exception e) {
            System.err.println("Error in player bouncing ray entity detection: " + e.getMessage());
        }
    }

    public static void processAndPlayAveragedSounds(Level world, Player player, Vec3 playerEyePos, List<Vec3> rayDirections, Queue<SoundData> soundQueue, double maxTotalDistance, Minecraft client) {
        CompletableFuture<Void> task;
        Map<SoundData, AveragedSoundData> averagedResults = RaycastingHelper.processRaysWithAveraging(world, player, playerEyePos, rayDirections, soundQueue, maxTotalDistance);
        if (averagedResults.isEmpty() && muffledAveragedResults.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture<Void>> soundTasks = new ArrayList<CompletableFuture<Void>>();
        freezeTickCounter.set(true);
        for (AveragedSoundData avgData : averagedResults.values()) {
            task = CompletableFuture.runAsync(() -> RaycastingHelper.playAveragedSoundWithAdjustments(client, avgData, playerEyePos, 1.0f, 1.0f), soundProcessingExecutor);
            soundTasks.add(task);
        }
        if (Config.getInstance().permeation) {
            for (AveragedSoundData avgData : muffledAveragedResults.values()) {
                task = CompletableFuture.runAsync(() -> RaycastingHelper.playMuffled(client, avgData, playerEyePos, 1.0f, 1.0f), soundProcessingExecutor);
                soundTasks.add(task);
            }
        }
        freezeTickCounter.set(false);
        CompletableFuture.allOf(soundTasks.toArray(new CompletableFuture[0])).join();
    }

    public static void playAveragedSoundWithAdjustments(Minecraft client, AveragedSoundData avgData, Vec3 playerPos, float volumeMultiplier, float pitchMultiplier) {
        if (client == null || client.level == null || avgData == null) {
            return;
        }
        try {
            Vec3 targetPosition = playerPos.add(avgData.averageDirection.scale(avgData.averageDistance));
            SoundInstance originalSound = avgData.soundEntity.sound;
            ResourceLocation soundId = originalSound.getLocation();
            if (avgData.totalWeight == 0.0 && originalSound instanceof RedTickableInstance) {
                ((RedTickableInstance)originalSound).setVolume(0.0f);
                return;
            }
            float baseVolume = originalSound instanceof RedTickableInstance ? ((RedTickableInstance)originalSound).getOriginalVolume() : ((RedSoundInstance)originalSound).original.getVolume();
            float confidenceMultiplier = (float)avgData.totalWeight / (float)Config.getInstance().raysCast * (float)Config.getInstance().raysBounced;
            confidenceMultiplier = Math.min(confidenceMultiplier, 1.0f);
            float adjustedVolume = baseVolume * volumeMultiplier * confidenceMultiplier;
            float basePitch = originalSound.getPitch();
            float adjustedPitch = basePitch * pitchMultiplier;
            if (originalSound instanceof RedTickableInstance) {
                ((RedTickableInstance)originalSound).setTargetPosition(targetPosition);
                ((RedTickableInstance)originalSound).setVolume(Math.max(0.01f, Math.min(1.0f, adjustedVolume)));
                return;
            }
            RedTickableInstance newSound = (RedSoundInstance)originalSound instanceof TickableSoundInstance ? new RedTickableInstance(soundId, originalSound.getSound(), originalSound.getSource(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new Vec3(originalSound.getX(), originalSound.getY(), originalSound.getZ()), baseVolume) : new RedTickableInstance(soundId, originalSound.getSound(), originalSound.getSource(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new Vec3(originalSound.getX(), originalSound.getY(), originalSound.getZ()), baseVolume);
            soundInstanceMap.put(((RedSoundInstance)originalSound).getOriginal(), (SoundInstance)newSound);
            if ((double)adjustedVolume <= 0.01) {
                return;
            }
            RaycastingHelper.queueSound((SoundInstance)newSound, (int)(avgData.averageDistance / 17.15));
        }
        catch (Exception e) {
            System.err.println("Error playing adjusted averaged sound: " + e.getMessage());
        }
    }

    public static void playMuffled(Minecraft client, AveragedSoundData avgData, Vec3 playerPos, float volumeMultiplier, float pitchMultiplier) {
        if (client == null || client.level == null || avgData == null) {
            return;
        }
        try {
            Vec3 targetPosition = playerPos.add(avgData.averageDirection.scale(avgData.averageDistance));
            SoundInstance originalSound = avgData.soundEntity.sound;
            ResourceLocation soundId = originalSound.getLocation();
            float baseVolume = originalSound instanceof RedTickableInstance ? ((RedTickableInstance)originalSound).getOriginalVolume() : ((RedSoundInstance)originalSound).original.getVolume();
            float confidenceMultiplier = (float)avgData.totalWeight / (float)Config.getInstance().raysCast * (float)Config.getInstance().raysBounced;
            float adjustedVolume = baseVolume * volumeMultiplier * confidenceMultiplier;
            if ((double)confidenceMultiplier > 0.9) {
                adjustedVolume = 0.0f;
            }
            float basePitch = originalSound.getPitch();
            float adjustedPitch = basePitch * pitchMultiplier;
            if (originalSound instanceof RedTickableInstance) {
                ((RedPermeatedSoundInstance)originalSound).setTargetPosition(targetPosition);
                ((RedPermeatedSoundInstance)originalSound).setVolume(Math.max(0.01f, Math.min(1.0f, adjustedVolume)));
                ((RedPermeatedSoundInstance)originalSound).setPermeationIndex(confidenceMultiplier);
                return;
            }
            RedPermeatedSoundInstance newSound = new RedPermeatedSoundInstance(soundId, originalSound.getSound(), originalSound.getSource(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new Vec3(originalSound.getX(), originalSound.getY(), originalSound.getZ()), baseVolume, confidenceMultiplier);
            soundPermInstanceMap.put(((RedSoundInstance)originalSound).getOriginal(), newSound);
            RaycastingHelper.queueSound((SoundInstance)newSound, (int)(avgData.averageDistance / 17.15));
        }
        catch (Exception e) {
            System.err.println("Error playing adjusted averaged sound: " + e.getMessage());
        }
    }

    private static void queueSound(SoundInstance newSound, int distance) {
        soundPlayingWaiting.computeIfAbsent(ticksSinceWorld + 1, k -> new ArrayList()).add(newSound);
    }

    public static Map<SoundData, AveragedSoundData> processRaysWithAveraging(Level world, Player player, Vec3 playerEyePos, List<Vec3> rayDirections, Queue<SoundData> soundQueue, double maxTotalDistance) {
        AveragedSoundData averagedData;
        List<RayHitData> rayHits;
        SoundData entity;
        reverbStrength.set(0);
        distanceFromWallEcho.set(0.0);
        distanceFromWallEchoDenom.set(0.0);
        reverbDenom.set(0);
        outdoorLeak.set(0);
        outdoorLeakDenom.set(0);
        ConcurrentLinkedQueue<SoundData> threadSafeSoundQueue = new ConcurrentLinkedQueue<SoundData>(soundQueue);
        int raysPerChunk = Math.max(1, rayDirections.size() / THREAD_POOL_SIZE);
        ArrayList<List<Vec3>> rayChunks = new ArrayList<List<Vec3>>();
        for (int i = 0; i < rayDirections.size(); i += raysPerChunk) {
            int endIndex = Math.min(i + raysPerChunk, rayDirections.size());
            rayChunks.add(rayDirections.subList(i, endIndex));
        }
        ArrayList<CompletableFuture<Void>> rayTasks = new ArrayList<CompletableFuture<Void>>();
        for (List list : rayChunks) {
            CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                for (Vec3 direction : rayChunk) {
                    RaycastingHelper.castBouncingRay(world, player, playerEyePos, direction, threadSafeSoundQueue, maxTotalDistance);
                }
            }, raycastExecutor);
            rayTasks.add(task);
        }
        CompletableFuture.allOf(rayTasks.toArray(new CompletableFuture[0])).join();
        ConcurrentHashMap<SoundData, AveragedSoundData> averagedResults = new ConcurrentHashMap<SoundData, AveragedSoundData>();
        muffledAveragedResults.clear();
        for (Map.Entry<SoundData, List<RayHitData>> entry : rayHitsByEntity.entrySet()) {
            entity = entry.getKey();
            rayHits = entry.getValue();
            averagedData = RaycastingHelper.calculateWeightedAverages(entity, rayHits);
            averagedResults.put(entity, averagedData);
        }
        for (Map.Entry<SoundData, List<RayHitData>> entry : redRaysToTarget.entrySet()) {
            entity = entry.getKey();
            rayHits = entry.getValue();
            averagedData = RaycastingHelper.calculateWeightedAverages(entity, rayHits);
            muffledAveragedResults.put(entity, averagedData);
        }
        return averagedResults;
    }

    public static RaycastResult castBouncingRay(Level world, Player player, Vec3 startPos, Vec3 direction, Queue<SoundData> soundQueue, double maxTotalDistance) {
        double segmentTraveled;
        Vec3 currentPos = startPos;
        Vec3 currentDirection = direction.normalize();
        Vec3 initialDirection = currentDirection.normalize();
        double remainingDistance = maxTotalDistance;
        double totalDistanceTraveled = 0.0;
        SoundData hitEntity = null;
        if (Config.getInstance().permeation) {
            RaycastingHelper.castRedRay(world, player, startPos, soundQueue, totalDistanceTraveled, initialDirection);
        }
        RaycastingHelper.castGreenRay(world, player, startPos, soundQueue, totalDistanceTraveled, initialDirection);
        for (int bounce = 0; bounce <= Config.getInstance().raysBounced && remainingDistance > 0.0; remainingDistance -= segmentTraveled, ++bounce) {
            double segmentDistance = Math.min(16.0 * (double)Config.getInstance().maxRayLength, remainingDistance);
            Vec3 segmentEnd = currentPos.add(currentDirection.scale(segmentDistance));
            ClipContext raycastContext = new ClipContext(currentPos, segmentEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult blockHit = world.clip(raycastContext);
            Vec3 actualEnd = segmentEnd;
            boolean hitBlock = false;
            if (blockHit.getType() == HitResult.Type.BLOCK) {
                actualEnd = blockHit.getLocation();
                hitBlock = true;
            }
            segmentTraveled = currentPos.distanceTo(actualEnd);
            totalDistanceTraveled += segmentTraveled;
            totalDistanceTraveled *= Config.getInstance().rayBounce;
            if (hitBlock) {
                if (Config.getInstance().reverb) {
                    BlueRayResult blueRayResult = RaycastingHelper.castBlueRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection, bounce);
                    if (blueRayResult.arrived) {
                        initialDirection = blueRayResult.directionFromPlayer;
                        totalDistanceTraveled = blueRayResult.distance;
                        totalDistanceTraveled *= Config.getInstance().rayBounce;
                    }
                }
                if (Config.getInstance().permeation) {
                    RaycastingHelper.castRedRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
                }
                RaycastingHelper.castGreenRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
            }
            if (hitBlock) {
                Vec3 hitPos = blockHit.getLocation();
                Direction hitSide = blockHit.getDirection();
                Vec3 reflectedDirection = RaycastingHelper.calculateReflection(currentDirection, hitSide);
                currentPos = hitPos.add(reflectedDirection.scale(0.01));
                currentDirection = reflectedDirection;
            } else {
                for (SoundData soundEntity : weatherQueue) {
                    double weight = Config.getInstance().attenuationType == RedsAttenuationType.INVERSE_SQUARE ? 1.0 / (Math.max(totalDistanceTraveled - segmentTraveled, 0.1) * Math.max(totalDistanceTraveled - segmentTraveled, 0.1)) : 1.0 / Math.max(totalDistanceTraveled - segmentTraveled, 0.1);
                    RaycastResult GreenRayResult = new RaycastResult(maxTotalDistance, initialDirection, soundEntity);
                    RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
                    rayHitsByEntity.computeIfAbsent(soundEntity, k -> new CopyOnWriteArrayList()).add(hitData);
                    entityRayHitCounts.merge(soundEntity, 1, Integer::sum);
                }
                Vec3 toCenter = player.position().subtract(actualEnd);
                Vec3 normal = toCenter.normalize();
                Vec3 reflectedDirection = RaycastingHelper.calculateReflection(currentDirection, normal);
                currentPos = segmentEnd.add(reflectedDirection.scale(0.01));
                currentDirection = reflectedDirection;
                remainingDistance -= segmentTraveled;
                outdoorLeak.incrementAndGet();
                outdoorLeakDenom.incrementAndGet();
                return null;
            }
            outdoorLeakDenom.incrementAndGet();
        }
        return new RaycastResult(totalDistanceTraveled, initialDirection, hitEntity);
    }

    private static void castGreenRay(Level world, Player player, Vec3 currentPos, Queue<SoundData> entities, double currentDistance, Vec3 initialDirection) {
        for (SoundData soundData : entities) {
            ClipContext raycastContext;
            BlockHitResult blockHit;
            boolean hasLineOfSight;
            Vec3 entityCenter = soundData.position;
            double distanceToEntity = currentPos.distanceTo(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * soundData.sound.getVolume()) || !(hasLineOfSight = (blockHit = world.clip(raycastContext = new ClipContext(currentPos, entityCenter, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).getType() != HitResult.Type.BLOCK || currentPos.distanceTo(blockHit.getLocation()) >= distanceToEntity - 1.0)) continue;
            double weight = Config.getInstance().attenuationType == RedsAttenuationType.INVERSE_SQUARE ? 1.0 / (Math.max(distanceToEntity + currentDistance, 0.1) * Math.max(distanceToEntity + currentDistance, 0.1)) : 1.0 / Math.max(distanceToEntity + currentDistance, 0.1);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, soundData);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(soundData, 1, Integer::sum);
        }
        for (RedTickableInstance redTickableInstance : tickQueue) {
            ClipContext raycastContext;
            BlockHitResult blockHit;
            boolean hasLineOfSight;
            TickableSoundData data = new TickableSoundData((SoundInstance)redTickableInstance, redTickableInstance.getOriginalPosition(), redTickableInstance.getSound().getLocation().toString());
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList());
            Vec3 entityCenter = redTickableInstance.getOriginalPosition();
            double distanceToEntity = currentPos.distanceTo(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redTickableInstance.getOriginalVolume()) || !(hasLineOfSight = (blockHit = world.clip(raycastContext = new ClipContext(currentPos, entityCenter, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).getType() != HitResult.Type.BLOCK || currentPos.distanceTo(blockHit.getLocation()) >= distanceToEntity - 1.0)) continue;
            double weight = Config.getInstance().attenuationType == RedsAttenuationType.INVERSE_SQUARE ? 1.0 / (Math.max(distanceToEntity + currentDistance, 0.1) * Math.max(distanceToEntity + currentDistance, 0.1)) : 1.0 / Math.max(distanceToEntity + currentDistance, 0.1);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, data);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(data, 1, Integer::sum);
        }
    }

    private static BlueRayResult castBlueRay(Level world, Player player, Vec3 currentPos, Queue<SoundData> entities, double currentDistance, Vec3 initialDirection, int bounceNumber) {
        double reflectionDelay;
        boolean hasLineOfSight;
        Vec3 entityCenter = player.getBoundingBox().getCenter();
        Vec3 adjustedPos = currentPos.add(entityCenter.subtract(currentPos).scale(0.87));
        double distanceToEntity = adjustedPos.distanceTo(entityCenter);
        ClipContext raycastContext = new ClipContext(adjustedPos, entityCenter, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult blockHit = world.clip(raycastContext);
        boolean bl = hasLineOfSight = blockHit.getType() != HitResult.Type.BLOCK || adjustedPos.distanceTo(blockHit.getLocation()) >= distanceToEntity - 0.6;
        if (bounceNumber <= 2) {
            RaycastingHelper.analyzeSurfaceAtPosition(world, currentPos, currentDistance, hasLineOfSight);
        }
        if ((reflectionDelay = currentDistance / 17.15) < 0.05) {
            earlyReflectionStrength.updateAndGet(current -> current + (hasLineOfSight ? 1.0 : 0.0));
            earlyReflectionCount.incrementAndGet();
        } else {
            lateReflectionStrength.updateAndGet(current -> current + (hasLineOfSight ? 0.6 : 0.0));
            lateReflectionCount.incrementAndGet();
        }
        reverbDenom.incrementAndGet();
        if (hasLineOfSight) {
            distanceFromWallEcho.updateAndGet(current -> current + currentDistance);
            distanceFromWallEchoDenom.updateAndGet(current -> current + 1.0);
            reverbStrength.incrementAndGet();
            Vec3 toPlayer = entityCenter.subtract(currentPos).normalize();
            Vec3 playerToAdjustedPos = adjustedPos.subtract(entityCenter);
            Vec3 reflectionAngle = initialDirection.subtract(toPlayer);
            double angleDeviation = Math.abs(reflectionAngle.length());
            double reflectionQuality = Math.max(0.1, 1.0 - angleDeviation);
            weightedReverbStrength.updateAndGet(current -> current + reflectionQuality);
            return new BlueRayResult(true, playerToAdjustedPos, entityCenter.distanceTo(adjustedPos));
        }
        return new BlueRayResult(false, null, -1.0);
    }

    private static void analyzeSurfaceAtPosition(Level world, Vec3 pos, double distance, boolean hasLineOfSight) {
        BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
        BlockState blockState = world.getBlockState(blockPos);
        if (!blockState.isAir()) {
            String materialName = blockState.getBlock().getName().getString().toLowerCase();
            ReverbSurfaceData surfaceData = surfaceMaterials.getOrDefault(materialName, surfaceMaterials.get("default"));
            double distanceWeight = 1.0 / Math.max(distance, 1.0);
            averageAbsorption.updateAndGet(current -> current + surfaceData.absorptionCoefficient * distanceWeight);
            totalSurfaceArea.updateAndGet(current -> current + 1);
            if (hasLineOfSight) {
                RaycastingHelper.analyzeRoomDimensions(world, pos, blockPos);
            }
        }
    }

    private static void analyzeRoomDimensions(Level world, Vec3 center, BlockPos hitPos) {
        double[] distances = new double[6];
        Vec3[] directions = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, -1.0)};
        for (int i = 0; i < 6; ++i) {
            distances[i] = RaycastingHelper.measureDistanceToWall(world, center, directions[i], 16.0);
        }
        double width = distances[0] + distances[1];
        double height = distances[2] + distances[3];
        double depth = distances[4] + distances[5];
        double estimatedVolume = width * height * depth;
        roomVolume.updateAndGet(current -> Math.max(current, estimatedVolume));
        double estimatedSurfaceArea = 2.0 * (width * height + width * depth + height * depth);
        if (estimatedVolume > 0.0) {
            surfaceToVolumeRatio.updateAndGet(current -> Math.max(current, estimatedSurfaceArea / estimatedVolume));
        }
    }

    private static double measureDistanceToWall(Level world, Vec3 start, Vec3 direction, double maxDistance) {
        for (double d = 1.0; d < maxDistance; d += 1.0) {
            Vec3 testPos = start.add(direction.scale(d));
            BlockPos blockPos = new BlockPos((int)testPos.x, (int)testPos.y, (int)testPos.z);
            if (world.getBlockState(blockPos).isAir()) continue;
            return d;
        }
        return maxDistance;
    }

    public static EnhancedReverbData calculateEnhancedReverb() {
        double totalSurface = totalSurfaceArea.get();
        double avgAbsorption = totalSurface > 0.0 ? averageAbsorption.get() / totalSurface : 0.05;
        double volume = roomVolume.get();
        double surfaceToVolRatio = surfaceToVolumeRatio.get();
        double totalAbsorption = totalSurface * avgAbsorption;
        double rt60 = totalAbsorption > 0.0 ? 0.161 * volume / totalAbsorption : 0.0;
        rt60 = Math.min(rt60, 8.0);
        double roomRadius = Math.cbrt(volume * 3.0 / (Math.PI * 4));
        double earlyReflectionDelay = roomRadius / 17.15;
        double earlyStrength = earlyReflectionCount.get() > 0 ? earlyReflectionStrength.get() / (double)earlyReflectionCount.get() : 0.0;
        double lateStrength = lateReflectionCount.get() > 0 ? lateReflectionStrength.get() / (double)lateReflectionCount.get() : 0.0;
        String acousticProfile = RaycastingHelper.determineAcousticProfile(avgAbsorption, surfaceToVolRatio, volume);
        boolean isIndoors = surfaceToVolRatio > 0.5 && volume < 8000.0;
        return new EnhancedReverbData(rt60, earlyReflectionDelay, lateStrength, roomRadius, avgAbsorption, acousticProfile, isIndoors);
    }

    private static String determineAcousticProfile(double absorption, double surfaceToVolRatio, double volume) {
        if (volume > 10000.0) {
            return "cathedral";
        }
        if (absorption > 0.6) {
            return "padded_room";
        }
        if (absorption < 0.1 && surfaceToVolRatio < 0.3) {
            return "gymnasium";
        }
        if (surfaceToVolRatio > 1.0) {
            return "small_room";
        }
        if (absorption > 0.3) {
            return "living_room";
        }
        return "generic_room";
    }

    public static EnhancedReverbData getEnhancedReverbData() {
        return RaycastingHelper.calculateEnhancedReverb();
    }

    public static double getWeightedReverbStrength() {
        return weightedReverbStrength.get();
    }

    public static double getEarlyReflectionRatio() {
        int totalLate;
        int totalEarly = earlyReflectionCount.get();
        int total = totalEarly + (totalLate = lateReflectionCount.get());
        return total > 0 ? (double)totalEarly / (double)total : 0.0;
    }

    private static void castRedRay(Level world, Player player, Vec3 currentPos, Queue<SoundData> entities, double currentDistance, Vec3 initialDirection) {
        Vec3 entityCenter;
        for (SoundData soundData : entities) {
            entityCenter = soundData.position;
            double distanceToEntity = currentPos.distanceTo(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * soundData.sound.getVolume())) continue;
            ClipContext raycastContext = new ClipContext(currentPos, entityCenter, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult blockHit = world.clip(raycastContext);
            currentPos = blockHit.getLocation();
            double blockCount = RaycastingHelper.countBlocksBetween(world, currentPos, entityCenter, player);
            double blockAttenuation = Math.pow(0.7, blockCount);
            double weight = blockAttenuation / (Math.max(distanceToEntity, 0.1) * Math.max(distanceToEntity, 0.1));
            RaycastResult rayResult = new RaycastResult(distanceToEntity, initialDirection, soundData);
            RayHitData hitData = new RayHitData(rayResult, initialDirection, weight);
            redRaysToTarget.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
        }
        for (RedPermeatedSoundInstance redPermeatedSoundInstance : permeatedTickQueue) {
            entityCenter = redPermeatedSoundInstance.getOriginalPosition();
            TickableSoundData data = new TickableSoundData((SoundInstance)redPermeatedSoundInstance, redPermeatedSoundInstance.getOriginalPosition(), redPermeatedSoundInstance.getSound().getLocation().toString());
            double distanceToEntity = currentPos.distanceTo(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redPermeatedSoundInstance.getOriginalVolume())) continue;
            ClipContext context = new ClipContext(currentPos, entityCenter, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult blockHit = world.clip(context);
            currentPos = blockHit.getLocation();
            double blockCount = RaycastingHelper.countBlocksBetween(world, currentPos, entityCenter, player);
            double blockAttenuation = Math.pow(0.7, blockCount);
            double weight = blockAttenuation / (Math.max(distanceToEntity, 0.1) * Math.max(distanceToEntity, 0.1));
            RaycastResult rayResult = new RaycastResult(distanceToEntity, initialDirection, data);
            RayHitData hitData = new RayHitData(rayResult, initialDirection, weight);
            redRaysToTarget.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
        }
    }

    private static AveragedSoundData calculateWeightedAverages(SoundData entity, List<RayHitData> rayHits) {
        double totalWeight = 0.0;
        double weightedDistanceSum = 0.0;
        Vec3 weightedDirectionSum = Vec3.ZERO;
        for (RayHitData rayHit : rayHits) {
            double weight = rayHit.weight;
            totalWeight += weight;
            weightedDistanceSum += rayHit.rayResult.totalDistance * weight;
            Vec3 weightedDirection = rayHit.rayResult.initialDirection.scale(weight);
            weightedDirectionSum = weightedDirectionSum.add(weightedDirection);
        }
        if (totalWeight == 0.0) {
            return new AveragedSoundData(entity, weightedDirectionSum, weightedDistanceSum, totalWeight, rayHits.size(), rayHits);
        }
        double averageDistance = weightedDistanceSum / totalWeight;
        Vec3 averageDirection = weightedDirectionSum.scale(1.0 / totalWeight).normalize();
        return new AveragedSoundData(entity, averageDirection, averageDistance, totalWeight, rayHits.size(), rayHits);
    }

    private static double countBlocksBetween(Level world, Vec3 start, Vec3 end, Player player) {
        ClipContext context;
        BlockHitResult hit;
        double totalDistanceInBlocks;
        double distanceInBlock;
        Vec3 currentStart = start;
        for (totalDistanceInBlocks = 0.0; totalDistanceInBlocks < 3.0 && (hit = world.clip(context = new ClipContext(currentStart, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).getType() == HitResult.Type.BLOCK; totalDistanceInBlocks += distanceInBlock) {
            Vec3 exitPoint;
            Vec3 direction;
            BlockPos hitBlockPos = hit.getBlockPos();
            BlockState blockState = world.getBlockState(hitBlockPos);
            if (!blockState.isAir()) {
                direction = end.subtract(currentStart).normalize();
                VoxelShape blockShape = blockState.getShape((BlockGetter)world, hitBlockPos);
                AABB blockBounds = !blockShape.isEmpty() ? blockShape.bounds().move(hitBlockPos) : new AABB((double)hitBlockPos.getX(), (double)hitBlockPos.getY(), (double)hitBlockPos.getZ(), (double)(hitBlockPos.getX() + 1), (double)(hitBlockPos.getY() + 1), (double)(hitBlockPos.getZ() + 1));
                exitPoint = hit.getLocation();
                double step = Config.getInstance().permeationStepSize;
                while (blockBounds.contains(exitPoint)) {
                    exitPoint = exitPoint.add(direction.scale(step));
                }
                distanceInBlock = hit.getLocation().distanceTo(exitPoint);
            } else {
                throw new RuntimeException("Why tf is the raycasting getting stuck within air... WHAT HAVE YOU DONE!!!");
            }
            currentStart = exitPoint.add(direction.scale(0.01));
            if (!(currentStart.distanceTo(start) >= end.distanceTo(start))) continue;
            break;
        }
        return totalDistanceInBlocks;
    }

    public static Vec3 calculateReflection(Vec3 incident, Direction hitSide) {
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)hitSide.getUnitVec3i());
        double dotProduct = incident.dot(normal);
        return incident.subtract(normal.scale(2.0 * dotProduct));
    }

    public static Vec3 calculateReflection(Vec3 incident, Vec3 normal) {
        double dotProduct = incident.dot(normal);
        return incident.subtract(normal.scale(2.0 * dotProduct));
    }

    public static void displayEntityRayHitCounts(Level world, Player player) {
        if (world.isClientSide && !entityRayHitCounts.isEmpty()) {
            for (Map.Entry<SoundData, Integer> entry : entityRayHitCounts.entrySet()) {
                SoundData entity = entry.getKey();
                int rayCount = entry.getValue();
                Vec3 entityPos = entity.position;
                Vec3 displayPos = entityPos.add(0.0, entity.position.y, 0.0);
                String string = entity.soundId;
            }
        }
    }

    public static Vec3[] generateRayDirections() {
        int numRays = Config.getInstance().raysCast;
        Vec3[] directions = new Vec3[numRays];
        double goldenRatio = (1.0 + Math.sqrt(5.0)) / 2.0;
        for (int i = 0; i < numRays; ++i) {
            double theta = Math.PI * 2 * (double)i / goldenRatio;
            double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)numRays);
            double x = Math.sin(phi) * Math.cos(theta);
            double y = Math.cos(phi);
            double z = Math.sin(phi) * Math.sin(theta);
            directions[i] = new Vec3(x, y, z);
        }
        return directions;
    }

    public static void playQueuedObjects(int tsw) {
        if (freezeTickCounter.get()) {
            return;
        }
        if (!soundPlayingWaiting.containsKey(++ticksSinceWorld)) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        ArrayList<SoundInstance> sound = soundPlayingWaiting.get(ticksSinceWorld);
        for (SoundInstance newSound : sound) {
            if (newSound == null) continue;
            client.getSoundManager().play(newSound);
        }
        soundPlayingWaiting.remove(tsw);
    }

    public static double getDistanceFromWallEcho() {
        return distanceFromWallEcho.get();
    }

    public static double getDistanceFromWallEchoDenom() {
        return distanceFromWallEchoDenom.get();
    }

    public static int getReverbStrength() {
        return reverbStrength.get();
    }

    public static int getReverbDenom() {
        return reverbDenom.get();
    }

    public static int getOutdoorLeak() {
        return outdoorLeak.get();
    }

    public static int getOutdoorLeakDenom() {
        return outdoorLeakDenom.get();
    }

    public static void shutdown() {
        try {
            raycastExecutor.shutdown();
            soundProcessingExecutor.shutdown();
            if (!raycastExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                raycastExecutor.shutdownNow();
            }
            if (!soundProcessingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                soundProcessingExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            raycastExecutor.shutdownNow();
            soundProcessingExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        distanceFromWallEcho = new AtomicReference<Double>(0.0);
        distanceFromWallEchoDenom = new AtomicReference<Double>(0.0);
        reverbStrength = new AtomicInteger(0);
        reverbDenom = new AtomicInteger(0);
        outdoorLeak = new AtomicInteger(0);
        outdoorLeakDenom = new AtomicInteger(0);
        surfaceMaterials = new ConcurrentHashMap();
        roomVolumeCache = new ConcurrentHashMap();
        totalSurfaceArea = new AtomicInteger(0);
        averageAbsorption = new AtomicReference<Double>(0.0);
        roomVolume = new AtomicReference<Double>(0.0);
        surfaceToVolumeRatio = new AtomicReference<Double>(0.0);
        earlyReflectionStrength = new AtomicReference<Double>(0.0);
        lateReflectionStrength = new AtomicReference<Double>(0.0);
        weightedReverbStrength = new AtomicReference<Double>(0.0);
        earlyReflectionCount = new AtomicInteger(0);
        lateReflectionCount = new AtomicInteger(0);
        rayHitsByEntity = new ConcurrentHashMap();
        redRaysToTarget = new ConcurrentHashMap();
        muffledAveragedResults = new ConcurrentHashMap();
        soundInstanceMap = new ConcurrentHashMap();
        soundPermInstanceMap = new ConcurrentHashMap();
        THREAD_POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
        raycastExecutor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
        soundProcessingExecutor = Executors.newFixedThreadPool(2);
        isRaytracing = new AtomicBoolean(false);
        freezeTickCounter = new AtomicBoolean(false);
        surfaceMaterials.put("default", new ReverbSurfaceData(0.05, 0.7, "medium"));
        FXQueue = new LinkedList<RedPermeatedSoundInstance>();
    }
}

