/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.config.Config;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class RedTickableInstance
implements TickableSoundInstance {
    private final ResourceLocation location;
    private final Sound sound;
    private final SoundSource source;
    private final Vec3 originalPosition;
    private final float originalVolume;
    private SoundInstance wrapped;
    private double x;
    private double y;
    private double z;
    private boolean stopped;
    private float volume;
    private float pitch;
    private int tickCount;
    private Vec3 targetPosition;
    private float targetVolume;

    public RedTickableInstance(ResourceLocation location, Sound sound, SoundSource source, Vec3 position, float volume, float pitch, SoundInstance wrapped, Vec3 originalPosition, float originalVolume) {
        this.location = location;
        this.sound = sound;
        this.source = source;
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.stopped = false;
        this.volume = volume;
        this.pitch = pitch;
        this.wrapped = wrapped;
        this.originalPosition = originalPosition;
        this.originalVolume = originalVolume;
        this.tickCount = 0;
        this.targetPosition = position;
        this.targetVolume = volume;
    }

    public void tick() {
        ++this.tickCount;
        if (this.stopped || Config.getInstance().tickRate == 0) {
            return;
        }
        if (!this.location.toString().contains("rain")) {
            if (this.tickCount % Math.max(Config.getInstance().tickRate, 8) == 0) {
                RaycastingHelper.tickQueue.add(this);
            }
        } else if (this.tickCount % Config.getInstance().tickRate == 0) {
            RaycastingHelper.tickQueue.add(this);
        }
        if (this.wrapped instanceof TickableSoundInstance) {
            ((TickableSoundInstance)this.wrapped).tick();
        }
        this.updatePos();
        this.updateVolume();
    }

    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.NONE;
    }

    public void stop() {
        this.stopped = true;
    }

    public void updatePos() {
        double deltaX = this.targetPosition.x() - this.x;
        double deltaY = this.targetPosition.y() - this.y;
        double deltaZ = this.targetPosition.z() - this.z;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double maxSpeed = 17.15;
        if (distance <= 0.001 || distance > maxSpeed * (double)Config.getInstance().tickRate) {
            this.x = this.targetPosition.x();
            this.y = this.targetPosition.y();
            this.z = this.targetPosition.z();
            return;
        }
        double moveDistance = Math.min(maxSpeed, distance);
        double moveX = deltaX / distance * moveDistance;
        double moveY = deltaY / distance * moveDistance;
        double moveZ = deltaZ / distance * moveDistance;
        this.x += moveX;
        this.y += moveY;
        this.z += moveZ;
    }

    public void setVolume(float targetVolume) {
        this.targetVolume = targetVolume;
    }

    public void updateVolume() {
        float deltaVolume = this.targetVolume - this.volume;
        float maxVolumeChange = Math.abs(deltaVolume / (float)Config.getInstance().tickRate);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)Config.getInstance().tickRate) {
            this.volume = this.targetVolume;
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.volume = deltaVolume > 0.0f ? (this.volume += volumeChange) : (this.volume -= volumeChange);
    }

    public Sound getSound() {
        return this.sound;
    }

    @Generated
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Generated
    public SoundSource getSource() {
        return this.source;
    }

    @Generated
    public Vec3 getOriginalPosition() {
        return this.originalPosition;
    }

    @Generated
    public float getOriginalVolume() {
        return this.originalVolume;
    }

    @Generated
    public SoundInstance getWrapped() {
        return this.wrapped;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public boolean isStopped() {
        return this.stopped;
    }

    @Generated
    public float getVolume() {
        return this.volume;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public int getTickCount() {
        return this.tickCount;
    }

    @Generated
    public Vec3 getTargetPosition() {
        return this.targetPosition;
    }

    @Generated
    public float getTargetVolume() {
        return this.targetVolume;
    }

    @Generated
    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Generated
    public void setTargetPosition(Vec3 targetPosition) {
        this.targetPosition = targetPosition;
    }

    @Generated
    public WeighedSoundEvents resolve(SoundManager manager) {
        return this.getWrapped().resolve(manager);
    }

    @Generated
    public boolean isLooping() {
        return this.getWrapped().isLooping();
    }

    @Generated
    public boolean isRelative() {
        return this.getWrapped().isRelative();
    }

    @Generated
    public int getDelay() {
        return this.getWrapped().getDelay();
    }

    @Generated
    public boolean canStartSilent() {
        return this.getWrapped().canStartSilent();
    }

    @Generated
    public boolean canPlaySound() {
        return this.getWrapped().canPlaySound();
    }

    @Generated
    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return this.getWrapped().getStream(soundBuffers, sound, looping);
    }
}

