/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.mixin.client;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.ReverbHelpers.EnhancedReverbData;
import com.redsmods.sound_physics_perfected.mixin.client.SourceAccessor;
import com.redsmods.sound_physics_perfected.mixin.client.SourceManagerAccessor;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedPositionedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4224;
import net.minecraft.class_4235;
import org.joml.Math;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1140.class})
public abstract class SoundSystemMixin {
    private static final int MAX_SOUNDS = 100;
    private static int auxFXSlot = 0;
    private static int reverbEffect = 0;
    private static int muffleFilter = 0;
    private static int sendFilter = 0;
    private static boolean efxInitialized = false;
    private static final Queue<RedTickableInstance> FXTickQueue = new LinkedList<RedTickableInstance>();
    private static final Map<Integer, RedTickableInstance> tickMap = new HashMap<Integer, RedTickableInstance>();
    @Shadow
    private class_1144 field_5552;
    @Shadow
    private Map<class_1113, class_4235.class_4236> field_18950;

    @Shadow
    public abstract void method_4856();

    @Shadow
    public abstract void method_20185(boolean var1);

    @Inject(method={"play(Lnet/minecraft/client/sound/SoundInstance;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSoundPlay(class_1113 sound, CallbackInfo ci) {
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null || sound == null || this.field_5552 == null) {
            return;
        }
        try {
            class_1146 weightedSoundSet = sound.method_4783(this.field_5552);
            if (!(sound instanceof RedPositionedSoundInstance || sound instanceof class_1117 || sound instanceof RedPermeatedSoundInstance || sound.method_4777() == class_1113.class_1114.field_5478)) {
                double soundX = sound.method_4784();
                double soundY = sound.method_4779();
                double soundZ = sound.method_4778();
                class_243 soundPos = new class_243(soundX, soundY, soundZ);
                String soundId = sound.method_4775().toString();
                RedSoundInstance redSoundData = new RedSoundInstance(sound);
                SoundData soundData = new SoundData(redSoundData, soundPos, soundId);
                RaycastingHelper.soundQueue.offer(soundData);
                while (RaycastingHelper.soundQueue.size() > 100) {
                    RaycastingHelper.soundQueue.poll();
                }
                ci.cancel();
            } else if (RaycastingHelper.ENABLE_PERMEATION && sound instanceof RedPermeatedSoundInstance) {
                RaycastingHelper.FXQueue.add((RedPermeatedSoundInstance)sound);
            } else if (RaycastingHelper.TICK_RATE == 0 && sound instanceof RedTickableInstance) {
                FXTickQueue.add((RedTickableInstance)sound);
            }
        }
        catch (Exception e) {
            System.err.println("Error tracking sound: " + e.getMessage());
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sound/SoundSystem;tick()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onSoundTick(boolean paused, CallbackInfo ci) {
        int id;
        class_4224 source;
        SourceManagerAccessor accessor;
        class_4235.class_4236 manager;
        RedTickableInstance sound;
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        if (paused) {
            return;
        }
        while (!RaycastingHelper.FXQueue.isEmpty()) {
            try {
                sound = RaycastingHelper.FXQueue.poll();
                manager = this.field_18950.get(sound);
                accessor = (SourceManagerAccessor)manager;
                source = accessor.getSource();
                id = ((SourceAccessor)source).getPointer();
                ((RedPermeatedSoundInstance)sound).setSource(id);
                ((RedPermeatedSoundInstance)sound).applyMuffleToSource(id, ((RedPermeatedSoundInstance)sound).getPermeationIndex());
            }
            catch (Exception e) {
                System.out.println("sourceID is invalid for a sound, non-issue" + String.valueOf(e));
            }
        }
        while (!FXTickQueue.isEmpty()) {
            sound = FXTickQueue.poll();
            try {
                manager = this.field_18950.get(sound);
                accessor = (SourceManagerAccessor)manager;
                source = accessor.getSource();
                id = ((SourceAccessor)source).getPointer();
                tickMap.put(id, sound);
            }
            catch (Exception e) {
                if (tickMap.containsValue(sound)) {
                    System.out.println("Critical error (mem leak prolly)");
                }
                System.out.println("sourceID is invalid for a sound, non-issue");
            }
        }
        if (RaycastingHelper.ENABLE_REVERB) {
            SoundSystemMixin.updateActiveSources();
        }
    }

    @ModifyVariable(method={"stop(Lnet/minecraft/client/sound/SoundInstance;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1113 modifySoundParameter(class_1113 sound) {
        class_4235.class_4236 sourceManagerNormal;
        if (!efxInitialized) {
            return sound;
        }
        if (sound == null) {
            return sound;
        }
        RaycastingHelper.soundQueue.remove(sound);
        class_1113 customSound = RaycastingHelper.soundInstanceMap.get(sound);
        RedPermeatedSoundInstance soundPermeation = RaycastingHelper.soundPermInstanceMap.get(sound);
        if (soundPermeation != null) {
            soundPermeation.setDone(true);
        }
        RaycastingHelper.soundInstanceMap.remove(sound);
        RaycastingHelper.soundPermInstanceMap.remove(sound);
        class_4235.class_4236 sourceManager = this.field_18950.get(soundPermeation);
        if (sourceManager != null) {
            sourceManager.method_19735(class_4224::method_19655);
        }
        if ((sourceManagerNormal = this.field_18950.get(customSound)) != null) {
            sourceManagerNormal.method_19735(class_4224::method_19655);
        }
        return sound;
    }

    @Inject(method={"stopAll()V"}, at={@At(value="HEAD")})
    private void onStopAll(CallbackInfo ci) {
        RaycastingHelper.soundQueue.clear();
    }

    private static void cleanupEFXResources() {
        if (!efxInitialized) {
            return;
        }
        try {
            System.out.println("Cleaning up EFX resources...");
            RaycastingHelper.FXQueue.clear();
            FXTickQueue.clear();
            tickMap.clear();
            if (auxFXSlot != 0) {
                EXTEfx.alDeleteAuxiliaryEffectSlots((int)auxFXSlot);
                auxFXSlot = 0;
            }
            if (reverbEffect != 0) {
                EXTEfx.alDeleteEffects((int)reverbEffect);
                reverbEffect = 0;
            }
            if (muffleFilter != 0) {
                EXTEfx.alDeleteFilters((int)muffleFilter);
                muffleFilter = 0;
            }
            if (sendFilter != 0) {
                EXTEfx.alDeleteFilters((int)sendFilter);
                sendFilter = 0;
            }
            efxInitialized = false;
            System.out.println("EFX resources cleaned up successfully");
        }
        catch (Exception e) {
            System.err.println("Error cleaning up EFX resources: " + e.getMessage());
            auxFXSlot = 0;
            reverbEffect = 0;
            muffleFilter = 0;
            sendFilter = 0;
            efxInitialized = false;
        }
    }

    private static void initializeReverb() {
        if (efxInitialized) {
            return;
        }
        try {
            long currentContext = ALC10.alcGetCurrentContext();
            long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
            if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
                System.out.println("EFX Extension not available - reverb disabled");
                return;
            }
            auxFXSlot = EXTEfx.alGenAuxiliaryEffectSlots();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)3, (int)1);
            reverbEffect = EXTEfx.alGenEffects();
            EXTEfx.alEffecti((int)reverbEffect, (int)32769, (int)32768);
            muffleFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)muffleFilter, (int)32769, (int)1);
            RedPermeatedSoundInstance.muffleFilter = muffleFilter;
            sendFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)sendFilter, (int)32769, (int)1);
            SoundSystemMixin.setBasicReverbParams();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbEffect);
            efxInitialized = true;
            System.out.println("Reverb system initialized successfully");
        }
        catch (Exception e) {
            System.err.println("Failed to initialize reverb: " + e.getMessage());
        }
    }

    private static void setBasicReverbParams() {
        EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)0.5f);
        EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)0.3f);
        EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)15.0f);
        EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)0.7f);
        EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)0.2f);
        EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)0.4f);
        EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)0.03f);
        EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)0.99f);
        EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)0.0f);
    }

    private static void updateActiveSources() {
        long context = ALC10.alcGetCurrentContext();
        if (context == 0L) {
            return;
        }
        AL10.alGetError();
        try {
            for (int sourceId = 1; sourceId <= 256; ++sourceId) {
                if (AL10.alIsSource((int)sourceId)) {
                    int state = AL10.alGetSourcei((int)sourceId, (int)4112);
                    if (state != 4114 && state != 4115) continue;
                    SoundSystemMixin.applyReverbToSource(sourceId);
                    continue;
                }
                if (!tickMap.containsKey(sourceId)) continue;
                tickMap.get(sourceId).stop();
                tickMap.remove(sourceId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyReverbToSource(int sourceId) {
        try {
            EnhancedReverbData reverbData = RaycastingHelper.getEnhancedReverbData();
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float reverbStrength = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float weightedReverbStrength = (float)RaycastingHelper.getWeightedReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float earlyReflectionRatio = (float)RaycastingHelper.getEarlyReflectionRatio();
            float rt60 = (float)reverbData.rt60;
            float roomSize = (float)reverbData.roomSize;
            float absorption = (float)reverbData.absorption;
            float earlyReflectionDelay = (float)reverbData.earlyReflectionDelay;
            float lateReflectionStrength = (float)reverbData.lateReflectionStrength;
            boolean isIndoors = reverbData.isIndoors;
            wallDistance = SoundSystemMixin.clamp(wallDistance, 0.5f, 200.0f);
            reverbStrength = SoundSystemMixin.clamp(reverbStrength, 0.0f, 1.0f);
            weightedReverbStrength = SoundSystemMixin.clamp(weightedReverbStrength, 0.0f, 1.0f);
            outdoorLeakPercent = SoundSystemMixin.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            earlyReflectionRatio = SoundSystemMixin.clamp(earlyReflectionRatio, 0.0f, 1.0f);
            rt60 = SoundSystemMixin.clamp(rt60, 0.1f, 10.0f);
            roomSize = SoundSystemMixin.clamp(roomSize, 1.0f, 100.0f);
            absorption = SoundSystemMixin.clamp(absorption, 0.01f, 0.9f);
            earlyReflectionDelay = SoundSystemMixin.clamp(earlyReflectionDelay, 0.001f, 0.1f);
            lateReflectionStrength = SoundSystemMixin.clamp(lateReflectionStrength, 0.0f, 1.0f);
            float enclosureFactor = isIndoors ? 1.0f - outdoorLeakPercent : java.lang.Math.max(0.0f, reverbStrength - outdoorLeakPercent);
            enclosureFactor = SoundSystemMixin.clamp(enclosureFactor, 0.0f, 1.0f);
            float opennessFactor = 1.0f - enclosureFactor;
            float estimatedVolume = roomSize * roomSize * roomSize * 0.7f;
            float estimatedSurfaceArea = 6.0f * roomSize * roomSize;
            float surfaceToVolumeRatio = estimatedSurfaceArea / java.lang.Math.max(estimatedVolume, 1.0f);
            surfaceToVolumeRatio = SoundSystemMixin.clamp(surfaceToVolumeRatio, 0.1f, 5.0f);
            float dynamicAbsorption = absorption;
            float totalAbsorption = estimatedSurfaceArea * dynamicAbsorption;
            float calculatedRT60 = rt60;
            if (calculatedRT60 < 0.1f || calculatedRT60 > 10.0f) {
                calculatedRT60 = 0.161f * estimatedVolume / java.lang.Math.max(totalAbsorption, 0.1f);
                calculatedRT60 = SoundSystemMixin.clamp(calculatedRT60, 0.1f, 8.0f);
            }
            float effectiveDecayTime = calculatedRT60 * enclosureFactor;
            effectiveDecayTime = SoundSystemMixin.clamp(effectiveDecayTime, 0.1f, 8.0f);
            float distanceAttenuation = 1.0f / (1.0f + wallDistance * 0.02f + wallDistance * wallDistance * 1.0E-4f);
            float airAbsorptionFactor = 1.0f - wallDistance * 0.003f;
            airAbsorptionFactor = SoundSystemMixin.clamp(airAbsorptionFactor, 0.2f, 1.0f);
            float decayHfRatio = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            decayHfRatio = SoundSystemMixin.clamp(decayHfRatio, 0.1f, 2.0f);
            float reflectionsDelay = earlyReflectionDelay;
            float reflectionsGain = earlyReflectionRatio * reverbStrength * enclosureFactor * distanceAttenuation;
            reflectionsGain = SoundSystemMixin.clamp(reflectionsGain, 0.0f, 0.8f);
            float lateReverbDelay = earlyReflectionDelay * 2.0f + roomSize / 343.0f;
            lateReverbDelay = SoundSystemMixin.clamp(lateReverbDelay, 0.005f, 0.2f);
            float lateReverbGain = lateReflectionStrength * enclosureFactor * distanceAttenuation;
            lateReverbGain = SoundSystemMixin.clamp(lateReverbGain, 0.0f, 1.0f);
            float roomComplexity = java.lang.Math.min(1.0f, surfaceToVolumeRatio / 2.0f);
            float diffusion = Math.lerp((float)0.3f, (float)0.95f, (float)(roomComplexity * enclosureFactor * weightedReverbStrength));
            diffusion = SoundSystemMixin.clamp(diffusion, 0.1f, 1.0f);
            float density = Math.lerp((float)0.3f, (float)1.0f, (float)(enclosureFactor * (1.0f - roomSize / 100.0f)));
            density = SoundSystemMixin.clamp(density, 0.1f, 1.0f);
            float overallGain = enclosureFactor * distanceAttenuation * (0.1f + reverbStrength * 0.4f);
            overallGain = SoundSystemMixin.clamp(overallGain, 0.0f, 0.5f);
            float gainHF = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            gainHF = SoundSystemMixin.clamp(gainHF, 0.1f, 1.0f);
            float airAbsorptionHF = airAbsorptionFactor * enclosureFactor + opennessFactor * 0.7f;
            airAbsorptionHF = SoundSystemMixin.clamp(airAbsorptionHF, 0.5f, 1.0f);
            float roomRolloff = Math.lerp((float)1.0f, (float)0.0f, (float)enclosureFactor) * (roomSize / 50.0f);
            roomRolloff = SoundSystemMixin.clamp(roomRolloff, 0.0f, 1.0f);
            float sendFilterGain = overallGain;
            float sendFilterGainHF = gainHF * 0.7f;
            float echoDensity = Math.lerp((float)1.0f, (float)0.4f, (float)(roomSize / 100.0f)) * enclosureFactor;
            echoDensity = SoundSystemMixin.clamp(echoDensity, 0.1f, 1.0f);
            float modulationTime = SoundSystemMixin.clamp(roomSize * 0.01f, 0.04f, 4.0f);
            float modulationDepth = SoundSystemMixin.clamp(enclosureFactor * 0.1f, 0.0f, 1.0f);
            EXTEfx.alFilterf((int)sendFilter, (int)1, (float)sendFilterGain);
            EXTEfx.alFilterf((int)sendFilter, (int)2, (float)sendFilterGainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)overallGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)5, (float)SoundSystemMixin.clamp(1.0f - dynamicAbsorption * 0.5f, 0.1f, 1.0f));
            EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)effectiveDecayTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)8, (float)SoundSystemMixin.clamp(decayHfRatio * 1.2f, 0.1f, 2.0f));
            EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)lateReverbGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)reverbEffect, (int)15, (float)SoundSystemMixin.clamp(roomSize * 0.002f, 0.075f, 0.25f));
            EXTEfx.alEffectf((int)reverbEffect, (int)16, (float)SoundSystemMixin.clamp(echoDensity * 0.1f, 0.0f, 1.0f));
            EXTEfx.alEffectf((int)reverbEffect, (int)17, (float)modulationTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)18, (float)modulationDepth);
            EXTEfx.alEffectf((int)reverbEffect, (int)20, (float)SoundSystemMixin.clamp(5000.0f - roomSize * 20.0f, 1000.0f, 20000.0f));
            EXTEfx.alEffectf((int)reverbEffect, (int)21, (float)SoundSystemMixin.clamp(250.0f - roomSize * 2.0f, 20.0f, 1000.0f));
            AL11.alSource3i((int)sourceId, (int)131078, (int)auxFXSlot, (int)0, (int)sendFilter);
        }
        catch (Exception e) {
            System.err.println("Error applying dynamic reverb: " + e.getMessage());
        }
    }

    private static void debugSourceCount() {
        int sourcesInUse = 0;
        for (int i = 1; i < 1000; ++i) {
            if (!AL10.alIsSource((int)i)) continue;
            ++sourcesInUse;
        }
        System.out.println("Sources currently in use: " + sourcesInUse);
    }

    @Inject(method={"stop()V"}, at={@At(value="HEAD")})
    private void onAudioEngineStop(CallbackInfo ci) {
        SoundSystemMixin.cleanupEFXResources();
    }

    @Inject(method={"start()V"}, at={@At(value="TAIL")})
    private void onAudioEngineStart(CallbackInfo ci) {
        efxInitialized = false;
        SoundSystemMixin.initializeReverb();
    }

    private static float clamp(float a, float b, float c) {
        return java.lang.Math.min(java.lang.Math.max(a, b), c);
    }
}

