/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.config.Config;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4234;
import net.minecraft.class_4237;

public class RedTickableInstance
implements class_1117 {
    private final class_2960 location;
    private final class_1111 sound;
    private final class_3419 source;
    private class_1113 wrapped;
    private double x;
    private double y;
    private double z;
    private boolean stopped;
    private float volume;
    private float pitch;
    private int tickCount;
    private class_243 targetPosition;
    private float targetVolume;
    private boolean isBlacklisted;

    public RedTickableInstance(class_2960 location, class_1111 sound, class_3419 source, class_243 position, float volume, float pitch, class_1113 wrapped, class_243 originalPosition, float originalVolume) {
        this.location = location;
        this.sound = sound;
        this.source = source;
        this.x = position.field_1352;
        this.y = position.field_1351;
        this.z = position.field_1350;
        this.stopped = false;
        this.volume = volume;
        this.pitch = pitch;
        this.wrapped = wrapped;
        this.tickCount = 0;
        this.targetPosition = position;
        this.targetVolume = volume;
        this.isBlacklisted = this.isSoundTickBlacklisted(sound.toString());
    }

    public void method_16896() {
        if (this.isBlacklisted) {
            if (this.wrapped instanceof class_1117) {
                ((class_1117)this.wrapped).method_16896();
            }
            return;
        }
        ++this.tickCount;
        if (this.stopped || Config.getInstance().tickRate == 0) {
            return;
        }
        if (!this.location.toString().contains("rain")) {
            if (this.tickCount % Math.max(Config.getInstance().tickRate, 8) == 0) {
                RaycastingHelper.tickQueue.add(this);
            }
        } else if (this.tickCount % Config.getInstance().tickRate == 0) {
            RaycastingHelper.tickQueue.add(this);
        }
        if (this.wrapped instanceof class_1117) {
            ((class_1117)this.wrapped).method_16896();
        }
        this.updatePos();
        this.updateVolume();
    }

    public class_1113.class_1114 method_4777() {
        return class_1113.class_1114.field_5478;
    }

    public void stop() {
        this.stopped = true;
    }

    public void updatePos() {
        double deltaX = this.targetPosition.method_10216() - this.x;
        double deltaY = this.targetPosition.method_10214() - this.y;
        double deltaZ = this.targetPosition.method_10215() - this.z;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double maxSpeed = 17.15;
        if (distance <= 0.001 || distance > maxSpeed * (double)Config.getInstance().tickRate) {
            this.x = this.targetPosition.method_10216();
            this.y = this.targetPosition.method_10214();
            this.z = this.targetPosition.method_10215();
            return;
        }
        double moveDistance = Math.min(maxSpeed, distance);
        double moveX = deltaX / distance * moveDistance;
        double moveY = deltaY / distance * moveDistance;
        double moveZ = deltaZ / distance * moveDistance;
        this.x += moveX;
        this.y += moveY;
        this.z += moveZ;
    }

    public void updateVolume() {
        float deltaVolume = this.targetVolume - this.volume;
        float maxVolumeChange = Math.max(Math.abs(deltaVolume / (float)Config.getInstance().tickRate), 0.05f);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)Config.getInstance().tickRate) {
            this.volume = this.targetVolume;
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.volume = deltaVolume > 0.0f ? (this.volume += volumeChange) : (this.volume -= volumeChange);
    }

    public class_1111 method_4776() {
        return this.sound;
    }

    public float getOriginalVolume() {
        return this.wrapped.method_4781();
    }

    public class_243 getOriginalPosition() {
        return new class_243(this.wrapped.method_4784(), this.wrapped.method_4779(), this.wrapped.method_4778());
    }

    private boolean isSoundTickBlacklisted(String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return false;
        }
        List<String> blacklist = Config.getInstance().soundTickBlacklist;
        if (blacklist == null || blacklist.isEmpty()) {
            return false;
        }
        return blacklist.stream().filter(entry -> entry != null && !entry.trim().isEmpty()).anyMatch(entry -> soundName.toLowerCase().contains(entry.toLowerCase().trim()));
    }

    @Generated
    public class_2960 method_4775() {
        return this.location;
    }

    @Generated
    public class_3419 method_4774() {
        return this.source;
    }

    @Generated
    public class_1113 getWrapped() {
        return this.wrapped;
    }

    @Generated
    public double method_4784() {
        return this.x;
    }

    @Generated
    public double method_4779() {
        return this.y;
    }

    @Generated
    public double method_4778() {
        return this.z;
    }

    @Generated
    public boolean method_4793() {
        return this.stopped;
    }

    @Generated
    public float method_4781() {
        return this.volume;
    }

    @Generated
    public float method_4782() {
        return this.pitch;
    }

    @Generated
    public int getTickCount() {
        return this.tickCount;
    }

    @Generated
    public class_243 getTargetPosition() {
        return this.targetPosition;
    }

    @Generated
    public float getTargetVolume() {
        return this.targetVolume;
    }

    @Generated
    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    @Generated
    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Generated
    public void setVolume(float volume) {
        this.volume = volume;
    }

    @Generated
    public void setTargetPosition(class_243 targetPosition) {
        this.targetPosition = targetPosition;
    }

    @Generated
    public void setTargetVolume(float targetVolume) {
        this.targetVolume = targetVolume;
    }

    @Generated
    public class_1146 method_4783(class_1144 manager) {
        return this.getWrapped().method_4783(manager);
    }

    @Generated
    public boolean method_4786() {
        return this.getWrapped().method_4786();
    }

    @Generated
    public boolean method_4787() {
        return this.getWrapped().method_4787();
    }

    @Generated
    public int method_4780() {
        return this.getWrapped().method_4780();
    }

    @Generated
    public boolean method_4785() {
        return this.getWrapped().method_4785();
    }

    @Generated
    public boolean method_26273() {
        return this.getWrapped().method_26273();
    }

    @Generated
    public CompletableFuture<class_4234> getAudioStream(class_4237 loader, class_2960 id, boolean repeatInstantly) {
        return this.getWrapped().getAudioStream(loader, id, repeatInstantly);
    }
}

