/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RedTickableInstance
implements TickableSoundInstance {
    private final ResourceLocation soundID;
    private final Sound sound;
    private final SoundSource category;
    private final Vec3 originalPos;
    private final float originalVolume;
    private SoundInstance wrapped;
    private double x;
    private double y;
    private double z;
    private boolean done;
    private float volume;
    private float pitch;
    private int tickCount;
    private Vec3 targetPosition;
    private float targetVolume;

    public RedTickableInstance(ResourceLocation soundID, Sound sound, SoundSource category, Vec3 position, float volume, float pitch, SoundInstance wrapped, Vec3 originalPos, float originalVolume) {
        this.soundID = soundID;
        this.sound = sound;
        this.category = category;
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.done = false;
        this.volume = volume;
        this.pitch = pitch;
        this.wrapped = wrapped;
        this.originalPos = originalPos;
        this.originalVolume = originalVolume;
        this.tickCount = 0;
        this.targetPosition = position;
        this.targetVolume = volume;
    }

    public boolean isStopped() {
        return this.done;
    }

    public void tick() {
        ++this.tickCount;
        if (this.done || RaycastingHelper.TICK_RATE == 0) {
            return;
        }
        if (this.tickCount % RaycastingHelper.TICK_RATE == 0) {
            RaycastingHelper.tickQueue.add(this);
        }
        if (this.wrapped instanceof TickableSoundInstance) {
            ((TickableSoundInstance)this.wrapped).tick();
        }
        this.updatePos();
        this.updateVolume();
    }

    public ResourceLocation getLocation() {
        return this.soundID;
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager soundManager) {
        return this.wrapped.resolve(soundManager);
    }

    public Sound getSound() {
        return this.sound;
    }

    public SoundSource getSource() {
        return this.category;
    }

    public boolean isLooping() {
        return this.wrapped.isLooping();
    }

    public Vec3 getOriginalPosition() {
        return this.originalPos;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean canStartSilent() {
        return this.wrapped.canStartSilent();
    }

    public boolean isRelative() {
        return this.wrapped.isRelative();
    }

    public int getDelay() {
        return this.wrapped.getDelay();
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.NONE;
    }

    public void stop() {
        this.done = true;
    }

    public void setPos(Vec3 targetPosition) {
        this.targetPosition = targetPosition;
    }

    public void updatePos() {
        double deltaX = this.targetPosition.x() - this.x;
        double deltaY = this.targetPosition.y() - this.y;
        double deltaZ = this.targetPosition.z() - this.z;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double maxSpeed = 17.15;
        if (distance <= 0.001 || distance > maxSpeed * (double)RaycastingHelper.TICK_RATE) {
            this.x = this.targetPosition.x();
            this.y = this.targetPosition.y();
            this.z = this.targetPosition.z();
            return;
        }
        double moveDistance = Math.min(maxSpeed, distance);
        double moveX = deltaX / distance * moveDistance;
        double moveY = deltaY / distance * moveDistance;
        double moveZ = deltaZ / distance * moveDistance;
        this.x += moveX;
        this.y += moveY;
        this.z += moveZ;
    }

    public void setVolume(float targetVolume) {
        if (!this.soundID.toString().contains("rain")) {
            this.targetVolume = targetVolume;
        }
    }

    public void updateVolume() {
        float deltaVolume = this.targetVolume - this.volume;
        float maxVolumeChange = Math.abs(deltaVolume / (float)RaycastingHelper.TICK_RATE);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)RaycastingHelper.TICK_RATE) {
            this.volume = this.targetVolume;
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.volume = deltaVolume > 0.0f ? (this.volume += volumeChange) : (this.volume -= volumeChange);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public float getOriginalVolume() {
        return this.originalVolume;
    }

    protected SoundInstance getOriginal() {
        return this.wrapped;
    }
}

