/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.integration;

import com.redsmods.sound_physics_perfected.OpenALEffectsHandler;
import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.config.Config;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.ClientVoicechatConnectionEvent;
import de.maxhenkel.voicechat.api.events.CreateOpenALContextEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;

@ForgeVoicechatPlugin
public class SVC
implements VoicechatPlugin {
    private final Map<UUID, VoiceChannelData> audioChannels;
    private final OpenALEffectsHandler fxHandler = new OpenALEffectsHandler();

    public SVC() {
        this.audioChannels = new HashMap<UUID, VoiceChannelData>();
    }

    public String getPluginId() {
        return "soundphysicsperfected";
    }

    public void initialize(VoicechatApi api) {
        System.out.println("Initializing Sound Physics Perfected Voice Chat integration");
        this.audioChannels.clear();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(OpenALSoundEvent.class, this::onOpenALSound);
        registration.registerEvent(ClientVoicechatConnectionEvent.class, this::onConnection);
        registration.registerEvent(CreateOpenALContextEvent.class, this::onCreateALContext);
    }

    private void onCreateALContext(CreateOpenALContextEvent event) {
        System.out.println("Initializing OpenAL effects for voice chat");
        long context = event.getContext();
        long device = event.getDevice();
        this.fxHandler.initializeReverb(context, device);
        System.out.println("succ init openal yipee");
    }

    private void onConnection(ClientVoicechatConnectionEvent event) {
        this.audioChannels.values().removeIf(VoiceChannelData::canBeRemoved);
    }

    private void onOpenALSound(OpenALSoundEvent event) {
        int openALSource = event.getSource();
        Position position = event.getPosition();
        UUID channelId = event.getChannelId();
        if (channelId == null || position == null) {
            return;
        }
        VoiceChannelData channelData = this.audioChannels.computeIfAbsent(channelId, id -> new VoiceChannelData((UUID)id));
        class_243 sourcePos = new class_243(position.getX(), position.getY(), position.getZ());
        channelData.updateSound(openALSource, sourcePos, event.getCategory());
        this.applySoundPhysicsEffects(openALSource, sourcePos, channelData);
    }

    private void applySoundPhysicsEffects(int openALSource, class_243 sourcePos, VoiceChannelData channelData) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        class_243 listenerPos = mc.field_1724.method_19538();
        float occlusion = (float)Math.pow(Config.getInstance().permeationAbsorption, RaycastingHelper.countBlocksBetween((class_1937)mc.field_1687, listenerPos, sourcePos, (class_1657)mc.field_1724));
        this.applyOpenALEffects(openALSource, occlusion);
    }

    private float getMaterialOcclusion(class_2680 blockState) {
        String blockName = blockState.method_26204().method_9539();
        if (blockName.contains("stone") || blockName.contains("concrete")) {
            return 0.8f;
        }
        if (blockName.contains("wood")) {
            return 0.6f;
        }
        if (blockName.contains("glass")) {
            return 0.3f;
        }
        if (blockName.contains("wool") || blockName.contains("carpet")) {
            return 0.9f;
        }
        if (blockName.contains("leaves")) {
            return 0.4f;
        }
        if (blockName.contains("water") || blockName.contains("lava")) {
            return 0.7f;
        }
        return 0.7f;
    }

    private void applyOpenALEffects(int openALSource, float occlusion) {
        try {
            if (Config.getInstance().voicechatReverb) {
                this.fxHandler.applyReverbToSource(openALSource);
            }
            if (Config.getInstance().voicechatMuffle) {
                this.fxHandler.applyMuffleToSource(openALSource, occlusion);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to apply OpenAL effects: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static class VoiceChannelData {
        private final UUID channelId;
        private int lastSource = -1;
        private class_243 lastPosition;
        private String lastCategory;
        private long lastUpdateTime;

        public VoiceChannelData(UUID channelId) {
            this.channelId = channelId;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public void updateSound(int source, class_243 position, String category) {
            this.lastSource = source;
            this.lastPosition = position;
            this.lastCategory = category;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public boolean canBeRemoved() {
            return System.currentTimeMillis() - this.lastUpdateTime > 5000L;
        }

        @Generated
        public UUID getChannelId() {
            return this.channelId;
        }

        @Generated
        public int getLastSource() {
            return this.lastSource;
        }

        @Generated
        public class_243 getLastPosition() {
            return this.lastPosition;
        }

        @Generated
        public String getLastCategory() {
            return this.lastCategory;
        }
    }
}

