/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected;

import java.util.Objects;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class RedSoundInstance
implements SoundInstance {
    SoundInstance original;

    public RedSoundInstance(SoundInstance original) {
        if (original == null) {
            throw new IllegalArgumentException("Original SoundInstance cannot be null");
        }
        this.original = original;
    }

    public ResourceLocation getLocation() {
        return this.original.getLocation();
    }

    public SoundInstance getOriginal() {
        return this.original;
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager soundManager) {
        return this.original.resolve(soundManager);
    }

    public Sound getSound() {
        return this.original.getSound();
    }

    public SoundSource getSource() {
        return this.original.getSource();
    }

    public boolean isLooping() {
        return this.original.isLooping();
    }

    public boolean isRelative() {
        return this.original.isRelative();
    }

    public int getDelay() {
        return this.original.getDelay();
    }

    public float getVolume() {
        return this.original.getVolume();
    }

    public float getPitch() {
        return this.original.getPitch();
    }

    public double getX() {
        return this.original.getX();
    }

    public double getY() {
        return this.original.getY();
    }

    public double getZ() {
        return this.original.getZ();
    }

    public SoundInstance.Attenuation getAttenuation() {
        return this.original.getAttenuation();
    }

    public String toString() {
        return String.format("RedSoundInstance{id=%s, category=%s, pos=[%.2f,%.2f,%.2f], vol=%.2f, pitch=%.2f}", this.getLocation(), this.getSource(), this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getVolume()), Float.valueOf(this.getPitch()));
    }

    public int hashCode() {
        return Objects.hash(this.getLocation(), this.getSource(), Float.valueOf(this.getVolume()), Float.valueOf(this.getPitch()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RedSoundInstance that = (RedSoundInstance)obj;
        return Double.compare(that.getVolume(), this.getVolume()) == 0 && Double.compare(that.getPitch(), this.getPitch()) == 0 && Objects.equals(this.getLocation(), this.getLocation()) && Objects.equals(this.getSource(), that.getSource());
    }
}

