/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.mixin.client;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.ReverbHelpers.LegacyReverb;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.config.DebugType;
import com.redsmods.sound_physics_perfected.mixin.client.SourceAccessor;
import com.redsmods.sound_physics_perfected.mixin.client.SourceManagerAccessor;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedPositionedSoundInstance;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4224;
import net.minecraft.class_4235;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1140.class})
public abstract class SoundSystemMixin {
    @Shadow
    private class_1144 field_5552;
    @Shadow
    private Map<class_1113, class_4235.class_4236> field_18950;

    @Shadow
    public abstract void method_4856();

    @Shadow
    public abstract void method_20185(boolean var1);

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)Lnet/minecraft/client/sounds/SoundEngine$PlayResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSoundPlay(class_1113 sound, CallbackInfoReturnable<class_1140.class_11518> cir) {
        if (!RaycastingHelper.fxHandler.efxInitialized) {
            RaycastingHelper.fxHandler.initializeReverb();
        }
        if (this.isSoundBlacklisted(sound.toString())) {
            return;
        }
        if (!RaycastingHelper.fxHandler.efxInitialized) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null || sound == null || this.field_5552 == null) {
            return;
        }
        try {
            class_1146 weightedSoundSet = sound.method_4783(this.field_5552);
            if (!(sound instanceof RedPositionedSoundInstance || sound instanceof class_1117 || sound instanceof RedPermeatedSoundInstance || sound.method_4777() == class_1113.class_1114.field_5478)) {
                double soundX = sound.method_4784();
                double soundY = sound.method_4779();
                double soundZ = sound.method_4778();
                class_243 soundPos = new class_243(soundX, soundY, soundZ);
                String soundId = sound.method_4775().toString();
                RedSoundInstance redSoundData = new RedSoundInstance(sound);
                SoundData soundData = new SoundData(redSoundData, soundPos, soundId);
                RaycastingHelper.soundQueue.offer(soundData);
                while (RaycastingHelper.soundQueue.size() > Config.getInstance().maxSounds) {
                    RaycastingHelper.soundQueue.poll();
                }
                cir.cancel();
            } else if (Config.getInstance().permeation && sound instanceof RedPermeatedSoundInstance) {
                RaycastingHelper.FXQueue.add((RedPermeatedSoundInstance)sound);
            }
        }
        catch (Exception e) {
            System.err.println("Error tracking sound: " + e.getMessage());
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundEngine;tickInGameSound()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onSoundTick(boolean paused, CallbackInfo ci) {
        if (!RaycastingHelper.fxHandler.efxInitialized) {
            RaycastingHelper.fxHandler.initializeReverb();
        }
        if (!RaycastingHelper.fxHandler.efxInitialized) {
            return;
        }
        if (paused) {
            return;
        }
        while (!RaycastingHelper.FXQueue.isEmpty()) {
            try {
                RedPermeatedSoundInstance sound = RaycastingHelper.FXQueue.poll();
                class_4235.class_4236 manager = this.field_18950.get(sound);
                SourceManagerAccessor accessor = (SourceManagerAccessor)manager;
                class_4224 source = accessor.getChannel();
                int id = ((SourceAccessor)source).getSource();
                sound.setSource(id);
                RaycastingHelper.fxHandler.applyMuffleToSource(id, sound.getPermeationIndex());
            }
            catch (Exception e) {
                if (Config.getInstance().debug == DebugType.OFF) continue;
                System.out.println("sourceID is invalid for a sound, non-issue" + String.valueOf(e));
            }
        }
        if (Config.getInstance().reverb) {
            SoundSystemMixin.updateActiveSources();
        }
    }

    @ModifyVariable(method={"stop(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1113 modifySoundParameter(class_1113 sound) {
        class_4235.class_4236 sourceManagerNormal;
        if (!RaycastingHelper.fxHandler.efxInitialized) {
            return sound;
        }
        if (sound == null) {
            return sound;
        }
        RaycastingHelper.soundQueue.remove(sound);
        class_1113 customSound = RaycastingHelper.soundInstanceMap.get(sound);
        RedPermeatedSoundInstance soundPermeation = RaycastingHelper.soundPermInstanceMap.get(sound);
        if (soundPermeation != null) {
            soundPermeation.setStopped(true);
        }
        RaycastingHelper.soundInstanceMap.remove(sound);
        RaycastingHelper.soundPermInstanceMap.remove(sound);
        class_4235.class_4236 sourceManager = this.field_18950.get(soundPermeation);
        if (sourceManager != null) {
            sourceManager.method_19735(class_4224::method_19655);
        }
        if ((sourceManagerNormal = this.field_18950.get(customSound)) != null) {
            sourceManagerNormal.method_19735(class_4224::method_19655);
        }
        return sound;
    }

    @Inject(method={"stopAll()V"}, at={@At(value="HEAD")})
    private void onStopAll(CallbackInfo ci) {
        RaycastingHelper.soundQueue.clear();
    }

    private static void updateActiveSources() {
        long context = ALC10.alcGetCurrentContext();
        if (context == 0L) {
            return;
        }
        AL10.alGetError();
        try {
            for (int sourceId = 1; sourceId <= 256; ++sourceId) {
                int state;
                if (!AL10.alIsSource((int)sourceId) || (state = AL10.alGetSourcei((int)sourceId, (int)4112)) != 4114 && state != 4115) continue;
                if (Config.getInstance().legacyReverb == LegacyReverb.VERSION140) {
                    RaycastingHelper.fxHandler.applyLegacyReverbToSource(sourceId);
                    continue;
                }
                if (Config.getInstance().legacyReverb == LegacyReverb.VERSION100) {
                    RaycastingHelper.fxHandler.applyInitalLegacyReverbToSource(sourceId);
                    continue;
                }
                RaycastingHelper.fxHandler.applyReverbToSource(sourceId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void debugSourceCount() {
        int sourcesInUse = 0;
        for (int i = 1; i < 1000; ++i) {
            if (!AL10.alIsSource((int)i)) continue;
            ++sourcesInUse;
        }
        System.out.println("Sources currently in use: " + sourcesInUse);
    }

    @Inject(method={"destroy()V"}, at={@At(value="HEAD")})
    private void onAudioEngineStop(CallbackInfo ci) {
        RaycastingHelper.fxHandler.cleanupEFXResources();
    }

    @Inject(method={"loadLibrary()V"}, at={@At(value="TAIL")})
    private void onAudioEngineStart(CallbackInfo ci) {
        RaycastingHelper.fxHandler.efxInitialized = false;
        RaycastingHelper.fxHandler.initializeReverb();
    }

    private boolean isSoundBlacklisted(String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return false;
        }
        List<String> blacklist = Config.getInstance().soundBlacklist;
        if (blacklist == null || blacklist.isEmpty()) {
            return false;
        }
        return blacklist.stream().filter(entry -> entry != null && !entry.trim().isEmpty()).anyMatch(entry -> soundName.toLowerCase().contains(entry.toLowerCase().trim()));
    }
}

