/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected;

import com.redsmods.sound_physics_perfected.Config;
import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.RedsAttenuationType;
import com.redsmods.sound_physics_perfected.storageclasses.AveragedSoundData;
import com.redsmods.sound_physics_perfected.storageclasses.RayHitData;
import com.redsmods.sound_physics_perfected.storageclasses.RaycastResult;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.storageclasses.TickableSoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaycastingHelper {
    public static final Queue<RedTickableInstance> tickQueue = new LinkedList<RedTickableInstance>();
    public static final Queue<RedPermeatedSoundInstance> permeatedTickQueue = new LinkedList<RedPermeatedSoundInstance>();
    private static final ConcurrentHashMap<SoundData, Integer> entityRayHitCounts = new ConcurrentHashMap();
    public static final Queue<SoundData> soundQueue = new LinkedList<SoundData>();
    public static final Queue<SoundData> weatherQueue = new LinkedList<SoundData>();
    private static final double SPEED_OF_SOUND_TICKS = 17.15;
    private static final Map<Integer, ArrayList<class_1113>> soundPlayingWaiting = new ConcurrentHashMap<Integer, ArrayList<class_1113>>();
    private static int ticksSinceWorld;
    private static final AtomicReference<Double> distanceFromWallEcho;
    private static final AtomicReference<Double> distanceFromWallEchoDenom;
    private static final AtomicInteger reverbStrength;
    private static final AtomicInteger reverbDenom;
    private static final AtomicInteger outdoorLeak;
    private static final AtomicInteger outdoorLeakDenom;
    private static final ConcurrentHashMap<SoundData, List<RayHitData>> rayHitsByEntity;
    private static final ConcurrentHashMap<SoundData, List<RayHitData>> redRaysToTarget;
    private static final ConcurrentHashMap<SoundData, AveragedSoundData> muffledAveragedResults;
    public static final ConcurrentHashMap<class_1113, class_1113> soundInstanceMap;
    public static final ConcurrentHashMap<class_1113, RedPermeatedSoundInstance> soundPermInstanceMap;
    private static final int THREAD_POOL_SIZE;
    private static final ExecutorService raycastExecutor;
    private static final ExecutorService soundProcessingExecutor;
    private static final AtomicBoolean isRaytracing;
    private static final AtomicBoolean freezeTickCounter;
    private static int RAYS_CAST;
    private static int MAX_BOUNCES;
    private static double RAY_SEGMENT_LENGTH;
    public static boolean ENABLE_REVERB;
    public static boolean ENABLE_PERMEATION;
    public static int TICK_RATE;
    public static RedsAttenuationType ATTENUATION_TYPE;
    public static double PERMEATION_STEP_SIZE;
    public static final Queue<RedPermeatedSoundInstance> FXQueue;

    public static void getConfig() {
        RAYS_CAST = Config.getInstance().raysCast;
        MAX_BOUNCES = Config.getInstance().raysBounced;
        ENABLE_REVERB = Config.getInstance().reverbEnabled;
        ENABLE_PERMEATION = Config.getInstance().permeationEnabled;
        RAY_SEGMENT_LENGTH = 16.0 * (double)Config.getInstance().maxRayLength;
        TICK_RATE = Config.getInstance().tickRate;
        ATTENUATION_TYPE = Config.getInstance().attenuationType;
    }

    public static void castBouncingRaysAndDetectSFX(class_1937 world, class_1657 player) {
        try {
            if (!isRaytracing.compareAndSet(false, true)) {
                return;
            }
            class_243 playerEyePos = player.method_33571();
            double maxTotalDistance = RAY_SEGMENT_LENGTH * (double)MAX_BOUNCES;
            entityRayHitCounts.clear();
            class_310 client = class_310.method_1551();
            if (client == null || client.method_1483() == null) {
                isRaytracing.set(false);
                return;
            }
            if (soundQueue.isEmpty() && tickQueue.isEmpty() && permeatedTickQueue.isEmpty()) {
                isRaytracing.set(false);
                return;
            }
            weatherQueue.clear();
            Iterator iterator = soundQueue.iterator();
            while (iterator.hasNext()) {
                SoundData sound = (SoundData)iterator.next();
                if (!sound.soundId.contains("rain")) continue;
                weatherQueue.add(sound);
                iterator.remove();
            }
            class_243[] rayDirections = RaycastingHelper.generateRayDirections();
            rayHitsByEntity.clear();
            redRaysToTarget.clear();
            RaycastingHelper.processAndPlayAveragedSounds(world, player, playerEyePos, new ArrayList<class_243>(Arrays.asList(rayDirections)), soundQueue, maxTotalDistance, client);
            RaycastingHelper.displayEntityRayHitCounts(world, player);
            tickQueue.clear();
            soundQueue.clear();
            permeatedTickQueue.clear();
            isRaytracing.set(false);
        }
        catch (Exception e) {
            System.err.println("Error in player bouncing ray entity detection: " + e.getMessage());
        }
    }

    public static void processAndPlayAveragedSounds(class_1937 world, class_1657 player, class_243 playerEyePos, List<class_243> rayDirections, Queue<SoundData> soundQueue, double maxTotalDistance, class_310 client) {
        CompletableFuture<Void> task;
        Map<SoundData, AveragedSoundData> averagedResults = RaycastingHelper.processRaysWithAveraging(world, player, playerEyePos, rayDirections, soundQueue, maxTotalDistance);
        if (averagedResults.isEmpty() && muffledAveragedResults.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture<Void>> soundTasks = new ArrayList<CompletableFuture<Void>>();
        freezeTickCounter.set(true);
        for (AveragedSoundData avgData : averagedResults.values()) {
            task = CompletableFuture.runAsync(() -> RaycastingHelper.playAveragedSoundWithAdjustments(client, avgData, playerEyePos, 1.0f, 1.0f), soundProcessingExecutor);
            soundTasks.add(task);
        }
        if (ENABLE_PERMEATION) {
            for (AveragedSoundData avgData : muffledAveragedResults.values()) {
                task = CompletableFuture.runAsync(() -> RaycastingHelper.playMuffled(client, avgData, playerEyePos, 1.0f, 1.0f), soundProcessingExecutor);
                soundTasks.add(task);
            }
        }
        freezeTickCounter.set(false);
        CompletableFuture.allOf(soundTasks.toArray(new CompletableFuture[0])).join();
    }

    public static void playAveragedSoundWithAdjustments(class_310 client, AveragedSoundData avgData, class_243 playerPos, float volumeMultiplier, float pitchMultiplier) {
        if (client == null || client.field_1687 == null || avgData == null) {
            return;
        }
        try {
            class_243 targetPosition = avgData.soundEntity.soundId.contains("rain") ? playerPos.method_1019(avgData.averageDirection.method_1021(5.0)) : playerPos.method_1019(avgData.averageDirection.method_1021(avgData.averageDistance));
            class_1113 originalSound = avgData.soundEntity.sound;
            class_2960 soundId = originalSound.method_4775();
            if (avgData.totalWeight == 0.0 && originalSound instanceof RedTickableInstance) {
                ((RedTickableInstance)originalSound).setVolume(0.0f);
                return;
            }
            float baseVolume = originalSound instanceof RedTickableInstance ? ((RedTickableInstance)originalSound).getOriginalVolume() : ((RedSoundInstance)originalSound).original.method_4781();
            float confidenceMultiplier = (float)avgData.totalWeight / (float)RAYS_CAST * (float)MAX_BOUNCES;
            float adjustedVolume = baseVolume * volumeMultiplier * confidenceMultiplier;
            float basePitch = originalSound.method_4782();
            float adjustedPitch = basePitch * pitchMultiplier;
            if (originalSound instanceof RedTickableInstance) {
                ((RedTickableInstance)originalSound).setPos(targetPosition);
                ((RedTickableInstance)originalSound).setVolume(Math.max(0.01f, Math.min(1.0f, adjustedVolume)));
                return;
            }
            RedTickableInstance newSound = (RedSoundInstance)originalSound instanceof class_1117 ? new RedTickableInstance(soundId, originalSound.method_4776(), originalSound.method_4774(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new class_243(originalSound.method_4784(), originalSound.method_4779(), originalSound.method_4778()), baseVolume) : new RedTickableInstance(soundId, originalSound.method_4776(), originalSound.method_4774(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new class_243(originalSound.method_4784(), originalSound.method_4779(), originalSound.method_4778()), baseVolume);
            soundInstanceMap.put(((RedSoundInstance)originalSound).getOriginal(), (class_1113)newSound);
            if ((double)adjustedVolume <= 0.01) {
                return;
            }
            RaycastingHelper.queueSound((class_1113)newSound, (int)(avgData.averageDistance / 17.15));
        }
        catch (Exception e) {
            System.err.println("Error playing adjusted averaged sound: " + e.getMessage());
        }
    }

    public static void playMuffled(class_310 client, AveragedSoundData avgData, class_243 playerPos, float volumeMultiplier, float pitchMultiplier) {
        if (client == null || client.field_1687 == null || avgData == null) {
            return;
        }
        try {
            class_243 targetPosition = playerPos.method_1019(avgData.averageDirection.method_1021(avgData.averageDistance));
            class_1113 originalSound = avgData.soundEntity.sound;
            class_2960 soundId = originalSound.method_4775();
            float baseVolume = originalSound instanceof RedTickableInstance ? ((RedTickableInstance)originalSound).getOriginalVolume() : ((RedSoundInstance)originalSound).original.method_4781();
            float confidenceMultiplier = (float)avgData.totalWeight / (float)RAYS_CAST * (float)MAX_BOUNCES;
            float adjustedVolume = baseVolume * volumeMultiplier * confidenceMultiplier;
            if ((double)confidenceMultiplier > 0.9) {
                adjustedVolume = 0.0f;
            }
            float basePitch = originalSound.method_4782();
            float adjustedPitch = basePitch * pitchMultiplier;
            if (originalSound instanceof RedTickableInstance) {
                ((RedPermeatedSoundInstance)originalSound).setPos(targetPosition);
                ((RedPermeatedSoundInstance)originalSound).setVolume(Math.max(0.01f, Math.min(1.0f, adjustedVolume)));
                ((RedPermeatedSoundInstance)originalSound).setPermeationIndex(confidenceMultiplier);
                return;
            }
            RedPermeatedSoundInstance newSound = new RedPermeatedSoundInstance(soundId, originalSound.method_4776(), originalSound.method_4774(), targetPosition, Math.max(0.01f, Math.min(1.0f, adjustedVolume)), Math.max(0.5f, Math.min(2.0f, adjustedPitch)), originalSound, new class_243(originalSound.method_4784(), originalSound.method_4779(), originalSound.method_4778()), baseVolume, confidenceMultiplier);
            soundPermInstanceMap.put(((RedSoundInstance)originalSound).getOriginal(), newSound);
            if ((double)adjustedVolume <= 0.01) {
                return;
            }
            RaycastingHelper.queueSound((class_1113)newSound, (int)(avgData.averageDistance / 17.15));
        }
        catch (Exception e) {
            System.err.println("Error playing adjusted averaged sound: " + e.getMessage());
        }
    }

    private static void queueSound(class_1113 newSound, int distance) {
        soundPlayingWaiting.computeIfAbsent(ticksSinceWorld + 1, k -> new ArrayList()).add(newSound);
    }

    public static Map<SoundData, AveragedSoundData> processRaysWithAveraging(class_1937 world, class_1657 player, class_243 playerEyePos, List<class_243> rayDirections, Queue<SoundData> soundQueue, double maxTotalDistance) {
        AveragedSoundData averagedData;
        List<RayHitData> rayHits;
        SoundData entity;
        reverbStrength.set(0);
        distanceFromWallEcho.set(0.0);
        distanceFromWallEchoDenom.set(0.0);
        reverbDenom.set(0);
        outdoorLeak.set(0);
        outdoorLeakDenom.set(0);
        ConcurrentLinkedQueue<SoundData> threadSafeSoundQueue = new ConcurrentLinkedQueue<SoundData>(soundQueue);
        int raysPerChunk = Math.max(1, rayDirections.size() / THREAD_POOL_SIZE);
        ArrayList<List<class_243>> rayChunks = new ArrayList<List<class_243>>();
        for (int i = 0; i < rayDirections.size(); i += raysPerChunk) {
            int endIndex = Math.min(i + raysPerChunk, rayDirections.size());
            rayChunks.add(rayDirections.subList(i, endIndex));
        }
        ArrayList<CompletableFuture<Void>> rayTasks = new ArrayList<CompletableFuture<Void>>();
        for (List list : rayChunks) {
            CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                for (class_243 direction : rayChunk) {
                    RaycastingHelper.castBouncingRay(world, player, playerEyePos, direction, threadSafeSoundQueue, maxTotalDistance);
                }
            }, raycastExecutor);
            rayTasks.add(task);
        }
        CompletableFuture.allOf(rayTasks.toArray(new CompletableFuture[0])).join();
        ConcurrentHashMap<SoundData, AveragedSoundData> averagedResults = new ConcurrentHashMap<SoundData, AveragedSoundData>();
        muffledAveragedResults.clear();
        for (Map.Entry<SoundData, List<RayHitData>> entry : rayHitsByEntity.entrySet()) {
            entity = entry.getKey();
            rayHits = entry.getValue();
            averagedData = RaycastingHelper.calculateWeightedAverages(entity, rayHits);
            averagedResults.put(entity, averagedData);
        }
        for (Map.Entry<SoundData, List<RayHitData>> entry : redRaysToTarget.entrySet()) {
            entity = entry.getKey();
            rayHits = entry.getValue();
            averagedData = RaycastingHelper.calculateWeightedAverages(entity, rayHits);
            muffledAveragedResults.put(entity, averagedData);
        }
        return averagedResults;
    }

    public static RaycastResult castBouncingRay(class_1937 world, class_1657 player, class_243 startPos, class_243 direction, Queue<SoundData> soundQueue, double maxTotalDistance) {
        double segmentTraveled;
        class_243 currentPos = startPos;
        class_243 currentDirection = direction.method_1029();
        class_243 initialDirection = currentDirection.method_1029();
        double remainingDistance = maxTotalDistance;
        double totalDistanceTraveled = 0.0;
        SoundData hitEntity = null;
        if (ENABLE_PERMEATION) {
            RaycastingHelper.castRedRay(world, player, startPos, soundQueue, totalDistanceTraveled, initialDirection);
        }
        RaycastingHelper.castGreenRay(world, player, startPos, soundQueue, totalDistanceTraveled, initialDirection);
        for (int bounce = 0; bounce <= MAX_BOUNCES && remainingDistance > 0.0; remainingDistance -= segmentTraveled, ++bounce) {
            double segmentDistance = Math.min(RAY_SEGMENT_LENGTH, remainingDistance);
            class_243 segmentEnd = currentPos.method_1019(currentDirection.method_1021(segmentDistance));
            class_3959 raycastContext = new class_3959(currentPos, segmentEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 blockHit = world.method_17742(raycastContext);
            class_243 actualEnd = segmentEnd;
            boolean hitBlock = false;
            if (blockHit.method_17783() == class_239.class_240.field_1332) {
                actualEnd = blockHit.method_17784();
                hitBlock = true;
            }
            segmentTraveled = currentPos.method_1022(actualEnd);
            totalDistanceTraveled += segmentTraveled;
            if (hitBlock) {
                if (ENABLE_REVERB) {
                    RaycastingHelper.castBlueRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
                }
                if (ENABLE_PERMEATION && bounce < 2) {
                    RaycastingHelper.castRedRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
                }
                RaycastingHelper.castGreenRay(world, player, actualEnd, soundQueue, totalDistanceTraveled, initialDirection);
            }
            if (hitBlock) {
                class_243 hitPos = blockHit.method_17784();
                class_2350 hitSide = blockHit.method_17780();
                class_243 reflectedDirection = RaycastingHelper.calculateReflection(currentDirection, hitSide);
                currentPos = hitPos.method_1019(reflectedDirection.method_1021(0.01));
                currentDirection = reflectedDirection;
            } else {
                for (SoundData soundEntity : weatherQueue) {
                    double weight = ATTENUATION_TYPE == RedsAttenuationType.INVERSE_SQUARE ? 1.0 / (Math.max(totalDistanceTraveled - segmentTraveled, 0.1) * Math.max(totalDistanceTraveled - segmentTraveled, 0.1)) : 1.0 / Math.max(totalDistanceTraveled - segmentTraveled, 0.1);
                    RaycastResult GreenRayResult = new RaycastResult(maxTotalDistance, initialDirection, soundEntity);
                    RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
                    rayHitsByEntity.computeIfAbsent(soundEntity, k -> new CopyOnWriteArrayList()).add(hitData);
                    entityRayHitCounts.merge(soundEntity, 1, Integer::sum);
                }
                class_243 toCenter = player.method_19538().method_1020(actualEnd);
                class_243 normal = toCenter.method_1029();
                class_243 reflectedDirection = RaycastingHelper.calculateReflection(currentDirection, normal);
                currentPos = segmentEnd.method_1019(reflectedDirection.method_1021(0.01));
                currentDirection = reflectedDirection;
                remainingDistance -= segmentTraveled;
                outdoorLeak.incrementAndGet();
                outdoorLeakDenom.incrementAndGet();
                return null;
            }
            outdoorLeakDenom.incrementAndGet();
        }
        return new RaycastResult(totalDistanceTraveled, initialDirection, hitEntity, currentPos);
    }

    private static void castGreenRay(class_1937 world, class_1657 player, class_243 currentPos, Queue<SoundData> entities, double currentDistance, class_243 initialDirection) {
        for (SoundData soundData : entities) {
            class_3959 raycastContext;
            class_3965 blockHit;
            boolean hasLineOfSight;
            class_243 entityCenter = soundData.position;
            double distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * soundData.sound.method_4781()) || !(hasLineOfSight = (blockHit = world.method_17742(raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() != class_239.class_240.field_1332 || currentPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 1.0)) continue;
            double weight = ATTENUATION_TYPE == RedsAttenuationType.INVERSE_SQUARE ? 1.0 / (Math.max(distanceToEntity + currentDistance, 0.1) * Math.max(distanceToEntity + currentDistance, 0.1)) : 1.0 / Math.max(distanceToEntity + currentDistance, 0.1);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, soundData, entityCenter);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(soundData, 1, Integer::sum);
        }
        for (RedTickableInstance redTickableInstance : tickQueue) {
            class_3959 raycastContext;
            class_3965 blockHit;
            boolean hasLineOfSight;
            TickableSoundData data = new TickableSoundData((class_1113)redTickableInstance, redTickableInstance.getOriginalPosition(), redTickableInstance.method_4776().method_4767().toString());
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList());
            class_243 entityCenter = redTickableInstance.getOriginalPosition();
            double distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redTickableInstance.getOriginalVolume()) || !(hasLineOfSight = (blockHit = world.method_17742(raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() != class_239.class_240.field_1332 || currentPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 1.0)) continue;
            double weight = ATTENUATION_TYPE == RedsAttenuationType.INVERSE_SQUARE ? 1.0 / (Math.max(distanceToEntity + currentDistance, 0.1) * Math.max(distanceToEntity + currentDistance, 0.1)) : 1.0 / Math.max(distanceToEntity + currentDistance, 0.1);
            RaycastResult GreenRayResult = new RaycastResult(distanceToEntity, initialDirection, data, entityCenter);
            RayHitData hitData = new RayHitData(GreenRayResult, initialDirection, weight);
            rayHitsByEntity.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
            entityRayHitCounts.merge(data, 1, Integer::sum);
        }
    }

    private static boolean castBlueRay(class_1937 world, class_1657 player, class_243 currentPos, Queue<SoundData> entities, double currentDistance, class_243 initialDirection) {
        class_243 entityCenter = player.method_5829().method_1005();
        currentPos = currentPos.method_1019(entityCenter.method_1020(currentPos).method_1021(0.87));
        double distanceToEntity = currentPos.method_1022(entityCenter);
        class_3959 raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
        class_3965 blockHit = world.method_17742(raycastContext);
        boolean hasLineOfSight = blockHit.method_17783() != class_239.class_240.field_1332 || currentPos.method_1022(blockHit.method_17784()) >= distanceToEntity - 0.6;
        reverbDenom.incrementAndGet();
        if (hasLineOfSight) {
            distanceFromWallEcho.updateAndGet(current -> current + currentDistance);
            distanceFromWallEchoDenom.updateAndGet(current -> current + 1.0);
            reverbStrength.incrementAndGet();
        }
        return hasLineOfSight;
    }

    private static void castRedRay(class_1937 world, class_1657 player, class_243 currentPos, Queue<SoundData> entities, double currentDistance, class_243 initialDirection) {
        class_243 entityCenter;
        for (SoundData soundData : entities) {
            entityCenter = soundData.position;
            double distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * soundData.sound.method_4781())) continue;
            class_3959 raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 blockHit = world.method_17742(raycastContext);
            currentPos = blockHit.method_17784();
            double blockCount = RaycastingHelper.countBlocksBetween(world, currentPos, entityCenter, player);
            double blockAttenuation = Math.pow(0.7, blockCount);
            double weight = blockAttenuation / (Math.max(distanceToEntity, 0.1) * Math.max(distanceToEntity, 0.1));
            RaycastResult rayResult = new RaycastResult(distanceToEntity, initialDirection, soundData, entityCenter);
            RayHitData hitData = new RayHitData(rayResult, initialDirection, weight);
            redRaysToTarget.computeIfAbsent(soundData, k -> new CopyOnWriteArrayList()).add(hitData);
        }
        for (RedPermeatedSoundInstance redPermeatedSoundInstance : permeatedTickQueue) {
            entityCenter = redPermeatedSoundInstance.getOriginalPosition();
            TickableSoundData data = new TickableSoundData((class_1113)redPermeatedSoundInstance, redPermeatedSoundInstance.getOriginalPosition(), redPermeatedSoundInstance.method_4776().method_4767().toString());
            double distanceToEntity = currentPos.method_1022(entityCenter);
            if (distanceToEntity + currentDistance > (double)(16.0f * redPermeatedSoundInstance.getOriginalVolume())) continue;
            class_3959 raycastContext = new class_3959(currentPos, entityCenter, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 blockHit = world.method_17742(raycastContext);
            currentPos = blockHit.method_17784();
            double blockCount = RaycastingHelper.countBlocksBetween(world, currentPos, entityCenter, player);
            double blockAttenuation = Math.pow(0.7, blockCount);
            double weight = blockAttenuation / (Math.max(distanceToEntity, 0.1) * Math.max(distanceToEntity, 0.1));
            RaycastResult rayResult = new RaycastResult(distanceToEntity, initialDirection, data, entityCenter);
            RayHitData hitData = new RayHitData(rayResult, initialDirection, weight);
            redRaysToTarget.computeIfAbsent(data, k -> new CopyOnWriteArrayList()).add(hitData);
        }
    }

    private static AveragedSoundData calculateWeightedAverages(SoundData entity, List<RayHitData> rayHits) {
        double totalWeight = 0.0;
        double weightedDistanceSum = 0.0;
        class_243 weightedDirectionSum = class_243.field_1353;
        for (RayHitData rayHit : rayHits) {
            double weight = rayHit.weight;
            totalWeight += weight;
            weightedDistanceSum += rayHit.rayResult.totalDistance * weight;
            class_243 weightedDirection = rayHit.rayResult.initialDirection.method_1021(weight);
            weightedDirectionSum = weightedDirectionSum.method_1019(weightedDirection);
        }
        if (totalWeight == 0.0) {
            return new AveragedSoundData(entity, weightedDirectionSum, weightedDistanceSum, totalWeight, rayHits.size(), rayHits);
        }
        double averageDistance = weightedDistanceSum / totalWeight;
        class_243 averageDirection = weightedDirectionSum.method_1021(1.0 / totalWeight).method_1029();
        return new AveragedSoundData(entity, averageDirection, averageDistance, totalWeight, rayHits.size(), rayHits);
    }

    private static double countBlocksBetween(class_1937 world, class_243 start, class_243 end, class_1657 player) {
        class_3959 raycastContext;
        class_3965 hit;
        double totalDistanceInBlocks;
        double distanceInBlock;
        class_243 currentStart = start;
        for (totalDistanceInBlocks = 0.0; totalDistanceInBlocks < 3.0 && (hit = world.method_17742(raycastContext = new class_3959(currentStart, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player))).method_17783() == class_239.class_240.field_1332; totalDistanceInBlocks += distanceInBlock) {
            class_243 exitPoint;
            class_243 direction;
            class_2338 hitBlockPos = hit.method_17777();
            class_2680 blockState = world.method_8320(hitBlockPos);
            if (!blockState.method_26215()) {
                direction = end.method_1020(currentStart).method_1029();
                class_265 blockShape = blockState.method_26218((class_1922)world, hitBlockPos);
                class_238 blockBounds = blockShape.method_1107().method_996(hitBlockPos);
                exitPoint = hit.method_17784();
                double step = PERMEATION_STEP_SIZE;
                while (blockBounds.method_1006(exitPoint)) {
                    exitPoint = exitPoint.method_1019(direction.method_1021(step));
                }
                distanceInBlock = hit.method_17784().method_1022(exitPoint);
            } else {
                throw new RuntimeException("Why tf is the raycasting getting stuck within air... WHAT HAVE YOU DONE!!!");
            }
            currentStart = exitPoint.method_1019(direction.method_1021(0.01));
            if (!(currentStart.method_1022(start) >= end.method_1022(start))) continue;
            break;
        }
        return totalDistanceInBlocks;
    }

    public static void drawGreenRay(class_1937 world, class_243 start, class_243 end) {
        if (world.field_9236) {
            class_243 direction = end.method_1020(start).method_1029();
            double distance = start.method_1022(end);
            for (double d = 0.0; d < distance; d += 0.5) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                world.method_8406((class_2394)class_2398.field_11211, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void drawBlueRay(class_1937 world, class_243 start, class_243 end) {
        if (world.field_9236) {
            class_243 direction = end.method_1020(start).method_1029();
            double distance = start.method_1022(end);
            for (double d = 0.0; d < distance; d += 0.5) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                world.method_8406((class_2394)class_2398.field_22246, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class_243 calculateReflection(class_243 incident, class_2350 hitSide) {
        class_243 normal = class_243.method_24954((class_2382)hitSide.method_10163());
        double dotProduct = incident.method_1026(normal);
        return incident.method_1020(normal.method_1021(2.0 * dotProduct));
    }

    public static class_243 calculateReflection(class_243 incident, class_243 normal) {
        double dotProduct = incident.method_1026(normal);
        return incident.method_1020(normal.method_1021(2.0 * dotProduct));
    }

    public static void drawBouncingRaySegment(class_1937 world, class_243 start, class_243 end, int bounceCount) {
        if (world.field_9236) {
            class_243 direction = end.method_1020(start).method_1029();
            double distance = start.method_1022(end);
            block5: for (double d = 0.0; d < distance; d += 0.4) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                switch (bounceCount) {
                    case 0: {
                        world.method_8406((class_2394)class_2398.field_11207, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
                        continue block5;
                    }
                    case 1: {
                        world.method_8406((class_2394)class_2398.field_11240, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
                        continue block5;
                    }
                    case 2: {
                        world.method_8406((class_2394)class_2398.field_11239, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
                        continue block5;
                    }
                    default: {
                        world.method_8406((class_2394)class_2398.field_11237, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void drawEntityDetectionLine(class_1937 world, class_243 start, class_243 end) {
        if (world.field_9236) {
            class_243 direction = end.method_1020(start).method_1029();
            double distance = start.method_1022(end);
            for (double d = 0.0; d < distance; d += 0.3) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                world.method_8406((class_2394)class_2398.field_11215, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.02, 0.0);
            }
        }
    }

    public static void displayEntityRayHitCounts(class_1937 world, class_1657 player) {
        if (world.field_9236 && !entityRayHitCounts.isEmpty()) {
            for (Map.Entry<SoundData, Integer> entry : entityRayHitCounts.entrySet()) {
                SoundData entity = entry.getKey();
                int rayCount = entry.getValue();
                class_243 entityPos = entity.position;
                class_243 displayPos = entityPos.method_1031(0.0, entity.position.field_1351, 0.0);
                String string = entity.soundId;
            }
        }
    }

    public static class_243[] generateRayDirections() {
        int numRays = RAYS_CAST;
        class_243[] directions = new class_243[numRays];
        double goldenRatio = (1.0 + Math.sqrt(5.0)) / 2.0;
        for (int i = 0; i < numRays; ++i) {
            double theta = Math.PI * 2 * (double)i / goldenRatio;
            double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)numRays);
            double x = Math.sin(phi) * Math.cos(theta);
            double y = Math.cos(phi);
            double z = Math.sin(phi) * Math.sin(theta);
            directions[i] = new class_243(x, y, z);
        }
        return directions;
    }

    public static void playQueuedObjects(int tsw) {
        if (freezeTickCounter.get()) {
            return;
        }
        if (!soundPlayingWaiting.containsKey(++ticksSinceWorld)) {
            return;
        }
        class_310 client = class_310.method_1551();
        ArrayList<class_1113> sound = soundPlayingWaiting.get(ticksSinceWorld);
        for (class_1113 newSound : sound) {
            if (newSound == null) continue;
            client.method_1483().method_4873(newSound);
        }
        soundPlayingWaiting.remove(tsw);
    }

    public static double getDistanceFromWallEcho() {
        return distanceFromWallEcho.get();
    }

    public static double getDistanceFromWallEchoDenom() {
        return distanceFromWallEchoDenom.get();
    }

    public static int getReverbStrength() {
        return reverbStrength.get();
    }

    public static int getReverbDenom() {
        return reverbDenom.get();
    }

    public static int getOutdoorLeak() {
        return outdoorLeak.get();
    }

    public static int getOutdoorLeakDenom() {
        return outdoorLeakDenom.get();
    }

    public static void shutdown() {
        try {
            raycastExecutor.shutdown();
            soundProcessingExecutor.shutdown();
            if (!raycastExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                raycastExecutor.shutdownNow();
            }
            if (!soundProcessingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                soundProcessingExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            raycastExecutor.shutdownNow();
            soundProcessingExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        distanceFromWallEcho = new AtomicReference<Double>(0.0);
        distanceFromWallEchoDenom = new AtomicReference<Double>(0.0);
        reverbStrength = new AtomicInteger(0);
        reverbDenom = new AtomicInteger(0);
        outdoorLeak = new AtomicInteger(0);
        outdoorLeakDenom = new AtomicInteger(0);
        rayHitsByEntity = new ConcurrentHashMap();
        redRaysToTarget = new ConcurrentHashMap();
        muffledAveragedResults = new ConcurrentHashMap();
        soundInstanceMap = new ConcurrentHashMap();
        soundPermInstanceMap = new ConcurrentHashMap();
        THREAD_POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
        raycastExecutor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
        soundProcessingExecutor = Executors.newFixedThreadPool(2);
        isRaytracing = new AtomicBoolean(false);
        freezeTickCounter = new AtomicBoolean(false);
        RAYS_CAST = Config.getInstance().raysCast;
        MAX_BOUNCES = Config.getInstance().raysBounced;
        RAY_SEGMENT_LENGTH = 16.0 * (double)Config.getInstance().maxRayLength;
        ENABLE_REVERB = Config.getInstance().reverbEnabled;
        ENABLE_PERMEATION = Config.getInstance().permeationEnabled;
        TICK_RATE = Config.getInstance().tickRate;
        ATTENUATION_TYPE = Config.getInstance().attenuationType;
        PERMEATION_STEP_SIZE = Config.getInstance().permeationStepSize;
        FXQueue = new LinkedList<RedPermeatedSoundInstance>();
    }
}

