/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.mixin.client;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.mixin.client.SourceAccessor;
import com.redsmods.sound_physics_perfected.mixin.client.SourceManagerAccessor;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedPositionedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4224;
import net.minecraft.class_4235;
import org.joml.Math;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1140.class})
public abstract class SoundSystemMixin {
    private static final int MAX_SOUNDS = 100;
    private static int auxFXSlot = 0;
    private static int reverbEffect = 0;
    private static int muffleFilter = 0;
    private static int sendFilter = 0;
    private static boolean efxInitialized = false;
    private static final Queue<RedTickableInstance> FXTickQueue = new LinkedList<RedTickableInstance>();
    private static final Map<Integer, RedTickableInstance> tickMap = new HashMap<Integer, RedTickableInstance>();
    @Shadow
    private class_1144 field_5552;
    @Shadow
    private Map<class_1113, class_4235.class_4236> field_18950;

    @Shadow
    public abstract void method_4856();

    @Shadow
    public abstract void method_20185(boolean var1);

    @Inject(method={"play(Lnet/minecraft/client/sound/SoundInstance;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSoundPlay(class_1113 sound, CallbackInfo ci) {
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null || sound == null || this.field_5552 == null) {
            return;
        }
        try {
            class_1146 weightedSoundSet = sound.method_4783(this.field_5552);
            if (!(sound instanceof RedPositionedSoundInstance || sound instanceof class_1117 || sound instanceof RedPermeatedSoundInstance || sound.method_4777() == class_1113.class_1114.field_5478)) {
                double soundX = sound.method_4784();
                double soundY = sound.method_4779();
                double soundZ = sound.method_4778();
                class_243 soundPos = new class_243(soundX, soundY, soundZ);
                String soundId = sound.method_4775().toString();
                RedSoundInstance redSoundData = new RedSoundInstance(sound);
                SoundData soundData = new SoundData(redSoundData, soundPos, soundId);
                RaycastingHelper.soundQueue.offer(soundData);
                while (RaycastingHelper.soundQueue.size() > 100) {
                    RaycastingHelper.soundQueue.poll();
                }
                ci.cancel();
            } else if (RaycastingHelper.ENABLE_PERMEATION && sound instanceof RedPermeatedSoundInstance) {
                RaycastingHelper.FXQueue.add((RedPermeatedSoundInstance)sound);
            } else if (RaycastingHelper.TICK_RATE == 0 && sound instanceof RedTickableInstance) {
                FXTickQueue.add((RedTickableInstance)sound);
            }
        }
        catch (Exception e) {
            System.err.println("Error tracking sound: " + e.getMessage());
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sound/SoundSystem;tick()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onSoundTick(boolean paused, CallbackInfo ci) {
        int id;
        class_4224 source;
        SourceManagerAccessor accessor;
        class_4235.class_4236 manager;
        RedTickableInstance sound;
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        if (paused) {
            return;
        }
        while (!RaycastingHelper.FXQueue.isEmpty()) {
            try {
                sound = RaycastingHelper.FXQueue.poll();
                manager = this.field_18950.get(sound);
                accessor = (SourceManagerAccessor)manager;
                source = accessor.getSource();
                id = ((SourceAccessor)source).getPointer();
                ((RedPermeatedSoundInstance)sound).setSource(id);
                ((RedPermeatedSoundInstance)sound).applyMuffleToSource(id, ((RedPermeatedSoundInstance)sound).getPermeationIndex());
            }
            catch (Exception e) {
                System.out.println("sourceID is invalid for a sound, non-issue" + String.valueOf(e));
            }
        }
        while (!FXTickQueue.isEmpty()) {
            sound = FXTickQueue.poll();
            try {
                manager = this.field_18950.get(sound);
                accessor = (SourceManagerAccessor)manager;
                source = accessor.getSource();
                id = ((SourceAccessor)source).getPointer();
                tickMap.put(id, sound);
            }
            catch (Exception e) {
                if (tickMap.containsValue(sound)) {
                    System.out.println("Critical error (mem leak prolly)");
                }
                System.out.println("sourceID is invalid for a sound, non-issue");
            }
        }
        if (RaycastingHelper.ENABLE_REVERB) {
            SoundSystemMixin.updateActiveSources();
        }
    }

    @ModifyVariable(method={"stop(Lnet/minecraft/client/sound/SoundInstance;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1113 modifySoundParameter(class_1113 sound) {
        class_4235.class_4236 sourceManagerNormal;
        if (!efxInitialized) {
            return sound;
        }
        if (sound == null) {
            return sound;
        }
        RaycastingHelper.soundQueue.remove(sound);
        class_1113 customSound = RaycastingHelper.soundInstanceMap.get(sound);
        RedPermeatedSoundInstance soundPermeation = RaycastingHelper.soundPermInstanceMap.get(sound);
        if (soundPermeation != null) {
            soundPermeation.setDone(true);
        }
        RaycastingHelper.soundInstanceMap.remove(sound);
        RaycastingHelper.soundPermInstanceMap.remove(sound);
        class_4235.class_4236 sourceManager = this.field_18950.get(soundPermeation);
        if (sourceManager != null) {
            sourceManager.method_19735(class_4224::method_19655);
        }
        if ((sourceManagerNormal = this.field_18950.get(customSound)) != null) {
            sourceManagerNormal.method_19735(class_4224::method_19655);
        }
        return sound;
    }

    @Inject(method={"stopAll()V"}, at={@At(value="HEAD")})
    private void onStopAll(CallbackInfo ci) {
        RaycastingHelper.soundQueue.clear();
    }

    private static void cleanupEFXResources() {
        if (!efxInitialized) {
            return;
        }
        try {
            System.out.println("Cleaning up EFX resources...");
            RaycastingHelper.FXQueue.clear();
            FXTickQueue.clear();
            tickMap.clear();
            if (auxFXSlot != 0) {
                EXTEfx.alDeleteAuxiliaryEffectSlots((int)auxFXSlot);
                auxFXSlot = 0;
            }
            if (reverbEffect != 0) {
                EXTEfx.alDeleteEffects((int)reverbEffect);
                reverbEffect = 0;
            }
            if (muffleFilter != 0) {
                EXTEfx.alDeleteFilters((int)muffleFilter);
                muffleFilter = 0;
            }
            if (sendFilter != 0) {
                EXTEfx.alDeleteFilters((int)sendFilter);
                sendFilter = 0;
            }
            efxInitialized = false;
            System.out.println("EFX resources cleaned up successfully");
        }
        catch (Exception e) {
            System.err.println("Error cleaning up EFX resources: " + e.getMessage());
            auxFXSlot = 0;
            reverbEffect = 0;
            muffleFilter = 0;
            sendFilter = 0;
            efxInitialized = false;
        }
    }

    private static void initializeReverb() {
        if (efxInitialized) {
            return;
        }
        try {
            long currentContext = ALC10.alcGetCurrentContext();
            long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
            if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
                System.out.println("EFX Extension not available - reverb disabled");
                return;
            }
            auxFXSlot = EXTEfx.alGenAuxiliaryEffectSlots();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)3, (int)1);
            reverbEffect = EXTEfx.alGenEffects();
            EXTEfx.alEffecti((int)reverbEffect, (int)32769, (int)32768);
            muffleFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)muffleFilter, (int)32769, (int)1);
            RedPermeatedSoundInstance.muffleFilter = muffleFilter;
            sendFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)sendFilter, (int)32769, (int)1);
            SoundSystemMixin.setBasicReverbParams();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbEffect);
            efxInitialized = true;
            System.out.println("Reverb system initialized successfully");
        }
        catch (Exception e) {
            System.err.println("Failed to initialize reverb: " + e.getMessage());
        }
    }

    private static void setBasicReverbParams() {
        EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)0.5f);
        EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)0.3f);
        EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)15.0f);
        EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)0.7f);
        EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)0.2f);
        EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)0.4f);
        EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)0.03f);
        EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)0.99f);
        EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)0.0f);
    }

    private static void updateActiveSources() {
        long context = ALC10.alcGetCurrentContext();
        if (context == 0L) {
            return;
        }
        AL10.alGetError();
        try {
            for (int sourceId = 1; sourceId <= 256; ++sourceId) {
                if (AL10.alIsSource((int)sourceId)) {
                    int state = AL10.alGetSourcei((int)sourceId, (int)4112);
                    if (state != 4114 && state != 4115) continue;
                    SoundSystemMixin.applyReverbToSource(sourceId);
                    continue;
                }
                if (!tickMap.containsKey(sourceId)) continue;
                tickMap.get(sourceId).stop();
                tickMap.remove(sourceId);
                System.out.println(tickMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyReverbToSource(int sourceId) {
        try {
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float occlusionPercent = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            occlusionPercent = 1.0f - occlusionPercent;
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float distanceMeters = SoundSystemMixin.clamp(wallDistance, 1.0f, 100.0f);
            occlusionPercent = 1.0f - SoundSystemMixin.clamp(occlusionPercent + (outdoorLeakPercent *= 2.0f), 0.0f, 1.0f);
            outdoorLeakPercent = SoundSystemMixin.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            float dryFactor = 1.0f - outdoorLeakPercent;
            float speedOfSound = 343.0f;
            float distanceAttenuation = 1.0f / (1.0f + (distanceMeters - 1.0f) * 0.01f);
            float volumeEstimate = distanceMeters * distanceMeters * distanceMeters;
            float surfaceArea = 6.0f * distanceMeters * distanceMeters;
            float materialAbsorption = Math.lerp((float)0.25f, (float)0.05f, (float)dryFactor);
            float totalAbsorption = surfaceArea * materialAbsorption;
            float salineRT60 = 0.161f * volumeEstimate / java.lang.Math.max(totalAbsorption, 0.1f);
            float decayTime = SoundSystemMixin.clamp(salineRT60 * dryFactor, 0.1f, 8.0f);
            float airAbsorptionCoeff = 1.0f - distanceMeters * 0.002f;
            airAbsorptionCoeff = SoundSystemMixin.clamp(airAbsorptionCoeff, 0.3f, 1.0f);
            float wallDelay = distanceMeters * 2.0f / speedOfSound;
            float earlyReflectionDelay = SoundSystemMixin.clamp(distanceMeters / speedOfSound, 0.001f, 0.03f);
            float lateReverbBuildupTime = SoundSystemMixin.clamp(distanceMeters * 1.5f / speedOfSound, 0.01f, 0.08f);
            float airAbsorption = 1.0f - distanceMeters * 0.001f;
            float decayHfRatio = SoundSystemMixin.clamp(Math.lerp((float)0.3f, (float)1.0f, (float)((1.0f - occlusionPercent) * dryFactor * airAbsorption)), 0.1f, 2.0f);
            float reflectionsDelay = SoundSystemMixin.clamp(earlyReflectionDelay * 0.3f, 0.005f, 0.03f);
            float lateReverbDelay = SoundSystemMixin.clamp(earlyReflectionDelay * 1.5f, 0.01f, 0.08f);
            float sizeFactor = SoundSystemMixin.clamp(distanceMeters / 20.0f, 0.0f, 1.0f);
            float diffusion = Math.lerp((float)0.4f, (float)0.95f, (float)(sizeFactor * dryFactor * (1.0f - occlusionPercent)));
            float gainHF = Math.lerp((float)0.1f, (float)0.8f, (float)((1.0f - occlusionPercent) * dryFactor * airAbsorption));
            float sizeGainReduction = 1.0f / (1.0f + sizeFactor * 0.3f);
            float reflectionsGain = Math.lerp((float)0.0f, (float)0.6f, (float)(dryFactor * distanceAttenuation * sizeGainReduction));
            float lateReverbGain = Math.lerp((float)0.0f, (float)0.8f, (float)(dryFactor * distanceAttenuation * sizeGainReduction));
            float density = Math.lerp((float)0.8f, (float)0.4f, (float)sizeFactor) * dryFactor;
            float gain = Math.lerp((float)0.02f, (float)0.25f, (float)(dryFactor * distanceAttenuation * sizeGainReduction));
            float airAbsorptionHF = Math.lerp((float)0.92f, (float)0.99f, (float)dryFactor) * airAbsorption;
            float roomRolloff = Math.lerp((float)0.6f, (float)0.2f, (float)sizeFactor);
            EXTEfx.alFilterf((int)sendFilter, (int)1, (float)gain);
            EXTEfx.alFilterf((int)sendFilter, (int)2, (float)(gainHF * 0.8f));
            EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)gain);
            EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)decayTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)lateReverbGain);
            AL11.alSource3i((int)sourceId, (int)131078, (int)auxFXSlot, (int)0, (int)sendFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void debugSourceCount() {
        int sourcesInUse = 0;
        for (int i = 1; i < 1000; ++i) {
            if (!AL10.alIsSource((int)i)) continue;
            ++sourcesInUse;
        }
        System.out.println("Sources currently in use: " + sourcesInUse);
    }

    @Inject(method={"stop()V"}, at={@At(value="HEAD")})
    private void onAudioEngineStop(CallbackInfo ci) {
        SoundSystemMixin.cleanupEFXResources();
    }

    @Inject(method={"start()V"}, at={@At(value="TAIL")})
    private void onAudioEngineStart(CallbackInfo ci) {
        efxInitialized = false;
        SoundSystemMixin.initializeReverb();
    }

    private static float clamp(float a, float b, float c) {
        return java.lang.Math.min(java.lang.Math.max(a, b), c);
    }
}

