/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

public class RedPermeatedSoundInstance
extends RedTickableInstance {
    float permeationIndex;
    int tickCount = 0;
    private int id;
    public static Integer muffleFilter = -1;
    private boolean sourceSet = false;
    private float targetMuffle;

    public RedPermeatedSoundInstance(class_2960 soundID, class_1111 sound, class_3419 category, class_243 position, float volume, float pitch, class_1113 wrapped, class_243 originalPos, float originalVolume, float permeationIndex) {
        super(soundID, sound, category, position, volume, pitch, wrapped, originalPos, originalVolume);
        this.permeationIndex = permeationIndex;
    }

    public float getPermeationIndex() {
        return 1.0f - this.permeationIndex;
    }

    public void setPermeationIndex(float permeationIndex) {
        if (super.method_4793()) {
            return;
        }
        this.targetMuffle = permeationIndex;
    }

    @Override
    public void method_16896() {
        ++this.tickCount;
        if (super.method_4793() || RaycastingHelper.TICK_RATE == 0) {
            return;
        }
        if (this.tickCount % RaycastingHelper.TICK_RATE == 0) {
            RaycastingHelper.permeatedTickQueue.add(this);
        }
        super.updatePos();
        super.updateVolume();
        this.updateMuffle();
    }

    public void updateMuffle() {
        float deltaVolume = this.targetMuffle - this.permeationIndex;
        float maxVolumeChange = Math.abs(deltaVolume / (float)RaycastingHelper.TICK_RATE);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)RaycastingHelper.TICK_RATE) {
            this.permeationIndex = this.targetMuffle;
            if (this.sourceSet && AL10.alIsSource((int)this.id)) {
                this.applyMuffleToSource(this.id, 1.0f - this.permeationIndex);
            }
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.permeationIndex = deltaVolume > 0.0f ? (this.permeationIndex += volumeChange) : (this.permeationIndex -= volumeChange);
        if (this.sourceSet && AL10.alIsSource((int)this.id)) {
            this.applyMuffleToSource(this.id, 1.0f - this.permeationIndex);
        }
    }

    public void setSource(int id) {
        this.sourceSet = true;
        this.id = id;
    }

    public void applyMuffleToSource(int sourceId, float muffleStrength) {
        try {
            muffleStrength = class_3532.method_15363((float)muffleStrength, (float)0.0f, (float)1.0f);
            float lowpassGain = org.joml.Math.lerp((float)1.0f, (float)0.2f, (float)muffleStrength);
            float lowpassGainHF = org.joml.Math.lerp((float)1.0f, (float)0.1f, (float)muffleStrength);
            if (muffleFilter != -1) {
                EXTEfx.alFilterf((int)muffleFilter, (int)1, (float)lowpassGain);
                EXTEfx.alFilterf((int)muffleFilter, (int)2, (float)lowpassGainHF);
                AL11.alSourcei((int)sourceId, (int)131077, (int)muffleFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

