/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.mixin.client;

import com.mojang.blaze3d.audio.Channel;
import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.ReverbHelpers.EnhancedReverbData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.LegacyReverb;
import com.redsmods.sound_physics_perfected.ReverbHelpers.ReverbConstants;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.config.DebugType;
import com.redsmods.sound_physics_perfected.mixin.client.SourceAccessor;
import com.redsmods.sound_physics_perfected.mixin.client.SourceManagerAccessor;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedPositionedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public abstract class SoundSystemMixin {
    private static final int MAX_SOUNDS = 100;
    private static int auxFXSlot = 0;
    private static int reverbEffect = 0;
    private static int muffleFilter = 0;
    private static int sendFilter = 0;
    private static boolean efxInitialized = false;
    private static final Map<Integer, RedTickableInstance> tickMap = new HashMap<Integer, RedTickableInstance>();
    @Shadow
    private SoundManager soundManager;
    @Shadow
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;

    @Shadow
    public abstract void destroy();

    @Shadow
    public abstract void tick(boolean var1);

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)Lnet/minecraft/client/sounds/SoundEngine$PlayResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSoundPlay(SoundInstance sound, CallbackInfoReturnable<SoundEngine.PlayResult> cir) {
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (this.isSoundBlacklisted(sound.toString())) {
            return;
        }
        if (!efxInitialized) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.player == null || client.level == null || sound == null || this.soundManager == null) {
            return;
        }
        try {
            WeighedSoundEvents weightedSoundSet = sound.resolve(this.soundManager);
            if (!(sound instanceof RedPositionedSoundInstance || sound instanceof TickableSoundInstance || sound instanceof RedPermeatedSoundInstance || sound.getAttenuation() == SoundInstance.Attenuation.NONE)) {
                double soundX = sound.getX();
                double soundY = sound.getY();
                double soundZ = sound.getZ();
                Vec3 soundPos = new Vec3(soundX, soundY, soundZ);
                String soundId = sound.getLocation().toString();
                RedSoundInstance redSoundData = new RedSoundInstance(sound);
                SoundData soundData = new SoundData(redSoundData, soundPos, soundId);
                RaycastingHelper.soundQueue.offer(soundData);
                while (RaycastingHelper.soundQueue.size() > 100) {
                    RaycastingHelper.soundQueue.poll();
                }
                cir.cancel();
            } else if (Config.getInstance().permeation && sound instanceof RedPermeatedSoundInstance) {
                RaycastingHelper.FXQueue.add((RedPermeatedSoundInstance)sound);
            }
        }
        catch (Exception e) {
            System.err.println("Error tracking sound: " + e.getMessage());
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundEngine;tickInGameSound()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onSoundTick(boolean paused, CallbackInfo ci) {
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        if (paused) {
            return;
        }
        while (!RaycastingHelper.FXQueue.isEmpty()) {
            try {
                RedPermeatedSoundInstance sound = RaycastingHelper.FXQueue.poll();
                ChannelAccess.ChannelHandle manager = this.instanceToChannel.get(sound);
                SourceManagerAccessor accessor = (SourceManagerAccessor)manager;
                Channel source = accessor.getChannel();
                int id = ((SourceAccessor)source).getSource();
                sound.setSource(id);
                sound.applyMuffleToSource(id, sound.getPermeationIndex());
            }
            catch (Exception e) {
                if (Config.getInstance().debug == DebugType.OFF) continue;
                System.out.println("sourceID is invalid for a sound, non-issue" + String.valueOf(e));
            }
        }
        if (Config.getInstance().reverb) {
            SoundSystemMixin.updateActiveSources();
        }
    }

    @ModifyVariable(method={"stop(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private SoundInstance modifySoundParameter(SoundInstance sound) {
        ChannelAccess.ChannelHandle sourceManagerNormal;
        if (!efxInitialized) {
            return sound;
        }
        if (sound == null) {
            return sound;
        }
        RaycastingHelper.soundQueue.remove(sound);
        SoundInstance customSound = RaycastingHelper.soundInstanceMap.get(sound);
        RedPermeatedSoundInstance soundPermeation = RaycastingHelper.soundPermInstanceMap.get(sound);
        if (soundPermeation != null) {
            soundPermeation.setStopped(true);
        }
        RaycastingHelper.soundInstanceMap.remove(sound);
        RaycastingHelper.soundPermInstanceMap.remove(sound);
        ChannelAccess.ChannelHandle sourceManager = this.instanceToChannel.get(soundPermeation);
        if (sourceManager != null) {
            sourceManager.execute(Channel::stop);
        }
        if ((sourceManagerNormal = this.instanceToChannel.get(customSound)) != null) {
            sourceManagerNormal.execute(Channel::stop);
        }
        return sound;
    }

    @Inject(method={"stopAll()V"}, at={@At(value="HEAD")})
    private void onStopAll(CallbackInfo ci) {
        RaycastingHelper.soundQueue.clear();
    }

    private static void cleanupEFXResources() {
        if (!efxInitialized) {
            return;
        }
        try {
            System.out.println("Cleaning up EFX resources...");
            RaycastingHelper.FXQueue.clear();
            tickMap.clear();
            if (auxFXSlot != 0) {
                EXTEfx.alDeleteAuxiliaryEffectSlots((int)auxFXSlot);
                auxFXSlot = 0;
            }
            if (reverbEffect != 0) {
                EXTEfx.alDeleteEffects((int)reverbEffect);
                reverbEffect = 0;
            }
            if (muffleFilter != 0) {
                EXTEfx.alDeleteFilters((int)muffleFilter);
                muffleFilter = 0;
            }
            if (sendFilter != 0) {
                EXTEfx.alDeleteFilters((int)sendFilter);
                sendFilter = 0;
            }
            efxInitialized = false;
            System.out.println("EFX resources cleaned up successfully");
        }
        catch (Exception e) {
            System.err.println("Error cleaning up EFX resources: " + e.getMessage());
            auxFXSlot = 0;
            reverbEffect = 0;
            muffleFilter = 0;
            sendFilter = 0;
            efxInitialized = false;
        }
    }

    private static void initializeReverb() {
        if (efxInitialized) {
            return;
        }
        try {
            long currentContext = ALC10.alcGetCurrentContext();
            long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
            if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
                System.out.println("EFX Extension not available - reverb disabled");
                return;
            }
            auxFXSlot = EXTEfx.alGenAuxiliaryEffectSlots();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)3, (int)1);
            reverbEffect = EXTEfx.alGenEffects();
            EXTEfx.alEffecti((int)reverbEffect, (int)32769, (int)32768);
            muffleFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)muffleFilter, (int)32769, (int)1);
            RedPermeatedSoundInstance.muffleFilter = muffleFilter;
            sendFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)sendFilter, (int)32769, (int)1);
            SoundSystemMixin.setBasicReverbParams();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbEffect);
            efxInitialized = true;
            System.out.println("Reverb system initialized successfully");
        }
        catch (Exception e) {
            System.err.println("Failed to initialize reverb: " + e.getMessage());
        }
    }

    private static void setBasicReverbParams() {
        EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)0.5f);
        EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)0.3f);
        EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)15.0f);
        EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)0.7f);
        EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)0.2f);
        EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)0.4f);
        EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)0.03f);
        EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)0.99f);
        EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)0.0f);
    }

    private static void updateActiveSources() {
        long context = ALC10.alcGetCurrentContext();
        if (context == 0L) {
            return;
        }
        AL10.alGetError();
        try {
            for (int sourceId = 1; sourceId <= 256; ++sourceId) {
                int state;
                if (!AL10.alIsSource((int)sourceId) || (state = AL10.alGetSourcei((int)sourceId, (int)4112)) != 4114 && state != 4115) continue;
                if (Config.getInstance().legacyReverb == LegacyReverb.VERSION140) {
                    SoundSystemMixin.applyLegacyReverbToSource(sourceId);
                    continue;
                }
                if (Config.getInstance().legacyReverb == LegacyReverb.VERSION100) {
                    SoundSystemMixin.applyInitalLegacyReverbToSource(sourceId);
                    continue;
                }
                SoundSystemMixin.applyReverbToSource(sourceId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyReverbToSource(int sourceId) {
        try {
            EnhancedReverbData reverbData = RaycastingHelper.getEnhancedReverbData();
            if (Config.getInstance().reverbTuning == DebugType.CHAT) {
                client = Minecraft.getInstance();
                client.player.displayClientMessage((Component)Component.literal((String)reverbData.toString()), false);
            } else if (Config.getInstance().reverbTuning == DebugType.ACTION_BAR) {
                client = Minecraft.getInstance();
                client.player.displayClientMessage((Component)Component.literal((String)reverbData.toString()), true);
            }
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float reverbStrength = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float weightedReverbStrength = (float)RaycastingHelper.getWeightedReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float earlyReflectionRatio = (float)RaycastingHelper.getEarlyReflectionRatio();
            float rt60 = (float)reverbData.rt60;
            float roomSize = (float)reverbData.roomSize;
            float absorption = (float)reverbData.absorption;
            float earlyReflectionDelay = (float)reverbData.earlyReflectionDelay;
            float lateReflectionStrength = (float)reverbData.lateReflectionStrength;
            boolean isIndoors = reverbData.isIndoors;
            wallDistance = SoundSystemMixin.clamp(wallDistance, ReverbConstants.MIN_WALL_DISTANCE, ReverbConstants.MAX_WALL_DISTANCE);
            reverbStrength = SoundSystemMixin.clamp(reverbStrength, 0.0f, 1.0f);
            weightedReverbStrength = SoundSystemMixin.clamp(weightedReverbStrength, 0.0f, 1.0f);
            outdoorLeakPercent = SoundSystemMixin.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            earlyReflectionRatio = SoundSystemMixin.clamp(earlyReflectionRatio, 0.0f, 1.0f);
            roomSize = SoundSystemMixin.clamp(roomSize, ReverbConstants.MIN_ROOM_SIZE, ReverbConstants.MAX_ROOM_SIZE);
            absorption = SoundSystemMixin.clamp(absorption, ReverbConstants.MIN_ABSORPTION, ReverbConstants.MAX_ABSORPTION);
            earlyReflectionDelay = SoundSystemMixin.clamp(earlyReflectionDelay, ReverbConstants.MIN_EARLY_REFLECTION_DELAY, ReverbConstants.MAX_EARLY_REFLECTION_DELAY);
            lateReflectionStrength = SoundSystemMixin.clamp(lateReflectionStrength, 0.0f, 1.0f);
            float enclosureFactor = isIndoors ? (1.0f - outdoorLeakPercent) * Config.getInstance().indoorBias : Math.max(0.0f, reverbStrength - outdoorLeakPercent) * Config.getInstance().outdoorBias;
            enclosureFactor = SoundSystemMixin.clamp(enclosureFactor, 0.0f, 1.0f);
            float opennessFactor = 1.0f - enclosureFactor;
            float estimatedVolume = roomSize * roomSize * roomSize * Config.getInstance().roomVolumeMultiplier;
            float estimatedSurfaceArea = Config.getInstance().surfaceAreaMultiplier * roomSize * roomSize;
            float surfaceToVolumeRatio = estimatedSurfaceArea / Math.max(estimatedVolume, 1.0f);
            surfaceToVolumeRatio = SoundSystemMixin.clamp(surfaceToVolumeRatio, ReverbConstants.MIN_SURFACE_TO_VOLUME_RATIO, ReverbConstants.MAX_SURFACE_TO_VOLUME_RATIO);
            float dynamicAbsorption = absorption;
            float totalAbsorption = estimatedSurfaceArea * dynamicAbsorption;
            float calculatedRT60 = rt60;
            if (calculatedRT60 < ReverbConstants.MIN_RT60 || calculatedRT60 > ReverbConstants.MAX_RT60) {
                calculatedRT60 = Config.getInstance().rt60SabineConstant * estimatedVolume / Math.max(totalAbsorption, Config.getInstance().minTotalAbsorption);
                calculatedRT60 = SoundSystemMixin.clamp(calculatedRT60, ReverbConstants.MIN_CALCULATED_RT60, ReverbConstants.MAX_CALCULATED_RT60);
            }
            float effectiveDecayTime = calculatedRT60 * enclosureFactor;
            effectiveDecayTime = SoundSystemMixin.clamp(effectiveDecayTime, ReverbConstants.MIN_EFFECTIVE_DECAY_TIME, ReverbConstants.MAX_EFFECTIVE_DECAY_TIME);
            float distanceAttenuation = 1.0f / (1.0f + wallDistance * Config.getInstance().distanceAttenuationLinear + wallDistance * wallDistance * Config.getInstance().distanceAttenuationQuadratic);
            float airAbsorptionFactor = 1.0f - wallDistance * Config.getInstance().airAbsorptionRate;
            airAbsorptionFactor = SoundSystemMixin.clamp(airAbsorptionFactor, Config.getInstance().minAirAbsorption, 1.0f);
            float decayHfRatio = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            decayHfRatio = SoundSystemMixin.clamp(decayHfRatio, ReverbConstants.MIN_DECAY_HF_RATIO, ReverbConstants.MAX_DECAY_HF_RATIO);
            float reflectionsDelay = earlyReflectionDelay;
            float reflectionsGain = earlyReflectionRatio * reverbStrength * enclosureFactor * distanceAttenuation * Config.getInstance().globalReverbIntensity;
            reflectionsGain = SoundSystemMixin.clamp(reflectionsGain, ReverbConstants.MIN_REFLECTIONS_GAIN, ReverbConstants.MAX_REFLECTIONS_GAIN);
            float lateReverbDelay = earlyReflectionDelay * Config.getInstance().lateReverbDelayMultiplier + roomSize / Config.getInstance().soundSpeed;
            lateReverbDelay = SoundSystemMixin.clamp(lateReverbDelay, ReverbConstants.MIN_LATE_REVERB_DELAY, ReverbConstants.MAX_LATE_REVERB_DELAY);
            float lateReverbGain = lateReflectionStrength * enclosureFactor * distanceAttenuation * Config.getInstance().globalReverbIntensity;
            lateReverbGain = SoundSystemMixin.clamp(lateReverbGain, ReverbConstants.MIN_LATE_REVERB_GAIN, ReverbConstants.MAX_LATE_REVERB_GAIN);
            float roomComplexity = Math.min(1.0f, surfaceToVolumeRatio / Config.getInstance().roomComplexityDivisor);
            float roomSizeScaling = 1.0f;
            float smallRoomReduction = 1.0f;
            float volumeBasedReduction = 1.0f;
            if (roomSize < 0.5f) {
                roomSizeScaling = 0.05f;
                smallRoomReduction = 0.1f;
                volumeBasedReduction = 0.1f;
            } else if (roomSize < 2.0f) {
                roomSizeScaling = 0.15f;
                smallRoomReduction = 0.25f;
                volumeBasedReduction = 0.3f;
            } else if (roomSize < 5.0f) {
                roomSizeScaling = 0.4f;
                smallRoomReduction = 0.5f;
                volumeBasedReduction = 0.6f;
            } else if (roomSize < 20.0f) {
                roomSizeScaling = 0.7f;
                smallRoomReduction = 0.8f;
                volumeBasedReduction = 0.8f;
            }
            float actualVolumeReduction = Math.max(0.1f, Math.min(1.0f, estimatedVolume / 500.0f));
            volumeBasedReduction *= actualVolumeReduction;
            float roomSizeEmphasis = roomSize < 10.0f ? Config.getInstance().smallRoomEmphasis * smallRoomReduction : Config.getInstance().largeRoomEmphasis;
            float diffusion = org.joml.Math.lerp((float)Config.getInstance().minDiffusion, (float)Config.getInstance().maxDiffusion, (float)(roomComplexity * Config.getInstance().diffusionComplexityWeight * enclosureFactor * Config.getInstance().diffusionEnclosureWeight * weightedReverbStrength * Config.getInstance().diffusionReverbWeight * roomSizeEmphasis));
            diffusion = SoundSystemMixin.clamp(diffusion, 0.1f, 1.0f);
            float density = org.joml.Math.lerp((float)Config.getInstance().minDensity, (float)1.0f, (float)(enclosureFactor * (1.0f - roomSize / Config.getInstance().densityRoomSizeFactor) * roomSizeEmphasis));
            density = SoundSystemMixin.clamp(density, 0.1f, 1.0f);
            float overallGain = enclosureFactor * distanceAttenuation * roomSizeScaling * volumeBasedReduction * (Config.getInstance().baseReverbGain + reverbStrength * Config.getInstance().reverbGainMultiplier) * Config.getInstance().globalReverbIntensity;
            overallGain = SoundSystemMixin.clamp(overallGain, 0.0f, Config.getInstance().maxOverallGain);
            float gainHF = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            gainHF = SoundSystemMixin.clamp(gainHF, 0.1f, 1.0f);
            float airAbsorptionHF = airAbsorptionFactor * enclosureFactor + opennessFactor * Config.getInstance().outdoorHfLeak;
            airAbsorptionHF = SoundSystemMixin.clamp(airAbsorptionHF, ReverbConstants.MIN_AIR_ABSORPTION_HF, ReverbConstants.MAX_AIR_ABSORPTION_HF);
            float roomRolloff = org.joml.Math.lerp((float)1.0f, (float)0.0f, (float)enclosureFactor) * (roomSize / Config.getInstance().roomRolloffSizeFactor);
            roomRolloff = SoundSystemMixin.clamp(roomRolloff, ReverbConstants.MIN_ROOM_ROLLOFF, ReverbConstants.MAX_ROOM_ROLLOFF);
            float sendFilterGain = overallGain;
            float sendFilterGainHF = gainHF * Config.getInstance().sendFilterHfReduction;
            float echoDensity = org.joml.Math.lerp((float)1.0f, (float)0.4f, (float)(roomSize / Config.getInstance().densityRoomSizeFactor)) * enclosureFactor;
            echoDensity = SoundSystemMixin.clamp(echoDensity, 0.1f, 1.0f);
            float modulationTime = SoundSystemMixin.clamp(roomSize * Config.getInstance().modulationTimeMultiplier, ReverbConstants.MIN_MODULATION_TIME, ReverbConstants.MAX_MODULATION_TIME);
            float modulationDepth = SoundSystemMixin.clamp(enclosureFactor * Config.getInstance().modulationDepthMultiplier, ReverbConstants.MIN_MODULATION_DEPTH, ReverbConstants.MAX_MODULATION_DEPTH);
            float hfReference = SoundSystemMixin.clamp(Config.getInstance().baseHfReference - roomSize * Config.getInstance().hfRoomSizeFactor, ReverbConstants.MIN_HF_REFERENCE, ReverbConstants.MAX_HF_REFERENCE);
            float lfReference = SoundSystemMixin.clamp(Config.getInstance().baseLfReference - roomSize * Config.getInstance().lfRoomSizeFactor, ReverbConstants.MIN_LF_REFERENCE, ReverbConstants.MAX_LF_REFERENCE);
            float gainLF = SoundSystemMixin.clamp(1.0f - dynamicAbsorption * Config.getInstance().dynamicAbsorptionLfFactor, ReverbConstants.MIN_GAIN_LF, ReverbConstants.MAX_GAIN_LF);
            float decayLfRatio = SoundSystemMixin.clamp(decayHfRatio * Config.getInstance().decayLfMultiplier, ReverbConstants.MIN_DECAY_HF_RATIO, ReverbConstants.MAX_DECAY_HF_RATIO);
            float echoTime = SoundSystemMixin.clamp(roomSize * Config.getInstance().echoTimeMultiplier, ReverbConstants.MIN_ECHO_TIME, ReverbConstants.MAX_ECHO_TIME);
            float echoDepth = SoundSystemMixin.clamp(echoDensity * Config.getInstance().echoDepthMultiplier, ReverbConstants.MIN_ECHO_DEPTH, ReverbConstants.MAX_ECHO_DEPTH);
            reflectionsGain *= roomSizeScaling;
            reflectionsGain = SoundSystemMixin.clamp(reflectionsGain, ReverbConstants.MIN_REFLECTIONS_GAIN, ReverbConstants.MAX_REFLECTIONS_GAIN);
            lateReverbGain *= roomSizeScaling;
            lateReverbGain = SoundSystemMixin.clamp(lateReverbGain, ReverbConstants.MIN_LATE_REVERB_GAIN, ReverbConstants.MAX_LATE_REVERB_GAIN);
            effectiveDecayTime *= roomSizeScaling;
            effectiveDecayTime = SoundSystemMixin.clamp(effectiveDecayTime, ReverbConstants.MIN_EFFECTIVE_DECAY_TIME, ReverbConstants.MAX_EFFECTIVE_DECAY_TIME);
            EXTEfx.alFilterf((int)sendFilter, (int)1, (float)sendFilterGain);
            EXTEfx.alFilterf((int)sendFilter, (int)2, (float)sendFilterGainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)overallGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)5, (float)gainLF);
            EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)effectiveDecayTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)8, (float)decayLfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)lateReverbGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)reverbEffect, (int)15, (float)echoTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)16, (float)echoDepth);
            EXTEfx.alEffectf((int)reverbEffect, (int)17, (float)modulationTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)18, (float)modulationDepth);
            EXTEfx.alEffectf((int)reverbEffect, (int)20, (float)hfReference);
            EXTEfx.alEffectf((int)reverbEffect, (int)21, (float)lfReference);
            AL11.alSource3i((int)sourceId, (int)131078, (int)auxFXSlot, (int)0, (int)sendFilter);
        }
        catch (Exception e) {
            System.err.println("Error applying dynamic reverb: " + e.getMessage());
        }
    }

    private static void applyLegacyReverbToSource(int sourceId) {
        try {
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float occlusionPercent = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            occlusionPercent = 1.0f - occlusionPercent;
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float distanceMeters = SoundSystemMixin.clamp(wallDistance, 1.0f, 100.0f);
            occlusionPercent = 1.0f - SoundSystemMixin.clamp(occlusionPercent + (outdoorLeakPercent *= 2.0f), 0.0f, 1.0f);
            outdoorLeakPercent = SoundSystemMixin.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            float dryFactor = 1.0f - outdoorLeakPercent;
            float speedOfSound = 343.0f;
            float wallDelay = distanceMeters * 2.0f / speedOfSound;
            float decayTime = SoundSystemMixin.clamp(wallDelay * 5.0f * dryFactor, 0.1f, 6.0f);
            float reflectionsDelay = SoundSystemMixin.clamp(wallDelay * 0.5f, 0.005f, 0.05f);
            float lateReverbDelay = SoundSystemMixin.clamp(wallDelay, 0.01f, 0.1f);
            float decayHfRatio = org.joml.Math.lerp((float)0.5f, (float)1.3f, (float)((1.0f - occlusionPercent) * dryFactor));
            float diffusion = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)(dryFactor * (1.0f - occlusionPercent)));
            float gainHF = org.joml.Math.lerp((float)0.05f, (float)0.9f, (float)((1.0f - occlusionPercent) * dryFactor));
            float reflectionsGain = org.joml.Math.lerp((float)0.0f, (float)0.7f, (float)dryFactor);
            float lateReverbGain = org.joml.Math.lerp((float)0.0f, (float)1.0f, (float)dryFactor);
            float density = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)dryFactor);
            float gain = org.joml.Math.lerp((float)0.05f, (float)0.3f, (float)dryFactor);
            float airAbsorptionHF = org.joml.Math.lerp((float)0.95f, (float)0.99f, (float)dryFactor);
            float roomRolloff = 0.4f;
            EXTEfx.alFilterf((int)sendFilter, (int)1, (float)gain);
            EXTEfx.alFilterf((int)sendFilter, (int)2, (float)1.0f);
            EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)gain);
            EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)decayTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)lateReverbGain);
            AL11.alSource3i((int)sourceId, (int)131078, (int)auxFXSlot, (int)0, (int)sendFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyInitalLegacyReverbToSource(int sourceId) {
        try {
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float occlusionPercent = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float distanceMeters = SoundSystemMixin.clamp(wallDistance, 1.0f, 100.0f);
            occlusionPercent = 1.0f - SoundSystemMixin.clamp(occlusionPercent + outdoorLeakPercent, 0.0f, 1.0f);
            outdoorLeakPercent = SoundSystemMixin.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            float dryFactor = 1.0f - outdoorLeakPercent;
            float speedOfSound = 343.0f;
            float wallDelay = distanceMeters * 2.0f / speedOfSound;
            float decayTime = SoundSystemMixin.clamp(wallDelay * 5.0f * dryFactor, 0.1f, 6.0f);
            float reflectionsDelay = SoundSystemMixin.clamp(wallDelay * 0.5f, 0.005f, 0.05f);
            float lateReverbDelay = SoundSystemMixin.clamp(wallDelay, 0.01f, 0.1f);
            float decayHfRatio = org.joml.Math.lerp((float)0.5f, (float)1.3f, (float)((1.0f - occlusionPercent) * dryFactor));
            float diffusion = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)(dryFactor * (1.0f - occlusionPercent)));
            float gainHF = org.joml.Math.lerp((float)0.05f, (float)0.9f, (float)((1.0f - occlusionPercent) * dryFactor));
            float reflectionsGain = org.joml.Math.lerp((float)0.0f, (float)0.7f, (float)dryFactor);
            float lateReverbGain = org.joml.Math.lerp((float)0.0f, (float)1.0f, (float)dryFactor);
            float density = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)dryFactor);
            float gain = org.joml.Math.lerp((float)0.05f, (float)0.3f, (float)dryFactor);
            float airAbsorptionHF = org.joml.Math.lerp((float)0.95f, (float)0.99f, (float)dryFactor);
            float roomRolloff = 0.4f;
            AL11.alSourcef((int)sourceId, (int)131083, (float)0.0f);
            AL11.alSourcef((int)sourceId, (int)131084, (float)0.0f);
            EXTEfx.alFilterf((int)sendFilter, (int)1, (float)gain);
            EXTEfx.alFilterf((int)sendFilter, (int)2, (float)1.0f);
            EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)gain);
            EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)decayTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)lateReverbGain);
            if ((double)outdoorLeakPercent < 0.95) {
                AL11.alSource3i((int)sourceId, (int)131078, (int)auxFXSlot, (int)0, (int)sendFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void debugSourceCount() {
        int sourcesInUse = 0;
        for (int i = 1; i < 1000; ++i) {
            if (!AL10.alIsSource((int)i)) continue;
            ++sourcesInUse;
        }
        System.out.println("Sources currently in use: " + sourcesInUse);
    }

    @Inject(method={"destroy()V"}, at={@At(value="HEAD")})
    private void onAudioEngineStop(CallbackInfo ci) {
        SoundSystemMixin.cleanupEFXResources();
    }

    @Inject(method={"loadLibrary()V"}, at={@At(value="TAIL")})
    private void onAudioEngineStart(CallbackInfo ci) {
        efxInitialized = false;
        SoundSystemMixin.initializeReverb();
    }

    private static float clamp(float a, float b, float c) {
        return Math.min(Math.max(a, b), c);
    }

    private boolean isSoundBlacklisted(String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return false;
        }
        List<String> blacklist = Config.getInstance().soundBlacklist;
        if (blacklist == null || blacklist.isEmpty()) {
            return false;
        }
        return blacklist.stream().filter(entry -> entry != null && !entry.trim().isEmpty()).anyMatch(entry -> soundName.toLowerCase().contains(entry.toLowerCase().trim()));
    }
}

