/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.mixin.client;

import com.mojang.blaze3d.audio.Channel;
import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.RedSoundInstance;
import com.redsmods.sound_physics_perfected.ReverbHelpers.EnhancedReverbData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.ReverbConstants;
import com.redsmods.sound_physics_perfected.mixin.client.SourceAccessor;
import com.redsmods.sound_physics_perfected.mixin.client.SourceManagerAccessor;
import com.redsmods.sound_physics_perfected.storageclasses.SoundData;
import com.redsmods.sound_physics_perfected.wrappers.RedPermeatedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedPositionedSoundInstance;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public abstract class SoundSystemMixin {
    private static final int MAX_SOUNDS = 100;
    private static int auxFXSlot = 0;
    private static int reverbEffect = 0;
    private static int muffleFilter = 0;
    private static int sendFilter = 0;
    private static boolean efxInitialized = false;
    private static final Map<Integer, RedTickableInstance> tickMap = new HashMap<Integer, RedTickableInstance>();
    @Shadow
    private SoundManager soundManager;
    @Shadow
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;

    @Shadow
    public abstract void destroy();

    @Shadow
    public abstract void tick(boolean var1);

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSoundPlay(SoundInstance sound, CallbackInfo ci) {
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.player == null || client.level == null || sound == null || this.soundManager == null) {
            return;
        }
        try {
            WeighedSoundEvents weightedSoundSet = sound.resolve(this.soundManager);
            if (!(sound instanceof RedPositionedSoundInstance || sound instanceof TickableSoundInstance || sound instanceof RedPermeatedSoundInstance || sound.getAttenuation() == SoundInstance.Attenuation.NONE)) {
                double soundX = sound.getX();
                double soundY = sound.getY();
                double soundZ = sound.getZ();
                Vec3 soundPos = new Vec3(soundX, soundY, soundZ);
                String soundId = sound.getLocation().toString();
                RedSoundInstance redSoundData = new RedSoundInstance(sound);
                SoundData soundData = new SoundData(redSoundData, soundPos, soundId);
                RaycastingHelper.soundQueue.offer(soundData);
                while (RaycastingHelper.soundQueue.size() > 100) {
                    RaycastingHelper.soundQueue.poll();
                }
                ci.cancel();
            } else if (RaycastingHelper.ENABLE_PERMEATION && sound instanceof RedPermeatedSoundInstance) {
                RaycastingHelper.FXQueue.add((RedPermeatedSoundInstance)sound);
            }
        }
        catch (Exception e) {
            System.err.println("Error tracking sound: " + e.getMessage());
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundEngine;tickNonPaused()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onSoundTick(boolean paused, CallbackInfo ci) {
        if (!efxInitialized) {
            SoundSystemMixin.initializeReverb();
        }
        if (!efxInitialized) {
            return;
        }
        if (paused) {
            return;
        }
        while (!RaycastingHelper.FXQueue.isEmpty()) {
            try {
                RedPermeatedSoundInstance sound = RaycastingHelper.FXQueue.poll();
                ChannelAccess.ChannelHandle manager = this.instanceToChannel.get(sound);
                SourceManagerAccessor accessor = (SourceManagerAccessor)manager;
                Channel source = accessor.getSource();
                int id = ((SourceAccessor)source).getPointer();
                sound.setSource(id);
                sound.applyMuffleToSource(id, sound.getPermeationIndex());
            }
            catch (Exception e) {
                System.out.println("sourceID is invalid for a sound, non-issue" + String.valueOf(e));
            }
        }
        if (RaycastingHelper.ENABLE_REVERB) {
            SoundSystemMixin.updateActiveSources();
        }
    }

    @ModifyVariable(method={"stop(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private SoundInstance modifySoundParameter(SoundInstance sound) {
        ChannelAccess.ChannelHandle sourceManagerNormal;
        if (!efxInitialized) {
            return sound;
        }
        if (sound == null) {
            return sound;
        }
        RaycastingHelper.soundQueue.remove(sound);
        SoundInstance customSound = RaycastingHelper.soundInstanceMap.get(sound);
        RedPermeatedSoundInstance soundPermeation = RaycastingHelper.soundPermInstanceMap.get(sound);
        if (soundPermeation != null) {
            soundPermeation.setDone(true);
        }
        RaycastingHelper.soundInstanceMap.remove(sound);
        RaycastingHelper.soundPermInstanceMap.remove(sound);
        ChannelAccess.ChannelHandle sourceManager = this.instanceToChannel.get(soundPermeation);
        if (sourceManager != null) {
            sourceManager.execute(Channel::stop);
        }
        if ((sourceManagerNormal = this.instanceToChannel.get(customSound)) != null) {
            sourceManagerNormal.execute(Channel::stop);
        }
        return sound;
    }

    @Inject(method={"stopAll()V"}, at={@At(value="HEAD")})
    private void onStopAll(CallbackInfo ci) {
        RaycastingHelper.soundQueue.clear();
    }

    private static void cleanupEFXResources() {
        if (!efxInitialized) {
            return;
        }
        try {
            System.out.println("Cleaning up EFX resources...");
            RaycastingHelper.FXQueue.clear();
            tickMap.clear();
            if (auxFXSlot != 0) {
                EXTEfx.alDeleteAuxiliaryEffectSlots((int)auxFXSlot);
                auxFXSlot = 0;
            }
            if (reverbEffect != 0) {
                EXTEfx.alDeleteEffects((int)reverbEffect);
                reverbEffect = 0;
            }
            if (muffleFilter != 0) {
                EXTEfx.alDeleteFilters((int)muffleFilter);
                muffleFilter = 0;
            }
            if (sendFilter != 0) {
                EXTEfx.alDeleteFilters((int)sendFilter);
                sendFilter = 0;
            }
            efxInitialized = false;
            System.out.println("EFX resources cleaned up successfully");
        }
        catch (Exception e) {
            System.err.println("Error cleaning up EFX resources: " + e.getMessage());
            auxFXSlot = 0;
            reverbEffect = 0;
            muffleFilter = 0;
            sendFilter = 0;
            efxInitialized = false;
        }
    }

    private static void initializeReverb() {
        if (efxInitialized) {
            return;
        }
        try {
            long currentContext = ALC10.alcGetCurrentContext();
            long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
            if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
                System.out.println("EFX Extension not available - reverb disabled");
                return;
            }
            auxFXSlot = EXTEfx.alGenAuxiliaryEffectSlots();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)3, (int)1);
            reverbEffect = EXTEfx.alGenEffects();
            EXTEfx.alEffecti((int)reverbEffect, (int)32769, (int)32768);
            muffleFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)muffleFilter, (int)32769, (int)1);
            RedPermeatedSoundInstance.muffleFilter = muffleFilter;
            sendFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)sendFilter, (int)32769, (int)1);
            SoundSystemMixin.setBasicReverbParams();
            EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbEffect);
            efxInitialized = true;
            System.out.println("Reverb system initialized successfully");
        }
        catch (Exception e) {
            System.err.println("Failed to initialize reverb: " + e.getMessage());
        }
    }

    private static void setBasicReverbParams() {
        EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)0.5f);
        EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)0.3f);
        EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)0.8f);
        EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)15.0f);
        EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)0.7f);
        EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)0.2f);
        EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)0.4f);
        EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)0.03f);
        EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)0.99f);
        EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)0.0f);
    }

    private static void updateActiveSources() {
        long context = ALC10.alcGetCurrentContext();
        if (context == 0L) {
            return;
        }
        AL10.alGetError();
        try {
            for (int sourceId = 1; sourceId <= 256; ++sourceId) {
                int state;
                if (!AL10.alIsSource((int)sourceId) || (state = AL10.alGetSourcei((int)sourceId, (int)4112)) != 4114 && state != 4115) continue;
                SoundSystemMixin.applyReverbToSource(sourceId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyReverbToSource(int sourceId) {
        try {
            EnhancedReverbData reverbData = RaycastingHelper.getEnhancedReverbData();
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float reverbStrength = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float weightedReverbStrength = (float)RaycastingHelper.getWeightedReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float earlyReflectionRatio = (float)RaycastingHelper.getEarlyReflectionRatio();
            float rt60 = (float)reverbData.rt60;
            float roomSize = (float)reverbData.roomSize;
            float absorption = (float)reverbData.absorption;
            float earlyReflectionDelay = (float)reverbData.earlyReflectionDelay;
            float lateReflectionStrength = (float)reverbData.lateReflectionStrength;
            boolean isIndoors = reverbData.isIndoors;
            wallDistance = SoundSystemMixin.clamp(wallDistance, ReverbConstants.MIN_WALL_DISTANCE, ReverbConstants.MAX_WALL_DISTANCE);
            reverbStrength = SoundSystemMixin.clamp(reverbStrength, 0.0f, 1.0f);
            weightedReverbStrength = SoundSystemMixin.clamp(weightedReverbStrength, 0.0f, 1.0f);
            outdoorLeakPercent = SoundSystemMixin.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            earlyReflectionRatio = SoundSystemMixin.clamp(earlyReflectionRatio, 0.0f, 1.0f);
            rt60 = SoundSystemMixin.clamp(rt60, ReverbConstants.MIN_RT60, ReverbConstants.MAX_RT60);
            roomSize = SoundSystemMixin.clamp(roomSize, ReverbConstants.MIN_ROOM_SIZE, ReverbConstants.MAX_ROOM_SIZE);
            absorption = SoundSystemMixin.clamp(absorption, ReverbConstants.MIN_ABSORPTION, ReverbConstants.MAX_ABSORPTION);
            earlyReflectionDelay = SoundSystemMixin.clamp(earlyReflectionDelay, ReverbConstants.MIN_EARLY_REFLECTION_DELAY, ReverbConstants.MAX_EARLY_REFLECTION_DELAY);
            lateReflectionStrength = SoundSystemMixin.clamp(lateReflectionStrength, 0.0f, 1.0f);
            float enclosureFactor = isIndoors ? (1.0f - outdoorLeakPercent) * ReverbConstants.INDOOR_BIAS : java.lang.Math.max(0.0f, reverbStrength - outdoorLeakPercent) * ReverbConstants.OUTDOOR_BIAS;
            enclosureFactor = SoundSystemMixin.clamp(enclosureFactor, 0.0f, 1.0f);
            float opennessFactor = 1.0f - enclosureFactor;
            float estimatedVolume = roomSize * roomSize * roomSize * ReverbConstants.ROOM_VOLUME_MULTIPLIER;
            float estimatedSurfaceArea = ReverbConstants.SURFACE_AREA_MULTIPLIER * roomSize * roomSize;
            float surfaceToVolumeRatio = estimatedSurfaceArea / java.lang.Math.max(estimatedVolume, 1.0f);
            surfaceToVolumeRatio = SoundSystemMixin.clamp(surfaceToVolumeRatio, ReverbConstants.MIN_SURFACE_TO_VOLUME_RATIO, ReverbConstants.MAX_SURFACE_TO_VOLUME_RATIO);
            float dynamicAbsorption = absorption;
            float totalAbsorption = estimatedSurfaceArea * dynamicAbsorption;
            float calculatedRT60 = rt60;
            if (calculatedRT60 < ReverbConstants.MIN_RT60 || calculatedRT60 > ReverbConstants.MAX_RT60) {
                calculatedRT60 = ReverbConstants.RT60_SABINE_CONSTANT * estimatedVolume / java.lang.Math.max(totalAbsorption, ReverbConstants.MIN_TOTAL_ABSORPTION);
                calculatedRT60 = SoundSystemMixin.clamp(calculatedRT60, ReverbConstants.MIN_CALCULATED_RT60, ReverbConstants.MAX_CALCULATED_RT60);
            }
            float effectiveDecayTime = calculatedRT60 * enclosureFactor;
            effectiveDecayTime = SoundSystemMixin.clamp(effectiveDecayTime, ReverbConstants.MIN_EFFECTIVE_DECAY_TIME, ReverbConstants.MAX_EFFECTIVE_DECAY_TIME);
            float distanceAttenuation = 1.0f / (1.0f + wallDistance * ReverbConstants.DISTANCE_ATTENUATION_LINEAR + wallDistance * wallDistance * ReverbConstants.DISTANCE_ATTENUATION_QUADRATIC);
            float airAbsorptionFactor = 1.0f - wallDistance * ReverbConstants.AIR_ABSORPTION_RATE;
            airAbsorptionFactor = SoundSystemMixin.clamp(airAbsorptionFactor, ReverbConstants.MIN_AIR_ABSORPTION, 1.0f);
            float decayHfRatio = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            decayHfRatio = SoundSystemMixin.clamp(decayHfRatio, ReverbConstants.MIN_DECAY_HF_RATIO, ReverbConstants.MAX_DECAY_HF_RATIO);
            float reflectionsDelay = earlyReflectionDelay;
            float reflectionsGain = earlyReflectionRatio * reverbStrength * enclosureFactor * distanceAttenuation * ReverbConstants.GLOBAL_REVERB_INTENSITY;
            reflectionsGain = SoundSystemMixin.clamp(reflectionsGain, ReverbConstants.MIN_REFLECTIONS_GAIN, ReverbConstants.MAX_REFLECTIONS_GAIN);
            float lateReverbDelay = earlyReflectionDelay * ReverbConstants.LATE_REVERB_DELAY_MULTIPLIER + roomSize / ReverbConstants.SOUND_SPEED;
            lateReverbDelay = SoundSystemMixin.clamp(lateReverbDelay, ReverbConstants.MIN_LATE_REVERB_DELAY, ReverbConstants.MAX_LATE_REVERB_DELAY);
            float lateReverbGain = lateReflectionStrength * enclosureFactor * distanceAttenuation * ReverbConstants.GLOBAL_REVERB_INTENSITY;
            lateReverbGain = SoundSystemMixin.clamp(lateReverbGain, ReverbConstants.MIN_LATE_REVERB_GAIN, ReverbConstants.MAX_LATE_REVERB_GAIN);
            float roomComplexity = java.lang.Math.min(1.0f, surfaceToVolumeRatio / ReverbConstants.ROOM_COMPLEXITY_DIVISOR);
            float roomSizeEmphasis = roomSize < 10.0f ? ReverbConstants.SMALL_ROOM_EMPHASIS : ReverbConstants.LARGE_ROOM_EMPHASIS;
            float diffusion = Math.lerp((float)ReverbConstants.MIN_DIFFUSION, (float)ReverbConstants.MAX_DIFFUSION, (float)(roomComplexity * ReverbConstants.DIFFUSION_COMPLEXITY_WEIGHT * enclosureFactor * ReverbConstants.DIFFUSION_ENCLOSURE_WEIGHT * weightedReverbStrength * ReverbConstants.DIFFUSION_REVERB_WEIGHT * roomSizeEmphasis));
            diffusion = SoundSystemMixin.clamp(diffusion, 0.1f, 1.0f);
            float density = Math.lerp((float)ReverbConstants.MIN_DENSITY, (float)1.0f, (float)(enclosureFactor * (1.0f - roomSize / ReverbConstants.DENSITY_ROOM_SIZE_FACTOR) * roomSizeEmphasis));
            density = SoundSystemMixin.clamp(density, 0.1f, 1.0f);
            float overallGain = enclosureFactor * distanceAttenuation * (ReverbConstants.BASE_REVERB_GAIN + reverbStrength * ReverbConstants.REVERB_GAIN_MULTIPLIER) * ReverbConstants.GLOBAL_REVERB_INTENSITY;
            overallGain = SoundSystemMixin.clamp(overallGain, 0.0f, ReverbConstants.MAX_OVERALL_GAIN);
            float gainHF = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            gainHF = SoundSystemMixin.clamp(gainHF, 0.1f, 1.0f);
            float airAbsorptionHF = airAbsorptionFactor * enclosureFactor + opennessFactor * ReverbConstants.OUTDOOR_HF_LEAK;
            airAbsorptionHF = SoundSystemMixin.clamp(airAbsorptionHF, ReverbConstants.MIN_AIR_ABSORPTION_HF, ReverbConstants.MAX_AIR_ABSORPTION_HF);
            float roomRolloff = Math.lerp((float)1.0f, (float)0.0f, (float)enclosureFactor) * (roomSize / ReverbConstants.ROOM_ROLLOFF_SIZE_FACTOR);
            roomRolloff = SoundSystemMixin.clamp(roomRolloff, ReverbConstants.MIN_ROOM_ROLLOFF, ReverbConstants.MAX_ROOM_ROLLOFF);
            float sendFilterGain = overallGain;
            float sendFilterGainHF = gainHF * ReverbConstants.SEND_FILTER_HF_REDUCTION;
            float echoDensity = Math.lerp((float)1.0f, (float)0.4f, (float)(roomSize / ReverbConstants.DENSITY_ROOM_SIZE_FACTOR)) * enclosureFactor;
            echoDensity = SoundSystemMixin.clamp(echoDensity, 0.1f, 1.0f);
            float modulationTime = SoundSystemMixin.clamp(roomSize * ReverbConstants.MODULATION_TIME_MULTIPLIER, ReverbConstants.MIN_MODULATION_TIME, ReverbConstants.MAX_MODULATION_TIME);
            float modulationDepth = SoundSystemMixin.clamp(enclosureFactor * ReverbConstants.MODULATION_DEPTH_MULTIPLIER, ReverbConstants.MIN_MODULATION_DEPTH, ReverbConstants.MAX_MODULATION_DEPTH);
            float hfReference = SoundSystemMixin.clamp(ReverbConstants.BASE_HF_REFERENCE - roomSize * ReverbConstants.HF_ROOM_SIZE_FACTOR, ReverbConstants.MIN_HF_REFERENCE, ReverbConstants.MAX_HF_REFERENCE);
            float lfReference = SoundSystemMixin.clamp(ReverbConstants.BASE_LF_REFERENCE - roomSize * ReverbConstants.LF_ROOM_SIZE_FACTOR, ReverbConstants.MIN_LF_REFERENCE, ReverbConstants.MAX_LF_REFERENCE);
            float gainLF = SoundSystemMixin.clamp(1.0f - dynamicAbsorption * ReverbConstants.DYNAMIC_ABSORPTION_LF_FACTOR, ReverbConstants.MIN_GAIN_LF, ReverbConstants.MAX_GAIN_LF);
            float decayLfRatio = SoundSystemMixin.clamp(decayHfRatio * ReverbConstants.DECAY_LF_MULTIPLIER, ReverbConstants.MIN_DECAY_HF_RATIO, ReverbConstants.MAX_DECAY_HF_RATIO);
            float echoTime = SoundSystemMixin.clamp(roomSize * ReverbConstants.ECHO_TIME_MULTIPLIER, ReverbConstants.MIN_ECHO_TIME, ReverbConstants.MAX_ECHO_TIME);
            float echoDepth = SoundSystemMixin.clamp(echoDensity * ReverbConstants.ECHO_DEPTH_MULTIPLIER, ReverbConstants.MIN_ECHO_DEPTH, ReverbConstants.MAX_ECHO_DEPTH);
            EXTEfx.alFilterf((int)sendFilter, (int)1, (float)sendFilterGain);
            EXTEfx.alFilterf((int)sendFilter, (int)2, (float)sendFilterGainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)reverbEffect, (int)3, (float)overallGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)5, (float)gainLF);
            EXTEfx.alEffectf((int)reverbEffect, (int)6, (float)effectiveDecayTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)8, (float)decayLfRatio);
            EXTEfx.alEffectf((int)reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)12, (float)lateReverbGain);
            EXTEfx.alEffectf((int)reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)reverbEffect, (int)15, (float)echoTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)16, (float)echoDepth);
            EXTEfx.alEffectf((int)reverbEffect, (int)17, (float)modulationTime);
            EXTEfx.alEffectf((int)reverbEffect, (int)18, (float)modulationDepth);
            EXTEfx.alEffectf((int)reverbEffect, (int)20, (float)hfReference);
            EXTEfx.alEffectf((int)reverbEffect, (int)21, (float)lfReference);
            AL11.alSource3i((int)sourceId, (int)131078, (int)auxFXSlot, (int)0, (int)sendFilter);
        }
        catch (Exception e) {
            System.err.println("Error applying dynamic reverb: " + e.getMessage());
        }
    }

    private static void debugSourceCount() {
        int sourcesInUse = 0;
        for (int i = 1; i < 1000; ++i) {
            if (!AL10.alIsSource((int)i)) continue;
            ++sourcesInUse;
        }
        System.out.println("Sources currently in use: " + sourcesInUse);
    }

    @Inject(method={"destroy()V"}, at={@At(value="HEAD")})
    private void onAudioEngineStop(CallbackInfo ci) {
        SoundSystemMixin.cleanupEFXResources();
    }

    @Inject(method={"loadLibrary()V"}, at={@At(value="TAIL")})
    private void onAudioEngineStart(CallbackInfo ci) {
        efxInitialized = false;
        SoundSystemMixin.initializeReverb();
    }

    private static float clamp(float a, float b, float c) {
        return java.lang.Math.min(java.lang.Math.max(a, b), c);
    }
}

