/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.ReverbHelpers.EnhancedReverbData;
import com.redsmods.sound_physics_perfected.ReverbHelpers.ReverbConstants;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.config.DebugType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;

public class OpenALEffectsHandler {
    private int auxFXSlot = 0;
    private int reverbEffect = 0;
    private int muffleFilter = 0;
    private int sendFilter = 0;
    public boolean efxInitialized = false;

    public void applyReverbToSource(int sourceId) {
        try {
            EnhancedReverbData reverbData = RaycastingHelper.getEnhancedReverbData();
            if (Config.getInstance().reverbTuning == DebugType.CHAT) {
                client = Minecraft.getInstance();
                if (client.player != null) {
                    client.player.displayClientMessage((Component)Component.literal((String)reverbData.toString()), false);
                }
            } else if (Config.getInstance().reverbTuning == DebugType.ACTION_BAR) {
                client = Minecraft.getInstance();
                if (client.player != null) {
                    client.player.displayClientMessage((Component)Component.literal((String)reverbData.toString()), true);
                }
            }
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            if (!EXTEfx.alIsAuxiliaryEffectSlot((int)this.auxFXSlot)) {
                System.err.println("auxFXSlot " + this.auxFXSlot + " is not valid in the current context");
                this.cleanupEFXResources();
                this.initializeReverb();
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float reverbStrength = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float weightedReverbStrength = (float)RaycastingHelper.getWeightedReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float earlyReflectionRatio = (float)RaycastingHelper.getEarlyReflectionRatio();
            float rt60 = (float)reverbData.rt60;
            float roomSize = (float)reverbData.roomSize;
            float absorption = (float)reverbData.absorption;
            float earlyReflectionDelay = (float)reverbData.earlyReflectionDelay;
            float lateReflectionStrength = (float)reverbData.lateReflectionStrength;
            boolean isIndoors = reverbData.isIndoors;
            wallDistance = OpenALEffectsHandler.clamp(wallDistance, ReverbConstants.MIN_WALL_DISTANCE, ReverbConstants.MAX_WALL_DISTANCE);
            reverbStrength = OpenALEffectsHandler.clamp(reverbStrength, 0.0f, 1.0f);
            weightedReverbStrength = OpenALEffectsHandler.clamp(weightedReverbStrength, 0.0f, 1.0f);
            outdoorLeakPercent = OpenALEffectsHandler.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            earlyReflectionRatio = OpenALEffectsHandler.clamp(earlyReflectionRatio, 0.0f, 1.0f);
            roomSize = OpenALEffectsHandler.clamp(roomSize, ReverbConstants.MIN_ROOM_SIZE, ReverbConstants.MAX_ROOM_SIZE);
            absorption = OpenALEffectsHandler.clamp(absorption, ReverbConstants.MIN_ABSORPTION, ReverbConstants.MAX_ABSORPTION);
            earlyReflectionDelay = OpenALEffectsHandler.clamp(earlyReflectionDelay, ReverbConstants.MIN_EARLY_REFLECTION_DELAY, ReverbConstants.MAX_EARLY_REFLECTION_DELAY);
            lateReflectionStrength = OpenALEffectsHandler.clamp(lateReflectionStrength, 0.0f, 1.0f);
            float enclosureFactor = isIndoors ? (1.0f - outdoorLeakPercent) * Config.getInstance().indoorBias : Math.max(0.0f, reverbStrength - outdoorLeakPercent) * Config.getInstance().outdoorBias;
            enclosureFactor = OpenALEffectsHandler.clamp(enclosureFactor, 0.0f, 1.0f);
            float opennessFactor = 1.0f - enclosureFactor;
            float estimatedVolume = roomSize * roomSize * roomSize * Config.getInstance().roomVolumeMultiplier;
            float estimatedSurfaceArea = Config.getInstance().surfaceAreaMultiplier * roomSize * roomSize;
            float surfaceToVolumeRatio = estimatedSurfaceArea / Math.max(estimatedVolume, 1.0f);
            surfaceToVolumeRatio = OpenALEffectsHandler.clamp(surfaceToVolumeRatio, ReverbConstants.MIN_SURFACE_TO_VOLUME_RATIO, ReverbConstants.MAX_SURFACE_TO_VOLUME_RATIO);
            float dynamicAbsorption = absorption;
            float totalAbsorption = estimatedSurfaceArea * dynamicAbsorption;
            float calculatedRT60 = rt60;
            if (calculatedRT60 < ReverbConstants.MIN_RT60 || calculatedRT60 > ReverbConstants.MAX_RT60) {
                calculatedRT60 = Config.getInstance().rt60SabineConstant * estimatedVolume / Math.max(totalAbsorption, Config.getInstance().minTotalAbsorption);
                calculatedRT60 = OpenALEffectsHandler.clamp(calculatedRT60, ReverbConstants.MIN_CALCULATED_RT60, ReverbConstants.MAX_CALCULATED_RT60);
            }
            float effectiveDecayTime = calculatedRT60 * enclosureFactor;
            effectiveDecayTime = OpenALEffectsHandler.clamp(effectiveDecayTime, ReverbConstants.MIN_EFFECTIVE_DECAY_TIME, ReverbConstants.MAX_EFFECTIVE_DECAY_TIME);
            float distanceAttenuation = 1.0f / (1.0f + wallDistance * Config.getInstance().distanceAttenuationLinear + wallDistance * wallDistance * Config.getInstance().distanceAttenuationQuadratic);
            float airAbsorptionFactor = 1.0f - wallDistance * Config.getInstance().airAbsorptionRate;
            airAbsorptionFactor = OpenALEffectsHandler.clamp(airAbsorptionFactor, Config.getInstance().minAirAbsorption, 1.0f);
            float decayHfRatio = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            decayHfRatio = OpenALEffectsHandler.clamp(decayHfRatio, ReverbConstants.MIN_DECAY_HF_RATIO, ReverbConstants.MAX_DECAY_HF_RATIO);
            float reflectionsDelay = earlyReflectionDelay;
            float reflectionsGain = earlyReflectionRatio * reverbStrength * enclosureFactor * distanceAttenuation * Config.getInstance().globalReverbIntensity;
            reflectionsGain = OpenALEffectsHandler.clamp(reflectionsGain, ReverbConstants.MIN_REFLECTIONS_GAIN, ReverbConstants.MAX_REFLECTIONS_GAIN);
            float lateReverbDelay = earlyReflectionDelay * Config.getInstance().lateReverbDelayMultiplier + roomSize / Config.getInstance().soundSpeed;
            lateReverbDelay = OpenALEffectsHandler.clamp(lateReverbDelay, ReverbConstants.MIN_LATE_REVERB_DELAY, ReverbConstants.MAX_LATE_REVERB_DELAY);
            float lateReverbGain = lateReflectionStrength * enclosureFactor * distanceAttenuation * Config.getInstance().globalReverbIntensity;
            lateReverbGain = OpenALEffectsHandler.clamp(lateReverbGain, ReverbConstants.MIN_LATE_REVERB_GAIN, ReverbConstants.MAX_LATE_REVERB_GAIN);
            float roomComplexity = Math.min(1.0f, surfaceToVolumeRatio / Config.getInstance().roomComplexityDivisor);
            float roomSizeScaling = 1.0f;
            float smallRoomReduction = 1.0f;
            float volumeBasedReduction = 1.0f;
            if (roomSize < 0.5f) {
                roomSizeScaling = 0.05f;
                smallRoomReduction = 0.1f;
                volumeBasedReduction = 0.1f;
            } else if (roomSize < 2.0f) {
                roomSizeScaling = 0.15f;
                smallRoomReduction = 0.25f;
                volumeBasedReduction = 0.3f;
            } else if (roomSize < 5.0f) {
                roomSizeScaling = 0.4f;
                smallRoomReduction = 0.5f;
                volumeBasedReduction = 0.6f;
            } else if (roomSize < 20.0f) {
                roomSizeScaling = 0.7f;
                smallRoomReduction = 0.8f;
                volumeBasedReduction = 0.8f;
            }
            float actualVolumeReduction = Math.max(0.1f, Math.min(1.0f, estimatedVolume / 500.0f));
            volumeBasedReduction *= actualVolumeReduction;
            float roomSizeEmphasis = roomSize < 10.0f ? Config.getInstance().smallRoomEmphasis * smallRoomReduction : Config.getInstance().largeRoomEmphasis;
            float diffusion = org.joml.Math.lerp((float)Config.getInstance().minDiffusion, (float)Config.getInstance().maxDiffusion, (float)(roomComplexity * Config.getInstance().diffusionComplexityWeight * enclosureFactor * Config.getInstance().diffusionEnclosureWeight * weightedReverbStrength * Config.getInstance().diffusionReverbWeight * roomSizeEmphasis));
            diffusion = OpenALEffectsHandler.clamp(diffusion, 0.1f, 1.0f);
            float density = org.joml.Math.lerp((float)Config.getInstance().minDensity, (float)1.0f, (float)(enclosureFactor * (1.0f - roomSize / Config.getInstance().densityRoomSizeFactor) * roomSizeEmphasis));
            density = OpenALEffectsHandler.clamp(density, 0.1f, 1.0f);
            float overallGain = enclosureFactor * distanceAttenuation * roomSizeScaling * volumeBasedReduction * (Config.getInstance().baseReverbGain + reverbStrength * Config.getInstance().reverbGainMultiplier) * Config.getInstance().globalReverbIntensity;
            overallGain = OpenALEffectsHandler.clamp(overallGain, 0.0f, Config.getInstance().maxOverallGain);
            float gainHF = (1.0f - dynamicAbsorption) * airAbsorptionFactor * enclosureFactor;
            gainHF = OpenALEffectsHandler.clamp(gainHF, 0.1f, 1.0f);
            float airAbsorptionHF = airAbsorptionFactor * enclosureFactor + opennessFactor * Config.getInstance().outdoorHfLeak;
            airAbsorptionHF = OpenALEffectsHandler.clamp(airAbsorptionHF, ReverbConstants.MIN_AIR_ABSORPTION_HF, ReverbConstants.MAX_AIR_ABSORPTION_HF);
            float roomRolloff = org.joml.Math.lerp((float)1.0f, (float)0.0f, (float)enclosureFactor) * (roomSize / Config.getInstance().roomRolloffSizeFactor);
            roomRolloff = OpenALEffectsHandler.clamp(roomRolloff, ReverbConstants.MIN_ROOM_ROLLOFF, ReverbConstants.MAX_ROOM_ROLLOFF);
            float sendFilterGain = overallGain;
            float sendFilterGainHF = gainHF * Config.getInstance().sendFilterHfReduction;
            float echoDensity = org.joml.Math.lerp((float)1.0f, (float)0.4f, (float)(roomSize / Config.getInstance().densityRoomSizeFactor)) * enclosureFactor;
            echoDensity = OpenALEffectsHandler.clamp(echoDensity, 0.1f, 1.0f);
            float modulationTime = OpenALEffectsHandler.clamp(roomSize * Config.getInstance().modulationTimeMultiplier, ReverbConstants.MIN_MODULATION_TIME, ReverbConstants.MAX_MODULATION_TIME);
            float modulationDepth = OpenALEffectsHandler.clamp(enclosureFactor * Config.getInstance().modulationDepthMultiplier, ReverbConstants.MIN_MODULATION_DEPTH, ReverbConstants.MAX_MODULATION_DEPTH);
            float hfReference = OpenALEffectsHandler.clamp(Config.getInstance().baseHfReference - roomSize * Config.getInstance().hfRoomSizeFactor, ReverbConstants.MIN_HF_REFERENCE, ReverbConstants.MAX_HF_REFERENCE);
            float lfReference = OpenALEffectsHandler.clamp(Config.getInstance().baseLfReference - roomSize * Config.getInstance().lfRoomSizeFactor, ReverbConstants.MIN_LF_REFERENCE, ReverbConstants.MAX_LF_REFERENCE);
            float gainLF = OpenALEffectsHandler.clamp(1.0f - dynamicAbsorption * Config.getInstance().dynamicAbsorptionLfFactor, ReverbConstants.MIN_GAIN_LF, ReverbConstants.MAX_GAIN_LF);
            float decayLfRatio = OpenALEffectsHandler.clamp(decayHfRatio * Config.getInstance().decayLfMultiplier, ReverbConstants.MIN_DECAY_HF_RATIO, ReverbConstants.MAX_DECAY_HF_RATIO);
            float echoTime = OpenALEffectsHandler.clamp(roomSize * Config.getInstance().echoTimeMultiplier, ReverbConstants.MIN_ECHO_TIME, ReverbConstants.MAX_ECHO_TIME);
            float echoDepth = OpenALEffectsHandler.clamp(echoDensity * Config.getInstance().echoDepthMultiplier, ReverbConstants.MIN_ECHO_DEPTH, ReverbConstants.MAX_ECHO_DEPTH);
            reflectionsGain *= roomSizeScaling;
            reflectionsGain = OpenALEffectsHandler.clamp(reflectionsGain, ReverbConstants.MIN_REFLECTIONS_GAIN, ReverbConstants.MAX_REFLECTIONS_GAIN);
            lateReverbGain *= roomSizeScaling;
            lateReverbGain = OpenALEffectsHandler.clamp(lateReverbGain, ReverbConstants.MIN_LATE_REVERB_GAIN, ReverbConstants.MAX_LATE_REVERB_GAIN);
            effectiveDecayTime *= roomSizeScaling;
            effectiveDecayTime = OpenALEffectsHandler.clamp(effectiveDecayTime, ReverbConstants.MIN_EFFECTIVE_DECAY_TIME, ReverbConstants.MAX_EFFECTIVE_DECAY_TIME);
            EXTEfx.alFilterf((int)this.sendFilter, (int)1, (float)sendFilterGain);
            EXTEfx.alFilterf((int)this.sendFilter, (int)2, (float)sendFilterGainHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)3, (float)overallGain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)5, (float)gainLF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)6, (float)effectiveDecayTime);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)8, (float)decayLfRatio);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)12, (float)lateReverbGain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)15, (float)echoTime);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)16, (float)echoDepth);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)17, (float)modulationTime);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)18, (float)modulationDepth);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)20, (float)hfReference);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)21, (float)lfReference);
            AL11.alSource3i((int)sourceId, (int)131078, (int)this.auxFXSlot, (int)0, (int)this.sendFilter);
        }
        catch (Exception e) {
            System.err.println("Error applying dynamic reverb: " + e.getMessage());
        }
    }

    public void applyLegacyReverbToSource(int sourceId) {
        try {
            if (RaycastingHelper.getDistanceFromWallEchoDenom() == 0.0 || RaycastingHelper.getReverbDenom() == 0 || RaycastingHelper.getOutdoorLeakDenom() == 0) {
                return;
            }
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float occlusionPercent = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            occlusionPercent = 1.0f - occlusionPercent;
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float distanceMeters = OpenALEffectsHandler.clamp(wallDistance, 1.0f, 100.0f);
            occlusionPercent = 1.0f - OpenALEffectsHandler.clamp(occlusionPercent + (outdoorLeakPercent *= 2.0f), 0.0f, 1.0f);
            outdoorLeakPercent = OpenALEffectsHandler.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            float dryFactor = 1.0f - outdoorLeakPercent;
            float speedOfSound = 343.0f;
            float wallDelay = distanceMeters * 2.0f / speedOfSound;
            float decayTime = OpenALEffectsHandler.clamp(wallDelay * 5.0f * dryFactor, 0.1f, 6.0f);
            float reflectionsDelay = OpenALEffectsHandler.clamp(wallDelay * 0.5f, 0.005f, 0.05f);
            float lateReverbDelay = OpenALEffectsHandler.clamp(wallDelay, 0.01f, 0.1f);
            float decayHfRatio = org.joml.Math.lerp((float)0.5f, (float)1.3f, (float)((1.0f - occlusionPercent) * dryFactor));
            float diffusion = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)(dryFactor * (1.0f - occlusionPercent)));
            float gainHF = org.joml.Math.lerp((float)0.05f, (float)0.9f, (float)((1.0f - occlusionPercent) * dryFactor));
            float reflectionsGain = org.joml.Math.lerp((float)0.0f, (float)0.7f, (float)dryFactor);
            float lateReverbGain = org.joml.Math.lerp((float)0.0f, (float)1.0f, (float)dryFactor);
            float density = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)dryFactor);
            float gain = org.joml.Math.lerp((float)0.05f, (float)0.3f, (float)dryFactor);
            float airAbsorptionHF = org.joml.Math.lerp((float)0.95f, (float)0.99f, (float)dryFactor);
            float roomRolloff = 0.4f;
            EXTEfx.alFilterf((int)this.sendFilter, (int)1, (float)gain);
            EXTEfx.alFilterf((int)this.sendFilter, (int)2, (float)1.0f);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)3, (float)gain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)6, (float)decayTime);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)12, (float)lateReverbGain);
            AL11.alSource3i((int)sourceId, (int)131078, (int)this.auxFXSlot, (int)0, (int)this.sendFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyInitalLegacyReverbToSource(int sourceId) {
        try {
            float wallDistance = (float)(RaycastingHelper.getDistanceFromWallEcho() / RaycastingHelper.getDistanceFromWallEchoDenom());
            float occlusionPercent = (float)RaycastingHelper.getReverbStrength() / (float)RaycastingHelper.getReverbDenom();
            float outdoorLeakPercent = (float)RaycastingHelper.getOutdoorLeak() / (float)RaycastingHelper.getOutdoorLeakDenom();
            float distanceMeters = OpenALEffectsHandler.clamp(wallDistance, 1.0f, 100.0f);
            occlusionPercent = 1.0f - OpenALEffectsHandler.clamp(occlusionPercent + outdoorLeakPercent, 0.0f, 1.0f);
            outdoorLeakPercent = OpenALEffectsHandler.clamp(outdoorLeakPercent, 0.0f, 1.0f);
            float dryFactor = 1.0f - outdoorLeakPercent;
            float speedOfSound = 343.0f;
            float wallDelay = distanceMeters * 2.0f / speedOfSound;
            float decayTime = OpenALEffectsHandler.clamp(wallDelay * 5.0f * dryFactor, 0.1f, 6.0f);
            float reflectionsDelay = OpenALEffectsHandler.clamp(wallDelay * 0.5f, 0.005f, 0.05f);
            float lateReverbDelay = OpenALEffectsHandler.clamp(wallDelay, 0.01f, 0.1f);
            float decayHfRatio = org.joml.Math.lerp((float)0.5f, (float)1.3f, (float)((1.0f - occlusionPercent) * dryFactor));
            float diffusion = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)(dryFactor * (1.0f - occlusionPercent)));
            float gainHF = org.joml.Math.lerp((float)0.05f, (float)0.9f, (float)((1.0f - occlusionPercent) * dryFactor));
            float reflectionsGain = org.joml.Math.lerp((float)0.0f, (float)0.7f, (float)dryFactor);
            float lateReverbGain = org.joml.Math.lerp((float)0.0f, (float)1.0f, (float)dryFactor);
            float density = org.joml.Math.lerp((float)0.3f, (float)1.0f, (float)dryFactor);
            float gain = org.joml.Math.lerp((float)0.05f, (float)0.3f, (float)dryFactor);
            float airAbsorptionHF = org.joml.Math.lerp((float)0.95f, (float)0.99f, (float)dryFactor);
            float roomRolloff = 0.4f;
            AL11.alSourcef((int)sourceId, (int)131083, (float)0.0f);
            AL11.alSourcef((int)sourceId, (int)131084, (float)0.0f);
            EXTEfx.alFilterf((int)this.sendFilter, (int)1, (float)gain);
            EXTEfx.alFilterf((int)this.sendFilter, (int)2, (float)1.0f);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)1, (float)density);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)3, (float)gain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)19, (float)airAbsorptionHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)22, (float)roomRolloff);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)6, (float)decayTime);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)7, (float)decayHfRatio);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)2, (float)diffusion);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)4, (float)gainHF);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)10, (float)reflectionsDelay);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)13, (float)lateReverbDelay);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)9, (float)reflectionsGain);
            EXTEfx.alEffectf((int)this.reverbEffect, (int)12, (float)lateReverbGain);
            if ((double)outdoorLeakPercent < 0.95) {
                AL11.alSource3i((int)sourceId, (int)131078, (int)this.auxFXSlot, (int)0, (int)this.sendFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeReverb() {
        if (this.efxInitialized) {
            this.cleanupEFXResources();
        }
        try {
            long currentContext = ALC10.alcGetCurrentContext();
            long device = ALC10.alcGetContextsDevice((long)currentContext);
            this.initializeReverb(currentContext, device);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize reverb: " + e.getMessage());
        }
    }

    public void initializeReverb(long currentContext, long currentDevice) {
        if (this.efxInitialized) {
            this.cleanupEFXResources();
        }
        try {
            if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
                System.out.println("EFX Extension not available - reverb disabled");
                return;
            }
            this.auxFXSlot = EXTEfx.alGenAuxiliaryEffectSlots();
            EXTEfx.alAuxiliaryEffectSloti((int)this.auxFXSlot, (int)3, (int)1);
            this.reverbEffect = EXTEfx.alGenEffects();
            EXTEfx.alEffecti((int)this.reverbEffect, (int)32769, (int)32768);
            this.muffleFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)this.muffleFilter, (int)32769, (int)1);
            this.sendFilter = EXTEfx.alGenFilters();
            EXTEfx.alFilteri((int)this.sendFilter, (int)32769, (int)1);
            this.setBasicReverbParams();
            EXTEfx.alAuxiliaryEffectSloti((int)this.auxFXSlot, (int)1, (int)this.reverbEffect);
            this.efxInitialized = true;
            System.out.println("Reverb system initialized successfully");
        }
        catch (Exception e) {
            System.err.println("Failed to initialize reverb: " + e.getMessage());
        }
    }

    private void setBasicReverbParams() {
        EXTEfx.alEffectf((int)this.reverbEffect, (int)1, (float)0.5f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)2, (float)0.8f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)3, (float)0.3f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)4, (float)0.8f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)6, (float)15.0f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)7, (float)0.7f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)9, (float)0.2f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)12, (float)0.4f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)13, (float)0.03f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)19, (float)0.99f);
        EXTEfx.alEffectf((int)this.reverbEffect, (int)22, (float)0.0f);
    }

    public void cleanupEFXResources() {
        if (!this.efxInitialized) {
            return;
        }
        try {
            System.out.println("Cleaning up EFX resources...");
            RaycastingHelper.FXQueue.clear();
            if (this.auxFXSlot != 0) {
                EXTEfx.alDeleteAuxiliaryEffectSlots((int)this.auxFXSlot);
                this.auxFXSlot = 0;
            }
            if (this.reverbEffect != 0) {
                EXTEfx.alDeleteEffects((int)this.reverbEffect);
                this.reverbEffect = 0;
            }
            if (this.muffleFilter != 0) {
                EXTEfx.alDeleteFilters((int)this.muffleFilter);
                this.muffleFilter = 0;
            }
            if (this.sendFilter != 0) {
                EXTEfx.alDeleteFilters((int)this.sendFilter);
                this.sendFilter = 0;
            }
            this.efxInitialized = false;
            System.out.println("EFX resources cleaned up successfully");
        }
        catch (Exception e) {
            System.err.println("Error cleaning up EFX resources: " + e.getMessage());
            this.auxFXSlot = 0;
            this.reverbEffect = 0;
            this.muffleFilter = 0;
            this.sendFilter = 0;
            this.efxInitialized = false;
        }
    }

    public void applyMuffleToSource(int sourceId, float muffleStrength) {
        try {
            muffleStrength = OpenALEffectsHandler.clamp(muffleStrength, 0.0f, 1.0f);
            float lowpassGain = org.joml.Math.lerp((float)1.0f, (float)0.2f, (float)muffleStrength);
            float lowpassGainHF = org.joml.Math.lerp((float)1.0f, (float)0.1f, (float)muffleStrength);
            if (!EXTEfx.alIsAuxiliaryEffectSlot((int)this.auxFXSlot)) {
                System.err.println("Muffle Filter isn't defined properly");
                this.cleanupEFXResources();
                this.initializeReverb();
                return;
            }
            if (this.muffleFilter != -1) {
                EXTEfx.alFilterf((int)this.muffleFilter, (int)1, (float)lowpassGain);
                EXTEfx.alFilterf((int)this.muffleFilter, (int)2, (float)lowpassGainHF);
                AL11.alSourcei((int)sourceId, (int)131077, (int)this.muffleFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static float clamp(float a, float b, float c) {
        return Math.min(Math.max(a, b), c);
    }
}

