/*
 * Decompiled with CFR 0.152.
 */
package com.redsmods.sound_physics_perfected.wrappers;

import com.redsmods.sound_physics_perfected.RaycastingHelper;
import com.redsmods.sound_physics_perfected.config.Config;
import com.redsmods.sound_physics_perfected.wrappers.RedTickableInstance;
import lombok.Generated;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.lwjgl.openal.AL10;

public class RedPermeatedSoundInstance
extends RedTickableInstance {
    float permeationIndex;
    int tickCount = 0;
    private int id;
    private boolean sourceSet = false;
    private float targetMuffle;

    public RedPermeatedSoundInstance(class_2960 soundID, class_1111 sound, class_3419 category, class_243 position, float volume, float pitch, class_1113 wrapped, class_243 originalPos, float originalVolume, float permeationIndex) {
        super(soundID, sound, category, position, volume, pitch, wrapped, originalPos, originalVolume);
        this.permeationIndex = permeationIndex;
    }

    public void setPermeationIndex(float permeationIndex) {
        if (super.method_4793()) {
            return;
        }
        this.targetMuffle = permeationIndex;
    }

    @Override
    public void method_16896() {
        ++this.tickCount;
        if (super.method_4793() || Config.getInstance().permeatedTickRate == 0) {
            return;
        }
        if (this.tickCount % Config.getInstance().permeatedTickRate == 0 && !RaycastingHelper.permeatedTickQueue.contains(this)) {
            RaycastingHelper.permeatedTickQueue.add(this);
        }
        super.updatePos();
        super.updateVolume();
        this.updateMuffle();
    }

    public void updateMuffle() {
        float deltaVolume = this.targetMuffle - this.permeationIndex;
        float maxVolumeChange = Math.max(Math.abs(deltaVolume / (float)Config.getInstance().tickRate), 0.3f);
        if (Math.abs(deltaVolume) <= 0.001f || Math.abs(deltaVolume) > maxVolumeChange * (float)Config.getInstance().tickRate) {
            this.permeationIndex = this.targetMuffle;
            if (this.sourceSet && AL10.alIsSource((int)this.id)) {
                RaycastingHelper.fxHandler.applyMuffleToSource(this.id, this.permeationIndex);
            }
            return;
        }
        float volumeChange = Math.min(maxVolumeChange, Math.abs(deltaVolume));
        this.permeationIndex = deltaVolume > 0.0f ? (this.permeationIndex += volumeChange) : (this.permeationIndex -= volumeChange);
        if (this.sourceSet && AL10.alIsSource((int)this.id)) {
            RaycastingHelper.fxHandler.applyMuffleToSource(this.id, 1.0f - this.permeationIndex);
        }
    }

    public void setSource(int id) {
        this.sourceSet = true;
        this.id = id;
    }

    private static float clamp(float a, float b, float c) {
        return Math.min(Math.max(a, b), c);
    }

    @Generated
    public float getPermeationIndex() {
        return this.permeationIndex;
    }
}

