/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bukkit.hooks;

import it.frafol.cleanss.bukkit.CleanSS;
import it.frafol.cleanss.bukkit.enums.SpigotConfig;
import it.frafol.cleanss.bukkit.objects.PlayerCache;
import java.util.Map;
import java.util.Objects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderHook
extends PlaceholderExpansion {
    public final CleanSS plugin;

    public PlaceholderHook(CleanSS plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "screenshare";
    }

    public String getAuthor() {
        return "frafol";
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String placeholder) {
        if (placeholder.equalsIgnoreCase("seconds")) {
            if (this.plugin.getSeconds(player.getUniqueId()) != null) {
                return String.valueOf(this.plugin.getSeconds(player.getUniqueId()));
            }
            return "0";
        }
        if (placeholder.equalsIgnoreCase("time")) {
            if (this.plugin.getFormattedSeconds(player.getUniqueId()) != null) {
                return this.plugin.getFormattedSeconds(player.getUniqueId());
            }
            return "00:00";
        }
        if (placeholder.equalsIgnoreCase("suspicious")) {
            if (PlayerCache.getCouples().get(player.getUniqueId()) != null) {
                Player checked = this.plugin.getServer().getPlayer(PlayerCache.getCouples().get(player.getUniqueId()));
                if (checked == null) {
                    return SpigotConfig.NONE.color();
                }
                if (!checked.isOnline()) {
                    return SpigotConfig.NONE.color();
                }
                return checked.getName();
            }
            return SpigotConfig.NONE.color();
        }
        if (placeholder.equalsIgnoreCase("administrator")) {
            if (PlaceholderHook.getKeyByValue(PlayerCache.getCouples(), player.getUniqueId()) != null) {
                Player checked = this.plugin.getServer().getPlayer(PlaceholderHook.getKeyByValue(PlayerCache.getCouples(), player.getUniqueId()));
                if (checked == null) {
                    return SpigotConfig.NONE.color();
                }
                if (!checked.isOnline()) {
                    return SpigotConfig.NONE.color();
                }
                return checked.getName();
            }
            return SpigotConfig.NONE.color();
        }
        if (placeholder.equalsIgnoreCase("prefix")) {
            if (PlayerCache.getSuspicious().contains(player.getUniqueId())) {
                return SpigotConfig.SUSPECTPREFIX.color();
            }
            if (PlayerCache.getAdministrator().contains(player.getUniqueId())) {
                return SpigotConfig.STAFFPREFIX.color();
            }
            return SpigotConfig.OTHERPREFIX.color();
        }
        return null;
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

