/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee;

import de.myzelyam.api.vanish.BungeeVanishAPI;
import it.frafol.cleanss.bungee.Metrics;
import it.frafol.cleanss.bungee.UpdateCheck;
import it.frafol.cleanss.bungee.commands.AdmitCommand;
import it.frafol.cleanss.bungee.commands.ControlCommand;
import it.frafol.cleanss.bungee.commands.DebugCommand;
import it.frafol.cleanss.bungee.commands.FinishCommand;
import it.frafol.cleanss.bungee.commands.HelpCommand;
import it.frafol.cleanss.bungee.commands.InfoCommand;
import it.frafol.cleanss.bungee.commands.ReloadCommand;
import it.frafol.cleanss.bungee.commands.SpectateCommand;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.enums.BungeeVersion;
import it.frafol.cleanss.bungee.listeners.ChatListener;
import it.frafol.cleanss.bungee.listeners.CommandListener;
import it.frafol.cleanss.bungee.listeners.KickListener;
import it.frafol.cleanss.bungee.listeners.ServerListener;
import it.frafol.cleanss.bungee.mysql.MySQLWorker;
import it.frafol.cleanss.bungee.objects.PlayerCache;
import it.frafol.cleanss.bungee.objects.PlayerUtil;
import it.frafol.cleanss.bungee.objects.TextFile;
import it.frafol.cleanss.bungee.objects.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.byteflux.libby.BungeeLibraryManager;
import net.byteflux.libby.Library;
import net.byteflux.libby.relocation.Relocation;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.simpleyaml.configuration.file.YamlFile;
import ru.vyarus.yaml.updater.YamlUpdater;
import ru.vyarus.yaml.updater.profile.ProdConfigurator;
import ru.vyarus.yaml.updater.util.FileUtils;

public class CleanSS
extends Plugin {
    private TextFile messagesTextFile;
    private TextFile configTextFile;
    private TextFile aliasesTextFile;
    private TextFile dataTextFile;
    private TextFile versionTextFile;
    private JDA jda;
    private MySQLWorker data;
    private static CleanSS instance;
    public boolean updated = false;

    public void onEnable() {
        instance = this;
        this.loadLibraries();
        this.getLogger().info("\n\u00a7d   ___  __    ____    __    _  _    ___  ___\n  / __)(  )  ( ___)  /__\\  ( \\( )  / __)/ __)\n ( (__  )(__  )__)  /(__)\\  )  (   \\__ \\\\__ \\\n  \\___)(____)(____)(__)(__)(_)\\_)  (___/(___/\n");
        this.getLogger().info("\u00a77Server version: \u00a7d" + this.getServerBrand() + " - " + this.getServerVersion());
        this.checkIncompatibilities();
        this.getLogger().info("\u00a77Loading \u00a7dconfiguration\u00a77...");
        this.loadFiles();
        this.updateConfig();
        this.getLogger().info("\u00a77Loading \u00a7dplugin\u00a77...");
        this.getProxy().registerChannel("cleanss:join");
        this.registerCommands();
        this.registerListeners();
        if (BungeeConfig.MYSQL.get(Boolean.class).booleanValue()) {
            this.data = new MySQLWorker();
            this.ControlTask();
        }
        if (BungeeConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            this.loadDiscord();
        }
        if (this.getPremiumVanish() && BungeeConfig.PREMIUMVANISH.get(Boolean.class).booleanValue()) {
            this.getLogger().info("\u00a77PremiumVanish hooked \u00a7dsuccessfully\u00a77!");
        }
        if (BungeeConfig.STATS.get(Boolean.class).booleanValue() && !this.getDescription().getVersion().contains("alpha")) {
            new Metrics(this, 17063);
            this.getLogger().info("\u00a77Metrics loaded \u00a7dsuccessfully\u00a77!");
        }
        this.UpdateChecker();
        this.startTasks();
        this.getLogger().info("\u00a77Plugin \u00a7dsuccessfully \u00a77loaded!");
    }

    public YamlFile getConfigTextFile() {
        return CleanSS.getInstance().configTextFile.getConfig();
    }

    public YamlFile getVersionTextFile() {
        return CleanSS.getInstance().versionTextFile.getConfig();
    }

    public YamlFile getDataTextFile() {
        return CleanSS.getInstance().dataTextFile.getConfig();
    }

    public YamlFile getAliasesTextFile() {
        return CleanSS.getInstance().aliasesTextFile.getConfig();
    }

    public YamlFile getMessagesTextFile() {
        return CleanSS.getInstance().messagesTextFile.getConfig();
    }

    private void startTasks() {
        List<ServerInfo> servers = Utils.getServerList(BungeeConfig.CONTROL.getStringList());
        List<ServerInfo> fallbacks = Utils.getServerList(BungeeConfig.CONTROL_FALLBACK.getStringList());
        servers.forEach(Utils::startTask);
        fallbacks.forEach(Utils::startTask);
    }

    private void stopTasks() {
        List<ServerInfo> servers = Utils.getServerList(BungeeConfig.CONTROL.getStringList());
        List<ServerInfo> fallbacks = Utils.getServerList(BungeeConfig.CONTROL_FALLBACK.getStringList());
        servers.forEach(Utils::stopTask);
        fallbacks.forEach(Utils::stopTask);
    }

    private void registerCommands() {
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new HelpCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ControlCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new FinishCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new AdmitCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new InfoCommand(this));
        if (BungeeConfig.ENABLE_SPECTATING.get(Boolean.class).booleanValue()) {
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new SpectateCommand(this));
        }
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new DebugCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ReloadCommand());
    }

    private void loadFiles() {
        this.configTextFile = new TextFile(this.getDataFolder().toPath(), "config.yml");
        this.messagesTextFile = new TextFile(this.getDataFolder().toPath(), "messages.yml");
        this.aliasesTextFile = new TextFile(this.getDataFolder().toPath(), "aliases.yml");
        this.dataTextFile = new TextFile(this.getDataFolder().toPath(), "database.yml");
        this.versionTextFile = new TextFile(this.getDataFolder().toPath(), "version.yml");
    }

    private void registerListeners() {
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ServerListener());
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new CommandListener());
        if (BungeeMessages.CONTROL_CHAT.get(Boolean.class).booleanValue()) {
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ChatListener(this));
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new KickListener(this));
    }

    private void UpdateChecker() {
        if (!BungeeConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                if (BungeeConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                    this.autoUpdate();
                    return;
                }
                if (!this.updated) {
                    this.getLogger().warning("\u00a7eThere is a new update available, download it on SpigotMC!");
                }
            }
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                this.getLogger().warning("\u00a7eYou are using a development version, please report any bugs!");
            }
        });
    }

    public boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    public void autoUpdate() {
        if (this.isWindows()) {
            this.getLogger().warning("\u00a7eAuto update is not supported on Windows.");
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            String fileUrl = "https://github.com/frafol/CleanScreenShare/releases/download/release/cleanscreenshare-" + version + " .jar";
            String destination = "./plugins/";
            String fileName = this.getFileNameFromUrl(fileUrl);
            File outputFile = new File(destination, fileName);
            try {
                this.downloadFile(fileUrl, outputFile);
            }
            catch (IOException ignored) {
                this.getLogger().warning("An error occurred while downloading the update, please download it manually from SpigotMC.");
                return;
            }
            this.updated = true;
            this.getLogger().warning("CleanScreenShare successfully updated, a restart is required.");
        });
    }

    private String getFileNameFromUrl(String fileUrl) {
        int slashIndex = fileUrl.lastIndexOf(47);
        if (slashIndex != -1 && slashIndex < fileUrl.length() - 1) {
            return fileUrl.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException("Invalid file URL");
    }

    private void downloadFile(String fileUrl, File outputFile) throws IOException {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            this.deleteFile(outputFile.getParent(), "cleanscreenshare-");
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void deleteFile(String directoryPath, String file_start) {
        File directory = new File(directoryPath);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException();
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().startsWith(file_start)) continue;
            this.getLogger().warning("Found an old plugin file: " + file.getName());
            if (!file.delete()) continue;
            this.getLogger().warning("Deleted old file: " + file.getName());
        }
    }

    public void ControlTask() {
        instance.getProxy().getScheduler().schedule((Plugin)this, () -> {
            for (ProxiedPlayer players : this.getProxy().getPlayers()) {
                PlayerCache.getIn_control().put(players.getUniqueId(), this.data.getStats(players.getUniqueId(), "incontrol"));
                PlayerCache.getControls().put(players.getUniqueId(), this.data.getStats(players.getUniqueId(), "controls"));
                PlayerCache.getControls_suffered().put(players.getUniqueId(), this.data.getStats(players.getUniqueId(), "controls"));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void UpdateChecker(ProxiedPlayer player) {
        if (!BungeeConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                if (BungeeConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                    this.autoUpdate();
                    return;
                }
                if (!this.updated && BungeeConfig.UPDATE_ALERT.get(Boolean.class).booleanValue()) {
                    TextComponent update = new TextComponent(BungeeMessages.UPDATE_ALERT.color().replace("%old_version%", this.getDescription().getVersion()).replace("%new_version%", (CharSequence)version));
                    update.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, BungeeMessages.UPDATE_LINK.get(String.class)));
                    player.sendMessage((BaseComponent)update);
                }
            }
        });
    }

    private void loadDiscord() {
        try {
            this.jda = JDABuilder.createDefault((String)BungeeConfig.DISCORD_TOKEN.get(String.class)).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).setStatus(this.selectStatus()).build();
            this.getLogger().info("\u00a77Discord hooked \u00a7dsuccessfully\u00a77!");
        }
        catch (ExceptionInInitializerError e) {
            this.getLogger().severe("Invalid Discord configuration, please check your config.yml file.");
            this.getLogger().severe("Make sure you are not using any strange forks (like Aegis).");
        }
        this.updateTaskJDA();
    }

    public void reloadDiscord() {
        try {
            this.jda = JDABuilder.createDefault((String)BungeeConfig.DISCORD_TOKEN.get(String.class)).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).setStatus(this.selectStatus()).build();
        }
        catch (ExceptionInInitializerError e) {
            this.getLogger().severe("Invalid Discord configuration, please check your config.yml file.");
            this.getLogger().severe("Make sure you are not using any strange forks (like Aegis).");
        }
        this.updateTaskJDA();
    }

    private OnlineStatus selectStatus() {
        String status = BungeeConfig.DISCORD_STATUS.get(String.class);
        if (status.equalsIgnoreCase("ONLINE")) {
            return OnlineStatus.ONLINE;
        }
        if (status.equalsIgnoreCase("IDLE")) {
            return OnlineStatus.IDLE;
        }
        if (status.equalsIgnoreCase("DND")) {
            return OnlineStatus.DO_NOT_DISTURB;
        }
        if (status.equalsIgnoreCase("INVISIBLE")) {
            return OnlineStatus.INVISIBLE;
        }
        return OnlineStatus.ONLINE;
    }

    public void updateTaskJDA() {
        this.getProxy().getScheduler().schedule((Plugin)this, this::updateJDA, 1L, 30L, TimeUnit.SECONDS);
    }

    public void updateJDA() {
        if (!BungeeConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            return;
        }
        if (this.jda == null) {
            this.getLogger().severe("Fatal error while updating JDA. Please report this error to https://discord.com/invite/sTSwaGBCdC.");
            return;
        }
        if (this.getPremiumVanish() && BungeeConfig.PREMIUMVANISH.get(Boolean.class).booleanValue()) {
            this.jda.getPresence().setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.valueOf((String)BungeeConfig.DISCORD_ACTIVITY_TYPE.get(String.class).toUpperCase()), (String)BungeeConfig.DISCORD_ACTIVITY.get(String.class).replace("%players%", String.valueOf(this.getProxy().getOnlineCount() - BungeeVanishAPI.getInvisiblePlayers().size())).replace("%suspicious%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%players_formatted%", PlayerUtil.getPlayersFormatted())));
            return;
        }
        this.jda.getPresence().setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.valueOf((String)BungeeConfig.DISCORD_ACTIVITY_TYPE.get(String.class).toUpperCase()), (String)BungeeConfig.DISCORD_ACTIVITY.get(String.class).replace("%players%", String.valueOf(this.getProxy().getOnlineCount())).replace("%suspicious%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%players_formatted%", PlayerUtil.getPlayersFormatted())));
    }

    private void updateConfig() {
        if (this.getDescription().getVersion().equals(BungeeVersion.VERSION.get(String.class))) {
            return;
        }
        this.getLogger().info("\u00a77Creating new \u00a7dconfigurations\u00a77...");
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.getDataFolder().toPath()) + "/config.yml"), (InputStream)this.findFile("config.yml")).backup(true)).update();
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.getDataFolder().toPath()) + "/aliases.yml"), (InputStream)this.findFile("aliases.yml")).backup(true)).update();
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.getDataFolder().toPath()) + "/messages.yml"), (InputStream)this.findFile("messages.yml")).backup(true)).update();
        this.versionTextFile.getConfig().set("version", (Object)this.getDescription().getVersion());
        this.versionTextFile.getConfig().save();
        this.loadFiles();
    }

    private InputStream findFile(String fileName) {
        return FileUtils.findFile((String)("https://raw.githubusercontent.com/frafol/CleanScreenShare/refs/heads/main/bungeecord/src/main/resources/" + fileName));
    }

    private void loadLibraries() {
        BungeeLibraryManager bungeeLibraryManager = new BungeeLibraryManager(this);
        Relocation yamlrelocation = new Relocation("yaml", "it{}frafol{}libs{}yaml");
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").relocate(yamlrelocation).build();
        Relocation updaterrelocation = new Relocation("updater", "it{}frafol{}libs{}updater");
        Library updater = Library.builder().groupId("ru{}vyarus").artifactId("yaml-config-updater").version("1.4.2").relocate(updaterrelocation).build();
        Relocation jda = new Relocation("discord", "it{}frafol{}libs{}discord");
        Library discord = Library.builder().groupId("net{}dv8tion").artifactId("JDA").version("5.5.1").relocate(jda).url("https://github.com/DV8FromTheWorld/JDA/releases/download/v5.5.1/JDA-5.5.1-withDependencies-min.jar").build();
        bungeeLibraryManager.addMavenCentral();
        bungeeLibraryManager.addJitPack();
        try {
            bungeeLibraryManager.loadLibrary(yaml);
        }
        catch (RuntimeException ignored) {
            this.getLogger().severe("Failed to load Simple-YAML library. Trying to download it from GitHub...");
            yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").url("https://github.com/Carleslc/Simple-YAML/releases/download/1.8.4/Simple-Yaml-1.8.4.jar").relocate(yamlrelocation).build();
        }
        bungeeLibraryManager.loadLibrary(yaml);
        bungeeLibraryManager.loadLibrary(updater);
        bungeeLibraryManager.loadLibrary(discord);
    }

    private void checkIncompatibilities() {
        if (this.getSpicord()) {
            this.getLogger().severe("Spicord found, this plugin is completely unsupported and you won't receive any support.");
        }
        if (this.getProtocolize()) {
            this.getLogger().severe("Protocolize found, this plugin is completely unsupported and you won't receive any support.");
        }
    }

    public void onDisable() {
        this.getProxy().unregisterChannel("cleanss:join");
        this.stopTasks();
        if (this.getConfigTextFile() == null || BungeeConfig.MYSQL.get(Boolean.class).booleanValue()) {
            this.getLogger().info("\u00a77Closing \u00a7ddatabase\u00a77...");
            for (ProxiedPlayer players : this.getProxy().getPlayers()) {
                if (this.data == null) continue;
                this.data.setInControl(players.getUniqueId(), 0);
                this.data.setControls(players.getUniqueId(), PlayerCache.getControls().get(players.getUniqueId()));
            }
            if (this.data != null) {
                this.data.close();
            }
        }
        this.getLogger().info("\u00a77Clearing \u00a7dinstances\u00a77...");
        instance = null;
        this.getLogger().info("\u00a77Plugin successfully \u00a7ddisabled\u00a77!");
    }

    private String getServerBrand() {
        return this.getProxy().getName();
    }

    private String getServerVersion() {
        return this.getProxy().getVersion();
    }

    public <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public <K, V> V getValue(Map<K, V> map, K key) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setData() {
        this.data = new MySQLWorker();
    }

    public boolean getPremiumVanish() {
        return this.getProxy().getPluginManager().getPlugin("PremiumVanish") != null;
    }

    public boolean getLuckPerms() {
        return this.getProxy().getPluginManager().getPlugin("PremiumVanish") != null;
    }

    private boolean getSpicord() {
        return this.getProxy().getPluginManager().getPlugin("Spicord") != null;
    }

    private boolean getProtocolize() {
        return this.getProxy().getPluginManager().getPlugin("Protocolize") != null;
    }

    @Generated
    public JDA getJda() {
        return this.jda;
    }

    @Generated
    public void setJda(JDA jda) {
        this.jda = jda;
    }

    @Generated
    public MySQLWorker getData() {
        return this.data;
    }

    @Generated
    public static CleanSS getInstance() {
        return instance;
    }
}

