/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.commands;

import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeCommandsConfig;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.objects.ChatUtil;
import it.frafol.cleanss.bungee.objects.MessageUtil;
import it.frafol.cleanss.bungee.objects.Placeholder;
import it.frafol.cleanss.bungee.objects.PlayerCache;
import it.frafol.cleanss.bungee.objects.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class SpectateCommand
extends Command
implements TabExecutor {
    private final CleanSS instance;

    public SpectateCommand(CleanSS instance) {
        super(BungeeCommandsConfig.SS_SPECTATE.getStringList().get(0), "", BungeeCommandsConfig.SS_SPECTATE.getStringList().toArray(new String[0]));
        this.instance = instance;
    }

    public void execute(CommandSender invocation, String[] args) {
        String admin_displayname;
        String admin_suffix;
        String admin_prefix;
        boolean luckperms;
        if (!invocation.hasPermission(BungeeConfig.CONTROL_PERMISSION.get(String.class))) {
            invocation.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NO_PERMISSION.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            return;
        }
        if (!(invocation instanceof ProxiedPlayer)) {
            invocation.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.ONLY_PLAYERS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)invocation;
        boolean bl = luckperms = this.instance.getProxy().getPluginManager().getPlugin("LuckPerms") != null;
        if (args.length != 1) {
            BungeeMessages.USAGE.sendList(invocation, new Placeholder("%prefix%", BungeeMessages.PREFIX.color()));
            return;
        }
        if (args[0].equalsIgnoreCase("finish") && PlayerCache.getSpectators().contains(player.getUniqueId())) {
            PlayerCache.getSpectators().remove(player.getUniqueId());
            player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.NOT_SPECTATING.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            this.fallback(player);
            return;
        }
        if (this.instance.getProxy().getServerInfo(args[0]) == null) {
            player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.INVALID_SERVER.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%server%", args[0])));
            return;
        }
        ServerInfo server = this.instance.getProxy().getServerInfo(args[0]);
        if (!Utils.isInControlServer(server)) {
            player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.INVALID_SERVER.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%server%", args[0])));
            return;
        }
        if (PlayerCache.getSpectators().contains(player.getUniqueId()) || PlayerCache.getAdministrator().contains(player.getUniqueId()) || PlayerCache.getSuspicious().contains(player.getUniqueId())) {
            player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.IN_CONTROL_ERROR.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            return;
        }
        player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.SPECTATING.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%server%", server.getName())));
        PlayerCache.getSpectators().add(player.getUniqueId());
        player.connect(server);
        if (luckperms) {
            LuckPerms api = LuckPermsProvider.get();
            User admin = api.getUserManager().getUser(player.getUniqueId());
            if (admin == null) {
                return;
            }
            String prefix = admin.getCachedData().getMetaData().getPrefix();
            String suffix = admin.getCachedData().getMetaData().getSuffix();
            admin_prefix = prefix == null ? "" : prefix;
            admin_suffix = suffix == null ? "" : suffix;
            String displayname = admin.getCachedData().getMetaData().getPrimaryGroup();
            admin_displayname = displayname == null ? "" : displayname;
        } else {
            admin_prefix = "";
            admin_suffix = "";
            admin_displayname = "";
        }
        MessageUtil.sendDiscordSpectatorMessage(player, BungeeMessages.DISCORD_SPECTATOR.color().replace("%server%", server.getName()).replace("%staffer%", player.getName()).replace("%controls%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%admingroup%", admin_displayname), BungeeMessages.DISCORD_SPECTATOR_THUMBNAIL.color());
        if (BungeeConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
            this.instance.getProxy().getPlayers().stream().filter(players -> players.hasPermission(BungeeConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.SPECT_ADMIN_NOTIFY.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%admin%", player.getName()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)))));
        }
    }

    private void fallback(ProxiedPlayer player) {
        List<ServerInfo> servers = Utils.getServerList(BungeeConfig.CONTROL_FALLBACK.getStringList());
        if (!BungeeConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
            servers = Utils.getOnlineServers(servers);
        }
        ServerInfo proxyServer = Utils.getBestServer(servers);
        player.connect(proxyServer);
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        String partialName = args[0].toLowerCase();
        ArrayList<String> completions = new ArrayList<String>();
        for (String servers : BungeeConfig.CONTROL.getStringList()) {
            if (!servers.toLowerCase().startsWith(partialName)) continue;
            completions.add(servers);
        }
        return completions;
    }
}

