/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.objects;

import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeCommandsConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.objects.Placeholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.simpleyaml.configuration.ConfigurationSection;

public final class ChatUtil {
    private static final CleanSS instance = CleanSS.getInstance();

    public static List<String> getStringList(BungeeMessages velocityMessages) {
        return instance.getMessagesTextFile().getStringList(velocityMessages.getPath());
    }

    public static List<String> getStringList(BungeeMessages velocityMessages, Placeholder ... placeholders) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : ChatUtil.getStringList(velocityMessages)) {
            s = ChatUtil.applyPlaceholder(s, placeholders);
            newList.add(s);
        }
        return newList;
    }

    public static String applyPlaceholder(String s, Placeholder ... placeholders) {
        for (Placeholder placeholder : placeholders) {
            if (placeholder == null) continue;
            s = s.replace(placeholder.getKey(), placeholder.getValue());
        }
        return s;
    }

    public static String color(String string) {
        if (string == null) {
            return null;
        }
        String hex = ChatUtil.convertHexColors(string);
        return hex.replace("&", "\u00a7");
    }

    public static String convertHexColors(String str) {
        Pattern unicode = Pattern.compile("\\\\u\\+[a-fA-F0-9]{4}");
        Matcher match = unicode.matcher(str);
        while (match.find()) {
            String code = str.substring(match.start(), match.end());
            str = str.replace(code, Character.toString((char)Integer.parseInt(code.replace("\\u+", ""), 16)));
            match = unicode.matcher(str);
        }
        Pattern pattern = Pattern.compile("&#[a-fA-F0-9]{6}");
        match = pattern.matcher(str);
        while (match.find()) {
            String color = str.substring(match.start(), match.end());
            str = str.replace(color, String.valueOf(ChatColor.of((String)color.replace("&", ""))));
            match = pattern.matcher(str);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    public static List<String> color(List<String> list) {
        return list.stream().map(ChatUtil::color).collect(Collectors.toList());
    }

    private static boolean hasButton(List<String> stringList) {
        for (String string : stringList) {
            if (!string.contains("%buttons%")) continue;
            return true;
        }
        return false;
    }

    public static void sendList(CommandSender commandSource, List<String> stringList) {
        for (String message : stringList) {
            if (!ChatUtil.containsCommand(message).equals("none")) {
                TextComponent suggestMessage = new TextComponent(message);
                suggestMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + ChatUtil.containsCommand(message) + " "));
                commandSource.sendMessage((BaseComponent)suggestMessage);
                continue;
            }
            commandSource.sendMessage(TextComponent.fromLegacy((String)message));
        }
    }

    private static void sendButtonList(CommandSender commandSource, List<String> stringList, ProxiedPlayer player_name) {
        if (!BungeeMessages.CONTROL_USEVERTICALFORMAT.get(Boolean.class).booleanValue() && ChatUtil.hasButton(stringList)) {
            ChatUtil.sendHorizontalButtons(commandSource, stringList, player_name);
            return;
        }
        for (String message : stringList) {
            if (ChatUtil.getButton(message) == null) {
                commandSource.sendMessage(TextComponent.fromLegacy((String)message));
                continue;
            }
            String button = ChatUtil.getButton(message);
            TextComponent suggestMessage = new TextComponent(message.replace("%" + button + "name%", ChatUtil.color(instance.getMessagesTextFile().getString("messages.staff_message.buttons." + button + ".name"))));
            ClickEvent.Action action = ClickEvent.Action.SUGGEST_COMMAND;
            if (BungeeMessages.BUTTON_EXECUTION.get(Boolean.class).booleanValue()) {
                action = ClickEvent.Action.RUN_COMMAND;
            }
            suggestMessage.setClickEvent(new ClickEvent(action, instance.getMessagesTextFile().getString("messages.staff_message.buttons." + button + ".command").replace("%player%", player_name.getName())));
            commandSource.sendMessage((BaseComponent)suggestMessage);
        }
    }

    private static void sendHorizontalButtons(CommandSender commandSource, List<String> stringList, ProxiedPlayer player_name) {
        ArrayList<TextComponent> buttons = new ArrayList<TextComponent>();
        for (String message : stringList) {
            if (message.contains("%buttons%")) {
                for (String key : ChatUtil.getButtons(player_name).keySet()) {
                    TextComponent button = new TextComponent(key + " ");
                    button.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ChatUtil.getButtons(player_name).get(key).replace("%player%", player_name.getName())));
                    buttons.add(button);
                }
                ComponentBuilder builder = new ComponentBuilder();
                for (TextComponent component : buttons) {
                    builder.append((BaseComponent)component);
                }
                commandSource.sendMessage(builder.create());
                continue;
            }
            commandSource.sendMessage(TextComponent.fromLegacy((String)message));
        }
    }

    private static String getButton(String message) {
        ConfigurationSection buttons = instance.getMessagesTextFile().getConfigurationSection("messages.staff_message.buttons");
        for (String button : buttons.getKeys(false)) {
            if (!message.contains("%" + button + "name%")) continue;
            return button;
        }
        return null;
    }

    private static HashMap<String, String> getButtons(ProxiedPlayer suspect) {
        HashMap<String, String> buttons = new HashMap<String, String>();
        for (String button : instance.getMessagesTextFile().getStringList("messages.staff_message.buttons")) {
            buttons.put(instance.getMessagesTextFile().getString("messages.staff_message.buttons." + button + ".name"), instance.getMessagesTextFile().getString("messages.staff_message.buttons." + button + ".command").replace("%player%", suspect.getName()));
        }
        return buttons;
    }

    public static String getCommand(String input) {
        int slashIndex = input.indexOf("/");
        if (slashIndex == -1 || slashIndex == input.length() - 1) {
            return input;
        }
        int spaceIndex = input.indexOf(" ", slashIndex);
        if (spaceIndex == -1) {
            spaceIndex = input.length();
        }
        return input.substring(slashIndex + 1, spaceIndex).trim();
    }

    private static String containsCommand(String message) {
        String foundCommand = ChatUtil.getCommand(message);
        for (String command : BungeeCommandsConfig.SS_PLAYER.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : BungeeCommandsConfig.SS_SPECTATE.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : BungeeCommandsConfig.SS_FINISH.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : BungeeCommandsConfig.SS_ADMIT.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : BungeeCommandsConfig.SS_INFO.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        if (foundCommand.equalsIgnoreCase("ssreload")) {
            return foundCommand;
        }
        return "none";
    }

    public static void sendFormattedList(BungeeMessages velocityMessages, CommandSender commandSender, ProxiedPlayer player_name, boolean start, Placeholder ... placeholders) {
        if (start) {
            ChatUtil.sendButtonList(commandSender, ChatUtil.color(ChatUtil.getStringList(velocityMessages, placeholders)), player_name);
            return;
        }
        ChatUtil.sendList(commandSender, ChatUtil.color(ChatUtil.getStringList(velocityMessages, placeholders)));
    }

    @Generated
    private ChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

