/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.Metrics;
import it.frafol.cleanss.velocity.UpdateCheck;
import it.frafol.cleanss.velocity.commands.AdmitCommand;
import it.frafol.cleanss.velocity.commands.ControlCommand;
import it.frafol.cleanss.velocity.commands.DebugCommand;
import it.frafol.cleanss.velocity.commands.FinishCommand;
import it.frafol.cleanss.velocity.commands.HelpCommand;
import it.frafol.cleanss.velocity.commands.InfoCommand;
import it.frafol.cleanss.velocity.commands.ReloadCommand;
import it.frafol.cleanss.velocity.commands.SpectateCommand;
import it.frafol.cleanss.velocity.enums.VelocityCommandsConfig;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityLimbo;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.enums.VelocityVersion;
import it.frafol.cleanss.velocity.listeners.ChatListener;
import it.frafol.cleanss.velocity.listeners.CommandListener;
import it.frafol.cleanss.velocity.listeners.KickListener;
import it.frafol.cleanss.velocity.listeners.ServerListener;
import it.frafol.cleanss.velocity.mysql.MySQLWorker;
import it.frafol.cleanss.velocity.objects.JdaBuilder;
import it.frafol.cleanss.velocity.objects.LimboUtils;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.PlayerUtil;
import it.frafol.cleanss.velocity.objects.PremiumVanishUtils;
import it.frafol.cleanss.velocity.objects.TextFile;
import it.frafol.cleanss.velocity.objects.Utils;
import it.frafol.cleanss.velocity.objects.VelocityVanishUtils;
import it.frafol.cleanss.velocity.objects.adapter.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.byteflux.libby.Library;
import net.byteflux.libby.VelocityLibraryManager;
import net.byteflux.libby.relocation.Relocation;
import net.dv8tion.jda.api.entities.Activity;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.slf4j.Logger;
import ru.vyarus.yaml.updater.YamlUpdater;
import ru.vyarus.yaml.updater.profile.ProdConfigurator;
import ru.vyarus.yaml.updater.util.FileUtils;

@Plugin(id="cleanscreenshare", name="CleanScreenShare", version="2.7.1", description="Make control hacks on your players.", dependencies={@Dependency(id="luckperms", optional=true), @Dependency(id="mysqlandconfigurateforvelocity", optional=true), @Dependency(id="limboapi", optional=true), @Dependency(id="ajqueue", optional=true), @Dependency(id="premiumvanish", optional=true), @Dependency(id="velocityvanish", optional=true), @Dependency(id="spicord", optional=true), @Dependency(id="clientcatcher", optional=true)}, authors={"frafol"})
public class CleanSS {
    public static final ChannelIdentifier channel_join = MinecraftChannelIdentifier.create((String)"cleanss", (String)"join");
    public boolean mysql_installation = false;
    public boolean updated = false;
    @Inject
    private final Logger logger;
    @Inject
    private final ProxyServer server;
    private final Path path;
    private final Metrics.Factory metricsFactory;
    private final JdaBuilder jda = new JdaBuilder();
    private TextFile messagesTextFile;
    private TextFile configTextFile;
    private TextFile aliasesTextFile;
    private TextFile limboTextFile;
    private TextFile dataTextFile;
    private TextFile versionTextFile;
    public boolean useLimbo = false;
    private boolean ajQueue = false;
    private static CleanSS instance;
    private MySQLWorker data;
    @Inject
    public PluginContainer container;

    @Inject
    public CleanSS(Logger logger, ProxyServer server, @DataDirectory Path path, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.path = path;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        this.loadLibraries();
        if (this.mysql_installation) {
            return;
        }
        this.logger.info("\n   ___  __    ____    __    _  _   ___  ___\n  / __)(  )  ( ___)  /__\\  ( \\( ) / __)/ __)\n ( (__  )(__  )__)  /(__)\\  )  (  \\__ \\\\__ \\\n  \\___)(____)(____)(__)(__)(_)\\_) (___/(___/\n");
        this.logger.info("Server version: " + this.getServerBrand() + " - " + this.getServerVersion());
        this.checkIncompatibilities();
        this.logger.info("Loading configuration...");
        this.loadFiles();
        this.updateConfig();
        this.logger.info("Loading plugin...");
        this.loadChannelRegistrar();
        this.loadListeners();
        this.loadCommands();
        this.loadDiscord();
        if (VelocityLimbo.USE.get(Boolean.class).booleanValue()) {
            if (instance.getServer().getPluginManager().getPlugin("limboapi").isPresent() && instance.getServer().getPluginManager().getPlugin("limboapi").flatMap(PluginContainer::getInstance).isPresent()) {
                LimboUtils.loadLimbo();
            } else {
                this.logger.error("LimboAPI not found! Please install it to use the Limbo feature.");
            }
        }
        if (this.getPremiumVanish() && VelocityConfig.PREMIUMVANISH.get(Boolean.class).booleanValue()) {
            this.logger.info("PremiumVanish hooked successfully!");
        }
        if (instance.getServer().getPluginManager().getPlugin("ajqueue").isPresent() && instance.getServer().getPluginManager().getPlugin("ajqueue").flatMap(PluginContainer::getInstance).isPresent()) {
            this.ajQueue = true;
        }
        if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
            this.loadLibrariesSQL();
            if (this.mysql_installation) {
                this.getServer().getScheduler().buildTask((Object)this, () -> this.server.shutdown()).delay(5L, TimeUnit.SECONDS).schedule();
                return;
            }
            if (ReflectUtil.getClass("com.mysql.cj.jdbc.Driver") == null) {
                this.loadLibrariesSQL();
                return;
            }
            this.data = new MySQLWorker();
            this.ControlTask();
        }
        if (VelocityConfig.STATS.get(Boolean.class).booleanValue()) {
            this.metricsFactory.make(this, 16951);
            this.logger.info("Metrics loaded successfully!");
        }
        this.UpdateChecker();
        this.startTasks();
        this.logger.info("Plugin successfully loaded!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.stopTasks();
        this.dataTextFile.getConfig().save();
        if (this.getConfigTextFile() == null || VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
            this.logger.info("Closing database...");
            for (Player players : this.server.getAllPlayers()) {
                if (this.data == null) continue;
                this.data.setInControl(players.getUniqueId(), 0);
                this.data.setControls(players.getUniqueId(), PlayerCache.getControls().get(players.getUniqueId()));
            }
            if (this.data != null) {
                this.data.close();
            }
        }
        this.logger.info("Clearing instances...");
        instance = null;
        this.logger.info("Plugin successfully disabled!");
    }

    private void startTasks() {
        List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL.getStringList());
        List<Optional<RegisteredServer>> fallbacks = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
        for (Optional<RegisteredServer> server : servers) {
            server.ifPresent(Utils::startTask);
        }
        for (Optional<RegisteredServer> fallback : fallbacks) {
            fallback.ifPresent(Utils::startTask);
        }
    }

    private void stopTasks() {
        List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL.getStringList());
        List<Optional<RegisteredServer>> fallbacks = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
        for (Optional<RegisteredServer> server : servers) {
            server.ifPresent(Utils::stopTask);
        }
        for (Optional<RegisteredServer> fallback : fallbacks) {
            fallback.ifPresent(Utils::stopTask);
        }
    }

    public void setData() {
        this.loadLibrariesSQL();
        if (this.mysql_installation) {
            this.getServer().getScheduler().buildTask((Object)this, () -> this.server.shutdown()).delay(5L, TimeUnit.SECONDS).schedule();
            return;
        }
        if (ReflectUtil.getClass("com.mysql.cj.jdbc.Driver") == null) {
            this.loadLibrariesSQL();
            return;
        }
        this.data = new MySQLWorker();
    }

    public void loadLibrariesSQL() {
        try {
            String fileUrl = "https://github.com/frafol/CleanScreenShare/releases/download/release/CleanSQLDriver.jar";
            String destination = "./plugins/";
            String fileName = this.getFileNameFromUrl(fileUrl);
            File outputFile = new File(destination, fileName);
            if (!outputFile.exists()) {
                this.downloadMySQLFile(fileUrl, outputFile);
                this.mysql_installation = true;
                this.logger.warn("MySQL drivers ({}) are now successfully installed. A restart will be performed in 5 seconds.", (Object)fileName);
            }
        }
        catch (IOException ignored) {
            this.logger.error("An error occurred while downloading MySQL drivers, plugin may not work properly.");
        }
    }

    private String getServerBrand() {
        return this.server.getVersion().getName();
    }

    private String getServerVersion() {
        return this.server.getVersion().getVersion();
    }

    public void autoUpdate() {
        if (this.isWindows()) {
            this.logger.warn("Auto update is not supported on Windows.");
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            String fileUrl = "https://github.com/frafol/CleanScreenShare/releases/download/release/cleanscreenshare-" + version + " .jar";
            String destination = "./plugins/";
            String fileName = this.getFileNameFromUrl(fileUrl);
            File outputFile = new File(destination, fileName);
            try {
                this.downloadFile(fileUrl, outputFile);
            }
            catch (IOException ignored) {
                this.logger.warn("An error occurred while downloading the update, please download it manually from SpigotMC.");
                return;
            }
            this.updated = true;
            this.logger.warn("CleanScreenShare successfully updated, a restart is required.");
        });
    }

    private void loadLibraries() {
        VelocityLibraryManager<CleanSS> velocityLibraryManager = new VelocityLibraryManager<CleanSS>(this.getLogger(), this.path, this.getServer().getPluginManager(), this);
        Relocation yamlrelocation = new Relocation("yaml", "it{}frafol{}libs{}yaml");
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").relocate(yamlrelocation).build();
        Relocation updaterrelocation = new Relocation("updater", "it{}frafol{}libs{}updater");
        Library updater = Library.builder().groupId("ru{}vyarus").artifactId("yaml-config-updater").version("1.4.2").relocate(updaterrelocation).build();
        Relocation jda = new Relocation("discord", "it{}frafol{}libs{}discord");
        Library discord = Library.builder().groupId("net{}dv8tion").artifactId("JDA").version("5.5.1").relocate(jda).url("https://github.com/DV8FromTheWorld/JDA/releases/download/v5.5.1/JDA-5.5.1-withDependencies-min.jar").build();
        velocityLibraryManager.addMavenCentral();
        velocityLibraryManager.addJitPack();
        try {
            velocityLibraryManager.loadLibrary(yaml);
        }
        catch (RuntimeException ignored) {
            this.logger.error("Failed to load Simple-YAML library. Trying to download it from GitHub...");
            yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").relocate(yamlrelocation).url("https://github.com/Carleslc/Simple-YAML/releases/download/1.8.4/Simple-Yaml-1.8.4.jar").build();
        }
        velocityLibraryManager.loadLibrary(yaml);
        velocityLibraryManager.loadLibrary(updater);
        velocityLibraryManager.loadLibrary(discord);
    }

    private void checkIncompatibilities() {
        if (this.getSpicord()) {
            this.logger.error("Spicord found, this plugin is completely unsupported and you won't receive any support.");
        }
        if (this.getProtocolize()) {
            this.logger.error("Protocolize found, this plugin is completely unsupported and you won't receive any support.");
        }
    }

    public boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    private String getFileNameFromUrl(String fileUrl) {
        int slashIndex = fileUrl.lastIndexOf(47);
        if (slashIndex != -1 && slashIndex < fileUrl.length() - 1) {
            return fileUrl.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException("Invalid file URL");
    }

    private void downloadMySQLFile(String fileUrl, File outputFile) throws IOException {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void downloadFile(String fileUrl, File outputFile) throws IOException {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            this.deleteFile(outputFile.getParent(), "cleanscreenshare-");
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void deleteFile(String directoryPath, String file_start) {
        File directory = new File(directoryPath);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException();
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().startsWith(file_start)) continue;
            this.logger.warn("Found an old plugin file: {}", (Object)file.getName());
            if (!file.delete()) continue;
            this.logger.warn("Deleted old file: {}", (Object)file.getName());
        }
    }

    private void loadFiles() {
        this.configTextFile = new TextFile(this.path, "config.yml");
        this.messagesTextFile = new TextFile(this.path, "messages.yml");
        this.aliasesTextFile = new TextFile(this.path, "aliases.yml");
        this.limboTextFile = new TextFile(this.path, "limboapi.yml");
        this.dataTextFile = new TextFile(this.path, "database.yml");
        this.versionTextFile = new TextFile(this.path, "version.yml");
    }

    private void updateConfig() {
        if (!this.container.getDescription().getVersion().isPresent()) {
            return;
        }
        if (((String)this.container.getDescription().getVersion().get()).equals(VelocityVersion.VERSION.get(String.class))) {
            return;
        }
        this.logger.info("Creating new configurations...");
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/config.yml"), (InputStream)this.findFile("config.yml")).backup(true)).update();
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/messages.yml"), (InputStream)this.findFile("messages.yml")).backup(true)).update();
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/aliases.yml"), (InputStream)this.findFile("aliases.yml")).backup(true)).update();
        ((ProdConfigurator)YamlUpdater.create((File)new File(String.valueOf(this.path) + "/limboapi.yml"), (InputStream)this.findFile("limboapi.yml")).backup(true)).update();
        this.versionTextFile.getConfig().set("version", this.container.getDescription().getVersion().get());
        this.versionTextFile.getConfig().save();
        this.loadFiles();
    }

    private InputStream findFile(String fileName) {
        return FileUtils.findFile((String)("https://raw.githubusercontent.com/frafol/CleanScreenShare/refs/heads/main/velocity/src/main/resources/" + fileName));
    }

    private void loadCommands() {
        String[] aliases_help = VelocityCommandsConfig.HELP.getStringList().toArray(new String[0]);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(VelocityCommandsConfig.HELP.getStringList().get(0)).aliases(aliases_help).build(), (Command)new HelpCommand(this));
        String[] aliases_ss = VelocityCommandsConfig.SS_PLAYER.getStringList().toArray(new String[0]);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(VelocityCommandsConfig.SS_PLAYER.getStringList().get(0)).aliases(aliases_ss).build(), (Command)new ControlCommand(this));
        String[] aliases_ssfinish = VelocityCommandsConfig.SS_FINISH.getStringList().toArray(new String[0]);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(VelocityCommandsConfig.SS_FINISH.getStringList().get(0)).aliases(aliases_ssfinish).build(), (Command)new FinishCommand(this));
        String[] aliases_ssadmit = VelocityCommandsConfig.SS_ADMIT.getStringList().toArray(new String[0]);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(VelocityCommandsConfig.SS_ADMIT.getStringList().get(0)).aliases(aliases_ssadmit).build(), (Command)new AdmitCommand(this));
        String[] aliases_info = VelocityCommandsConfig.SS_INFO.getStringList().toArray(new String[0]);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(VelocityCommandsConfig.SS_INFO.getStringList().get(0)).aliases(aliases_info).build(), (Command)new InfoCommand(this));
        if (VelocityConfig.ENABLE_SPECTATING.get(Boolean.class).booleanValue()) {
            String[] aliases_spectate = VelocityCommandsConfig.SS_SPECTATE.getStringList().toArray(new String[0]);
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(VelocityCommandsConfig.SS_SPECTATE.getStringList().get(0)).aliases(aliases_spectate).build(), (Command)new SpectateCommand(this));
        }
        this.getServer().getCommandManager().register(this.server.getCommandManager().metaBuilder("ssdebug").aliases(new String[]{"cleanssdebug", "controldebug"}).build(), (Command)new DebugCommand(this));
        this.getServer().getCommandManager().register(this.server.getCommandManager().metaBuilder("ssreload").aliases(new String[]{"cleanssreload", "controlreload"}).build(), (Command)new ReloadCommand(this));
    }

    private void loadChannelRegistrar() {
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{channel_join});
    }

    private void loadListeners() {
        this.server.getEventManager().register((Object)this, (Object)new ServerListener(this));
        this.server.getEventManager().register((Object)this, (Object)new CommandListener(this));
        if (VelocityMessages.CONTROL_CHAT.get(Boolean.class).booleanValue()) {
            this.server.getEventManager().register((Object)this, (Object)new ChatListener(this));
        }
        this.server.getEventManager().register((Object)this, (Object)new KickListener(this));
    }

    private void loadDiscord() {
        if (VelocityConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            this.jda.startJDA();
            this.updateTaskJDA();
            this.getLogger().info("Hooked into Discord successfully!");
        }
    }

    public void reloadDiscord() {
        if (VelocityConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            this.jda.startJDA();
            this.updateTaskJDA();
        }
    }

    private void UpdateChecker() {
        if (!VelocityConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        if (!this.container.getDescription().getVersion().isPresent()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                if (VelocityConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                    this.autoUpdate();
                    return;
                }
                if (!this.updated) {
                    this.logger.warn("There is a new update available, download it on SpigotMC!");
                }
            }
            if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                this.logger.warn("You are using a development version, please report any bugs!");
            }
        });
    }

    public void ControlTask() {
        instance.getServer().getScheduler().buildTask((Object)this, () -> {
            for (Player players : this.server.getAllPlayers()) {
                PlayerCache.getIn_control().put(players.getUniqueId(), this.data.getStats(players.getUniqueId(), "incontrol"));
                PlayerCache.getControls().put(players.getUniqueId(), this.data.getStats(players.getUniqueId(), "controls"));
                PlayerCache.getControls_suffered().put(players.getUniqueId(), this.data.getStats(players.getUniqueId(), "suffered"));
            }
        }).repeat(1L, TimeUnit.SECONDS).schedule();
    }

    public void UpdateChecker(Player player) {
        if (!VelocityConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        if (!this.container.getDescription().getVersion().isPresent()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) >= Integer.parseInt(version.replace(".", ""))) {
                return;
            }
            if (VelocityConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                this.autoUpdate();
                return;
            }
            if (!this.updated && VelocityConfig.UPDATE_ALERT.get(Boolean.class).booleanValue()) {
                player.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.UPDATE_ALERT.color().replace("%old_version%", (CharSequence)this.container.getDescription().getVersion().get()).replace("%new_version%", (CharSequence)version)).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.OPEN_URL, (String)VelocityMessages.UPDATE_LINK.get(String.class))));
            }
        });
    }

    private void updateTaskJDA() {
        this.getServer().getScheduler().buildTask((Object)this, this::UpdateJDA).repeat(30L, TimeUnit.SECONDS).schedule();
    }

    public void UpdateJDA() {
        if (!VelocityConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            return;
        }
        if (this.jda.getJda() == null) {
            this.logger.error("Fatal error while updating JDA, please report this error on https://discord.com/invite/sTSwaGBCdC.");
            return;
        }
        if (this.getVelocityVanish() && VelocityConfig.VELOCITYVANISH.get(Boolean.class).booleanValue()) {
            this.jda.getJda().getPresence().setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.valueOf((String)VelocityConfig.DISCORD_ACTIVITY_TYPE.get(String.class).toUpperCase()), (String)VelocityConfig.DISCORD_ACTIVITY.get(String.class).replace("%players%", String.valueOf(VelocityVanishUtils.getOnlinePlayers(this))).replace("%suspicious%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%players_formatted%", PlayerUtil.getPlayersFormatted())));
            return;
        }
        if (this.getPremiumVanish() && VelocityConfig.PREMIUMVANISH.get(Boolean.class).booleanValue()) {
            this.jda.getJda().getPresence().setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.valueOf((String)VelocityConfig.DISCORD_ACTIVITY_TYPE.get(String.class).toUpperCase()), (String)VelocityConfig.DISCORD_ACTIVITY.get(String.class).replace("%players%", String.valueOf(PremiumVanishUtils.getOnlinePlayers(this))).replace("%suspicious%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%players_formatted%", PlayerUtil.getPlayersFormatted())));
            return;
        }
        this.jda.getJda().getPresence().setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.valueOf((String)VelocityConfig.DISCORD_ACTIVITY_TYPE.get(String.class).toUpperCase()), (String)VelocityConfig.DISCORD_ACTIVITY.get(String.class).replace("%players%", String.valueOf(this.server.getAllPlayers().size())).replace("%suspicious%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%players_formatted%", PlayerUtil.getPlayersFormatted())));
    }

    public <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public <K, V> V getValue(Map<K, V> map, K key) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean getUnsignedVelocityAddon() {
        return this.getServer().getPluginManager().isLoaded("unsignedvelocity") || this.getServer().getPluginManager().isLoaded("signedvelocity");
    }

    public boolean getPremiumVanish() {
        return this.getServer().getPluginManager().isLoaded("premiumvanish");
    }

    public boolean getVelocityVanish() {
        return this.getServer().getPluginManager().isLoaded("velocityvanish");
    }

    public boolean getClientCatcher() {
        return this.getServer().getPluginManager().isLoaded("clientcatcher");
    }

    public boolean getLuckPerms() {
        return this.getServer().getPluginManager().isLoaded("luckperms");
    }

    public boolean getSpicord() {
        return this.getServer().getPluginManager().isLoaded("spicord");
    }

    public boolean getProtocolize() {
        return this.getServer().getPluginManager().isLoaded("protocolize");
    }

    @Generated
    public boolean isMysql_installation() {
        return this.mysql_installation;
    }

    @Generated
    public boolean isUpdated() {
        return this.updated;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public ProxyServer getServer() {
        return this.server;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Generated
    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Generated
    public JdaBuilder getJda() {
        return this.jda;
    }

    @Generated
    public TextFile getMessagesTextFile() {
        return this.messagesTextFile;
    }

    @Generated
    public TextFile getConfigTextFile() {
        return this.configTextFile;
    }

    @Generated
    public TextFile getAliasesTextFile() {
        return this.aliasesTextFile;
    }

    @Generated
    public TextFile getLimboTextFile() {
        return this.limboTextFile;
    }

    @Generated
    public TextFile getDataTextFile() {
        return this.dataTextFile;
    }

    @Generated
    public TextFile getVersionTextFile() {
        return this.versionTextFile;
    }

    @Generated
    public boolean isUseLimbo() {
        return this.useLimbo;
    }

    @Generated
    public PluginContainer getContainer() {
        return this.container;
    }

    @Generated
    public boolean isAjQueue() {
        return this.ajQueue;
    }

    @Generated
    public void setAjQueue(boolean ajQueue) {
        this.ajQueue = ajQueue;
    }

    @Generated
    public static CleanSS getInstance() {
        return instance;
    }

    @Generated
    public MySQLWorker getData() {
        return this.data;
    }
}

