/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.LimboUtils;
import it.frafol.cleanss.velocity.objects.MessageUtil;
import it.frafol.cleanss.velocity.objects.Placeholder;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.PremiumVanishUtils;
import it.frafol.cleanss.velocity.objects.Utils;
import it.frafol.cleanss.velocity.objects.VelocityVanishUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;

public class ControlCommand
implements SimpleCommand {
    private final CleanSS instance;

    public ControlCommand(CleanSS instance) {
        this.instance = instance;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        boolean luckperms = this.instance.getServer().getPluginManager().getPlugin("luckperms").isPresent();
        if (Utils.isConsole(source)) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ONLY_PLAYERS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (!source.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length == 0) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.PLAYER_MISSING.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length > 1) {
            VelocityMessages.USAGE.sendList(source, null, new Placeholder("%prefix%", VelocityMessages.PREFIX.color()));
            return;
        }
        if (this.instance.getServer().getAllPlayers().toString().contains(((String[])invocation.arguments())[0])) {
            String suspect_group;
            String admin_group;
            Optional<RegisteredServer> proxyServer;
            Optional player = this.instance.getServer().getPlayer(((String[])invocation.arguments())[0]);
            Player sender = (Player)source;
            if (!player.isPresent()) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
                return;
            }
            if (sender.getUniqueId().equals(((Player)player.get()).getUniqueId())) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.YOURSELF.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            for (String blocked_servers : VelocityConfig.CONTROL_BYPASS.getStringList()) {
                if (!this.instance.getServer().getServer(blocked_servers).isPresent() || !((Player)player.get()).getCurrentServer().isPresent()) continue;
                ServerInfo blockedServer = ((RegisteredServer)this.instance.getServer().getServer(blocked_servers).get()).getServerInfo();
                if (!((ServerConnection)((Player)player.get()).getCurrentServer().get()).getServerInfo().equals((Object)blockedServer)) continue;
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.PLAYER_BYPASS_SERVER.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%server%", blockedServer.getName()).replace("%player%", ((Player)player.get()).getUsername())));
                return;
            }
            if (((Player)player.get()).hasPermission(VelocityConfig.BYPASS_PERMISSION.get(String.class))) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.PLAYER_BYPASS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (this.instance.getVelocityVanish() && VelocityConfig.VELOCITYVANISH.get(Boolean.class).booleanValue() && VelocityVanishUtils.isVanished((Player)player.get())) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.PLAYER_BYPASS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (this.instance.getPremiumVanish() && VelocityConfig.PREMIUMVANISH.get(Boolean.class).booleanValue() && PremiumVanishUtils.isVanished((Player)player.get())) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.PLAYER_BYPASS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (this.instance.useLimbo) {
                String suspect_group2;
                String admin_group2;
                if (PlayerCache.getSuspicious().contains(((Player)player.get()).getUniqueId())) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ALREADY.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return;
                }
                if (PlayerCache.getAdministrator().contains(sender.getUniqueId())) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ALREADY.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return;
                }
                if (PlayerCache.getIn_control().get(((Player)player.get()).getUniqueId()) != null && PlayerCache.getIn_control().get(((Player)player.get()).getUniqueId()) == 1) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ALREADY.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return;
                }
                if (luckperms) {
                    String suspectroup_displayname;
                    String admingroup_displayname;
                    LuckPerms api = LuckPermsProvider.get();
                    User admin = api.getUserManager().getUser(sender.getUniqueId());
                    User suspect = api.getUserManager().getUser(((Player)player.get()).getUniqueId());
                    if (admin == null || suspect == null) {
                        return;
                    }
                    Group admingroup = api.getGroupManager().getGroup(admin.getPrimaryGroup());
                    if (admingroup != null) {
                        admingroup_displayname = admingroup.getFriendlyName();
                        if (admingroup_displayname.equalsIgnoreCase("default")) {
                            admingroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                        }
                    } else {
                        admingroup_displayname = "";
                    }
                    admin_group2 = admingroup == null ? "" : admingroup_displayname;
                    Group suspectgroup = api.getGroupManager().getGroup(suspect.getPrimaryGroup());
                    if (suspectgroup != null) {
                        suspectroup_displayname = suspectgroup.getFriendlyName();
                        if (suspectroup_displayname.equalsIgnoreCase("default")) {
                            suspectroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                        }
                    } else {
                        suspectroup_displayname = "";
                    }
                    suspect_group2 = suspectgroup == null ? "" : suspectroup_displayname;
                } else {
                    admin_group2 = "";
                    suspect_group2 = "";
                }
                LimboUtils.spawnPlayerLimbo(sender);
                LimboUtils.spawnPlayerLimbo((Player)player.get());
                this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
                    Utils.startControl((Player)player.get(), sender, null);
                    MessageUtil.sendDiscordMessage((Player)player.get(), sender, VelocityMessages.DISCORD_STARTED.get(String.class).replace("%suspectgroup%", suspect_group2).replace("%admingroup%", admin_group2), VelocityMessages.DISCORD_STARTED_THUMBNAIL.get(String.class));
                }).delay(Duration.ofSeconds(1L)).schedule();
                return;
            }
            List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL.getStringList());
            if (!VelocityConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
                servers = Utils.getOnlineServers(servers);
            }
            if (!(proxyServer = Utils.getBestServer(servers)).isPresent()) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_EXIST.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (PlayerCache.getSuspicious().contains(((Player)player.get()).getUniqueId())) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ALREADY.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (PlayerCache.getAdministrator().contains(sender.getUniqueId())) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ALREADY.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (PlayerCache.getIn_control().get(((Player)player.get()).getUniqueId()) != null && PlayerCache.getIn_control().get(((Player)player.get()).getUniqueId()) == 1) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ALREADY.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            if (luckperms) {
                String suspectroup_displayname;
                String admingroup_displayname;
                LuckPerms api = LuckPermsProvider.get();
                User admin = api.getUserManager().getUser(sender.getUniqueId());
                User suspect = api.getUserManager().getUser(((Player)player.get()).getUniqueId());
                if (admin == null || suspect == null) {
                    return;
                }
                Group admingroup = api.getGroupManager().getGroup(admin.getPrimaryGroup());
                if (admingroup != null) {
                    admingroup_displayname = admingroup.getFriendlyName();
                    if (admingroup_displayname.equalsIgnoreCase("default")) {
                        admingroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                    }
                } else {
                    admingroup_displayname = "";
                }
                admin_group = admingroup == null ? "" : admingroup_displayname;
                Group suspectgroup = api.getGroupManager().getGroup(suspect.getPrimaryGroup());
                if (suspectgroup != null) {
                    suspectroup_displayname = suspectgroup.getFriendlyName();
                    if (suspectroup_displayname.equalsIgnoreCase("default")) {
                        suspectroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                    }
                } else {
                    suspectroup_displayname = "";
                }
                suspect_group = suspectgroup == null ? "" : suspectroup_displayname;
            } else {
                admin_group = "";
                suspect_group = "";
            }
            Utils.startControl((Player)player.get(), sender, proxyServer.get());
            MessageUtil.sendDiscordMessage((Player)player.get(), sender, VelocityMessages.DISCORD_STARTED.get(String.class).replace("%suspectgroup%", suspect_group).replace("%admingroup%", admin_group), VelocityMessages.DISCORD_STARTED_THUMBNAIL.get(String.class));
        } else {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] strings = (String[])invocation.arguments();
        if (Utils.isConsole(invocation.source())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List players = this.instance.getServer().getAllPlayers().stream().map(Player::getUsername).filter(player -> strings.length != 1 || strings[0].isEmpty() || player.toLowerCase().startsWith(strings[0].toLowerCase())).collect(Collectors.toList());
        return CompletableFuture.completedFuture(players);
    }
}

