/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.ChatUtil;
import it.frafol.cleanss.velocity.objects.MessageUtil;
import it.frafol.cleanss.velocity.objects.Placeholder;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;

public class FinishCommand
implements SimpleCommand {
    public final CleanSS instance;

    public FinishCommand(CleanSS instance) {
        this.instance = instance;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        boolean luckperms = this.instance.getServer().getPluginManager().isLoaded("luckperms");
        if (Utils.isConsole(source)) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ONLY_PLAYERS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (!source.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length == 0) {
            VelocityMessages.USAGE.sendList(source, null, new Placeholder("%prefix%", VelocityMessages.PREFIX.color()));
            return;
        }
        if (((String[])invocation.arguments()).length == 1) {
            if (this.instance.getServer().getAllPlayers().toString().contains(((String[])invocation.arguments())[0])) {
                String sus_suffix;
                String sus_prefix;
                String admin_suffix;
                String admin_prefix;
                Optional player = this.instance.getServer().getPlayer(((String[])invocation.arguments())[0]);
                List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
                if (!VelocityConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
                    servers = Utils.getOnlineServers(servers);
                }
                Optional<Object> proxyServer = Utils.getBestServer(servers);
                Player sender = (Player)invocation.source();
                if (VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue()) {
                    proxyServer = Optional.empty();
                }
                if (!player.isPresent()) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
                    return;
                }
                if (!PlayerCache.getSuspicious().contains(((Player)player.get()).getUniqueId())) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_CONTROL.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return;
                }
                if (this.instance.getValue(PlayerCache.getCouples(), sender) == null || this.instance.getValue(PlayerCache.getCouples(), sender) != player.get()) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_CONTROL.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return;
                }
                if (!proxyServer.isPresent()) {
                    return;
                }
                String admin_group = "";
                String suspect_group = "";
                if (luckperms) {
                    String suspectroup_displayname;
                    String admingroup_displayname;
                    LuckPerms api = LuckPermsProvider.get();
                    User admin = api.getUserManager().getUser(sender.getUniqueId());
                    User suspect = api.getUserManager().getUser(((Player)player.get()).getUniqueId());
                    if (admin == null || suspect == null) {
                        return;
                    }
                    Group admingroup = api.getGroupManager().getGroup(admin.getPrimaryGroup());
                    if (admingroup != null) {
                        admingroup_displayname = admingroup.getFriendlyName();
                        if (admingroup_displayname.equalsIgnoreCase("default")) {
                            admingroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                        }
                    } else {
                        admingroup_displayname = "";
                    }
                    admin_group = admingroup == null ? "" : admingroup_displayname;
                    Group suspectgroup = api.getGroupManager().getGroup(suspect.getPrimaryGroup());
                    if (suspectgroup != null) {
                        suspectroup_displayname = suspectgroup.getFriendlyName();
                        if (suspectroup_displayname.equalsIgnoreCase("default")) {
                            suspectroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                        }
                    } else {
                        suspectroup_displayname = "";
                    }
                    String string = suspect_group = suspectgroup == null ? "" : suspectroup_displayname;
                }
                if (luckperms) {
                    LuckPerms api = LuckPermsProvider.get();
                    User admin = api.getUserManager().getUser(((Player)invocation.source()).getUniqueId());
                    User suspect = api.getUserManager().getUser(((Player)player.get()).getUniqueId());
                    if (admin == null) {
                        return;
                    }
                    if (suspect == null) {
                        return;
                    }
                    String prefix1 = admin.getCachedData().getMetaData().getPrefix();
                    String suffix1 = admin.getCachedData().getMetaData().getSuffix();
                    String prefix2 = suspect.getCachedData().getMetaData().getPrefix();
                    String suffix2 = suspect.getCachedData().getMetaData().getSuffix();
                    admin_prefix = prefix1 == null ? "" : prefix1;
                    admin_suffix = suffix1 == null ? "" : suffix1;
                    sus_prefix = prefix2 == null ? "" : prefix2;
                    sus_suffix = suffix2 == null ? "" : suffix2;
                } else {
                    admin_prefix = "";
                    admin_suffix = "";
                    sus_prefix = "";
                    sus_suffix = "";
                }
                if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
                    this.instance.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ADMIN_NOTIFY_FINISH.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", ((Player)invocation.source()).getUsername()).replace("%suspect%", ((Player)player.get()).getUsername()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)).replace("%suspectprefix%", ChatUtil.color(sus_prefix)).replace("%suspectsuffix%", ChatUtil.color(sus_suffix)).replace("%result%", VelocityMessages.CLEAN.color()))));
                }
                Utils.finishControl((Player)player.get(), sender, (RegisteredServer)proxyServer.get());
                this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> sender.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_FINISH_MESSAGE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%suspect%", ((Player)player.get()).getUsername())))).delay((long)VelocityMessages.CONTROL_FINISH_MESSAGE_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule();
                MessageUtil.sendDiscordMessage((Player)player.get(), sender, VelocityMessages.DISCORD_FINISHED.get(String.class).replace("%suspectgroup%", suspect_group).replace("%admingroup%", admin_group), VelocityMessages.CLEAN.get(String.class), VelocityMessages.DISCORD_FINISHED_THUMBNAIL.get(String.class));
            } else {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
            }
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] strings = (String[])invocation.arguments();
        if (Utils.isConsole(invocation.source())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List players = this.instance.getServer().getAllPlayers().stream().map(Player::getUsername).filter(player -> strings.length != 1 || strings[0].isEmpty() || player.toLowerCase().startsWith(strings[0].toLowerCase())).collect(Collectors.toList());
        return CompletableFuture.completedFuture(players);
    }
}

