/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.ChatUtil;
import it.frafol.cleanss.velocity.objects.MessageUtil;
import it.frafol.cleanss.velocity.objects.Placeholder;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;

public class SpectateCommand
implements SimpleCommand {
    public final CleanSS plugin;

    public SpectateCommand(CleanSS plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String admin_displayname;
        String admin_suffix;
        String admin_prefix;
        CommandSource source = invocation.source();
        boolean luckperms = this.plugin.getServer().getPluginManager().getPlugin("luckperms").isPresent();
        if (Utils.isConsole(source)) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ONLY_PLAYERS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        Player player = (Player)source;
        if (!source.hasPermission(VelocityConfig.SPEC_PERMISSION.get(String.class))) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length != 1) {
            VelocityMessages.USAGE.sendList(source, null, new Placeholder("%prefix%", VelocityMessages.PREFIX.color()));
            return;
        }
        if (this.plugin.useLimbo) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.LIMBO_ERROR.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (!this.plugin.getServer().getAllServers().toString().contains(((String[])invocation.arguments())[0])) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.INVALID_SERVER.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%server%", ((String[])invocation.arguments())[0])));
            return;
        }
        if (((String[])invocation.arguments())[0].equalsIgnoreCase("finish") && PlayerCache.getSpectators().contains(player.getUniqueId())) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_SPECTATING.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            PlayerCache.getSpectators().remove(player.getUniqueId());
            this.fallback(player);
            return;
        }
        if (!this.plugin.getServer().getServer(((String[])invocation.arguments())[0]).isPresent()) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.INVALID_SERVER.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%server%", ((String[])invocation.arguments())[0])));
            return;
        }
        RegisteredServer server = (RegisteredServer)this.plugin.getServer().getServer(((String[])invocation.arguments())[0]).get();
        if (!Utils.isInControlServer(server)) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.INVALID_SERVER.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%server%", ((String[])invocation.arguments())[0])));
            return;
        }
        if (PlayerCache.getSpectators().contains(player.getUniqueId()) || PlayerCache.getAdministrator().contains(player.getUniqueId()) || PlayerCache.getSuspicious().contains(player.getUniqueId())) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.IN_CONTROL_ERROR.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.SPECTATING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%server%", ((String[])invocation.arguments())[0])));
        PlayerCache.getSpectators().add(player.getUniqueId());
        player.createConnectionRequest(server).fireAndForget();
        if (luckperms) {
            LuckPerms api = LuckPermsProvider.get();
            User admin = api.getUserManager().getUser(player.getUniqueId());
            if (admin == null) {
                return;
            }
            String prefix = admin.getCachedData().getMetaData().getPrefix();
            String suffix = admin.getCachedData().getMetaData().getSuffix();
            String displayname = admin.getCachedData().getMetaData().getPrimaryGroup();
            admin_prefix = prefix == null ? "" : prefix;
            admin_suffix = suffix == null ? "" : suffix;
            admin_displayname = displayname == null ? "" : displayname;
        } else {
            admin_prefix = "";
            admin_suffix = "";
            admin_displayname = "";
        }
        MessageUtil.sendDiscordSpectatorMessage(player, VelocityMessages.DISCORD_SPECTATOR.color().replace("%staffer%", player.getUsername()).replace("%server%", server.getServerInfo().getName()).replace("%controls%", String.valueOf(PlayerCache.getSuspicious().size())).replace("%admingroup%", admin_displayname), VelocityMessages.DISCORD_SPECTATOR_THUMBNAIL.color());
        if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
            this.plugin.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.SPECT_ADMIN_NOTIFY.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", player.getUsername()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)))));
        }
    }

    private void fallback(Player player) {
        Optional<RegisteredServer> proxyServer;
        List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
        if (!VelocityConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
            servers = Utils.getOnlineServers(servers);
        }
        if (!(proxyServer = Utils.getBestServer(servers)).isPresent()) {
            return;
        }
        player.createConnectionRequest(proxyServer.get()).fireAndForget();
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] strings = (String[])invocation.arguments();
        if (Utils.isConsole(invocation.source())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List servers = VelocityConfig.CONTROL.getStringList().stream().filter(string -> strings.length != 1 || strings[0].isEmpty() || string.toLowerCase().startsWith(strings[0].toLowerCase())).collect(Collectors.toList());
        return CompletableFuture.completedFuture(servers);
    }
}

