/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.ChatUtil;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;

public class ChatListener {
    public final CleanSS instance;

    public ChatListener(CleanSS instance) {
        this.instance = instance;
    }

    @Subscribe
    public void onChat(PlayerChatEvent event) {
        String user_suffix;
        String user_prefix;
        Player player = event.getPlayer();
        boolean luckperms = this.instance.getServer().getPluginManager().getPlugin("luckperms").isPresent();
        if (player.getCurrentServer().isEmpty()) {
            return;
        }
        if (!Utils.isInControlServer(((ServerConnection)player.getCurrentServer().get()).getServer())) {
            return;
        }
        if (PlayerCache.getSpectators().contains(player.getUniqueId()) && !VelocityConfig.CHAT_DISABLED.get(Boolean.class).booleanValue()) {
            return;
        }
        if (PlayerCache.getSpectators().contains(player.getUniqueId())) {
            player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CHAT_DISABLED.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            if (player.getProtocolVersion().getProtocol() < ProtocolVersion.getProtocolVersion((int)759).getProtocol() || this.instance.getUnsignedVelocityAddon()) {
                event.setResult(PlayerChatEvent.ChatResult.denied());
            }
            return;
        }
        if (player.getProtocolVersion().getProtocol() < ProtocolVersion.getProtocolVersion((int)759).getProtocol() || this.instance.getUnsignedVelocityAddon()) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
        }
        if (luckperms) {
            LuckPerms api = LuckPermsProvider.get();
            User user = api.getUserManager().getUser(player.getUniqueId());
            if (user == null) {
                return;
            }
            String prefix = user.getCachedData().getMetaData().getPrefix();
            String suffix = user.getCachedData().getMetaData().getSuffix();
            user_prefix = prefix == null ? "" : prefix;
            user_suffix = suffix == null ? "" : suffix;
        } else {
            user_suffix = "";
            user_prefix = "";
        }
        if (PlayerCache.getCouples().containsKey(player)) {
            this.instance.getValue(PlayerCache.getCouples(), player).sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_CHAT_FORMAT.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", player.getUsername()).replace("%message%", event.getMessage()).replace("%userprefix%", ChatUtil.color(user_prefix)).replace("%usersuffix%", ChatUtil.color(user_suffix)).replace("%state%", VelocityMessages.CONTROL_CHAT_STAFF.color())));
            player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_CHAT_FORMAT.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", player.getUsername()).replace("%message%", event.getMessage()).replace("%userprefix%", ChatUtil.color(user_prefix)).replace("%usersuffix%", ChatUtil.color(user_suffix)).replace("%state%", VelocityMessages.CONTROL_CHAT_STAFF.color())));
            this.instance.getServer().getAllPlayers().stream().filter(players -> PlayerCache.getSpectators().contains(players.getUniqueId())).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_CHAT_FORMAT.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", player.getUsername()).replace("%message%", event.getMessage()).replace("%userprefix%", ChatUtil.color(user_prefix)).replace("%usersuffix%", ChatUtil.color(user_suffix)).replace("%state%", VelocityMessages.CONTROL_CHAT_STAFF.color()))));
            return;
        }
        if (PlayerCache.getCouples().containsValue(player)) {
            this.instance.getKey(PlayerCache.getCouples(), player).sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_CHAT_FORMAT.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", player.getUsername()).replace("%message%", event.getMessage()).replace("%userprefix%", ChatUtil.color(user_prefix)).replace("%usersuffix%", ChatUtil.color(user_suffix)).replace("%state%", VelocityMessages.CONTROL_CHAT_SUS.color())));
            player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_CHAT_FORMAT.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", player.getUsername()).replace("%message%", event.getMessage()).replace("%userprefix%", ChatUtil.color(user_prefix)).replace("%usersuffix%", ChatUtil.color(user_suffix)).replace("%state%", VelocityMessages.CONTROL_CHAT_SUS.color())));
            this.instance.getServer().getAllPlayers().stream().filter(players -> PlayerCache.getSpectators().contains(players.getUniqueId())).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_CHAT_FORMAT.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", player.getUsername()).replace("%message%", event.getMessage()).replace("%userprefix%", ChatUtil.color(user_prefix)).replace("%usersuffix%", ChatUtil.color(user_suffix)).replace("%state%", VelocityMessages.CONTROL_CHAT_SUS.color()))));
        }
    }
}

