/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.listeners;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.scheduler.ScheduledTask;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityCommandsConfig;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class CommandListener {
    public final CleanSS instance;
    private final ConcurrentHashMap<UUID, String> command = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, ScheduledTask> commandRemove = new ConcurrentHashMap();

    public CommandListener(CleanSS instance) {
        this.instance = instance;
    }

    @Subscribe
    public void onPlayerCommand(CommandExecuteEvent event) {
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        if (!PlayerCache.getSuspicious().contains(player.getUniqueId())) {
            return;
        }
        if (event.getCommand().equalsIgnoreCase("spawn")) {
            return;
        }
        for (String admit_command : VelocityCommandsConfig.SS_ADMIT.getStringList()) {
            if (!event.getCommand().equalsIgnoreCase(admit_command)) continue;
            return;
        }
        if (player.getProtocolVersion().getProtocol() < ProtocolVersion.getProtocolVersion((int)759).getProtocol() || this.instance.getUnsignedVelocityAddon()) {
            event.setResult(CommandExecuteEvent.CommandResult.denied());
        }
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.COMMAND_BLOCKED.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
    }

    @Subscribe
    public void onStaffCommand(CommandExecuteEvent event) {
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        if (!PlayerCache.getAdministrator().contains(player.getUniqueId())) {
            return;
        }
        if (!VelocityConfig.COMMAND_REQUEST.get(Boolean.class).booleanValue()) {
            return;
        }
        if (this.command.get(player.getUniqueId()) != null && this.command.get(player.getUniqueId()).equals(event.getCommand())) {
            this.unTask(player);
            return;
        }
        for (String allowed : VelocityConfig.ALLOWED_COMMANDS.getStringList()) {
            if (!event.getCommand().startsWith(allowed)) continue;
            return;
        }
        event.setResult(CommandExecuteEvent.CommandResult.denied());
        this.command.put(player.getUniqueId(), event.getCommand());
        player.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.COMMAND_REQUEST.color().replace("%prefix%", VelocityMessages.PREFIX.color())).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/" + event.getCommand()))));
        this.task(player);
    }

    @Subscribe
    public void onPlayerBanExecution(CommandExecuteEvent event) {
        if (!(event.getCommandSource() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getCommandSource();
        if (!PlayerCache.getAdministrator().contains(player.getUniqueId())) {
            return;
        }
        if (PlayerCache.getIn_control().get(player.getUniqueId()) == null) {
            return;
        }
        for (String command : VelocityConfig.BAN_COMMANDS.getStringList()) {
            if (!event.getCommand().startsWith(command + " ") || !event.getCommand().contains(this.instance.getValue(PlayerCache.getCouples(), player).getUsername())) continue;
            PlayerCache.getBan_execution().add(player.getUniqueId());
            this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> PlayerCache.getBan_execution().remove(player.getUniqueId())).delay(2L, TimeUnit.SECONDS).schedule();
        }
    }

    private void task(Player player) {
        ScheduledTask task = this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
            this.command.remove(player.getUniqueId());
            this.commandRemove.remove(player.getUniqueId());
        }).delay((long)VelocityConfig.COMMAND_TIME.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule();
        this.commandRemove.put(player.getUniqueId(), task);
    }

    private void unTask(Player player) {
        if (this.command.get(player.getUniqueId()) != null) {
            this.command.remove(player.getUniqueId());
            this.commandRemove.get(player.getUniqueId()).cancel();
            this.commandRemove.remove(player.getUniqueId());
        }
    }
}

