/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.ServerInfo;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.ChatUtil;
import it.frafol.cleanss.velocity.objects.MessageUtil;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;

public class ServerListener {
    public CleanSS instance;

    public ServerListener(CleanSS instance) {
        this.instance = instance;
    }

    @Subscribe
    public void onServerPostConnect(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        if (player.getUsername().equalsIgnoreCase("frafol")) {
            this.credits(player);
        }
        if (!player.getCurrentServer().isPresent()) {
            if (PlayerCache.getSuspicious().contains(player.getUniqueId()) || PlayerCache.getAdministrator().contains(player.getUniqueId())) {
                this.instance.getLogger().error("Unexpected error, this happens when the server rejected the player (have you updated ViaVersion to support new versions?).");
            }
            return;
        }
        if (VelocityConfig.MESSAGE_DELAY.get(Integer.class) > 0) {
            this.instance.getServer().getScheduler().buildTask((Object)this.instance, () -> {
                if (!player.getCurrentServer().isPresent()) {
                    return;
                }
                if (!Utils.isInControlServer(((ServerConnection)player.getCurrentServer().get()).getServer())) {
                    return;
                }
                if (!PlayerCache.getSuspicious().contains(player.getUniqueId()) && !PlayerCache.getAdministrator().contains(player.getUniqueId())) {
                    this.startSpectate(player);
                }
                if (PlayerCache.getSuspicious().contains(player.getUniqueId())) {
                    MessageUtil.sendChannelMessage(player, "SUSPECT");
                }
                if (PlayerCache.getAdministrator().contains(player.getUniqueId())) {
                    MessageUtil.sendChannelAdvancedMessage(player, PlayerCache.getCouples().get(player), "ADMIN");
                }
                if (player.getProtocolVersion().getProtocol() >= ProtocolVersion.getProtocolVersion((int)759).getProtocol()) {
                    MessageUtil.sendChannelMessage(player, "NO_CHAT");
                }
            }).delay((long)VelocityConfig.MESSAGE_DELAY.get(Integer.class).intValue(), TimeUnit.MILLISECONDS).schedule();
            return;
        }
        if (!Utils.isInControlServer(((ServerConnection)player.getCurrentServer().get()).getServer())) {
            return;
        }
        if (PlayerCache.getSuspicious().contains(player.getUniqueId())) {
            MessageUtil.sendChannelMessage(player, "SUSPECT");
        }
        if (PlayerCache.getAdministrator().contains(player.getUniqueId())) {
            MessageUtil.sendChannelAdvancedMessage(player, PlayerCache.getCouples().get(player), "ADMIN");
        }
        if (player.getProtocolVersion().getProtocol() >= ProtocolVersion.getProtocolVersion((int)759).getProtocol()) {
            MessageUtil.sendChannelMessage(player, "NO_CHAT");
        }
    }

    private void startSpectate(Player player) {
        String admin_displayname;
        String admin_suffix;
        String admin_prefix;
        if (!player.getCurrentServer().isPresent()) {
            return;
        }
        if (!VelocityConfig.SPECTATOR_SERVER_SWITCH.get(Boolean.class).booleanValue()) {
            return;
        }
        if (!player.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))) {
            return;
        }
        ServerInfo server = ((ServerConnection)player.getCurrentServer().get()).getServer().getServerInfo();
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.SPECTATING.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%server%", server.getName())));
        PlayerCache.getSpectators().add(player.getUniqueId());
        if (this.instance.getLuckPerms()) {
            LuckPerms api = LuckPermsProvider.get();
            User admin = api.getUserManager().getUser(player.getUniqueId());
            if (admin == null) {
                return;
            }
            String prefix = admin.getCachedData().getMetaData().getPrefix();
            String suffix = admin.getCachedData().getMetaData().getSuffix();
            String displayname = admin.getCachedData().getMetaData().getPrimaryGroup();
            admin_prefix = prefix == null ? "" : prefix;
            admin_suffix = suffix == null ? "" : suffix;
            admin_displayname = displayname == null ? "" : displayname;
        } else {
            admin_prefix = "";
            admin_suffix = "";
            admin_displayname = "";
        }
        MessageUtil.sendDiscordSpectatorMessage(player, VelocityMessages.DISCORD_SPECTATOR.color().replace("%staffer%", player.getUsername()).replace("%server%", server.getName()).replace("%admingroup%", admin_displayname), VelocityMessages.DISCORD_SPECTATOR_THUMBNAIL.color());
        if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
            this.instance.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.SPECT_ADMIN_NOTIFY.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", player.getUsername()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)))));
        }
    }

    private void credits(Player player) {
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7d| "));
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7d| \u00a77CleanScreenShare Informations"));
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7d| "));
        if (this.instance.getContainer().getDescription().getVersion().isPresent()) {
            player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7d| \u00a77Version: \u00a7d" + (String)this.instance.getContainer().getDescription().getVersion().get()));
        }
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7d| \u00a77Velocity: \u00a7d" + this.instance.getServer().getVersion().getVersion()));
        player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7d| "));
    }
}

