/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityCommandsConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.Placeholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.simpleyaml.configuration.ConfigurationSection;

public final class ChatUtil {
    private static final CleanSS instance = CleanSS.getInstance();

    public static List<String> getStringList(VelocityMessages velocityMessages) {
        return instance.getMessagesTextFile().getConfig().getStringList(velocityMessages.getPath());
    }

    public static List<String> getStringList(VelocityMessages velocityMessages, Placeholder ... placeholders) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : ChatUtil.getStringList(velocityMessages)) {
            s = ChatUtil.applyPlaceHolder(s, placeholders);
            newList.add(s);
        }
        return newList;
    }

    public static String applyPlaceHolder(String s, Placeholder ... placeholders) {
        for (Placeholder placeholder : placeholders) {
            if (placeholder == null) continue;
            s = s.replace(placeholder.getKey(), placeholder.getValue());
        }
        return s;
    }

    public static String color(String string) {
        String hex = ChatUtil.convertHexColors(string);
        return hex.replace("&", "\u00a7");
    }

    private static String convertHexColors(String message) {
        if (!ChatUtil.containsHexColor(message)) {
            return message;
        }
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String hexCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = hexCode.replace('#', 'x');
            char[] ch = replaceSharp.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char c : ch) {
                builder.append("&").append(c);
            }
            message = message.replace(hexCode, builder.toString());
            matcher = pattern.matcher(message);
        }
        return message;
    }

    private static boolean containsHexColor(String message) {
        String hexColorPattern = "(?i)&#[a-f0-9]{6}";
        return message.matches(".*" + hexColorPattern + ".*");
    }

    public static List<String> color(List<String> list) {
        return list.stream().map(ChatUtil::color).collect(Collectors.toList());
    }

    public static void sendList(VelocityMessages velocityMessages, CommandSource commandSource, Placeholder ... placeholders) {
        ChatUtil.sendList(commandSource, ChatUtil.color(ChatUtil.getStringList(velocityMessages, placeholders)));
    }

    public static void sendCompiledButtons(VelocityMessages velocityMessages, CommandSource commandSource, Player player_name, Placeholder ... placeholders) {
        ChatUtil.sendButtons(commandSource, ChatUtil.color(ChatUtil.getStringList(velocityMessages, placeholders)), player_name);
    }

    public static void sendList(CommandSource commandSource, List<String> stringList) {
        for (String message : stringList) {
            if (!ChatUtil.containsCommand(message).equals("none")) {
                commandSource.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)("/" + ChatUtil.containsCommand(message) + " "))));
                continue;
            }
            commandSource.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message));
        }
    }

    public static void sendButtons(CommandSource commandSource, List<String> stringList, Player player_name) {
        if (!VelocityMessages.CONTROL_USEVERTICALFORMAT.get(Boolean.class).booleanValue()) {
            ChatUtil.sendHorizontalButtons(commandSource, stringList, player_name);
            return;
        }
        for (String message : stringList) {
            if (ChatUtil.getButton(message) == null) {
                commandSource.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message));
                continue;
            }
            String button = ChatUtil.getButton(message);
            ClickEvent.Action action = ClickEvent.Action.SUGGEST_COMMAND;
            if (VelocityMessages.BUTTON_EXECUTION.get(Boolean.class).booleanValue()) {
                action = ClickEvent.Action.RUN_COMMAND;
            }
            commandSource.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message.replace("%" + button + "name%", ChatUtil.color(instance.getMessagesTextFile().getConfig().getString("messages.staff_message.buttons." + button + ".name")))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)action, (String)instance.getMessagesTextFile().getConfig().getString("messages.staff_message.buttons." + button + ".command").replace("%player%", player_name.getUsername()))));
        }
    }

    private static void sendHorizontalButtons(CommandSource commandSource, List<String> stringList, Player player_name) {
        ArrayList<TextComponent> buttons = new ArrayList<TextComponent>();
        for (String message : stringList) {
            if (message.contains("%buttons%")) {
                for (String key : ChatUtil.getButtons(player_name).keySet()) {
                    TextComponent button = (TextComponent)((TextComponent)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(key).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)ChatUtil.getButtons(player_name).get(key).replace("%player%", player_name.getUsername())))).append((Component)Component.text((String)" "));
                    buttons.add(button);
                }
                TextComponent.Builder builder = Component.text();
                for (TextComponent component : buttons) {
                    builder.append((Component)component);
                }
                commandSource.sendMessage((Component)builder.build());
                continue;
            }
            commandSource.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message));
        }
    }

    private static String getButton(String message) {
        ConfigurationSection buttons = instance.getMessagesTextFile().getConfig().getConfigurationSection("messages.staff_message.buttons");
        for (String button : buttons.getKeys(false)) {
            if (!message.contains("%" + button + "name%")) continue;
            return button;
        }
        return null;
    }

    private static HashMap<String, String> getButtons(Player suspect) {
        HashMap<String, String> buttons = new HashMap<String, String>();
        for (String button : instance.getMessagesTextFile().getConfig().getStringList("messages.staff_message.buttons")) {
            buttons.put(instance.getMessagesTextFile().getConfig().getString("messages.staff_message.buttons." + button + ".name"), instance.getMessagesTextFile().getConfig().getString("messages.staff_message.buttons." + button + ".command").replace("%player%", suspect.getUsername()));
        }
        return buttons;
    }

    public static String getCommand(String input) {
        int slashIndex = input.indexOf("/");
        if (slashIndex == -1 || slashIndex == input.length() - 1) {
            return input;
        }
        int spaceIndex = input.indexOf(" ", slashIndex);
        if (spaceIndex == -1) {
            spaceIndex = input.length();
        }
        return input.substring(slashIndex + 1, spaceIndex).trim();
    }

    private static String containsCommand(String message) {
        String foundCommand = ChatUtil.getCommand(message);
        for (String command : VelocityCommandsConfig.SS_PLAYER.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : VelocityCommandsConfig.SS_SPECTATE.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : VelocityCommandsConfig.SS_FINISH.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : VelocityCommandsConfig.SS_ADMIT.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        for (String command : VelocityCommandsConfig.SS_INFO.getStringList()) {
            if (!foundCommand.equalsIgnoreCase(command)) continue;
            return command;
        }
        if (foundCommand.equalsIgnoreCase("ssreload")) {
            return foundCommand;
        }
        return "none";
    }

    @Generated
    private ChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

