/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityLimbo;
import it.frafol.cleanss.velocity.handlers.LimboHandler;
import java.io.File;
import lombok.Generated;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.chunk.Dimension;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.file.BuiltInWorldFileType;
import net.elytrium.limboapi.api.file.WorldFile;
import net.elytrium.limboapi.api.player.GameMode;
import net.elytrium.limboapi.api.player.LimboPlayer;

public final class LimboUtils {
    private static final CleanSS instance = CleanSS.getInstance();
    private static Limbo limbo;

    public static void disconnect(Player player, RegisteredServer proxyServer) {
        LimboPlayer limboPlayer = LimboHandler.limbo_players.get(player);
        limboPlayer.getScheduledExecutor().execute(() -> limboPlayer.disconnect(proxyServer));
    }

    public static void loadLimbo() {
        LimboUtils.instance.useLimbo = true;
        if (instance.getServer().getPluginManager().getPlugin("limboapi").flatMap(PluginContainer::getInstance).isPresent()) {
            LimboFactory factory = (LimboFactory)instance.getServer().getPluginManager().getPlugin("limboapi").flatMap(PluginContainer::getInstance).get();
            VirtualWorld world = factory.createVirtualWorld(Dimension.valueOf((String)VelocityLimbo.DIMENSION.get(String.class).toUpperCase()), (double)VelocityLimbo.X.get(Integer.class).intValue(), (double)VelocityLimbo.Y.get(Integer.class).intValue(), (double)VelocityLimbo.Z.get(Integer.class).intValue(), (float)VelocityLimbo.YAW.get(Integer.class).intValue(), (float)VelocityLimbo.PITCH.get(Integer.class).intValue());
            if (VelocityLimbo.SCHEMATIC_USE.get(Boolean.class).booleanValue()) {
                File file = new File(String.valueOf(instance.getPath()) + "/" + VelocityLimbo.SCHEMATIC_FILE.get(String.class));
                WorldFile schematic = switch (VelocityLimbo.SCHEMATIC_TYPE.get(String.class)) {
                    case "SCHEMATIC" -> factory.openWorldFile(BuiltInWorldFileType.SCHEMATIC, file.toPath());
                    case "WORLDEDIT_SCHEM" -> factory.openWorldFile(BuiltInWorldFileType.WORLDEDIT_SCHEM, file.toPath());
                    case "STRUCTURE" -> factory.openWorldFile(BuiltInWorldFileType.STRUCTURE, file.toPath());
                    default -> null;
                };
                if (schematic != null) {
                    schematic.toWorld(factory, world, VelocityLimbo.SCHEM_X.get(Integer.class).intValue(), VelocityLimbo.SCHEM_Y.get(Integer.class).intValue(), VelocityLimbo.SCHEM_Z.get(Integer.class).intValue());
                }
            }
            limbo = factory.createLimbo(world).setName("CleanScreenShare").setShouldRejoin(true).setShouldRespawn(true).setGameMode(switch (VelocityLimbo.GAMEMODE.get(String.class)) {
                case "survival" -> GameMode.SURVIVAL;
                case "creative" -> GameMode.CREATIVE;
                case "adventure" -> GameMode.ADVENTURE;
                case "spectator" -> GameMode.SPECTATOR;
                default -> {
                    instance.getLogger().warn("Invalid Limbo GameMode specified in limboapi.yml. Defaulting to survival.");
                    yield GameMode.SURVIVAL;
                }
            });
            instance.getLogger().info("LimboAPI hooked successfully!");
        }
    }

    public static void spawnPlayerLimbo(Player player) {
        LimboUtils.getLimbo().spawnPlayer(player, (LimboSessionHandler)new LimboHandler(player, instance));
    }

    @Generated
    private LimboUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Limbo getLimbo() {
        return limbo;
    }
}

