/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.ChatUtil;
import it.frafol.cleanss.velocity.objects.Placeholder;
import java.awt.Color;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;

public final class MessageUtil {
    private static final CleanSS instance = CleanSS.getInstance();

    public static void sendDiscordSpectatorMessage(Player player, String message, String thumbnail) {
        if (VelocityConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            if (instance.getJda() == null) {
                return;
            }
            if (instance.getJda().getJda() == null) {
                return;
            }
            TextChannel channel = instance.getJda().getJda().getTextChannelById(VelocityConfig.DISCORD_CHANNEL_ID.get(String.class));
            if (channel == null) {
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle(VelocityConfig.DISCORD_EMBED_TITLE.get(String.class), null);
            embed.setDescription((CharSequence)message.replace("%staffer%", player.getUsername()));
            embed.setColor(Color.RED);
            embed.setFooter(VelocityConfig.DISCORD_EMBED_FOOTER.get(String.class));
            if (!thumbnail.equals("none")) {
                embed.setThumbnail(thumbnail);
            }
            if (!VelocityConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class).equals("none")) {
                embed.setFooter(VelocityConfig.DISCORD_EMBED_FOOTER.get(String.class), VelocityConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class));
            }
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        }
    }

    public static void sendDiscordMessage(Player suspect, Player staffer, String message, String thumbnail) {
        if (VelocityConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            if (instance.getJda() == null) {
                return;
            }
            if (instance.getJda().getJda() == null) {
                return;
            }
            TextChannel channel = instance.getJda().getJda().getTextChannelById(VelocityConfig.DISCORD_CHANNEL_ID.get(String.class));
            if (channel == null) {
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle(VelocityConfig.DISCORD_EMBED_TITLE.get(String.class), null);
            embed.setDescription((CharSequence)message.replace("%suspect%", suspect.getUsername()).replace("%staffer%", staffer.getUsername()));
            embed.setColor(Color.RED);
            embed.setFooter(VelocityConfig.DISCORD_EMBED_FOOTER.get(String.class));
            if (!thumbnail.equals("none")) {
                embed.setThumbnail(thumbnail);
            }
            if (!VelocityConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class).equals("none")) {
                embed.setFooter(VelocityConfig.DISCORD_EMBED_FOOTER.get(String.class), VelocityConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class));
            }
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        }
    }

    public static void sendDiscordMessage(Player suspect, Player staffer, String message, String result, String thumbnail) {
        if (VelocityConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            TextChannel channel = instance.getJda().getJda().getTextChannelById(VelocityConfig.DISCORD_CHANNEL_ID.get(String.class));
            if (channel == null) {
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle(VelocityConfig.DISCORD_EMBED_TITLE.get(String.class), null);
            embed.setDescription((CharSequence)message.replace("%suspect%", suspect.getUsername()).replace("%staffer%", staffer.getUsername()).replace("%result%", result));
            embed.setColor(Color.RED);
            embed.setFooter(VelocityConfig.DISCORD_EMBED_FOOTER.get(String.class));
            if (!thumbnail.equals("none")) {
                embed.setThumbnail(thumbnail);
            }
            if (!VelocityConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class).equals("none")) {
                embed.setFooter(VelocityConfig.DISCORD_EMBED_FOOTER.get(String.class), VelocityConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class));
            }
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        }
    }

    public static void sendChannelMessage(Player player, String type) {
        try {
            ByteArrayDataOutput buf = ByteStreams.newDataOutput();
            buf.writeUTF(type);
            buf.writeUTF(player.getUsername());
            player.getCurrentServer().ifPresent(sv -> sv.sendPluginMessage(CleanSS.channel_join, buf.toByteArray()));
        }
        catch (IllegalStateException exception) {
            instance.getLogger().error("Failed to send message for player " + player.getUsername() + ". Connection failed?");
        }
    }

    public static void sendChannelAdvancedMessage(Player administrator, Player suspicious, String type) {
        try {
            ByteArrayDataOutput buf = ByteStreams.newDataOutput();
            buf.writeUTF(type);
            buf.writeUTF(administrator.getUsername());
            buf.writeUTF(suspicious.getUsername());
            administrator.getCurrentServer().ifPresent(sv -> sv.sendPluginMessage(CleanSS.channel_join, buf.toByteArray()));
        }
        catch (IllegalStateException exception) {
            instance.getLogger().error("Failed to send message for players " + administrator.getUsername() + " and " + suspicious.getUsername() + ". Connection failed?");
        }
    }

    public static void sendButtons(Player administrator, Player suspicious, String admin_prefix, String admin_suffix, String sus_prefix, String sus_suffix) {
        instance.getServer().getScheduler().buildTask((Object)instance, () -> {
            if (VelocityMessages.CONTROL_USEVERTICALFORMAT.get(Boolean.class).booleanValue()) {
                VelocityMessages.CONTROL_VERTICALFORMAT.sendButtons((CommandSource)administrator, suspicious, new Placeholder("prefix", VelocityMessages.PREFIX.color()), new Placeholder("suspect", suspicious.getUsername()), new Placeholder("administrator", administrator.getUsername()), new Placeholder("adminprefix", ChatUtil.color(admin_prefix)), new Placeholder("adminsuffix", ChatUtil.color(admin_suffix)), new Placeholder("suspectprefix", ChatUtil.color(sus_prefix)), new Placeholder("suspectsuffix", ChatUtil.color(sus_suffix)));
            } else {
                VelocityMessages.CONTROL_HORIZONTALFORMAT.sendButtons((CommandSource)administrator, suspicious, new Placeholder("prefix", VelocityMessages.PREFIX.color()), new Placeholder("suspect", suspicious.getUsername()), new Placeholder("administrator", administrator.getUsername()), new Placeholder("adminprefix", ChatUtil.color(admin_prefix)), new Placeholder("adminsuffix", ChatUtil.color(admin_suffix)), new Placeholder("suspectprefix", ChatUtil.color(sus_prefix)), new Placeholder("suspectsuffix", ChatUtil.color(sus_suffix)));
            }
        }).delay((long)VelocityMessages.CONTROL_DELAYMESSAGE.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule();
    }

    @Generated
    private MessageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

