/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.handlers.DataHandler;
import it.frafol.cleanss.velocity.objects.ChatUtil;
import it.frafol.cleanss.velocity.objects.LimboUtils;
import it.frafol.cleanss.velocity.objects.MessageUtil;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.ServerUtils;
import it.frafol.cleanss.velocity.objects.TitleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;

public final class Utils {
    private static final CleanSS instance = CleanSS.getInstance();
    private static final HashMap<RegisteredServer, ScheduledTask> task = new HashMap();

    public static void punishPlayer(UUID administrator, String suspicious, Player administrator_user, Player suspect) {
        String sus_suffix;
        String sus_prefix;
        String admin_prefix;
        String admin_suffix;
        boolean luckperms = instance.getServer().getPluginManager().isLoaded("luckperms");
        String admin_group = "";
        String suspect_group = "";
        if (luckperms) {
            String suspectroup_displayname;
            String admingroup_displayname;
            LuckPerms api = LuckPermsProvider.get();
            User admin = api.getUserManager().getUser(administrator_user.getUniqueId());
            User suspect2 = api.getUserManager().getUser(suspect.getUniqueId());
            if (admin == null || suspect2 == null) {
                return;
            }
            Group admingroup = api.getGroupManager().getGroup(admin.getPrimaryGroup());
            if (admingroup != null) {
                admingroup_displayname = admingroup.getFriendlyName();
                if (admingroup_displayname.equalsIgnoreCase("default")) {
                    admingroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                }
            } else {
                admingroup_displayname = "";
            }
            admin_group = admingroup == null ? "" : admingroup_displayname;
            Group suspectgroup = api.getGroupManager().getGroup(suspect2.getPrimaryGroup());
            if (suspectgroup != null) {
                suspectroup_displayname = suspectgroup.getFriendlyName();
                if (suspectroup_displayname.equalsIgnoreCase("default")) {
                    suspectroup_displayname = VelocityMessages.DISCORD_LUCKPERMS_FIX.get(String.class);
                }
            } else {
                suspectroup_displayname = "";
            }
            String string = suspect_group = suspectgroup == null ? "" : suspectroup_displayname;
        }
        if (PlayerCache.getBan_execution().contains(administrator)) {
            if (!PlayerCache.getAdmits().contains(suspect.getUniqueId())) {
                MessageUtil.sendDiscordMessage(suspect, administrator_user, VelocityMessages.DISCORD_FINISHED.get(String.class).replace("%suspectgroup%", suspect_group).replace("%admingroup%", admin_group), VelocityMessages.CHEATER.get(String.class), VelocityMessages.DISCORD_FINISHED_THUMBNAIL.get(String.class));
            } else {
                PlayerCache.getAdmits().remove(suspect.getUniqueId());
                MessageUtil.sendDiscordMessage(suspect, administrator_user, VelocityMessages.DISCORD_FINISHED.get(String.class).replace("%suspectgroup%", suspect_group).replace("%admingroup%", admin_group), VelocityMessages.ADMIT.get(String.class), VelocityMessages.DISCORD_FINISHED_THUMBNAIL.get(String.class));
            }
            if (luckperms) {
                admin_suffix = Utils.getSuffix(administrator_user);
                admin_prefix = Utils.getPrefix(administrator_user);
                sus_prefix = Utils.getPrefix(suspect);
                sus_suffix = Utils.getSuffix(suspect);
            } else {
                admin_prefix = "";
                admin_suffix = "";
                sus_prefix = "";
                sus_suffix = "";
            }
            if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
                instance.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ADMIN_NOTIFY.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", administrator_user.getUsername()).replace("%suspect%", suspect.getUsername()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)).replace("%suspectprefix%", ChatUtil.color(sus_prefix)).replace("%suspectsuffix%", ChatUtil.color(sus_suffix)).replace("%result%", VelocityMessages.CHEATER.color()))));
            }
            return;
        }
        MessageUtil.sendDiscordMessage(suspect, administrator_user, VelocityMessages.DISCORD_QUIT.get(String.class).replace("%suspectgroup%", suspect_group).replace("%admingroup%", admin_group), VelocityMessages.LEFT.get(String.class), VelocityMessages.DISCORD_LEAVE_DURING_CONTROL_THUMBNAIL.get(String.class));
        if (luckperms) {
            admin_suffix = Utils.getSuffix(administrator_user);
            admin_prefix = Utils.getPrefix(administrator_user);
            sus_prefix = Utils.getPrefix(suspect);
            sus_suffix = Utils.getSuffix(suspect);
        } else {
            admin_prefix = "";
            admin_suffix = "";
            sus_prefix = "";
            sus_suffix = "";
        }
        if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
            instance.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ADMIN_NOTIFY.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", administrator_user.getUsername()).replace("%suspect%", suspect.getUsername()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)).replace("%suspectprefix%", ChatUtil.color(sus_prefix)).replace("%suspectsuffix%", ChatUtil.color(sus_suffix)).replace("%result%", VelocityMessages.LEFT.color()))));
        }
        if (!VelocityConfig.SLOG_PUNISH.get(Boolean.class).booleanValue()) {
            return;
        }
        instance.getServer().getCommandManager().executeAsync((CommandSource)instance.getServer().getConsoleCommandSource(), VelocityConfig.SLOG_COMMAND.get(String.class).replace("%player%", suspicious).replace("%admin%", administrator_user.getUsername()));
    }

    public static boolean isInControlServer(RegisteredServer server) {
        for (String string : VelocityConfig.CONTROL.getStringList()) {
            if (!string.equals(server.getServerInfo().getName())) continue;
            return true;
        }
        return false;
    }

    public static String getPrefix(Player player) {
        LuckPerms api = LuckPermsProvider.get();
        User user = api.getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            return null;
        }
        if (user.getCachedData().getMetaData().getPrefix() == null) {
            return "";
        }
        return ChatUtil.color(user.getCachedData().getMetaData().getPrefix());
    }

    public static String getSuffix(Player player) {
        LuckPerms api = LuckPermsProvider.get();
        User user = api.getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            return null;
        }
        if (user.getCachedData().getMetaData().getSuffix() == null) {
            return "";
        }
        return ChatUtil.color(user.getCachedData().getMetaData().getSuffix());
    }

    public static String getGroup(Player player) {
        LuckPerms api = LuckPermsProvider.get();
        User user = api.getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            return null;
        }
        if (user.getCachedData().getMetaData().getPrimaryGroup() == null) {
            return "";
        }
        return ChatUtil.color(user.getCachedData().getMetaData().getPrimaryGroup());
    }

    public static void finishControl(Player suspicious, Player administrator, RegisteredServer proxyServer) {
        if (suspicious == null || administrator == null) {
            return;
        }
        if (suspicious.isActive() && administrator.isActive()) {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getCouples().remove(administrator, suspicious);
            if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
                instance.getData().setInControl(suspicious.getUniqueId(), 0);
                instance.getData().setInControl(administrator.getUniqueId(), 0);
            } else {
                PlayerCache.getIn_control().put(suspicious.getUniqueId(), 0);
                PlayerCache.getIn_control().put(administrator.getUniqueId(), 0);
            }
            if (!suspicious.getCurrentServer().isPresent() && !Utils.instance.useLimbo) {
                return;
            }
            if (Utils.instance.useLimbo || Utils.isInControlServer(((ServerConnection)suspicious.getCurrentServer().get()).getServer())) {
                TitleUtil.sendEndTitle(suspicious);
                TitleUtil.sendAdminEndTitle(administrator, suspicious);
                suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.FINISHSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                if (!VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue() || Utils.instance.useLimbo) {
                    if (Utils.instance.useLimbo) {
                        LimboUtils.disconnect(suspicious, proxyServer);
                    } else {
                        ServerUtils.connect(suspicious, proxyServer);
                    }
                } else {
                    MessageUtil.sendChannelMessage(suspicious, "DISCONNECT_NOW");
                }
                if (!administrator.getCurrentServer().isPresent() && !Utils.instance.useLimbo) {
                    return;
                }
                if (Utils.instance.useLimbo || Utils.isInControlServer(((ServerConnection)administrator.getCurrentServer().get()).getServer())) {
                    if (!VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue() && !VelocityConfig.NOT_FALLBACK_STAFF.get(Boolean.class).booleanValue() || Utils.instance.useLimbo) {
                        if (Utils.instance.useLimbo) {
                            LimboUtils.disconnect(administrator, proxyServer);
                        } else {
                            ServerUtils.connect(administrator, proxyServer);
                        }
                    } else if (!VelocityConfig.NOT_FALLBACK_STAFF.get(Boolean.class).booleanValue()) {
                        MessageUtil.sendChannelMessage(administrator, "DISCONNECT_NOW");
                    }
                }
            }
        } else if (suspicious.isActive()) {
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
                instance.getData().setInControl(suspicious.getUniqueId(), 0);
                instance.getData().setInControl(administrator.getUniqueId(), 0);
            } else {
                PlayerCache.getIn_control().put(suspicious.getUniqueId(), 0);
                PlayerCache.getIn_control().put(administrator.getUniqueId(), 0);
            }
            TitleUtil.sendEndTitle(suspicious);
            suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.FINISHSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            if (!VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue() || Utils.instance.useLimbo) {
                if (Utils.instance.useLimbo) {
                    LimboUtils.disconnect(suspicious, proxyServer);
                } else {
                    ServerUtils.connect(suspicious, proxyServer);
                }
            } else {
                MessageUtil.sendChannelMessage(suspicious, "DISCONNECT_NOW");
            }
            PlayerCache.getCouples().remove(administrator);
        } else if (administrator.isActive()) {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
                instance.getData().setInControl(suspicious.getUniqueId(), 0);
                instance.getData().setInControl(administrator.getUniqueId(), 0);
            } else {
                PlayerCache.getIn_control().put(suspicious.getUniqueId(), 0);
                PlayerCache.getIn_control().put(administrator.getUniqueId(), 0);
            }
            administrator.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.LEAVESUS.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", suspicious.getUsername())));
            if (!VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue() && !VelocityConfig.NOT_FALLBACK_STAFF.get(Boolean.class).booleanValue() || Utils.instance.useLimbo) {
                if (Utils.instance.useLimbo) {
                    LimboUtils.disconnect(administrator, proxyServer);
                } else {
                    ServerUtils.connect(administrator, proxyServer);
                }
            } else if (!VelocityConfig.NOT_FALLBACK_STAFF.get(Boolean.class).booleanValue()) {
                MessageUtil.sendChannelMessage(administrator, "DISCONNECT_NOW");
            }
            PlayerCache.getCouples().remove(administrator);
        } else {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getCouples().remove(administrator);
            if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
                instance.getData().setInControl(suspicious.getUniqueId(), 0);
                instance.getData().setInControl(administrator.getUniqueId(), 0);
            } else {
                PlayerCache.getIn_control().put(suspicious.getUniqueId(), 0);
                PlayerCache.getIn_control().put(administrator.getUniqueId(), 0);
            }
        }
    }

    public static void startControl(Player suspicious, Player administrator, RegisteredServer proxyServer) {
        String sus_prefix;
        String sus_suffix;
        String admin_prefix;
        String admin_suffix;
        boolean luckperms = instance.getServer().getPluginManager().getPlugin("luckperms").isPresent();
        if (luckperms) {
            admin_suffix = Utils.getSuffix(administrator);
            admin_prefix = Utils.getPrefix(administrator);
            sus_suffix = Utils.getSuffix(suspicious);
            sus_prefix = Utils.getPrefix(suspicious);
        } else {
            admin_prefix = "";
            admin_suffix = "";
            sus_prefix = "";
            sus_suffix = "";
        }
        if (admin_prefix == null) {
            admin_prefix = "";
        }
        if (admin_suffix == null) {
            admin_suffix = "";
        }
        if (sus_prefix == null) {
            sus_prefix = "";
        }
        if (sus_suffix == null) {
            sus_suffix = "";
        }
        if (Utils.instance.useLimbo) {
            if (VelocityConfig.CHECK_FOR_PROBLEMS.get(Boolean.class).booleanValue()) {
                PlayerCache.getNow_started_sus().add(suspicious.getUniqueId());
            }
            PlayerCache.getAdministrator().add(administrator.getUniqueId());
            PlayerCache.getSuspicious().add(suspicious.getUniqueId());
            PlayerCache.getCouples().put(administrator, suspicious);
            if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
                instance.getData().setInControl(suspicious.getUniqueId(), 1);
                instance.getData().setInControl(administrator.getUniqueId(), 1);
                if (instance.getData().getStats(administrator.getUniqueId(), "controls") != -1) {
                    instance.getData().setControls(administrator.getUniqueId(), instance.getData().getStats(administrator.getUniqueId(), "controls") + 1);
                }
                if (instance.getData().getStats(suspicious.getUniqueId(), "suffered") != -1) {
                    instance.getData().setControlsSuffered(suspicious.getUniqueId(), instance.getData().getStats(suspicious.getUniqueId(), "suffered") + 1);
                }
            } else {
                PlayerCache.getIn_control().put(suspicious.getUniqueId(), 1);
                PlayerCache.getIn_control().put(administrator.getUniqueId(), 1);
                DataHandler.incrementDone(administrator.getUniqueId());
                DataHandler.incrementSuffered(suspicious.getUniqueId());
            }
            TitleUtil.sendStartTitle(suspicious);
            TitleUtil.sendAdminStartTitle(administrator, suspicious);
            if (VelocityConfig.CHECK_FOR_PROBLEMS.get(Boolean.class).booleanValue()) {
                Utils.checkForErrors(suspicious, administrator, proxyServer);
            }
            if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
                String finalAdmin_prefix = admin_prefix;
                String finalAdmin_suffix = admin_suffix;
                String finalSus_prefix = sus_prefix;
                String finalSus_suffix = sus_suffix;
                instance.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ADMIN_NOTIFY.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", administrator.getUsername()).replace("%suspect%", suspicious.getUsername()).replace("%adminprefix%", ChatUtil.color(finalAdmin_prefix)).replace("%adminsuffix%", ChatUtil.color(finalAdmin_suffix)).replace("%suspectprefix%", ChatUtil.color(finalSus_prefix)).replace("%suspectsuffix%", ChatUtil.color(finalSus_suffix)))));
            }
            suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.MAINSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%administrator%", administrator.getUsername()).replace("%suspect%", suspicious.getUsername()).replace("%adminprefix%", admin_prefix).replace("%adminsuffix%", admin_suffix).replace("%suspectprefix%", sus_prefix).replace("%suspectsuffix%", sus_suffix)));
            MessageUtil.sendButtons(administrator, suspicious, admin_prefix, admin_suffix, sus_prefix, sus_suffix);
            return;
        }
        if (!administrator.getCurrentServer().isPresent()) {
            return;
        }
        if (!suspicious.getCurrentServer().isPresent()) {
            return;
        }
        if (((ServerConnection)administrator.getCurrentServer().get()).getServer() != proxyServer) {
            ServerUtils.connect(administrator, proxyServer);
        } else {
            MessageUtil.sendChannelAdvancedMessage(administrator, suspicious, "ADMIN");
            if (administrator.getProtocolVersion().getProtocol() >= ProtocolVersion.getProtocolVersion((int)759).getProtocol()) {
                MessageUtil.sendChannelMessage(administrator, "NO_CHAT");
            }
        }
        if (((ServerConnection)suspicious.getCurrentServer().get()).getServer() != proxyServer) {
            ServerUtils.connect(suspicious, proxyServer);
        } else {
            MessageUtil.sendChannelMessage(suspicious, "SUSPECT");
            if (suspicious.getProtocolVersion().getProtocol() >= ProtocolVersion.getProtocolVersion((int)759).getProtocol()) {
                MessageUtil.sendChannelMessage(suspicious, "NO_CHAT");
            }
        }
        PlayerCache.getAdministrator().add(administrator.getUniqueId());
        PlayerCache.getSuspicious().add(suspicious.getUniqueId());
        PlayerCache.getCouples().put(administrator, suspicious);
        if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
            instance.getData().setInControl(suspicious.getUniqueId(), 1);
            instance.getData().setInControl(administrator.getUniqueId(), 1);
            if (instance.getData().getStats(administrator.getUniqueId(), "controls") != -1) {
                instance.getData().setControls(administrator.getUniqueId(), instance.getData().getStats(administrator.getUniqueId(), "controls") + 1);
            }
            if (instance.getData().getStats(suspicious.getUniqueId(), "suffered") != -1) {
                instance.getData().setControlsSuffered(suspicious.getUniqueId(), instance.getData().getStats(suspicious.getUniqueId(), "suffered") + 1);
            }
        } else {
            PlayerCache.getIn_control().put(suspicious.getUniqueId(), 1);
            PlayerCache.getIn_control().put(administrator.getUniqueId(), 1);
            DataHandler.incrementDone(administrator.getUniqueId());
            DataHandler.incrementSuffered(suspicious.getUniqueId());
        }
        TitleUtil.sendStartTitle(suspicious);
        TitleUtil.sendAdminStartTitle(administrator, suspicious);
        if (VelocityConfig.CHECK_FOR_PROBLEMS.get(Boolean.class).booleanValue()) {
            Utils.checkForErrors(suspicious, administrator, proxyServer);
        }
        if (VelocityConfig.SEND_ADMIN_MESSAGE.get(Boolean.class).booleanValue()) {
            String finalAdmin_prefix1 = admin_prefix;
            String finalAdmin_suffix1 = admin_suffix;
            String finalSus_prefix1 = sus_prefix;
            String finalSus_suffix1 = sus_suffix;
            instance.getServer().getAllPlayers().stream().filter(players -> players.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))).forEach(players -> players.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ADMIN_NOTIFY.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%admin%", administrator.getUsername()).replace("%suspect%", suspicious.getUsername()).replace("%adminprefix%", ChatUtil.color(finalAdmin_prefix1)).replace("%adminsuffix%", ChatUtil.color(finalAdmin_suffix1)).replace("%suspectprefix%", ChatUtil.color(finalSus_prefix1)).replace("%suspectsuffix%", ChatUtil.color(finalSus_suffix1)))));
        }
        suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.MAINSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%administrator%", administrator.getUsername()).replace("%suspect%", suspicious.getUsername()).replace("%adminprefix%", ChatUtil.color(admin_prefix)).replace("%adminsuffix%", ChatUtil.color(admin_suffix)).replace("%suspectprefix%", ChatUtil.color(sus_prefix)).replace("%suspectsuffix%", ChatUtil.color(sus_suffix))));
        MessageUtil.sendButtons(administrator, suspicious, admin_prefix, admin_suffix, sus_prefix, sus_suffix);
    }

    public static void sendAdmit(Player suspicious, Player administrator) {
        suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ADMITSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
        administrator.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_ADMIT_MESSAGE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%suspect%", suspicious.getUsername())));
        PlayerCache.getAdmits().add(suspicious.getUniqueId());
        if (VelocityMessages.CONTROL_ADMIT_RESENDBUTTONS.get(Boolean.class).booleanValue()) {
            String sus_prefix;
            String sus_suffix;
            String admin_prefix;
            String admin_suffix;
            boolean luckperms = instance.getServer().getPluginManager().getPlugin("luckperms").isPresent();
            if (luckperms) {
                admin_suffix = Utils.getSuffix(administrator);
                admin_prefix = Utils.getPrefix(administrator);
                sus_suffix = Utils.getSuffix(suspicious);
                sus_prefix = Utils.getPrefix(suspicious);
            } else {
                admin_prefix = "";
                admin_suffix = "";
                sus_prefix = "";
                sus_suffix = "";
            }
            if (admin_prefix == null) {
                admin_prefix = "";
            }
            if (admin_suffix == null) {
                admin_suffix = "";
            }
            if (sus_prefix == null) {
                sus_prefix = "";
            }
            if (sus_suffix == null) {
                sus_suffix = "";
            }
            MessageUtil.sendButtons(administrator, suspicious, admin_prefix, admin_suffix, sus_prefix, sus_suffix);
            MessageUtil.sendDiscordMessage(suspicious, administrator, VelocityMessages.DISCORD_ADMIT.get(String.class).replace("%suspectgroup%", Utils.getGroup(suspicious)).replace("%admingroup%", Utils.getGroup(administrator)), VelocityMessages.DISCORD_ADMIT_THUMBNAIL.get(String.class));
        }
    }

    private static void checkForErrors(Player suspicious, Player administrator, RegisteredServer proxyServer) {
        instance.getServer().getScheduler().buildTask((Object)instance, () -> {
            Optional<RegisteredServer> fallbackServer;
            if (Utils.instance.useLimbo) {
                PlayerCache.getNow_started_sus().remove(suspicious.getUniqueId());
                return;
            }
            if (!PlayerCache.getSuspicious().contains(suspicious.getUniqueId()) || !PlayerCache.getAdministrator().contains(administrator.getUniqueId())) {
                return;
            }
            if (!suspicious.getCurrentServer().isPresent() || !administrator.getCurrentServer().isPresent()) {
                return;
            }
            if (proxyServer == null) {
                return;
            }
            if (((ServerConnection)suspicious.getCurrentServer().get()).getServer().equals(proxyServer) && ((ServerConnection)administrator.getCurrentServer().get()).getServer().equals(proxyServer)) {
                return;
            }
            List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
            if (!VelocityConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
                servers = Utils.getOnlineServers(servers);
            }
            if (!(fallbackServer = Utils.getBestServer(servers)).isPresent()) {
                suspicious.disconnect((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("Your control server is not configured correctly or is crashed, please check the configuration file. The Control cannot be handled!"));
                administrator.disconnect((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("Your control server is not configured correctly or is crashed, please check the configuration file. The Control cannot be handled!"));
                return;
            }
            Utils.finishControl(suspicious, administrator, fallbackServer.get());
            administrator.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_EXIST.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            instance.getLogger().error("Your control server is not configured correctly or is crashed, please check the configuration file. The Control cannot be handled!");
        }).delay(2L, TimeUnit.SECONDS).schedule();
    }

    public static boolean isConsole(CommandSource invocation) {
        return !(invocation instanceof Player);
    }

    public static List<Optional<RegisteredServer>> getServerList(List<String> stringList) {
        ArrayList<Optional<RegisteredServer>> servers = new ArrayList<Optional<RegisteredServer>>();
        for (String server : stringList) {
            if (!instance.getServer().getServer(server).isPresent()) {
                if (VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue()) continue;
                instance.getLogger().error(VelocityMessages.NOT_VALID.color().replace("%server%", server));
                continue;
            }
            servers.add(instance.getServer().getServer(server));
        }
        return servers;
    }

    public static Optional<RegisteredServer> getBestServer(List<Optional<RegisteredServer>> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        switch (VelocityConfig.STRATEGY.get(String.class)) {
            case "RANDOM": {
                return Utils.getRandomServer(list);
            }
            case "LEAST_PLAYERS": {
                return Utils.getLeastPlayersServer(list);
            }
            case "MOST_PLAYERS": {
                return Utils.getMostPlayersServer(list);
            }
        }
        instance.getLogger().error("The strategy '" + VelocityConfig.STRATEGY.get(String.class) + "' is not valid, using 'RANDOM' instead.");
        return Utils.getRandomServer(list);
    }

    public static List<Optional<RegisteredServer>> getOnlineServers(List<Optional<RegisteredServer>> list) {
        ArrayList<Optional<RegisteredServer>> servers = new ArrayList<Optional<RegisteredServer>>();
        for (Optional<RegisteredServer> server : list) {
            if (!server.isPresent()) {
                return null;
            }
            if (!PlayerCache.getOnlineServers().contains(server.get())) continue;
            servers.add(server);
        }
        return servers;
    }

    public static void startTask(RegisteredServer server) {
        Utils.taskServer(server);
    }

    public static void stopTask(RegisteredServer server) {
        if (task.get(server) != null) {
            task.get(server).cancel();
        }
        task.remove(server);
        PlayerCache.getOnlineServers().remove(server);
    }

    private static void taskServer(RegisteredServer server) {
        if (VelocityConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
            return;
        }
        task.put(server, instance.getServer().getScheduler().buildTask((Object)instance, () -> server.ping().whenComplete((result, throwable) -> {
            if (instance.getConfigTextFile() == null) {
                return;
            }
            if (VelocityConfig.CONTROL_FALLBACK.getStringList().contains(server.getServerInfo().getName()) && VelocityConfig.USE_DISCONNECT.get(Boolean.class).booleanValue()) {
                PlayerCache.getOnlineServers().add(server);
                return;
            }
            if (throwable == null && result != null) {
                PlayerCache.getOnlineServers().add(server);
                return;
            }
            PlayerCache.getOnlineServers().remove(server);
        })).repeat((long)VelocityConfig.PING_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule());
    }

    private static Optional<RegisteredServer> getLeastPlayersServer(List<Optional<RegisteredServer>> list) {
        Optional<RegisteredServer> server = Optional.empty();
        for (Optional<RegisteredServer> serverInfo : list) {
            if (!server.isPresent() || !serverInfo.isPresent()) {
                server = serverInfo;
                continue;
            }
            if (server.get().getPlayersConnected().size() <= serverInfo.get().getPlayersConnected().size()) continue;
            server = serverInfo;
        }
        return server;
    }

    private static Optional<RegisteredServer> getMostPlayersServer(List<Optional<RegisteredServer>> list) {
        Optional<RegisteredServer> server = Optional.empty();
        for (Optional<RegisteredServer> serverInfo : list) {
            if (!server.isPresent()) {
                server = serverInfo;
                continue;
            }
            if (!serverInfo.isPresent() || server.get().getPlayersConnected().size() >= serverInfo.get().getPlayersConnected().size()) continue;
            if (VelocityConfig.DISABLE_PING.get(Boolean.class).booleanValue()) {
                server = serverInfo;
                continue;
            }
            if (!PlayerCache.getOnlineServers().contains(serverInfo.get())) continue;
            server = serverInfo;
        }
        return server;
    }

    private static Optional<RegisteredServer> getRandomServer(List<Optional<RegisteredServer>> list) {
        return list.get(new Random().nextInt(list.size()));
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

