/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bukkit;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.tchristofferson.configupdater.ConfigUpdater;
import fr.mrmicky.fastboard.FastBoardBase;
import it.frafol.cleanss.bukkit.UpdateCheck;
import it.frafol.cleanss.bukkit.commands.AdminSpawnCommand;
import it.frafol.cleanss.bukkit.commands.OtherSpawnCommand;
import it.frafol.cleanss.bukkit.commands.SpawnCommand;
import it.frafol.cleanss.bukkit.commands.SuspectSpawnCommand;
import it.frafol.cleanss.bukkit.enums.SpigotConfig;
import it.frafol.cleanss.bukkit.enums.SpigotVersion;
import it.frafol.cleanss.bukkit.hooks.PlaceholderHook;
import it.frafol.cleanss.bukkit.listeners.PlayerListener;
import it.frafol.cleanss.bukkit.listeners.PluginMessageReceiver;
import it.frafol.cleanss.bukkit.listeners.TabListener;
import it.frafol.cleanss.bukkit.listeners.WorldListener;
import it.frafol.cleanss.bukkit.objects.PlayerCache;
import it.frafol.cleanss.bukkit.objects.TextFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import net.byteflux.libby.BukkitLibraryManager;
import net.byteflux.libby.Library;
import net.byteflux.libby.relocation.Relocation;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class CleanSS
extends JavaPlugin {
    public boolean updated = false;
    private final HashMap<UUID, MyScheduledTask> timerTask = new HashMap();
    private final HashMap<UUID, Integer> seconds = new HashMap();
    private TextFile configTextFile;
    private TextFile cacheTextFile;
    private TextFile versionTextFile;
    public static CleanSS instance;

    public void onEnable() {
        instance = this;
        BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager((Plugin)this);
        Relocation yamlrelocation = new Relocation("yaml", "it{}frafol{}libs{}yaml");
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").relocate(yamlrelocation).build();
        Relocation updaterrelocation = new Relocation("updater", "it{}frafol{}libs{}updater");
        Library updater = Library.builder().groupId("com{}tchristofferson").artifactId("ConfigUpdater").version("2.1-SNAPSHOT").relocate(updaterrelocation).url("https://github.com/frafol/Config-Updater/releases/download/compile/ConfigUpdater-2.1-SNAPSHOT.jar").build();
        Relocation scoreboardrelocation = new Relocation("scoreboard", "it{}frafol{}libs{}scoreboard");
        Library scoreboard = Library.builder().groupId("fr{}mrmicky").artifactId("FastBoard").version("2.1.5").relocate(scoreboardrelocation).build();
        Relocation schedulerrelocation = new Relocation("scheduler", "it{}frafol{}libs{}scheduler");
        Library scheduler = Library.builder().groupId("com{}github{}Anon8281").artifactId("UniversalScheduler").version("0.1.6").relocate(schedulerrelocation).build();
        try {
            bukkitLibraryManager.loadLibrary(yaml);
        }
        catch (RuntimeException ignored) {
            this.getLogger().severe("Failed to load Simple-YAML library. Trying to download it from GitHub...");
            yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").url("https://github.com/Carleslc/Simple-YAML/releases/download/1.8.4/Simple-Yaml-1.8.4.jar").relocate(yamlrelocation).build();
        }
        bukkitLibraryManager.addJitPack();
        bukkitLibraryManager.loadLibrary(updater);
        bukkitLibraryManager.loadLibrary(yaml);
        bukkitLibraryManager.loadLibrary(scheduler);
        bukkitLibraryManager.loadLibrary(scoreboard);
        this.getLogger().info("\n   ___  __    ____    __    _  _   ___  ___\n  / __)(  )  ( ___)  /__\\  ( \\( ) / __)/ __)\n ( (__  )(__  )__)  /(__)\\  )  (  \\__ \\\\__ \\\n  \\___)(____)(____)(__)(__)(_)\\_) (___/(___/\n");
        this.getLogger().info("Server version: " + this.getServer().getBukkitVersion());
        this.getLogger().info("Loading configuration...");
        this.configTextFile = new TextFile(this.getDataFolder().toPath(), "settings.yml");
        this.cacheTextFile = new TextFile(this.getDataFolder().toPath(), "cache_do_not_touch.yml");
        this.versionTextFile = new TextFile(this.getDataFolder().toPath(), "version.yml");
        File configFile = new File(this.getDataFolder(), "settings.yml");
        File cacheFile = new File(this.getDataFolder(), "cache_do_not_touch.yml");
        if (!this.getDescription().getVersion().equals(SpigotVersion.VERSION.get(String.class))) {
            this.getLogger().info("Creating new configurations...");
            try {
                ConfigUpdater.update((Plugin)this, (String)"settings.yml", (File)configFile, Collections.emptyList());
            }
            catch (IOException ignored) {
                this.getLogger().severe("Unable to update configuration file, please remove the settings.yml!");
            }
            try {
                ConfigUpdater.update((Plugin)this, (String)"cache_do_not_touch.yml", (File)cacheFile, Collections.emptyList());
            }
            catch (IOException ignored) {
                this.getLogger().severe("Unable to update cache file, please remove the cache_do_not_touch.yml!");
            }
            this.versionTextFile.getConfig().set("version", (Object)this.getDescription().getVersion());
            this.versionTextFile.getConfig().save();
            this.configTextFile = new TextFile(this.getDataFolder().toPath(), "settings.yml");
            this.cacheTextFile = new TextFile(this.getDataFolder().toPath(), "cache_do_not_touch.yml");
        }
        this.getLogger().info("Loading channels...");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "cleanss:join", (PluginMessageListener)new PluginMessageReceiver());
        this.getLogger().info("Loading commands...");
        this.getCommand("setadminspawn").setExecutor((CommandExecutor)new AdminSpawnCommand());
        this.getCommand("setsuspectspawn").setExecutor((CommandExecutor)new SuspectSpawnCommand());
        this.getCommand("setotherspawn").setExecutor((CommandExecutor)new OtherSpawnCommand());
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand());
        this.getCommand("spawn").setTabCompleter((TabCompleter)new TabListener());
        this.getLogger().info("Loading listeners...");
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        if (this.isPAPI()) {
            new PlaceholderHook(this).register();
            this.getLogger().info("PlaceholderAPI found, placeholders enabled.");
        }
        this.UpdateChecker();
        if (SpigotConfig.DAY_CYCLE.get(Boolean.class).booleanValue()) {
            if (!CleanSS.isFolia()) {
                for (World worlds : this.getServer().getWorlds()) {
                    worlds.setGameRuleValue("doDaylightCycle", "false");
                }
            } else {
                this.getLogger().severe("Cannot disable daylight cycle on Folia, please disable it manually.");
            }
        }
        if (SpigotConfig.SB_STAFF.get(Boolean.class).booleanValue() || SpigotConfig.SB_SUSPECT.get(Boolean.class).booleanValue()) {
            PlayerCache.updateScoreboardTask();
        }
        if (SpigotConfig.TABLIST_STAFF.get(Boolean.class).booleanValue() || SpigotConfig.TABLIST_SUSPECT.get(Boolean.class).booleanValue()) {
            PlayerCache.updateTabListTask();
        }
        this.getLogger().info("Successfully loaded!");
    }

    public void onDisable() {
        instance = null;
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this, "cleanss:join");
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this, "cleanss:reload");
        PlayerCache.getAdminBoard().values().forEach(FastBoardBase::delete);
        PlayerCache.getSuspectBoard().values().forEach(FastBoardBase::delete);
        PlayerCache.getOtherBoard().values().forEach(FastBoardBase::delete);
        this.getLogger().info("Successfully disabled!");
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        return true;
    }

    private void UpdateChecker() {
        if (!SpigotConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                if (SpigotConfig.AUTO_UPDATE.get(Boolean.class).booleanValue() && !this.updated) {
                    this.autoUpdate();
                    return;
                }
                if (!this.updated) {
                    this.getLogger().warning("There is a new update available, download it on SpigotMC!");
                }
            }
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                this.getLogger().warning("You are using a development version, please report any bugs!");
            }
        });
    }

    public boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    public void autoUpdate() {
        if (this.isWindows()) {
            this.getLogger().warning("Auto update is not supported on Windows.");
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            String fileUrl = "https://github.com/frafol/CleanScreenShare/releases/download/release/cleanscreenshare-" + version + " .jar";
            String destination = "./plugins/";
            String fileName = this.getFileNameFromUrl(fileUrl);
            File outputFile = new File(destination, fileName);
            try {
                this.downloadFile(fileUrl, outputFile);
            }
            catch (IOException ignored) {
                this.getLogger().warning("An error occurred while downloading the update, please download it manually from SpigotMC.");
                return;
            }
            this.updated = true;
            this.getLogger().warning("CleanScreenShare successfully updated, a restart is required.");
        });
    }

    private String getFileNameFromUrl(String fileUrl) {
        int slashIndex = fileUrl.lastIndexOf(47);
        if (slashIndex != -1 && slashIndex < fileUrl.length() - 1) {
            return fileUrl.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException("Invalid file URL");
    }

    private void downloadFile(String fileUrl, File outputFile) throws IOException {
        URL url = new URL(fileUrl);
        try (InputStream inputStream = url.openStream();){
            this.deleteFile(outputFile.getParent(), "cleanscreenshare-");
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void deleteFile(String directoryPath, String file_start) {
        File directory = new File(directoryPath);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException();
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().startsWith(file_start)) continue;
            this.getLogger().warning("Found an old plugin file: " + file.getName());
            if (!file.delete()) continue;
            this.getLogger().warning("Deleted old file: " + file.getName());
        }
    }

    public boolean isPAPI() {
        return this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null && SpigotConfig.PAPI_HOOK.get(Boolean.class) != false;
    }

    public void startTimer(UUID uuid) {
        this.timerTask.put(uuid, UniversalScheduler.getScheduler((Plugin)instance).runTaskTimer(() -> {
            this.seconds.putIfAbsent(uuid, 1);
            this.seconds.put(uuid, this.seconds.get(uuid) + 1);
        }, 20L, 20L));
    }

    public void stopTimer(UUID uuid) {
        if (this.timerTask.get(uuid) != null) {
            this.timerTask.get(uuid).cancel();
            this.seconds.remove(uuid);
            this.timerTask.remove(uuid);
        }
    }

    public Integer getSeconds(UUID uuid) {
        return this.seconds.get(uuid);
    }

    public String getFormattedSeconds(UUID uuid) {
        if (this.seconds.get(uuid) == null) {
            return "00:00";
        }
        if (this.seconds.get(uuid) > 86400) {
            return DurationFormatUtils.formatDuration((long)((long)this.seconds.get(uuid).intValue() * 1000L), (String)"dd:HH:mm:ss");
        }
        if (this.seconds.get(uuid) > 3600) {
            return DurationFormatUtils.formatDuration((long)((long)this.seconds.get(uuid).intValue() * 1000L), (String)"HH:mm:ss");
        }
        return DurationFormatUtils.formatDuration((long)((long)this.seconds.get(uuid).intValue() * 1000L), (String)"mm:ss");
    }

    @Generated
    public TextFile getConfigTextFile() {
        return this.configTextFile;
    }

    @Generated
    public TextFile getCacheTextFile() {
        return this.cacheTextFile;
    }

    @Generated
    public TextFile getVersionTextFile() {
        return this.versionTextFile;
    }

    @Generated
    public static CleanSS getInstance() {
        return instance;
    }
}

