/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bukkit.objects;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import fr.mrmicky.fastboard.FastBoard;
import it.frafol.cleanss.bukkit.CleanSS;
import it.frafol.cleanss.bukkit.enums.SpigotConfig;
import it.frafol.cleanss.bukkit.objects.utils.TabListUtil;
import it.frafol.cleanss.bukkit.objects.utils.ViaScoreboard;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;

public final class PlayerCache {
    private static final CleanSS instance = CleanSS.getInstance();
    private static final HashSet<UUID> no_chat = new HashSet();
    private static final HashMap<UUID, UUID> couples = new HashMap();
    private static final HashSet<UUID> suspicious = new HashSet();
    private static final HashSet<UUID> administrator = new HashSet();
    private static final HashMap<UUID, FastBoard> adminBoard = new HashMap();
    private static final HashMap<UUID, FastBoard> suspectBoard = new HashMap();
    private static final HashMap<UUID, FastBoard> otherBoard = new HashMap();

    @Contract(value="_ -> new")
    public static Location StringToLocation(String line) {
        String[] loc = line.split(";");
        World world = instance.getServer().getWorld(loc[0]);
        if (world == null) {
            world = instance.getServer().createWorld(new WorldCreator(loc[0]));
        }
        return new Location(world, Double.parseDouble(loc[1]), Double.parseDouble(loc[2]), Double.parseDouble(loc[3]), Float.parseFloat(loc[4]), Float.parseFloat(loc[5]));
    }

    public static String LocationToString(Location location) {
        String world = location.getWorld().getName();
        String x = String.valueOf(location.getBlockX());
        String y = String.valueOf(location.getBlockY());
        String z = String.valueOf(location.getBlockZ());
        String yaw = String.valueOf(location.getYaw());
        String pitch = String.valueOf(location.getPitch());
        return world + ";" + x + ";" + y + ";" + z + ";" + yaw + ";" + pitch;
    }

    public static void createSuspectScoreboard(Player player) {
        if (!SpigotConfig.SB_SUSPECT.get(Boolean.class).booleanValue()) {
            return;
        }
        if (PlayerCache.hasViaVersion()) {
            ViaScoreboard.createViaSuspectScoreboard(player);
            return;
        }
        FastBoard board = new FastBoard(player);
        suspectBoard.put(player.getUniqueId(), board);
    }

    public static void createAdminScoreboard(Player player) {
        if (!SpigotConfig.SB_STAFF.get(Boolean.class).booleanValue()) {
            return;
        }
        if (PlayerCache.hasViaVersion()) {
            ViaScoreboard.createViaAdminScoreboard(player);
            return;
        }
        FastBoard board = new FastBoard(player);
        adminBoard.put(player.getUniqueId(), board);
    }

    public static void createOtherScoreboard(Player player) {
        if (!SpigotConfig.SB_OTHER.get(Boolean.class).booleanValue()) {
            return;
        }
        if (PlayerCache.hasViaVersion()) {
            ViaScoreboard.createViaOtherScoreboard(player);
            return;
        }
        FastBoard board = new FastBoard(player);
        otherBoard.put(player.getUniqueId(), board);
    }

    public static void deleteSuspectScoreboard(Player player) {
        if (!SpigotConfig.SB_SUSPECT.get(Boolean.class).booleanValue()) {
            return;
        }
        if (suspectBoard.get(player.getUniqueId()) == null) {
            return;
        }
        suspectBoard.get(player.getUniqueId()).delete();
        suspectBoard.remove(player.getUniqueId());
    }

    public static void deleteAdminScoreboard(Player player) {
        if (!SpigotConfig.SB_STAFF.get(Boolean.class).booleanValue()) {
            return;
        }
        if (adminBoard.get(player.getUniqueId()) == null) {
            return;
        }
        adminBoard.get(player.getUniqueId()).delete();
        adminBoard.remove(player.getUniqueId());
    }

    public static void deleteOtherScoreboard(Player player) {
        if (!SpigotConfig.SB_OTHER.get(Boolean.class).booleanValue()) {
            return;
        }
        if (otherBoard.get(player.getUniqueId()) == null) {
            return;
        }
        otherBoard.get(player.getUniqueId()).delete();
        otherBoard.remove(player.getUniqueId());
    }

    public static void updateScoreboardTask() {
        UniversalScheduler.getScheduler((Plugin)instance).runTaskTimer(PlayerCache::updateScoreboard, (long)SpigotConfig.SB_UPDATE.get(Integer.class).intValue(), (long)SpigotConfig.SB_UPDATE.get(Integer.class).intValue());
    }

    public static void updateTabListTask() {
        UniversalScheduler.getScheduler((Plugin)instance).runTaskTimer(PlayerCache::updateTabList, (long)SpigotConfig.TABLIST_UPDATE.get(Integer.class).intValue(), (long)SpigotConfig.TABLIST_UPDATE.get(Integer.class).intValue());
    }

    private static void updateScoreboard() {
        instance.getServer().getOnlinePlayers().forEach(player -> {
            FastBoard board;
            if (SpigotConfig.SB_SUSPECT.get(Boolean.class).booleanValue()) {
                board = suspectBoard.get(player.getUniqueId());
                if (suspectBoard.get(player.getUniqueId()) != null && board != null) {
                    board.updateTitle(SpigotConfig.SB_SUSPECTTITLE.color());
                    board.updateLines(SpigotConfig.SB_SUSPECTLINES.parseScoreboard((Player)player));
                    return;
                }
            }
            if (SpigotConfig.SB_STAFF.get(Boolean.class).booleanValue()) {
                board = adminBoard.get(player.getUniqueId());
                if (adminBoard.get(player.getUniqueId()) != null && board != null) {
                    board.updateTitle(SpigotConfig.SB_STAFFTITLE.color());
                    board.updateLines(SpigotConfig.SB_STAFFLINES.parseScoreboard((Player)player));
                    return;
                }
            }
            if (SpigotConfig.SB_OTHER.get(Boolean.class).booleanValue()) {
                board = otherBoard.get(player.getUniqueId());
                if (otherBoard.get(player.getUniqueId()) != null && board != null) {
                    board.updateTitle(SpigotConfig.SB_OTHERTITLE.color());
                    board.updateLines(SpigotConfig.SB_OTHERLINES.parseScoreboard((Player)player));
                }
            }
        });
    }

    private static void updateTabList() {
        for (UUID uuid : PlayerCache.getSuspicious()) {
            if (!SpigotConfig.TABLIST_SUSPECT.get(Boolean.class).booleanValue()) continue;
            PlayerCache.setSuspectTabList(instance.getServer().getPlayer(uuid));
        }
        for (UUID uuid : PlayerCache.getAdministrator()) {
            if (!SpigotConfig.TABLIST_STAFF.get(Boolean.class).booleanValue()) continue;
            PlayerCache.setStaffTabList(instance.getServer().getPlayer(uuid));
        }
        for (Player player : instance.getServer().getOnlinePlayers()) {
            if (!SpigotConfig.TABLIST_OTHER.get(Boolean.class).booleanValue() || PlayerCache.getAdministrator().contains(player.getUniqueId()) || PlayerCache.getSuspicious().contains(player.getUniqueId())) continue;
            PlayerCache.setOtherTabList(player);
        }
    }

    public static void setStaffTabList(Player player) {
        String header = String.join((CharSequence)"\n", SpigotConfig.TABLIST_STAFFHEADER.getStringList());
        String footer = String.join((CharSequence)"\n", SpigotConfig.TABLIST_STAFFFOOTER.getStringList());
        if (!instance.isPAPI()) {
            TabListUtil.sendTabList(player, header, footer);
            return;
        }
        String final_header = PlaceholderAPI.setPlaceholders((Player)player, (String)header);
        String final_footer = PlaceholderAPI.setPlaceholders((Player)player, (String)footer);
        TabListUtil.sendTabList(player, final_header, final_footer);
    }

    public static void setSuspectTabList(Player player) {
        String header = String.join((CharSequence)"\n", SpigotConfig.TABLIST_SUSPECTHEADER.getStringList());
        String footer = String.join((CharSequence)"\n", SpigotConfig.TABLIST_SUSPECTFOOTER.getStringList());
        if (!instance.isPAPI()) {
            TabListUtil.sendTabList(player, header, footer);
            return;
        }
        String final_header = PlaceholderAPI.setPlaceholders((Player)player, (String)header);
        String final_footer = PlaceholderAPI.setPlaceholders((Player)player, (String)footer);
        TabListUtil.sendTabList(player, final_header, final_footer);
    }

    public static void setOtherTabList(Player player) {
        String header = String.join((CharSequence)"\n", SpigotConfig.TABLIST_OTHERHEADER.getStringList());
        String footer = String.join((CharSequence)"\n", SpigotConfig.TABLIST_OTHERFOOTER.getStringList());
        if (!instance.isPAPI()) {
            TabListUtil.sendTabList(player, header, footer);
            return;
        }
        String final_header = PlaceholderAPI.setPlaceholders((Player)player, (String)header);
        String final_footer = PlaceholderAPI.setPlaceholders((Player)player, (String)footer);
        TabListUtil.sendTabList(player, final_header, final_footer);
    }

    private static boolean hasViaVersion() {
        return instance.getServer().getPluginManager().isPluginEnabled("ViaVersion");
    }

    @Generated
    private PlayerCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static HashSet<UUID> getNo_chat() {
        return no_chat;
    }

    @Generated
    public static HashMap<UUID, UUID> getCouples() {
        return couples;
    }

    @Generated
    public static HashSet<UUID> getSuspicious() {
        return suspicious;
    }

    @Generated
    public static HashSet<UUID> getAdministrator() {
        return administrator;
    }

    @Generated
    public static HashMap<UUID, FastBoard> getAdminBoard() {
        return adminBoard;
    }

    @Generated
    public static HashMap<UUID, FastBoard> getSuspectBoard() {
        return suspectBoard;
    }

    @Generated
    public static HashMap<UUID, FastBoard> getOtherBoard() {
        return otherBoard;
    }
}

