/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bukkit.objects.utils;

import com.google.common.base.Strings;
import it.frafol.cleanss.bukkit.CleanSS;
import it.frafol.cleanss.bukkit.enums.SpigotConfig;
import it.frafol.cleanss.bukkit.objects.Placeholder;
import it.frafol.cleanss.bukkit.objects.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public final class TabListUtil {
    private static final CleanSS instance = CleanSS.getInstance();

    public static void sendTabList(Player player, String header, String footer) {
        header = Strings.isNullOrEmpty((String)header) ? "" : Placeholder.color(header);
        String string = footer = Strings.isNullOrEmpty((String)footer) ? "" : Placeholder.color(footer);
        if (!TabListUtil.isLowerThan1_12_2()) {
            player.setPlayerListHeaderFooter(header, footer);
            if (!instance.isPAPI()) {
                player.setPlayerListName(SpigotConfig.TABLIST_FORMAT.color().replace("%player%", player.getName()));
                player.setCustomName(SpigotConfig.TABLIST_FORMAT.color().replace("%player%", player.getName()));
                player.setCustomNameVisible(true);
                return;
            }
            player.setPlayerListName(Placeholder.color(PlaceholderAPI.setPlaceholders((Player)player, (String)SpigotConfig.TABLIST_FORMAT.get(String.class).replace("%player%", player.getName()))));
            return;
        }
        try {
            Field bField;
            Field aField;
            Method chatComponentBuilderMethod = Objects.requireNonNull(ReflectionUtils.getNMSClass("IChatBaseComponent")).getDeclaredClasses()[0].getMethod("a", String.class);
            Object tabHeader = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + header + "\"}");
            Object tabFooter = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + footer + "\"}");
            Object packet = Objects.requireNonNull(ReflectionUtils.getNMSClass("PacketPlayOutPlayerListHeaderFooter")).getConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                aField = packet.getClass().getDeclaredField("a");
                bField = packet.getClass().getDeclaredField("b");
            }
            catch (Exception ex) {
                aField = packet.getClass().getDeclaredField("header");
                bField = packet.getClass().getDeclaredField("footer");
            }
            aField.setAccessible(true);
            aField.set(packet, tabHeader);
            bField.setAccessible(true);
            bField.set(packet, tabFooter);
            ReflectionUtils.sendPacket(player, packet);
        }
        catch (Exception ignored) {
            instance.getLogger().severe("Cannot send tablist to " + player.getName() + ".");
        }
    }

    private static boolean isLowerThan1_12_2() {
        String serverVersion = instance.getServer().getVersion();
        Pattern pattern = Pattern.compile(".*(\\d+\\.\\d+\\.\\d+).*");
        Matcher matcher = pattern.matcher(serverVersion);
        if (matcher.matches()) {
            String serverVersionNumber = matcher.group(1);
            String[] serverVersionParts = serverVersionNumber.split("\\.");
            String[] targetVersionParts = "1.12.2".split("\\.");
            for (int i = 0; i < Math.min(serverVersionParts.length, targetVersionParts.length); ++i) {
                int targetPart;
                int serverPart = Integer.parseInt(serverVersionParts[i]);
                if (serverPart < (targetPart = Integer.parseInt(targetVersionParts[i]))) {
                    return true;
                }
                if (serverPart <= targetPart) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Generated
    private TabListUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

