/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.listeners;

import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeCommandsConfig;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.objects.PlayerCache;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.event.EventHandler;

public class CommandListener
implements Listener {
    private final CleanSS instance = CleanSS.getInstance();
    private final ConcurrentHashMap<UUID, String> command = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, ScheduledTask> commandRemove = new ConcurrentHashMap();

    @EventHandler
    public void onPlayerCommand(ChatEvent event) {
        if (!event.isCommand()) {
            return;
        }
        if (!(event.getSender() instanceof ProxiedPlayer)) {
            return;
        }
        if (event.getMessage().equalsIgnoreCase("/spawn")) {
            return;
        }
        for (String admit_command : BungeeCommandsConfig.SS_ADMIT.getStringList()) {
            if (!event.getMessage().equalsIgnoreCase("/" + admit_command)) continue;
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)event.getSender();
        if (PlayerCache.getSuspicious().contains(player.getUniqueId())) {
            event.setCancelled(true);
            player.sendMessage(TextComponent.fromLegacy((String)BungeeMessages.COMMAND_BLOCKED.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            return;
        }
        if (PlayerCache.getIn_control().get(player.getUniqueId()) == null) {
            return;
        }
        if (!PlayerCache.getAdministrator().contains(player.getUniqueId())) {
            return;
        }
        for (String command : BungeeConfig.BAN_COMMANDS.getStringList()) {
            if (!event.getMessage().startsWith("/" + command + " ") || !event.getMessage().contains(this.instance.getValue(PlayerCache.getCouples(), player).getName())) continue;
            PlayerCache.getBan_execution().add(player.getUniqueId());
            this.instance.getProxy().getScheduler().schedule((Plugin)this.instance, () -> PlayerCache.getBan_execution().remove(player.getUniqueId()), 2L, TimeUnit.SECONDS);
        }
    }

    @EventHandler
    public void onStaffCommand(ChatEvent event) {
        if (!event.isCommand()) {
            return;
        }
        if (!(event.getSender() instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)event.getSender();
        if (!PlayerCache.getAdministrator().contains(player.getUniqueId())) {
            return;
        }
        if (!BungeeConfig.COMMAND_REQUEST.get(Boolean.class).booleanValue()) {
            return;
        }
        if (this.command.get(player.getUniqueId()) != null && this.command.get(player.getUniqueId()).equals(event.getMessage())) {
            this.unTask(player);
            return;
        }
        for (String allowed : BungeeConfig.ALLOWED_COMMANDS.getStringList()) {
            if (!event.getMessage().startsWith(allowed)) continue;
            return;
        }
        event.setCancelled(true);
        this.command.put(player.getUniqueId(), event.getMessage());
        BaseComponent clickableMessageString = TextComponent.fromLegacy((String)BungeeMessages.COMMAND_REQUEST.color().replace("%prefix%", BungeeMessages.PREFIX.color()));
        TextComponent clickableMessage = new TextComponent(new BaseComponent[]{clickableMessageString});
        clickableMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, event.getMessage()));
        player.sendMessage((BaseComponent)clickableMessage);
        this.task(player);
    }

    private void task(ProxiedPlayer player) {
        ScheduledTask task = this.instance.getProxy().getScheduler().schedule((Plugin)this.instance, () -> {
            this.command.remove(player.getUniqueId());
            this.commandRemove.remove(player.getUniqueId());
        }, (long)BungeeConfig.COMMAND_TIME.get(Integer.class).intValue(), TimeUnit.SECONDS);
        this.commandRemove.put(player.getUniqueId(), task);
    }

    private void unTask(ProxiedPlayer player) {
        this.command.remove(player.getUniqueId());
        this.commandRemove.get(player.getUniqueId()).cancel();
        this.commandRemove.remove(player.getUniqueId());
    }
}

