/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.objects;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.objects.ChatUtil;
import it.frafol.cleanss.bungee.objects.Placeholder;
import java.awt.Color;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public final class MessageUtil {
    private static final CleanSS instance = CleanSS.getInstance();

    public static void sendDiscordSpectatorMessage(ProxiedPlayer player, String message, String thumbnail) {
        if (BungeeConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            if (instance.getJda() == null) {
                return;
            }
            TextChannel channel = instance.getJda().getTextChannelById(BungeeConfig.DISCORD_CHANNEL_ID.get(String.class));
            if (channel == null) {
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle(BungeeConfig.DISCORD_EMBED_TITLE.get(String.class), null);
            embed.setDescription((CharSequence)message.replace("%staffer%", player.getName()));
            embed.setColor(Color.RED);
            embed.setFooter(BungeeConfig.DISCORD_EMBED_FOOTER.get(String.class));
            if (!thumbnail.equals("none")) {
                embed.setThumbnail(thumbnail);
            }
            if (!BungeeConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class).equals("none")) {
                embed.setFooter(BungeeConfig.DISCORD_EMBED_FOOTER.get(String.class), BungeeConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class));
            }
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        }
    }

    public static void sendDiscordMessage(ProxiedPlayer suspect, ProxiedPlayer staffer, String message, String result, String thumbnail) {
        if (BungeeConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            TextChannel channel = instance.getJda().getTextChannelById(BungeeConfig.DISCORD_CHANNEL_ID.get(String.class));
            if (channel == null) {
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle(BungeeConfig.DISCORD_EMBED_TITLE.get(String.class), null);
            embed.setDescription((CharSequence)message.replace("%suspect%", suspect.getName()).replace("%staffer%", staffer.getName()).replace("%result%", result));
            embed.setColor(Color.RED);
            embed.setFooter(BungeeConfig.DISCORD_EMBED_FOOTER.get(String.class));
            if (!thumbnail.equals("none")) {
                embed.setThumbnail(thumbnail);
            }
            if (!BungeeConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class).equals("none")) {
                embed.setFooter(BungeeConfig.DISCORD_EMBED_FOOTER.get(String.class), BungeeConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class));
            }
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        }
    }

    public static void sendDiscordMessage(ProxiedPlayer suspect, ProxiedPlayer staffer, String message, String thumbnail) {
        if (BungeeConfig.DISCORD_ENABLED.get(Boolean.class).booleanValue()) {
            if (instance.getJda() == null) {
                return;
            }
            TextChannel channel = instance.getJda().getTextChannelById(BungeeConfig.DISCORD_CHANNEL_ID.get(String.class));
            if (channel == null) {
                return;
            }
            EmbedBuilder embed = new EmbedBuilder();
            embed.setTitle(BungeeConfig.DISCORD_EMBED_TITLE.get(String.class), null);
            embed.setDescription((CharSequence)message.replace("%suspect%", suspect.getName()).replace("%staffer%", staffer.getName()));
            embed.setColor(Color.RED);
            embed.setFooter(BungeeConfig.DISCORD_EMBED_FOOTER.get(String.class));
            if (!thumbnail.equals("none")) {
                embed.setThumbnail(thumbnail);
            }
            if (!BungeeConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class).equals("none")) {
                embed.setFooter(BungeeConfig.DISCORD_EMBED_FOOTER.get(String.class), BungeeConfig.DISCORD_EMBED_FOOTER_ICON.get(String.class));
            }
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        }
    }

    public static void sendChannelMessage(ProxiedPlayer player, String type) {
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        buf.writeUTF(type);
        buf.writeUTF(player.getName());
        if (player.getServer() == null) {
            instance.getLogger().severe("The player " + player.getName() + " has no server, please check your control server if it's working correctly!");
            return;
        }
        player.getServer().sendData("cleanss:join", buf.toByteArray());
    }

    public static void sendChannelAdvancedMessage(ProxiedPlayer administrator, ProxiedPlayer suspicious, String type) {
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        buf.writeUTF(type);
        buf.writeUTF(administrator.getName());
        buf.writeUTF(suspicious.getName());
        if (administrator.getServer() == null) {
            instance.getLogger().severe("The player " + administrator.getName() + " has no server, please check your control server if it's working correctly!");
            return;
        }
        administrator.getServer().sendData("cleanss:join", buf.toByteArray());
    }

    public static void sendButtons(ProxiedPlayer administrator, ProxiedPlayer suspicious, String admin_prefix, String admin_suffix, String sus_prefix, String sus_suffix) {
        instance.getProxy().getScheduler().schedule((Plugin)instance, () -> {
            if (BungeeMessages.CONTROL_USEVERTICALFORMAT.get(Boolean.class).booleanValue()) {
                BungeeMessages.CONTROL_VERTICALFORMAT.sendStartList((CommandSender)administrator, suspicious, new Placeholder("prefix", BungeeMessages.PREFIX.color()), new Placeholder("adminprefix", ChatUtil.color(admin_prefix)), new Placeholder("adminsuffix", ChatUtil.color(admin_suffix)), new Placeholder("suspectprefix", ChatUtil.color(sus_prefix)), new Placeholder("suspectsuffix", ChatUtil.color(sus_suffix)), new Placeholder("suspect", suspicious.getName()), new Placeholder("administrator", administrator.getName()));
            } else {
                BungeeMessages.CONTROL_HORIZONTALFORMAT.sendStartList((CommandSender)administrator, suspicious, new Placeholder("prefix", BungeeMessages.PREFIX.color()), new Placeholder("adminprefix", ChatUtil.color(admin_prefix)), new Placeholder("adminsuffix", ChatUtil.color(admin_suffix)), new Placeholder("suspectprefix", ChatUtil.color(sus_prefix)), new Placeholder("suspectsuffix", ChatUtil.color(sus_suffix)), new Placeholder("suspect", suspicious.getName()), new Placeholder("administrator", administrator.getName()));
            }
        }, (long)MessageUtil.getDelay(), TimeUnit.SECONDS);
    }

    private static int getDelay() {
        if (BungeeMessages.CONTROL_DELAYMESSAGE.get(Integer.class) <= 1) {
            return 1;
        }
        return BungeeMessages.CONTROL_DELAYMESSAGE.get(Integer.class);
    }

    @Generated
    private MessageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

