/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.objects;

import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SQLConnection {
    private Connection connection;
    private final ExecutorService executor;
    private final String host;
    private String database;
    private final String user;
    private final String password;

    private SQLConnection(String host, String user, String password) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public SQLConnection(String host, String user, String password, String database) {
        this(host, user, password);
        this.database = database;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connect();
        }
        return this.connection;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.executor.shutdownNow();
        }
    }

    private void connect() {
        try {
            CleanSS.getInstance().getLogger().info("\u00a77Connecting to \u00a7dMySQL database\u00a77...");
            this.connection = DriverManager.getConnection("JDBC:mysql://" + this.host + "/" + this.database + BungeeConfig.MYSQL_ARGUMENTS.get(String.class), this.user, this.password);
            CleanSS.getInstance().getLogger().info("\u00a77Connected to \u00a7dMySQL database\u00a77.");
        }
        catch (SQLException sqlException) {
            CleanSS.getInstance().getLogger().severe("\u00a7cUnable to connect to the database, cannot start the plugin. Is password correct?");
            sqlException.printStackTrace();
            CleanSS.getInstance().getProxy().stop();
        }
    }

    public void execute(String sql) {
        Runnable runnable = () -> {
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeUpdate(sql);
            }
            catch (SQLException var15) {
                var15.printStackTrace();
            }
        };
        runnable.run();
    }
}

