/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.handlers.DataHandler;
import it.frafol.cleanss.velocity.objects.Placeholder;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class InfoCommand
implements SimpleCommand {
    private final CleanSS instance;

    public InfoCommand(CleanSS instance) {
        this.instance = instance;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        Optional player;
        CommandSource source = invocation.source();
        boolean luckperms = this.instance.getServer().getPluginManager().getPlugin("luckperms").isPresent();
        if (!source.hasPermission(VelocityConfig.INFO_PERMISSION.get(String.class))) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length > 1) {
            VelocityMessages.USAGE.sendList(source, null, new Placeholder("%prefix%", VelocityMessages.PREFIX.color()));
            return;
        }
        if (((String[])invocation.arguments()).length == 0) {
            if (!(source instanceof Player)) {
                VelocityMessages.USAGE.sendList(source, null, new Placeholder("%prefix%", VelocityMessages.PREFIX.color()));
                return;
            }
            player = Optional.of((Player)source);
        } else {
            player = this.instance.getServer().getPlayer(((String[])invocation.arguments())[0]);
        }
        if (!player.isPresent()) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
            return;
        }
        if (VelocityConfig.MYSQL.get(Boolean.class).booleanValue()) {
            if (luckperms) {
                VelocityMessages.INFO_MESSAGE.sendList(source, new Placeholder("player", ((Player)player.get()).getUsername()), new Placeholder("prefix", VelocityMessages.PREFIX.color()), new Placeholder("is_in_control", String.valueOf(this.instance.getData().getStats(((Player)player.get()).getUniqueId(), "incontrol"))), new Placeholder("controls_done", String.valueOf(this.instance.getData().getStats(((Player)player.get()).getUniqueId(), "controls"))), new Placeholder("playerprefix", Utils.getPrefix((Player)player.get())), new Placeholder("playersuffix", Utils.getSuffix((Player)player.get())), new Placeholder("controls_suffered", String.valueOf(this.instance.getData().getStats(((Player)player.get()).getUniqueId(), "suffered"))), new Placeholder("is_spectating", PlayerCache.getSpectators().contains(((Player)player.get()).getUniqueId()) ? VelocityMessages.INFO_TRUE.color() : VelocityMessages.INFO_FALSE.color()));
                return;
            }
            VelocityMessages.INFO_MESSAGE.sendList(source, new Placeholder("player", ((Player)player.get()).getUsername()), new Placeholder("prefix", VelocityMessages.PREFIX.color()), new Placeholder("is_in_control", String.valueOf(this.instance.getData().getStats(((Player)player.get()).getUniqueId(), "incontrol"))), new Placeholder("controls_done", String.valueOf(this.instance.getData().getStats(((Player)player.get()).getUniqueId(), "controls"))), new Placeholder("controls_suffered", String.valueOf(this.instance.getData().getStats(((Player)player.get()).getUniqueId(), "suffered"))), new Placeholder("is_spectating", PlayerCache.getSpectators().contains(((Player)player.get()).getUniqueId()) ? VelocityMessages.INFO_TRUE.color() : VelocityMessages.INFO_FALSE.color()));
            return;
        }
        PlayerCache.getControls().put(((Player)player.get()).getUniqueId(), DataHandler.getStat(((Player)player.get()).getUniqueId(), "done"));
        PlayerCache.getControls_suffered().put(((Player)player.get()).getUniqueId(), DataHandler.getStat(((Player)player.get()).getUniqueId(), "suffered"));
        if (luckperms) {
            VelocityMessages.INFO_MESSAGE.sendList(source, new Placeholder("player", ((Player)player.get()).getUsername()), new Placeholder("prefix", VelocityMessages.PREFIX.color()), new Placeholder("is_in_control", PlayerCache.getSuspicious().contains(((Player)player.get()).getUniqueId()) || PlayerCache.getAdministrator().contains(((Player)player.get()).getUniqueId()) ? VelocityMessages.INFO_TRUE.color() : VelocityMessages.INFO_FALSE.color()), new Placeholder("controls_done", String.valueOf(PlayerCache.getControls().get(((Player)player.get()).getUniqueId()))), new Placeholder("playerprefix", Utils.getPrefix((Player)player.get())), new Placeholder("playersuffix", Utils.getSuffix((Player)player.get())), new Placeholder("controls_suffered", String.valueOf(PlayerCache.getControls_suffered().get(((Player)player.get()).getUniqueId()))), new Placeholder("is_spectating", PlayerCache.getSpectators().contains(((Player)player.get()).getUniqueId()) ? VelocityMessages.INFO_TRUE.color() : VelocityMessages.INFO_FALSE.color()));
            return;
        }
        VelocityMessages.INFO_MESSAGE.sendList(source, new Placeholder("player", ((Player)player.get()).getUsername()), new Placeholder("prefix", VelocityMessages.PREFIX.color()), new Placeholder("is_in_control", PlayerCache.getSuspicious().contains(((Player)player.get()).getUniqueId()) || PlayerCache.getAdministrator().contains(((Player)player.get()).getUniqueId()) ? VelocityMessages.INFO_TRUE.color() : VelocityMessages.INFO_FALSE.color()), new Placeholder("controls_done", String.valueOf(PlayerCache.getControls().get(((Player)player.get()).getUniqueId()))), new Placeholder("controls_suffered", String.valueOf(PlayerCache.getControls_suffered().get(((Player)player.get()).getUniqueId()))), new Placeholder("is_spectating", PlayerCache.getSpectators().contains(((Player)player.get()).getUniqueId()) ? VelocityMessages.INFO_TRUE.color() : VelocityMessages.INFO_FALSE.color()));
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] strings = (String[])invocation.arguments();
        if (Utils.isConsole(invocation.source())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List players = this.instance.getServer().getAllPlayers().stream().map(Player::getUsername).filter(player -> strings.length != 1 || strings[0].isEmpty() || player.toLowerCase().startsWith(strings[0].toLowerCase())).collect(Collectors.toList());
        return CompletableFuture.completedFuture(players);
    }
}

