/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.commands;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.TextFile;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ReloadCommand
implements SimpleCommand {
    public final CleanSS PLUGIN;

    public ReloadCommand(CleanSS plugin) {
        this.PLUGIN = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        if (!source.hasPermission(VelocityConfig.RELOAD_PERMISSION.get(String.class))) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        this.stopTasks();
        TextFile.reloadAll();
        this.restartBot();
        source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.RELOADED.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
        this.startTasks();
        if (!(source instanceof Player)) {
            return;
        }
        Player sender = (Player)source;
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        buf.writeUTF("RELOAD");
        sender.getCurrentServer().ifPresent(sv -> sv.sendPluginMessage(CleanSS.channel_join, buf.toByteArray()));
    }

    private void startTasks() {
        List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL.getStringList());
        List<Optional<RegisteredServer>> fallbacks = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
        for (Optional<RegisteredServer> server : servers) {
            server.ifPresent(Utils::startTask);
        }
        for (Optional<RegisteredServer> fallback : fallbacks) {
            fallback.ifPresent(Utils::startTask);
        }
    }

    private void stopTasks() {
        List<Optional<RegisteredServer>> servers = Utils.getServerList(VelocityConfig.CONTROL.getStringList());
        List<Optional<RegisteredServer>> fallbacks = Utils.getServerList(VelocityConfig.CONTROL_FALLBACK.getStringList());
        for (Optional<RegisteredServer> server : servers) {
            server.ifPresent(Utils::stopTask);
        }
        for (Optional<RegisteredServer> fallback : fallbacks) {
            fallback.ifPresent(Utils::stopTask);
        }
    }

    private void restartBot() {
        if (this.PLUGIN.getJda().getJda() != null) {
            this.PLUGIN.getJda().getJda().shutdown();
            this.PLUGIN.reloadDiscord();
        }
    }
}

