/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SQLConnection {
    private final CleanSS instance = CleanSS.getInstance();
    private Connection connection;
    private final ExecutorService executor;
    private final String host;
    private String database;
    private final String user;
    private final String password;

    private SQLConnection(String host, String user, String password) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public SQLConnection(String host, String user, String password, String database) {
        this(host, user, password);
        this.database = database;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connect();
        }
        return this.connection;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.executor.shutdownNow();
        }
    }

    private void connect() {
        try {
            this.instance.getLogger().warn("Connecting to MySQL database...");
            this.connection = DriverManager.getConnection("JDBC:mysql://" + this.host + "/" + this.database + VelocityConfig.MYSQL_ARGUMENTS.get(String.class), this.user, this.password);
            this.instance.getLogger().info("Connected to MySQL database.");
        }
        catch (SQLException sqlException) {
            this.instance.getLogger().error("Unable to connect to the database, cannot start the plugin.");
            sqlException.printStackTrace();
            this.instance.mysql_installation = true;
        }
    }

    public void execute(String sql) {
        Runnable runnable = () -> {
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeUpdate(sql);
            }
            catch (SQLException var15) {
                var15.printStackTrace();
            }
        };
        runnable.run();
    }
}

